/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        vecmult.c
*
* DESCRIPTION:     Function for computing product of two scalar arrays
*
**************************************************************************/

#include "typedef.h"
#include "dsp_op2.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : FdqMultiply
 *
 *  Description:
 *    This routine multiplies the fdq coeffiecients with a scalar value and
 *    normalizes them if necessary using the exponents.
 *
 * Memory Allocation:
 *    The fqd coeffieicent array must be in Y memory.  The size of the array
 *    must "2*s_length" words.
 *
 * Algorithm:
 *
 *    The routine cycles through each element of the two arrays performing a
 *    multiplication followed by a right shift and storing the results to Y
 *    memory (inplace) in the same order.
 *
 *  Prototype:
 *    void FdqMultiply(int16 *psa_fdq_coef, int8 *puca_fdq_exp, int16 s_multiplier, int16 s_first_tone, int16 s_length, int16 s_fdq_mantissa_wordlength, int16 s_fdq_multiplier_frac_bits)
 *
 *  Input Arguments:
 *    int16 *psa_fdq_coef           - Pointer to fdq coefs in Y memory
 *    int16 *puca_fdq_exp           - Pointer to fdq exponents
 *    int16 *s_multiplier           - Fdq multiplier
 *    int16 s_first_tone            - First tone
 *    int16 s_length             - Number of tones
 *    int16 s_fdq_mantissa_wordlength  - Fdq Mantissa Wordlength
 *    int16 s_fdq_multiplier_frac_bits- Number of fractional bits in fdq multiplier
 *
 *  Output Arguments:
 *    Fdq Multiplication done in place
 *    int16 *psa_fdq_coef     - Pointer to fdq coefs in Y memory
 *    int16 *puca_fdq_exp     - Pointer to fdq exponents
 *
 *  Return:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FdqMultiply(int16 *psa_fdq_coef, int8 *puca_fdq_exp, int16 s_multiplier, int16 s_first_tone, int16 s_length, int16 s_fdq_mantissa_wordlength, int16 s_fdq_multiplier_frac_bits)
{
    int j;
   int16 s_shift;
   int32 l_temp_real, l_temp_imag;

   for(j = s_first_tone; j < (s_first_tone+s_length); j++)
   {
      // right shift because gs_ExcessMarFDQBoost value is in 3.13 format
      l_temp_real = ((int32)psa_fdq_coef[2*j] * s_multiplier) >> s_fdq_multiplier_frac_bits;
      l_temp_imag = ((int32)psa_fdq_coef[2*j+1] * s_multiplier) >> s_fdq_multiplier_frac_bits;

      // determine if the result is representable in the FDQ_Mantissa_wordlength; else shift more
      RightNormalizeSignedPair(&l_temp_real, &l_temp_imag, s_fdq_mantissa_wordlength, &s_shift);

      psa_fdq_coef[2*j] = (int16) l_temp_real;
      psa_fdq_coef[2*j+1] = (int16) l_temp_imag;
      puca_fdq_exp[j] += s_shift;

      if (puca_fdq_exp[j] > FDQ_EXPONENT_MAX)
         puca_fdq_exp[j] = FDQ_EXPONENT_MAX;    // Saturate if necessary
   }
}
