/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        fpc48_ini.c
*
* DESCRIPTION:     performs initialization for the function FixedPointConvolve48
*
**************************************************************************/
#include "typedef.h"
#include "string.h"

/*******************************************************************************
*
*   Prototype: void MemCpyTDQFilterForConvolve(int16 *psa_filter_copy, int16 *psa_filter,
                        int16 s_filterlen)
*
*   Description:
*       This function performs any platform-specific initialization necessary for
*     the function FixedPointConvolve48.  For the Socrates platform, this function
*     checks if the filter is in XY memory.  If it is not, then the routine copies
*     the filter into the appropriate location in XY memory.
*
*   Arguments:
*     int16 *psa_filter_copy  - filter target storing address
*     int16 *psa_filter    - filter initial storing address
*     int16 s_filterlen    - length of filter
*
*     We use double indirection here in case we want to change the pointers that
*     are being passed into the initialization routine.
*
*   Return Value:
*       None
*
*   Global Variables:
*
*******************************************************************************/
void MemCpyTDQFilterForConvolve(int16 *psa_filter_copy, int16 *psa_filter,
                        int16 s_filterlen) {

   // a generic memcopy function
   memcpy(psa_filter_copy, psa_filter, s_filterlen);
}
