/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   logmips.c
*
*  Some of the functions used for generating the trail log file.
*  These are functions needed to open and update the log file during
*  execution.
*  The file 'trailend.c' contains additional printing functions needed
*  only after completion of execution.
*
*-------------------------------------------------------------------------
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "typedef.h"
#include "common.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "cmv.h"
#include "rt_state.h"
#include "trailfileio_defs.h"
#include "trail_data_const.h"
#include "data_alloc.h"
#include "gdata.h"
#include "bert.h"
#include "trail.h"
#include "const_bis.h"
#include "rx_ib.h"
#include "gdata_bis.h"
#include "tx_plam.h" //for vars referenced in logShowtimeEvent
#include "pll.h"

/* =============================================== */
/* global variable declarations */
/* =============================================== */


/* =============================================== */
/* static function prototypes */
/* =============================================== */

#ifdef PROFILE_TASKS
/************************************************************/
/* Task Profile Variables for tracking maximum MIPS load */
/* for each TC and NTC task.                       */
/* The ProfileTasks function may be used to clear and    */
/* log these values for each SubState.                */
/************************************************************/
    uint16   gsa_LogMips[NUM_TC_NTC];
    uint16   gsa_MaxMips[NUM_TC_NTC];
    uint16   gsa_MaxMipsState[NUM_TRN_TC_NTC];
    uint16   gsa_MaxMipsSubState[NUM_TRN_TC_NTC];
   FlagT gft_RxCPInserted;
   /* To get training max Mips */
   uint32 gs_TrainingMaxMips = 0;

   /* To get Showtime Max Mips */
   uint32 gs_ShowtimeMaxMips = 0;
   uint16 gs_timer_current;
   uint16 gsa_task_start_time[NUM_TC_NTC];
   uint16 gsa_task_stop_time[NUM_TC_NTC];
   uint16 gs_timer_flag = 0;
#endif /* #ifdef PROFILE_TASKS */


#ifdef PROFILE_TASKS

/*****************************************************************************
;  Prototype: LogMips(int16 s_taskId, int16 s_flag)
;
;  Description:
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void LogMips(int16 s_taskId, int16 s_flag)
{
//    static int16 s_timerStart;
//    int16 s_timerCurr, s_mips;

   uint16 tempsum1=0, tempsum2=0, count1, temp;

   int16  s_mips;
   /* Distinguish between training and showtime NTC task */
   if (gs_RxState == R_C_SHOWTIME_RX && s_taskId == RX_NTC)
      s_taskId = ST_RX_NTC;
   else if (gs_TxState == R_SHOWTIME_TX && s_taskId == TX_NTC)
      s_taskId = ST_TX_NTC;

   /* Read rx timer */
   gs_timer_current = ReadRxTimer();

#if 0
   /* =============================================== */
   /* Log per-frame Timing Information */
   /* =============================================== */
   if (gt_debugTrailTriggerControl.ft_RxStateTrigger)
   {
      if (s_flag == TC_NTC_START_FLAG)
         DebugTrail(2, DEBUG_LOG_TIMING, (int16)(0xAA00 | s_taskId), s_timerCurr);
      else if (s_flag == TC_NTC_END_FLAG)
         DebugTrail(2, DEBUG_LOG_TIMING, (int16)(0xBB00 | s_taskId), s_timerCurr);
   }
#endif  // #if 0

   temp = 1 << s_taskId;
   /* =============================================== */
   /* Log current TC/NTC Mips Information */
   /* =============================================== */
   if (s_flag == TC_NTC_START_FLAG)
   {
      gsa_task_start_time[s_taskId] = gs_timer_current;
      gs_timer_flag |= temp;
   }
   else if (s_flag == TC_NTC_END_FLAG)
   {
      if (gs_timer_flag & temp) {
         gs_timer_flag ^= temp;
         gsa_task_stop_time[s_taskId] = gs_timer_current;
         s_mips = gsa_task_stop_time[s_taskId] - gsa_task_start_time[s_taskId];
//       s_mips = gs_timer_current - gsa_task_start_time[s_taskId];
      } else {
         return;
      }
      /* Account for fact that timer resets to zero at frame start */
      if (s_mips < 0) {
         if (gft_RxCPInserted == FALSE) {
            s_mips += TIME_PER_FRAME_NO_CP;
         }
         else {
            s_mips += TIME_PER_FRAME_CP;
         }
      }

      //Code modified by kannan for testing purpose
      gsa_LogMips[s_taskId] = s_mips;
      if(s_taskId == RX_NTC)
      {
         tempsum1 = 0;
         tempsum2 = 0;
         for(count1 = 0; count1 <= 4; count1++)
         {
            tempsum1 += gsa_LogMips[count1];
            tempsum2 += gsa_MaxMips[count1];
         }
         if(tempsum1 > tempsum2)
         {
            gs_TrainingMaxMips = tempsum1;

            for(count1 = 0; count1 <= 4; count1++)
            {
               gsa_MaxMips[count1] = gsa_LogMips[count1];
            }
         }
      }
      if(s_taskId == ST_RX_NTC)
      {
         tempsum1 = 0;
         tempsum2 = 0;
         for(count1 = 5; count1 <= 12; count1++)
         {
            tempsum1 += gsa_LogMips[count1];
            tempsum2 += gsa_MaxMips[count1];
         }
         if(tempsum1 > tempsum2)
         {
            gs_ShowtimeMaxMips = tempsum1;
            for(count1 = 5; count1 <= 12; count1++)
            {
               gsa_MaxMips[count1] = gsa_LogMips[count1];
            }
         }
      }
#if 0
      /* Commented by kannan for testing */
      if (s_mips > gsa_LogMips[s_taskId]){
         gsa_LogMips[s_taskId] = s_mips;
      }

      if (s_mips > gsa_MaxMips[s_taskId]){
         gsa_MaxMips[s_taskId] = s_mips;

         if (s_taskId < NUM_TRN_TX_TC_NTC)
         {
            gsa_MaxMipsState[s_taskId] = gt_debugTrailTriggerControl.s_prevTxState;
            gsa_MaxMipsSubState[s_taskId] = gt_debugTrailTriggerControl.s_prevTxSubState;
         }
         else if (s_taskId < NUM_TRN_TC_NTC)
         {
            gsa_MaxMipsState[s_taskId] = gt_debugTrailTriggerControl.s_prevRxState;
            gsa_MaxMipsSubState[s_taskId] = gt_debugTrailTriggerControl.s_prevRxSubState;
         }
      }
#endif // #if 0

   }


}


#endif /* ifdef PROFILE_TASKS */
