/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: memcpywd.c
;
;  Function for copying 16-bit word data.
;
;***************************************************************************/

#include <string.h>
#include "typedef.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : MemCopyWords
 *
 *  Description:  Similar to standard memcpy(), but specifies source, destination addresses
 *          using origin+offset and uses word-aligned addresses only.
 *  Prototype:
 *    void MemCopyWords(int16 *psa_dstptr, int16 s_dst_offset, int16 *psa_srcptr, int16 s_src_offset, int16 s_Nwords)
 *
 *  Input Arguments:
 *    int16 *psa_dstptr - Pointer to origin of destination buffer.
 *    int16 s_dst_offset - Added to psa_dstptr to get starting destination address.
 *    int16 *psa_srcptr - Pointer to origin of source buffer.
 *    int16 s_src_offset - Added to psa_srcptr to get starting source address.
 *    int16 s_NBytes - Number of 16-bit words to copy.
 *
 *  Output Arguments:
 *    None.
 *  Return:
 *    None.
 *
 *  Notes:
 *    1) Whenever possible, psa_dstptr and psa_srcptr should be pointers to globally-declared arrays.
  *------------------------------------------------------------------------
 *^^^
 */

void MemCopyWords(int16 *psa_dstptr, int16 s_dst_offset, int16 *psa_srcptr, int16 s_src_offset, int16 s_NWords)
{
   memcpy(psa_dstptr + s_dst_offset, psa_srcptr + s_src_offset, sizeof(int16)*s_NWords);
}
