/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp_plfm.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*     int16 NewMPInitialize
*     int16 NewMPCheckMessage
*     void  NewMPSendMessage
*
*-------------------------------------------------------------------
*/

#ifndef NMP_PLFM_C
#define NMP_PLFM_C

#define IN_NMP_PLFM_C

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "nmp.h"
#include "nmp_plfm.h"
#include <stdio.h>
#include <stdlib.h>


int16 *NewMPRxArray = (int16 *)&NewMPRxBuffer;  /* RX buffer pointer */
int16 *NewMPTxArray = (int16 *)&NewMPTxBuffer;  /* TX buffer pointer */

/* =============================================== */
/* WINHOST connectivity functions               */
/* =============================================== */

typedef void (*WriteNewMPtoModem_f)(int16, int16 );
typedef int16 (*ReadNewMPtoModem_f)(int16 );
typedef void (*WriteModemtoNewMP_f)(int16, int16 );
typedef int16 (*ReadModemtoNewMP_f)(int16 );
typedef int16 (*SelectNewMPPort_f)(int16);

extern WriteNewMPtoModem_f    WriteNewMPtoModem;
extern ReadNewMPtoModem_f     ReadNewMPtoModem;
extern WriteModemtoNewMP_f    WriteModemtoNewMP;
extern ReadModemtoNewMP_f     ReadModemtoNewMP;
extern SelectNewMPPort_f      SelectNewMPPort;

/*******************************************************************
*
*       Define Variables
*
*******************************************************************/

/* =============================================== */
/* MP Message Structure                      */
/* =============================================== */
/*
**
**              typedef struct {
**                 int16 FunctionOpcode;
**                 int16 PayloadSize;
**                 int16 GroupField;
**                 int16 AddrField;
**                 int16 IndexField;
**                 int16 PayLoad[12];
**             } MPStruct;
**
**
*/
/*^^^
*-------------------------------------------------------------------------------------
*
*     Prototype:
*        int16 NewMPInitialize(int16 Source)
*
*     Abstract:
*        This function initializes all hardware and required variables
*        for the specified MP source.
*
*       Parameters:     None
*
*       Returns:
*        int   :  Returns TRUE if initialization successful, else
*              FALSE is returned.
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
int16 NewMPInitialize(void)
{
   int16 i;



   for (i=0; i<NEWMP_SIZE+1; i++)
   {
      /* Clear TX/RX buffer and Mailbox. */

      WriteModemtoNewMP(i,0);
      WriteNewMPtoModem(i,0);
   }

   return TRUE;

}  /* MPInitialize */


/*^^^
*-------------------------------------------------------------------
*
*     Prototype:
*        int16 NewMPCheckMessages(void)
*
*     Abstract:
*        This function checks all MP message sources for new
*     complete MP messages. If TRUE is returned then a new MP
*     message is in gt_MPRxBuffer. MPCheckMessages is the high level
*     C interface. This level hides all interaction with the hardware.
*     Therefore, the MP interface level does not know where (hardware
*     source) an MP message originated. This is all handled by the
*     hardware level interface. MPTxHandler and MPRxandler.
*
*       Parameters:
*           None
*
*       Returns:
*           int16 :       result =    TRUE   New Message Pending
*                 FALSE No messages
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
int16 NewMPCheckMessage(int16 mailbox)
{
   static int16 i;
   static int16 *q;
   static int16 *ptr;

   /*
   ** Check to see if a new message has been received
   ** by looking to see if the RxMailbox is non-zero
   */



        if (mailbox == VBM_MAILBOX){
      if ( ReadNewMPtoModem(16) != 0 )
      {
         /* Transfer the IDMA RX buffer to the main MP buffer */
         for (i=0; i<NEWMP_SIZE; i++, ptr++)
         {
            NewMPRxArray[i] = ReadNewMPtoModem(i);
         }

         /* Clear the IDMA RX MAILBOX */
         WriteNewMPtoModem(16,0);
         return TRUE;
      }  /* if ( ReadMPtoModem(16) != 0 ) */
   }
   return FALSE;
}

/*^^^
*----------------------------------------------------------------------------------
*
*       Prototype:
*        int16  NewMPHandleMessage(void);
*
*       Abstract:
*        This function receives the MP message and performs any required
*        variabe access. This function also sends a response (ACK) message
*        back to the sender. The hardware layer of the sender is handled
*        in the hardware layer.
*
*       Parameters:
*        None
*
*       Returns:
*        int16 :  TRUE  If a message was received which requires modem
*                    intervention.
*              FALSE If no intervention is required
*
*       Notes:
*
*-------------------------------------------------------------------------------------
^^^*/





int16 NewMPHandleMessage(int16 mailbox)
{
   static int16 FunctionOpcode, ReturnOpcode, Mode, Direction, Size;
   static int16 BlockNameType, AddrField, OffsetField, ReadWriteStatus;
   static int16 MemAccessError;
   static OperationRequired;
   static int16 i;
   static int16 *tmpptr;
   static int16  RW_status;

   /* Initialize response variable */
   OperationRequired = FALSE;

   RW_status = NewMPRxArray[0] & READ_MASK;
   FunctionOpcode = NewMPRxArray[0];
   /* Grab Message Type and Subtype. */
   FunctionOpcode = (NewMPRxArray[0] >> 4) & 0xFF;
   Mode = (FunctionOpcode >>1) & 0x1;  /* CMV mode or debug mode */
   Size = (NewMPRxArray[0] & 0x0F);

   AddrField = NewMPRxArray[2];
   OffsetField = NewMPRxArray[3];

   /* Grab Sender ID and Receiver ID. */
   Direction = FunctionOpcode & 0x1;

   /* Do nothing if Receiver ID is not 0. */

   if ( (Direction) != 0) return OperationRequired;

   /* Respond to message. */

   if (Mode == 0){ /* CMV mode */

      switch(FunctionOpcode)
      {
         case H2D_CMV_READ:

            /* Decode CMV Block Name & Offset; validate Offset is in range and determine read/write status. */
            MemAccessError = NewDecodeCMVBlockName(&BlockNameType,&ReadWriteStatus);
            /* If error found, send message to ME. */
            if (MemAccessError > 0)
            {
               /* zero out the size field */
               NewMPRxArray[0] = NewMPRxArray[0] & 0xfff0;
               ReturnOpcode = D2H_ERROR_CMV_UNKNOWN;
               break;
            }

         /* If BlockName.Offset is WRITE-ONLY, then send message to ME. */

            if (ReadWriteStatus == WRITE_ACCESS)
            {
               NewMPRxArray[0] = NewMPRxArray[0] & 0xfff0;
               ReturnOpcode = D2H_ERROR_CMV_WRITE_ONLY;
               break;
            }

            /* ================================================================= */
            /* Standard CMV READ                                     */
            /* ================================================================= */
#ifndef HERC_API
            if ((BlockNameType == NewINFOType) || (BlockNameType == NewRATEType) || (BlockNameType == NewPLAMType) || (BlockNameType == NewCNFGType) )
            {
#else
            if ((BlockNameType == NewINFOType) || (BlockNameType == NewRATEType) || (BlockNameType == NewPLAMType) || (BlockNameType == NewCNFGType) || (BlockNameType == NewCNTRType) || (BlockNameType == NewAINFType) || (BlockNameType == NewMONIType) )
            {
#endif
               if (BlockNameType == NewINFOType){
               /* ================================================================= */
               /* CMV INFO READ - indirect memory read                        */
               /* ================================================================= */
                  tmpptr = INFOMap[AddrField];
               }
               else if (BlockNameType == NewCNFGType){
               /* ================================================================= */
               /* CMV CNFG READ - indirect memory read                        */
               /* ================================================================= */
                  tmpptr = CNFGMap[AddrField];
               }
               else if (BlockNameType == NewPLAMType) {
                  tmpptr = PLAMMap[AddrField];
               }
#ifdef HERC_API
               else if (BlockNameType == NewCNTRType) {
                  tmpptr = CNTRMap[AddrField];
               }
               else if (BlockNameType == NewAINFType) {
                  tmpptr = AINFMap[AddrField];
               }
               else if (BlockNameType == NewMONIType) {
                  tmpptr = MONIMap[AddrField];
               }
#endif

               else {
                  tmpptr = RATEMap[AddrField];
               }
               if (tmpptr == NULL){
                  // This address entry not loaded yet, return error.
                  NewMPRxArray[0] = NewMPRxArray[0] & 0xfff0;
                  ReturnOpcode = D2H_ERROR_CMV_UNINITIALIZED_ENTRY;
                  break;
               }
               tmpptr = tmpptr + OffsetField;
            }
            else{
               NewBlockNameArrayPtr = NewCMVBlockNamePtr[BlockNameType - 1];
               tmpptr = &NewBlockNameArrayPtr[AddrField];
            }
            /* copy data to an array */
            for (i=0; i<Size; i++){
               NewMPRxArray[i+4] = *tmpptr;
               tmpptr++;
            }

            /* Set variable to signal the modem application */
            if (BlockNameType == NewCNTLType)
            {
               OperationRequired = TRUE;
            }
            ReturnOpcode = D2H_CMV_READ_REPLY;
            break;

         /* ================================================================= */
         /*                                                    */
         /* CMV WRITE                                             */
         /*                                                    */
         /* ================================================================= */

         case H2D_CMV_WRITE:

         /* Decode CMV Block Name & Offset; validate Offset is in range and determine read/write status. */
            MemAccessError = NewDecodeCMVBlockName(&BlockNameType,&ReadWriteStatus);

            if (MemAccessError > 0)
            {
               ReturnOpcode = D2H_ERROR_CMV_WRITE_ONLY;
               break;
            }

         /* If BlockName.Offset is READ-ONLY, then send message to ME. */
            if (ReadWriteStatus == READ_ACCESS)
            {
               ReturnOpcode = D2H_ERROR_CMV_READ_ONLY;
               break;
            }

            /* Set variable to signal the modem application */
            if (BlockNameType == NewCNTLType)
            {
               OperationRequired = TRUE;
            }

            /* ================================================================= */
            /* Standard CMV WRITE                                    */
            /* ================================================================= */
            if (BlockNameType == NewINFOType)
            {
               /* ================================================================= */
               /* CMV INFO WRITE - indirect memory write                   */
               /* ================================================================= */
               tmpptr = INFOMap[AddrField];
               if (tmpptr == NULL){
                  // This address entry not loaded yet, return error.
                  ReturnOpcode = D2H_ERROR_CMV_UNINITIALIZED_ENTRY;
                  break;
               }
               tmpptr = tmpptr + OffsetField;
            }
            else if (BlockNameType == NewCNFGType)
            {
               /* ================================================================= */
               /* CMV CNFG WRITE - indirect memory write                   */
               /* ================================================================= */
               tmpptr = CNFGMap[AddrField];
               if (tmpptr == NULL){
                  // This address entry not loaded yet, return error.
                  ReturnOpcode = D2H_ERROR_CMV_UNINITIALIZED_ENTRY;
                  break;
               }
               tmpptr = tmpptr + OffsetField;
            }
#ifdef HERC_API
            else if (BlockNameType == NewMONIType)
            {
               /* ================================================================= */
               /* CMV CNFG WRITE - indirect memory write                   */
               /* ================================================================= */
               tmpptr = MONIMap[AddrField];
               if (tmpptr == NULL){
                  // This address entry not loaded yet, return error.
                  ReturnOpcode = D2H_ERROR_CMV_UNINITIALIZED_ENTRY;
                  break;
               }
               tmpptr = tmpptr + OffsetField;
            }
#endif
            else{
               NewBlockNameArrayPtr = NewCMVBlockNamePtr[BlockNameType - 1];
               tmpptr = &NewBlockNameArrayPtr[AddrField];
            }
            for (i = 0; i< Size; i++){
               *tmpptr = NewMPRxArray[4+i];
               tmpptr++;
            }
            ReturnOpcode = D2H_CMV_WRITE_REPLY;
            break;

         default:
            ReturnOpcode = D2H_ERROR_OPCODE_UNKNOWN;
            break;
      }  /* switch (FunctionOpcode) */
   }   /* if mode ==0 */
   else{   /* Debug mode */
      switch(FunctionOpcode)
      {
         case H2D_DEBUG_READ_DM:
            ReadMem(0, AddrField, (int16)(Size-1), &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_READ_DM_REPLY;
         /* Send BlockName.Offset value to ME. */
            break;

         case H2D_DEBUG_READ_PM:
            ReadMem(1, AddrField, (int16)(Size-1), &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_READ_PM_REPLY;
         /* Send BlockName.Offset value to ME. */
            break;

         case H2D_DEBUG_WRITE_DM:
            WriteMem(0, AddrField, (int16)(Size-1), &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_WRITE_DM_REPLY;
         /* Send BlockName.Offset value to ME. */
            break;

         case H2D_DEBUG_WRITE_PM:
            WriteMem(1, AddrField, (int16)(Size-1), &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_WRITE_PM_REPLY;
         /* Send BlockName.Offset value to ME. */
            break;

         case H2D_DEBUG_READ_EXT_DM:
            ReadExtMem(0, AddrField, OffsetField, &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_READ_EXT_DM_REPLY;
            break;

         case H2D_DEBUG_READ_EXT_PM:
            ReadExtMem(1, AddrField, OffsetField, &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_READ_EXT_PM_REPLY;
            break;

         case H2D_DEBUG_WRITE_EXT_DM:
            WriteExtMem(0, AddrField, OffsetField, &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_WRITE_EXT_DM_REPLY;
            break;

         case H2D_DEBUG_WRITE_EXT_PM:
            WriteExtMem(1, AddrField, OffsetField, &NewMPRxArray[4]);
            ReturnOpcode = D2H_DEBUG_WRITE_EXT_PM_REPLY;
            break;

      }  /* switch (FunctionOpcode) */

   }  /* debug mode */

   NewMPSendMessage(ReturnOpcode, RW_status, mailbox);

   return OperationRequired;
}  /* HandleMessageADSL */



/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*     void  NewMPSendMessage(int, int*);
*
*       Abstract:
*     This function constructs and sends messages from ADSL to ME.
*
*       Parameters:
*           int16 MessageType:     The type of message: memory access or error indication.
*           int16 *CMVData:        Data to be sent out
*
*       Returns:
*           None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/

void NewMPSendMessage(int16 FunctionOpcode, int16 RW_status, int16 mailbox)
{
   static int16 i, j;

   /* Fill in 2-byte message preamble. */
   if (RW_status){
      for (j=0; j<NEWMP_SIZE; j++){
         NewMPTxArray[j] = NewMPRxArray[j];
      }
      NewMPTxArray[0] = ((NewMPRxArray[0] & ~(0xff0)) | ((FunctionOpcode <<4) & (~0xf))) ;

      for (i=0; i<NEWMP_SIZE; i++)
      {
         WriteModemtoNewMP(i,NewMPTxArray[i]);
      }
   /* Send the message by setting the mailbox = 1 */
      WriteModemtoNewMP(16,1);
   }

}  /* MPSendMessage */

/*******************************************************************************
*
*  Prototype: void ReadMem(int16 memtype, int16 address, int16 size, int16 *data)
*
*  This function reads from the internal memory.
*
*  Input Arguments:
*     memtype: data memory (0) / program memory (1)
*     address:
*     size:
*     data:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void ReadMem(int16 memtype, int16 address, int16 size, int16 *data)
{
   int32 addr;

   addr = (NewMPRxArray[2] & 0xFFFF) << 16;
   addr |= (NewMPRxArray[3] & 0xFFFF);
   *data = *(int16 *)addr;
}

/*******************************************************************************
*
*  Prototype: void WriteMem(int16 memtype, int16 address, int16 size, int16 *data)
*
*  This function writes to the internal memory.
*
*  Input Arguments:
*     memtype: data memory (0) / program memory (1)
*     address:
*     size:
*     data:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void WriteMem(int16 memtype, int16 address, int16 size, int16 *data)
{
   int32 addr;

   addr = (NewMPRxArray[2] & 0xFFFF) << 16;
   addr |= (NewMPRxArray[3] & 0xFFFF);
   *(int16 *)addr = *data;
}

void ReadExtMem(int16 memtype, int16 addrhi, int16 addrlo, int16 *data)
{

}

void WriteExtMem(int16 memtype, int16 addrhi, int16 addrlo, int16 *data)
{

}

#endif
