/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: noiseacc_st.c
;
;  This file contains the noiseacc function used in SNR calculation
;
;***************************************************************************/
#include "common.h"
#include "medley.h"
#include "GenMedly.h"
#include "noiseacc.h"
#include "rcmedly2.h"
#include "gdata.h"
#include "rt_state_bis.h"
#include "gdata_bis.h"
#include "cmv.h"

/********************************************************************************************
;  Subroutine Name: NoiseAccShowtime
;
;  Description:
;     This routine performs the following operations:
;
;       For each tone i,
;     1) Compute the noise power
;        pow[i] = (0.5*(ref_tone[i*2]-recv_tone[i*2]))^2
;                    + (0.5*(ref_tone[i*2+1]-recv_tone[i*2+1]))^2
;
;     2) Add pow[i] to the accumulated noise power array.
;
;       The scaling by 0.5 before the squaring is needed to avoid overflowing
;       the 32 bits variable that holds the square. Thus the final
;       accumulated power is the real power dividied by 4.
;
;     The code uses a 48-bit accumulator implemented in 2 32-bit counters.  The details
;     of the implementation of the 48-bit accumulator are not important so long as
;     the RoundNoiseAccum routine can correctly round and shift the 48-bit accumulator
;     into a single 32-bit counter.
;
;     This routine is called both during REVERB and MEDLEY SNR calculations.
;     The offset parameter is used to control the PN sequence shift during
;     MEDLEY SNR calculations.
;
;
;  Prototype:
;     void NoiseAccShowtime(int32 *pla_NoisePower, int16 s_doffset, int16 *psa_recv_tones, int16 s_offset, int16 *psa_ref_tones,
;              int16 s_first_chan, int16 s_last_chan);
;
;  Input Arguments:
;     psa_recv_tones -- pointer to the received DMT tones
;     psa_ref_tones  -- pointer to the reference DMT tones
;     s_offset    -- offset used to generate Medley signal
;     s_first_chan   -- first channel
;     s_last_chan    -- last channel
;
;  Output Arguments:
;     pla_NoisePower -- pointer to accumulators for storing noise power.
;     s_doffset      -- offset for pla_Noisepower to point to the first noise value.
;                 Noise values will get written to pla_NoisePower[s_doffset] through
;                 pla_NoisePower[s_doffset+s_last_chan-s_first_chan], rather than
;                 pla_NoisePower[s_first_chan] through pla_NoisePower[s_last_chan]
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;****************************************************************************/
void NoiseAccShowtime(int16 s_num_chans)
{
#ifndef HERCULES_ADSL_CPE
   int16 s_rxPmdFrameCnt, *psa_fdqOutput;

   // Note: NTC task and hence DD processing always occurs after QAM done interrupt
   // Here, we rely on the fdq outputs to perform DD processing. In this mode, data
   // collection and processing can occur in parallel. Hence, we need to select the
   // appropriate data buffer for DD processing
   if(( gl_SelectedMode & (MODE_ADSL2)  )) s_rxPmdFrameCnt = gs_RxPMDFrameCnt;
   else s_rxPmdFrameCnt = gs_MuxFrameCntRxFastPath;

   // We assume that gsa_DD_rxFDQOutput[] ping-pong buffer contains the captured rx fdq outputs
   // NOTE: Shouldnt recieve a fdq done interrupt during the execution of this
   // conditional statement that selects the ping/pong fdq output buffer
   // Refer showtime timing diagram to understand the below check
   if (s_rxPmdFrameCnt == RX_SYMBOLS_PER_SFRAME-1 ||
      gs_RxPMDFrameCnt_FftFdqBufferSymbol == s_rxPmdFrameCnt)
   {
      // It is also assumed that gsa_DD_rxFDQOutput[gs_DD_rxFDQOutput_Buffer_Select]
      // is not updated as DD processing is being executed in the foreground.
      psa_fdqOutput = &gsa_DD_rxFDQOutput[gs_DD_rxFDQOutput_Buffer_Select][0];
   }
   else
   {
      // It is also assumed that gsa_DD_rxFDQOutput[1-gs_DD_rxFDQOutput_Buffer_Select]
      // is not updated as DD processing is being executed in the foreground.
      psa_fdqOutput = &gsa_DD_rxFDQOutput[1-gs_DD_rxFDQOutput_Buffer_Select][0];
   }

   NoiseAcc(gla_RxShowtimeSnrAccumBuf, 0, psa_fdqOutput, 0/* Indicates Not Medley*/, -1, -1,/* -1 => Unused input parameters */
      &gsa_DD_rxQAMOutput[0], 0, (int16)(s_num_chans-1));
#else
   // no need to toggle for Hercules build
   NoiseAcc(gla_RxShowtimeSnrAccumBuf, 0, &gsa_DD_rxFDQOutput[0][0], 0/* Indicates Not Medley*/, -1, -1,/* -1 => Unused input parameters */
      &gsa_DD_rxQAMOutput[0], 0, (int16)(s_num_chans-1));
#endif // HERCULES_ADSL_CPE
}
