/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   rcmedly2.c
 *
 *   Functions for BG Tasks from rcmedley.c
 *
 *------------------------------------------------------------------------
 */


#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "bitload.h"
#include "bitload_bis.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pn_tab.h"
#include "pwr_ctbk.h"
#include "fifo.h"
#include "accum32.h"
#include "noiseacc.h"
#include "cmv.h"
#include "med2rev.h"
#include "DSLEngin.h"
#include <string.h>
#include "vecpwr.h"
#include "tx_ops_bis.h"
#include "GenMedly.h"
#include "gdata_bis.h"
#include "dsp_op.h"
#include "rcmedley_Data.h"
#include "fdq_init.h"
#include "fdq_adj.h"
#include "tdq_init.h"


void BgUnpackPN(void);

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: restore and realign representative frame for multi-TDQ
 *
 *  Prototype: void MedleyFrameRealignment(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void MedleyFrameRealignment(int16 s_offset)
{

   if (s_offset < 0) s_offset += gs_RxSamplesPerFrame;

   /* restore representative frame while rotating around new sync point.*/
   memcpy(gsa_RxRepFrameAlignBuf, &gsa_MultiTdqRxSignal[s_offset],
         sizeof(int16)*(gs_RxSamplesPerFrame-s_offset));
   memcpy(&gsa_RxRepFrameAlignBuf[(int16)(gs_RxSamplesPerFrame-s_offset)], &gsa_MultiTdqRxSignal[0],
         sizeof(int16)*(s_offset));

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype: void BGMultiTdqCalc(void)
 *
 *  Description: Background TDQ calculation for multiple sync points
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gla_RxAccumBuf[]    - (I) Noise accumulation buffer for tones
 *      gs_log2_num_snr_training_symbols - (I) speaks for itself
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BGMultiTdqCalc(void)
{
   int16 i;
   int16 s_offset;

   for (i=0; i<gs_NumMultiTdq; i++) {

      gps_TdqFilter = &(gsa_MultiTdqTaps[i*gs_TDQLen]);
      s_offset = gsa_MultiTdqPreSyncs[i];

      // restore data and re-align
      // TDQ training will always stomp on gsa_RxRepFrameAlignBuf
      MedleyFrameRealignment(s_offset);

      // Now call TDQ training
      TdqInit();

      // Store coefficients
      memcpy(gps_TdqFilter, &(gsa_pre_tdq_h[0]), gs_TDQLen*sizeof(int16));
      gsa_MultiTdqExp[i] = gs_pre_tdq_h_exp;
   }

   gs_UnpackPNState = TRAINING_IN_PROGRESS;
   /* while doing multi TDQ, generate the ON sequence here */
   BgUnpackPN();

   gs_MultiTdqTrainingState = TRAINING_DONE;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype: void BgUnpackPN(void)
 *
 *  Description: Background function to Unpack PN512 sequence.
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void BgUnpackPN(void)
{
   int16 s_gain = (int16) DEC_QPSK_GAIN;
   int16 s_NumBits, s_SequenceLengthMultiplier;


   if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
   {
      s_SequenceLengthMultiplier = 2;
   }
   else
      s_SequenceLengthMultiplier = 1;

   s_NumBits = s_SequenceLengthMultiplier * (PN512_LEN + 1);

   /* Unpack PN512 sequence to DMT tones */
   UnpackPN(gsa_unpk_PN512, s_NumBits, gpusa_MedleySeq, s_gain);

   gs_UnpackPNState = TRAINING_DONE;

}


