/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   rxinvfiltcoef.c
 *
 *   Function to return Rx Inverse Filter Coefficient for AFE
 *
 *
 *----------------------------------------------------------------------------
 */


#include "common.h"
#include "diagparam_bis.h"
#include "data_alloc.h"
#include "cmv.h"
#include "gdata_bis_diag.h"

/* CPE Modem front-end Rx path specific data  (Afe dependent) */
#if 1
/* New subsampled data (estimate for upto tone 511). */
/* Calibrated from Plus test. */
int16 gsa_Rxfilter_comp_dB[256] = { /*Q9.7*/
10674,
10687,
10674,
10687,
10674,
10674,
10700,
10700,
10687,
10674,
10687,
10687,
10674,
10687,
10687,
10674,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687,
10687
};
#else
/* old normal sampled bis data */
/* Note: shape here is really from Cocomo input signal */
int16 gsa_Rxfilter_comp_dB[256] = { /*Q9.7*/
0,
10682,
10663,
10676,
10662,
10678,
10682,
10682,
10680,
10683,
10668,
10683,
10677,
10673,
10670,
10683,
10674,
10676,
10683,
10685,
10674,
10676,
10676,
10684,
10673,
10683,
10673,
10685,
10681,
10684,
10678,
10676,
10672,
10683,
10683,
10683,
10683,
10683,
10684,
10684,
10683,
10683,
10685,
10685,
10685,
10685,
10685,
10685,
10685,
10685,
10685,
10686,
10686,
10685,
10686,
10686,
10686,
10686,
10686,
10686,
10687,
10686,
10686,
10687,
10687,
10686,
10686,
10687,
10687,
10686,
10687,
10686,
10686,
10687,
10687,
10687,
10686,
10687,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10687,
10687,
10686,
10686,
10687,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10685,
10686,
10686,
10686,
10686,
10685,
10686,
10686,
10687,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10686,
10685,
10685,
10685,
10685,
10685,
10685,
10685,
10685,
10684,
10683,
10683,
10683,
10682,
10682,
10681,
10680,
10680,
10679,
10679,
10678,
10677,
10676,
10675,
10674,
10672,
10671,
10670,
10669,
10667,
10665,
10664,
10662,
10660,
10658,
10656,
10653,
10652,
10649,
10646,
10644,
10641,
10638,
10634,
10631,
10627,
10624,
10620,
10616,
10612,
10608,
10603,
10600,
10594,
10589,
10584,
10578,
10572,
10567,
10561,
10555,
10548,
10542,
10534,
10527,
10520,
10512,
10504,
10496,
10487,
10478,
10469,
10461,
10452,
10441,
10431,
10420,
10409,
10398,
10386,
10375,
10363,
10352,
10339,
10325,
10312,
10298,
10284,
10269,
10255,
10239,
10224,
10209,
10192,
10176,
10159,
10142,
10125,
10107,
10087,
10069,
10052,
10032,
10014,
9993,
9974,
9954,
9935,
9915,
9894,
9874,
9854,
9835,
9815,
9797,
9777,
9759,
9740,
9725,
9708,
9692,
9678,
9665,
9654,
9643,
9633,
9626,
9620,
9616,
9612};
#endif

//Index to channel with minimum values (i.e. maximum compensation)
int16 gs_MinValueChan_Rxfilter = 255;

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RxInvFiltCoef()
 *
 *  Description:  Returns AFE specific Rx Inverse filter coefficient in (dB) Q9.7
 *          for given tone for compensation of the Rx Filter effects from
 *          the received signal (This includes the PGA, Rxsystem Gain, and Rxfilter)
 *          To reduce data memory storage, the Rxfilter compensation array is stored
 *          from tones 1 to 511 and subsampled by 2 to fit in 256 memory locations.
 *          The values for even tones must be interpolated.
 *          s_chan < 0 is used to indicate that this function should return the
 *          minimum Rxfilter coefficient (thus resulting in maximimum compensation value)
 *
 *  Prototype:
 *    int16 RxInvFiltCoef(int16 s_chan)
 *
 *  Input Arguments:
 *    int16  s_chan        - tone number to be compensated
 *
 *  Output Arguments:
 *
 *  Return:
 *      int16 AFE Rx Inverse Filter compensation coefficient in (dB) Q9.7
 *
 *  Global Variables Used:
 *    gsa_Rxfilter_comp_dB    -- (I) Rx filter compensation in dB
 *
 *  Notes: dB operations performed in Q9.7 to handle lowest possible realistic values for QLN
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE int16 RxInvFiltCoef(int16 s_chan)
{

   int16 s_InvFiltCoefValue, s_index;

   if(gft_DiagAfeRxCalibration==0)
   {
      if(s_chan >= 0)
      {
         s_index = s_chan>>1;
         if(s_chan & 0x1)
            s_InvFiltCoefValue = gsa_Rxfilter_comp_dB[s_index];
         else
         {
            // interpolate subsampled gsa_Rxfilter_comp_dB
            s_InvFiltCoefValue = (int16)(((int32)gsa_Rxfilter_comp_dB[s_index-1] + gsa_Rxfilter_comp_dB[s_index] + 1) >> 1);
         }
      }
      else
      {
         //The channel with the minimum value for Rx Filter will have maximum Compensation.
         s_InvFiltCoefValue = gsa_Rxfilter_comp_dB[gs_MinValueChan_Rxfilter];
      }
   }
   else
      s_InvFiltCoefValue = gs_DiagRxCalibrateConstant;

   return(s_InvFiltCoefValue);
}

