/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   trail.c
*
*  Some of the functions used for generating the trail log file.
*  These are functions needed to open and update the log file during
*  execution.
*  The file 'trailend.c' contains additional printing functions needed
*  only after completion of execution.
*
*-------------------------------------------------------------------------
*/
// **********************************************************************************************//
// trail.c
//
// History
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
// **********************************************************************************************//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "typedef.h"
#include "common.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "cmv.h"
#include "rt_state.h"
#include "trailfileio_defs.h"
#include "trail_data_const.h"
#include "data_alloc.h"
#include "gdata.h"
#include "bert.h"
#include "trail.h"
#include "const_bis.h"
#include "rx_ib.h"
#include "gdata_bis.h"
#include "tx_plam.h" //for vars referenced in logShowtimeEvent
#include "pll.h"

/* =============================================== */
/* global variable declarations */
/* =============================================== */

#ifdef LEAVE_TRAIL
FlagT gft_ShowtimeStateReached;
TRAILFILE trail_fid;
TRAILFILE crc_fid;

// BIS OLR specific
char OLR_MsgTypeName[MAX_OLR_TYPE][MAX_STATENAME_LEN];
char OLR_ResultState[MAX_OLR_RESULTS][MAX_STATENAME_LEN];
char OLRPM_ErrorName[MAX_OLRPM_ERROR_TYPE][MAX_STATENAME_LEN];
int16 gs_trail_deltaLp[NUM_DATA_PATHS], gs_trail_deltaBpn[NUM_DATA_PATHS];

/* =============================================== */
/* static variable declarations */
/* =============================================== */
DATA_MAP_SIM
char StateName[MAX_STATES][MAX_STATENAME_LEN];  /* Names of all State Functions. Printed to trail at each state transition. */
char HndshkMsgName[GHS_MAX_STATES][MAX_STATENAME_LEN];  // Names of all handshake message states(types)
char HSMsgType[GHS_MAX_HS_MSG_TYPES][MAX_STATENAME_LEN]; // Names of all handshake message types
char PreferredModeName[MAX_NUM_PREFFERED_MODES][MAX_STATENAME_LEN]; // Names of the DSL(BIS AnnexA/L) preferred mode (mode that will decide different PSD mask value)
DATA_MAP_END
#endif /*  LEAVE_TRAIL */

/* =============================================== */
/* static function prototypes */
/* =============================================== */
void PrintInfoField( TRAILFILE trail_fid, InfoField_t * t_Info );


#ifdef LEAVE_TRAIL
/*****************************************************************************
;  Prototype: int16 OpenTrailFile(void);
;
;  Description:
;     Opens trail file
;
;  Arguments:
;
;  Return:
;     SUCCEED -- open files succeed
;     FAIL  -- open files fails
;
;  Global Variables:
;     trail_fid   -- (O) trail file pointer
;****************************************************************************/
int16 OpenTrailFile(void)
{

   if( (trail_fid = FOPEN_TRAILFILE( "trail.txt", "wt" )) == NULL )

   {
      fprintf(stderr, "could not open trail file for output\n");
      return((int16)FAIL);
   }

   if( (crc_fid = FOPEN_TRAILFILE( "crc.txt", "wt" )) == NULL )
   {
      fprintf(stderr, "could not open crc text file for output\n");
      return((int16)FAIL);
   }
   gft_ShowtimeStateReached = 0;

   return((int16)SUCCEED);
}


/*****************************************************************************
;  Prototype: void PrnHeader(void);
;
;  Description:
;     Print header to trail file
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;     trail_fid   -- (O) trail file pointer
;****************************************************************************/
void PrnHeader(void)
{
   fprintf(stderr, "%15s%6s%7s%8s%7s\n", "State", "Next", "Symbol","Total", "State");
   fprintf(stderr, "%15s%6s%7s%8s%7s\n", "Code", "State","Count", "Symbols", "Name");
   FPRINTF_TO_TRAILFILE(trail_fid, "%15s%6s%7s%8s%7s\n", "State", "Next", "Symbol","Total", "State");
   FPRINTF_TO_TRAILFILE(trail_fid, "%15s%6s%7s%8s%7s\n", "Code", "State","Count", "Symbols", "Name");
}
#endif /* LEAVE_TRAIL */

/*^^^
*-------------------------------------------------------------------
*  Prototype:
*  void GhsLeaveTrail(int16 s_State, int16 s_NextState, int16 s_SymbolCount, char *stateDir, int16 msgType, Adsl2AllInfo_t *pt_Adsl2AllInfo);
*
*   This function, at Handshake Message Echange state transitions, write
*   out current state and next state.
*
*  Input Arguments:
*     s_State        -- current state
*     s_NextState    -- current next state
*       s_SymbolCount   -- # of symbols in this state
*
*  Output Arguments: none
*
*  Global Variables:
*     trail_fid       -- file pointer to trail file
*
*-------------------------------------------------------------------
*^^^
*/
void GhsLeaveTrail(int16 s_State, int16 s_NextState, int16 s_SymbolCount, char* stateDir, int16 msgType, Adsl2AllInfo_t *pt_Adsl2AllInfo) {
#ifdef LEAVE_TRAIL
   if (strstr(stateDir, "TX") != NULL) {
      FPRINTF_TO_TRAILFILE( trail_fid, "HS State:  TX     %5d%6d%7d%25s   (Sent %s Msg)\n", s_State, s_NextState, s_SymbolCount, HndshkMsgName[s_State-R_HS_INITIAL], HSMsgType[msgType] );
      fprintf(stderr, "CPE: HS State:  TX    %d %d %d  \t%s   (Sent %s Msg)\n", s_State, s_NextState, s_SymbolCount, HndshkMsgName[s_State-R_HS_INITIAL], HSMsgType[msgType] );
   }
   else if (strstr(stateDir, "RX") != NULL) {
      FPRINTF_TO_TRAILFILE( trail_fid, "HS State:    RX   %5d%6d%7d%25s   (Rcvd %s Msg)\n", s_State, s_NextState, s_SymbolCount, HndshkMsgName[s_State-R_HS_INITIAL], HSMsgType[msgType] );
      fprintf(stderr, "CPE: HS State:    RX  %d %d %d  \t%s   (Rcvd %s Msg)\n", s_State, s_NextState, s_SymbolCount, HndshkMsgName[s_State-R_HS_INITIAL], HSMsgType[msgType] );
   }
   else if (strstr(stateDir, "CLR Resend") != NULL) {
      FPRINTF_TO_TRAILFILE( trail_fid, "CLR Resend:  Reson Code:   %d  ", s_State);
      fprintf(stderr, "CPE: CLR Resend:  Reson Code:   %d  ", s_State);

      switch (s_State)
      {
      case 1: // different preferred mode
         FPRINTF_TO_TRAILFILE( trail_fid, "New Preferred Mode: %s\n", PreferredModeName[s_NextState]);
         fprintf(stderr, "New Preferred Mode: %s\n", PreferredModeName[s_NextState]);
         break;

      case 2: // CLR has higher US PSD
         FPRINTF_TO_TRAILFILE(trail_fid, "New (NOMPSD MAXNOMPSD MAXNOMATP):: %-4d%-4d%-4d\n",
            pt_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD, pt_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD, pt_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP);
         fprintf(stderr, "New (NOMPSD MAXNOMPSD MAXNOMATP):: %-4d%-4d%-4d\n",
            pt_Adsl2AllInfo->t_PMD_NPar3_US.s_NOMPSD, pt_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMPSD, pt_Adsl2AllInfo->t_PMD_NPar3_US.s_MAXNOMATP);
         break;

      case 4: // CL send different US Tssi info, dummy for now
         FPRINTF_TO_TRAILFILE(trail_fid, "CO Sends inconsistent US Tssi\n");
         fprintf(stderr, "CO Sends inconsistent US Tssi\n");
         break;

      default:
         break;
      }
   }
   else if (strstr(stateDir, "Ignore Difference") != NULL) {
      FPRINTF_TO_TRAILFILE( trail_fid, "Ignore Difference:  Reson Code:   %d  ", s_State);
      fprintf(stderr, "CPE: CLR ResendIgnore Difference:  Reson Code:   %d  ", s_State);
      if (s_State == TSSI_BreakPoint_OVERFLOW)
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "No enough memory to store additional US Tssi breakpoint\n");
         fprintf(stderr, "No enough memory to store additional US Tssi breakpoint\n");
      }
   }
   FFLUSH_TO_TRAILFILE(trail_fid);
   fflush(stderr);
#endif

}

#ifdef PRINT_SIM_END_RESULTS
/*****************************************************************************
;  Prototype: void PrnInitialCLR(void)
;
;  Description:
;      Prints initial CLR to trail file.
;
;  Arguments: none
;
;  Returns: none
;
;  Global Variables: none
;
;****************************************************************************/
void PrnInitialCLR(void)
{
#ifdef LEAVE_TRAIL
    /* ---- Trail for handshaking ---- */
   if (TESTArray[TEST_InitState] == TEST_GhsInitState)
   {
        FPRINTF_TO_TRAILFILE( trail_fid, "\nCLR Message prior to G.hs:\n" );
        PrintInfoField( trail_fid, gpt_TxInfo );
        FPRINTF_TO_TRAILFILE( trail_fid, "\n\n" );
    }
#endif
}
#endif  /* PRINT_SIM_END_RESULTS */

/*****************************************************************************
;  Prototype: void  PrnStatus(void);
;
;  Description:
;     Prints the status on screen
;     For g.hs, and Initialization it prints the Tx State Name Tx Symbol
;     Count, and then Rx State Name and Rx symbol count every 4 symbols
;
;    For showtime tests, it prints the running CRC error count on
;  Fast and Interleaved path for g.dmt and for LP0 and LP1 data path for g.bis
;    in addition to the symbol counts
;
;    For showtime connectivity tests, in addition to the above two, it prints the
;    Bert Pattern Synch for the active bearer channels
;
;  Globals :gl_TxSymbolCount,gl_RxSymbolCount, gft_ModemType,
;  gft_ShowtimeStateReached,gt_RxShowTimeVars,gusa_CRC_count,gta_RxBertStat
;
;
;****************************************************************************/

#ifdef   LEAVE_TRAIL

void PrnStatus(void)
{
   char ca_StatusString[128], ca_TempString[64],uca_chan_str[2][5];
   int16 s_Lp, s_Bc,s_Synch[NUM_DATA_PATHS*NUM_DS_BEARER_CHANNELS],s_num_active_channels;

   if ((gl_RxSymbolCount&0x3)==0)      // Print status every 4th frame.
   {

      if (gft_ShowtimeStateReached){
         if(gft_ModemType==G_DMT){
            sprintf(ca_StatusString, "Rx SymCnt=%d CRCErr[f,i]={%d,%d} FEC[f,i]={%d,%d}",gl_RxSymbolCount, gusa_CRC_count[FAST_DATA_PATH], gusa_CRC_count[INTERLEAVE_DATA_PATH], gsa_CorrectedRSErrors[FAST_DATA_PATH], gsa_CorrectedRSErrors[INTERLEAVE_DATA_PATH]);    ////XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
         }
         else{
            if(gt_rx_config.s_Lp[LP1_DATA_PATH]==0)
               sprintf(ca_StatusString, "Rx SymCnt=%d CRCErr[LP0,LP1]={%d,%c}",gl_RxSymbolCount, gusa_CRC_count[LP0_DATA_PATH], '-');
            else
               sprintf(ca_StatusString, "Rx SymCnt=%d CRCErr[LP0,LP1]={%d,%d}",gl_RxSymbolCount, gusa_CRC_count[LP0_DATA_PATH], gusa_CRC_count[LP1_DATA_PATH]);  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
         }
         if ((TESTArray[TEST_Control] & TEST_BertControl) != 0){

            s_num_active_channels=0;

            for(s_Lp=0; s_Lp<2;s_Lp++){
               for(s_Bc=0;s_Bc<NUM_DS_BEARER_CHANNELS;s_Bc++)
                  if(gt_rx_config.sa_Bpn[s_Lp][s_Bc]==0)
                     ;
                  else{
                     s_Synch[s_num_active_channels]=s_Bc;
                     switch (s_Bc)
                     {
                     case 0:
                        strcpy(uca_chan_str[s_num_active_channels++], "AS0");
                        break;
                     case 1:
                        strcpy(uca_chan_str[s_num_active_channels++], "AS1");
                        break;
                     case 2:
                        strcpy(uca_chan_str[s_num_active_channels++], "AS2");
                        break;
                     case 3:
                        strcpy(uca_chan_str[s_num_active_channels++], "AS3");
                        break;
                     case 4:
                        strcpy(uca_chan_str[s_num_active_channels++], "LS0");
                        break;
                     case 5:
                        strcpy(uca_chan_str[s_num_active_channels++], "LS1");
                        break;
                     case 6:
                        strcpy(uca_chan_str[s_num_active_channels++], "LS2");
                        break;
                     }

                  }

            }

            switch (s_num_active_channels)
            {
            case 1:
               sprintf(ca_TempString,",RxBertSync[%s]={%d}",uca_chan_str[0],gta_RxBertStat[0].s_pattern_sync,'-','-','-','-','-','-');
               break;

            case 2:
               sprintf(ca_TempString,",RxBertSync[%s %s]={%d %d}",uca_chan_str[0],uca_chan_str[1],gta_RxBertStat[0].s_pattern_sync,gta_RxBertStat[1].s_pattern_sync);
               break;

            case 3:
               sprintf(ca_TempString,",RxBertSync[%s %s %s]={%d %d %d}",uca_chan_str[0],uca_chan_str[1],uca_chan_str[2],gta_RxBertStat[0].s_pattern_sync,gta_RxBertStat[1].s_pattern_sync,gta_RxBertStat[2].s_pattern_sync);
               break;

            case 4:
               sprintf(ca_TempString,",RxBertSync[%s %s %s %s]={%d %d %d %d}",uca_chan_str[0],uca_chan_str[1],uca_chan_str[2],uca_chan_str[3],gta_RxBertStat[0].s_pattern_sync,gta_RxBertStat[1].s_pattern_sync,gta_RxBertStat[2].s_pattern_sync,gta_RxBertStat[3].s_pattern_sync,'-','-');
               break;

            case 5:
               sprintf(ca_TempString,",RxBertSync[%s %s %s %s %s]={%d %d %d %d %d}",uca_chan_str[0],uca_chan_str[1],uca_chan_str[2],uca_chan_str[3],uca_chan_str[4],gta_RxBertStat[0].s_pattern_sync,gta_RxBertStat[1].s_pattern_sync,gta_RxBertStat[2].s_pattern_sync,gta_RxBertStat[3].s_pattern_sync,gta_RxBertStat[4].s_pattern_sync);
               break;

            case 6:
               sprintf(ca_TempString,",RxBertSync[%s %s %s %s %s %s]={%d,%d,%d %d %d %d}",uca_chan_str[0],uca_chan_str[1],uca_chan_str[2],uca_chan_str[3],uca_chan_str[4],uca_chan_str[5],gta_RxBertStat[0].s_pattern_sync,gta_RxBertStat[1].s_pattern_sync,gta_RxBertStat[2].s_pattern_sync,gta_RxBertStat[3].s_pattern_sync,gta_RxBertStat[4].s_pattern_sync,gta_RxBertStat[5].s_pattern_sync,'-');
               break;

            case 7:
               sprintf(ca_TempString,",RxBertSync[%s %s %s %s %s %s %s]={%d,%d,%d %d %d %d %d}",uca_chan_str[0],uca_chan_str[1],uca_chan_str[2],uca_chan_str[3],uca_chan_str[4],uca_chan_str[5],uca_chan_str[6],gta_RxBertStat[0].s_pattern_sync,gta_RxBertStat[1].s_pattern_sync,gta_RxBertStat[2].s_pattern_sync,gta_RxBertStat[3].s_pattern_sync,gta_RxBertStat[4].s_pattern_sync,gta_RxBertStat[5].s_pattern_sync,gta_RxBertStat[6].s_pattern_sync);
               break;
            }
            sprintf(ca_TempString, " ");
            strcat(ca_StatusString, ca_TempString);
         }
         strcat(ca_StatusString,"\r");
         fprintf(stderr, ca_StatusString);
      }

      else
      {
         fprintf(stderr,"%s(%d) TxCnt=%d %s(%d) RxCnt=%d \r", StateName[gs_TxState], gs_TxState, gl_TxSymbolCount, StateName[gs_RxState], gs_RxState, gl_RxSymbolCount);
      }

   }
}
#endif

int16 gs_SyncSymbolCaptureTone;
#ifdef COLLECT_SYNCSYMBOL_INFO
   int16 gs_RxSyncSymbolBufferIndex, gs_RxSyncSymbolCount;
#endif /* #ifdef COLLECT_SYNCSYMBOL_INFO  */

/****************************/
/* SOCRATES DEBUG TRAIL */
/*****************************/

#if defined(DANUBE) && defined(TARGET_HW)
    DATA_MAP_ILV2
    int16 gsa_TrainStatesTrail[DEBUG_TRAIL_SIZE];
    DATA_MAP_END
    int16 gsa_ShowTimeStatesTrail[DEBUG_TRAIL_SMALL_SIZE];
    int16 *gsa_StatesTrail = gsa_TrainStatesTrail;
#else
    #ifdef ADSL_62
    DATA_EXTENDED_RES_BSS_BEGIN
    #endif
    int16 gsa_StatesTrail[DEBUG_TRAIL_SIZE];
    #ifdef ADSL_62
    DATA_MAP_END
    #endif
#endif

DebugTrailTriggerControl_t gt_debugTrailTriggerControl;
DebugTrailCollectControl_t gt_debugTrailCollectControl;
#ifdef DANUBE
    DebugTrailCollectControl_t gt_TrailXmemCollectControl;
#endif


#ifdef PROFILE_PHASEERR
   int16  gs_LogPhaseErr, gs_MaxPhaseErr, gs_MaxPhaseErrRxState, gs_MaxPhaseErrRxSubState;
#endif

#ifdef INSERT_ST_BRKPT  // Note: If enabled, update crc and mrgn threshold as per requirement
   int16 gs_stBrkpntCriteria; //can enable more than one criterias @ a time, see trail.h
#endif

/*****************************************************************************
;  Prototype: void isStateTrigger(int16 s_State, int16 s_SubState, int32 l_SymbolCount)
;
;  Description:
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/

void isStateTrigger(int16 s_State, int16 s_SubState, int32 l_SymbolCount)
{
#ifdef INSERT_ST_BRKPT  // Note: If enabled, update crc and mrgn threshold as per requirement
//XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
   if ((gs_stBrkpntCriteria & BRKPT_ON_CRC && gusa_CRC_count[LP0_DATA_PATH]>1000) ||
      (gs_stBrkpntCriteria & BRKPT_ON_MRGN && gs_RxAvMargin<0) ||
      (gs_stBrkpntCriteria & BRKPT_ON_LOS && gs_NearEndFailure&PLAM_LOS_FailureBit) ||
      (gs_stBrkpntCriteria & BRKPT_ON_LOSSEF_PILOT && gl_DD_numDiscardedDataFrames!=0))
   {
      Pause(0x0BAD);
   }
#endif

   if (gt_debugTrailTriggerControl.s_triggerRxState == s_State &&
      (gt_debugTrailTriggerControl.s_triggerRxSubState == s_SubState || gt_debugTrailTriggerControl.s_triggerRxSymbolCount == (int16) l_SymbolCount))
      gt_debugTrailTriggerControl.ft_StateTrigger = TRUE;

}

/*****************************************************************************
;  Prototype: DebugTrail(int16 s_count, ... )
;
;  Description:
;  Declare function to take variable number of input arguments first argument
;  (s_count) specifies # of input arguments for logging second argument
;  specifies the log type the subsequent s_count arguments forms the log data
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void DebugTrail(int16 s_count, ... )
{
   va_list argp; /* arg ptr */
   int16 s_logType;

   /* initalize var ptr */
   va_start( argp, s_count );

   /* check if valid logtype */
   s_logType = va_arg( argp, int16 );
   //Check if any unary flags match
   if ((gt_debugTrailTriggerControl.s_logType & (~DEBUG_LOG_4BITMASK) & s_logType) ||
      // or check if binary bitfield matches and is nonzero
      ((gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_4BITMASK) &&
      ((gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_4BITMASK) == (s_logType & DEBUG_LOG_4BITMASK))))
   {
      /* repeat for each arg */
      while(s_count-- > 0 && gt_debugTrailCollectControl.s_debugTrailLen < gt_debugTrailCollectControl.s_debugTrailSize)
      {
         *(INFOMap[INFO_DebugTrail] + gt_debugTrailCollectControl.s_debugTrailLen) = va_arg( argp, int16 );
         gt_debugTrailCollectControl.s_debugTrailLen++;
         if (gt_debugTrailTriggerControl.s_cyclicTrailUpdate &&
            gt_debugTrailCollectControl.s_debugTrailLen == gt_debugTrailCollectControl.s_debugTrailSize)
         {
            gt_debugTrailCollectControl.s_debugTrailLen = 0;
         }
      }
   }

   /* done with args */
   va_end( argp );
}


/*****************************************************************************
;  Prototype: void logShowtimeEventB(uint32 ul_data)
;
;  Description:
;  A function that is called from the modem code to log debugging information
;  into the statesTrail buffer when the far-end indicator bits change.
;  Note that we ignore the far end bits if there are receive crc to avoid ib
;  changes that are really crc errors.

;   The logged info is:
               us_marker ,             [BBB0 ] to delimit data in the buffer.
               gl_RxSymbolCount,       Lower part of symbol count.
               ul_data                 FE indicator bits.
;

;  Arguments:
;              ul_data        FE indicator bits.
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void logShowtimeEventB(uint32 ul_data) {

// first check if we want to record it
      if( ((gs_crc_cnt + gs_los_cnt + gs_sef_cnt)>0) || (gs_contiguous_bad_sec_cnt> 0) )
         return;

      DebugTrail(4, DEBUG_LOG_SHOW_EVENT , 0xBBB0 , (int16) gl_RxSymbolCount ,(int16) (ul_data),(int16) (ul_data>>16)  );
   }

/*
AAA0: symbol data tone70R crc contigBad-Good

  */

