/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   trail_nost.c
*
*  Some of the functions used for generating the trail log file.
*  These are functions needed to open and update the log file during
*  execution. These functions are used in states other than showtime
*  The file 'trailend.c' contains additional printing functions needed
*  only after completion of execution.
*
*-------------------------------------------------------------------------
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "typedef.h"
#include "common.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "cmv.h"
#include "rt_state.h"
#include "trailfileio_defs.h"
#include "trail_data_const.h"
#include "data_alloc.h"
#include "gdata.h"
#include "bert.h"
#include "trail.h"
#include "const_bis.h"
#include "rx_ib.h"
#include "pll.h"

/* =============================================== */
/* global variable declarations */
/* =============================================== */
int32 gl_Total_TX_symbols = 0;                  /*  total number of TX symbols */
int32 gl_Total_RX_symbols = 0;                  /*  total number of RX symbols */

/*^^^
*-------------------------------------------------------------------
*  Prototype:
*  void LeaveTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, char *name);
*
*   Description:
*     This function, at state transitions, write out current state, next state and count.
*     Also save info to buffer.
*
*  Arguments:
*     l_SymbolCound  -- current symbol count
*     s_State        -- current state
*     s_NextState    -- current next state
*     name        -- "TX" or "RX"
*
*  Global Variables:
*     gl_Total_TX_symbols  -- (I/O) the total number of TX symbols gone through far
*     gl_Total_RX_symbols  -- (I/O) the total number of RX symbols gone through far
*
*-------------------------------------------------------------------
*^^^
*/
void LeaveTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, char *name) {

   int32 l_count;
   l_count = l_SymbolCount + 1;
#ifdef LEAVE_TRAIL
   /* Update the total state count */
   if(strstr(name, "TX") != NULL){
      strcpy(formatted_name, name); // Left justify 'TX'
      strcat(formatted_name, "  ");
      gl_Total_TX_symbols += l_count;
      l_Total_symbols_to_print = gl_Total_TX_symbols;
   }

   else {
      strcpy(formatted_name, "  "); // Offset 'RX' to right by two spaces
      strcat(formatted_name, name);
      gl_Total_RX_symbols += l_count;
      l_Total_symbols_to_print = gl_Total_RX_symbols;
   }

   FPRINTF_TO_TRAILFILE(trail_fid,  "%5s%5s%5d%6d%7ld%8ld  %s\n", "CPE: ",formatted_name, s_State, s_NextState, l_count, l_Total_symbols_to_print, StateName[s_State]);
   FFLUSH_TO_TRAILFILE(trail_fid);
   fprintf(stderr, "%5s%5s%5d%6d%7ld%8ld  %s \t \t\n", "CPE: ",formatted_name, s_State, s_NextState, l_count, l_Total_symbols_to_print, StateName[s_State]);
   fflush(stderr);

   if (s_State == R_C_SHOWTIME_RX || s_NextState == R_C_SHOWTIME_RX ||
      s_State == R_SHOWTIME_TX || s_NextState == R_SHOWTIME_TX)
   {
      gft_ShowtimeStateReached = 1;
   }
#endif /* LEAVE_TRAIL */

   DebugTrail(3, DEBUG_LOG_STATESTRAIL, s_State, s_NextState, (int16)l_count);
}


/****************************/
/* SOCRATES DEBUG TRAIL */
/*****************************/
void isRxSubStateTrigger(void)
{
   if (gt_debugTrailTriggerControl.s_prevRxState != gs_RxState ||
      gt_debugTrailTriggerControl.s_prevRxSubState != gs_RxSubState)
   {
   #ifdef PROFILE_TASKS
      RxProfileTasks();
   #endif

   #ifdef PROFILE_PHASEERR
      ProfilePhaseErr();
   #endif

      gt_debugTrailTriggerControl.s_prevRxState = gs_RxState;
      gt_debugTrailTriggerControl.s_prevRxSubState = gs_RxSubState;
   }
}

void isTxSubStateTrigger(void)
{
   if (gt_debugTrailTriggerControl.s_prevTxState != gs_TxState ||
      gt_debugTrailTriggerControl.s_prevTxSubState != gs_TxSubState)
   {
   #ifdef PROFILE_TASKS
      TxProfileTasks();
   #endif

      gt_debugTrailTriggerControl.s_prevTxState = gs_TxState;
      gt_debugTrailTriggerControl.s_prevTxSubState = gs_TxSubState;
   }
}

#ifdef PROFILE_TASKS

/*****************************************************************************
;  Prototype: void ProfileTaskInit(void)
;
;  Description:
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void ProfileTaskInit(void)
{
/*===================================================================

The following variables are used to monitor the Task MIPS count
for each TC and NTC Task.

===================================================================*/
   int16 i;

   for (i = 0; i < NUM_TC_NTC; i++)
   {
      gsa_LogMips[i] = 0;
      gsa_MaxMips[i] = 0;

      if ( i < NUM_TRN_TC_NTC) {
      gsa_MaxMipsState[i] = 0;
      gsa_MaxMipsSubState[i] = 0;
      }
   }

   gft_RxCPInserted = FALSE;
}

/*****************************************************************************
;  Prototype: void RxProfileTasks(void)
;
;  Description:
;
;           The ProfileTasks function is used to monitor the processing
;  time of TC and NTC tasks.  Each of these tasks measures its processing time
;  each call and keeps track of the maximum duration.  The ProfileTasks
;  function monitors the RxSubState.  At each RxSubState change, the current
;  maximum duration for each task is logged and then cleared.  The resulting
;  log file is provides a measure of the processing time (or MIPS load) as
;  a function of time.
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void RxProfileTasks(void)
{
/* =============================================== */
/* Capture timing information */
/* =============================================== */
   if (gt_debugTrailTriggerControl.ft_StateTrigger)
   {
      DebugTrail(7, DEBUG_LOG_MIPS, 0xFFFF, gsa_LogMips[RX_TC_FS], gsa_LogMips[RX_TC_FDQ], gsa_LogMips[RX_NTC], gt_debugTrailTriggerControl.s_prevRxState, gt_debugTrailTriggerControl.s_prevRxSubState, gs_RxSubState);

      gsa_LogMips[RX_TC_FS] = 0;
      gsa_LogMips[RX_TC_FDQ] = 0;
      gsa_LogMips[RX_NTC] = 0;
   }
}

/*****************************************************************************
;  Prototype: void TxProfileTasks(void)
;
;  Description:
;
;        The TxProfileTasks function is the transmit path analog to the
;  RxProfileTasks function described above.
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void TxProfileTasks(void)
{
/* =============================================== */
/* Capture timing information */
/* =============================================== */
   if (gt_debugTrailTriggerControl.ft_StateTrigger)
   {
      DebugTrail(6, DEBUG_LOG_MIPS, 0xEEEE, gsa_LogMips[TX_TC_FS], gsa_LogMips[TX_NTC], gt_debugTrailTriggerControl.s_prevTxState, gt_debugTrailTriggerControl.s_prevTxSubState,gs_TxSubState);

      gsa_LogMips[TX_TC_FS] = 0;
      gsa_LogMips[TX_NTC] = 0;
   }
}


#endif /* ifdef PROFILE_TASKS */

#ifdef PROFILE_PHASEERR

/*****************************************************************************
;  Prototype: void ProfilePhaseErrInit(void)
;
;  Description:
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void ProfilePhaseErrInit(void)
{
   gs_LogPhaseErr = 0;
   gs_MaxPhaseErr = 0;
   gs_MaxPhaseErrRxState = 0;
   gs_MaxPhaseErrRxSubState = 0;
}

/*****************************************************************************
;  Prototype: void ProfilePhaseErr(void)
;
;  Description:
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void LogPhaseError(void)
{
   int16 s_abs;

   s_abs = gs_PhaseError;
   if(gs_PhaseError < 0)
      s_abs = -gs_PhaseError;

   if (s_abs > gs_LogPhaseErr) {
      gs_LogPhaseErr = s_abs;
   }

   if (s_abs > gs_MaxPhaseErr) {
      gs_MaxPhaseErr = s_abs;
      gs_MaxPhaseErrRxState = gs_RxState;
      gs_MaxPhaseErrRxSubState = gs_RxSubState;
   }
}

/*****************************************************************************
;  Prototype: void ProfilePhaseErr(void)
;
;  Description:
;
;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void ProfilePhaseErr(void)
{
/* =============================================== */
/* Capture phase error information  */
/* =============================================== */
   if (gt_debugTrailTriggerControl.ft_StateTrigger && gs_LogPhaseErr)
   {  // if trigger set and phase error non-zero
      DebugTrail(3, DEBUG_LOG_PHASEERROR, gs_LogPhaseErr, gt_debugTrailTriggerControl.s_prevRxState, gt_debugTrailTriggerControl.s_prevRxSubState);
   }
   gs_LogPhaseErr = 0;
}
#endif /* ifdef PROFILE_PHASEERR */

