/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   trail_st.c
*
*  Some of the functions used for generating the trail log file.
*  These are functions needed to open and update the log file during
*  execution. These functions are used only in showtime
*  The file 'trailend.c' contains additional printing functions needed
*  only after completion of execution.
*
*-------------------------------------------------------------------------
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "typedef.h"
#include "common.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "cmv.h"
#include "rt_state.h"
#include "trailfileio_defs.h"
#include "trail_data_const.h"
#include "data_alloc.h"
#include "gdata.h"
#include "bert.h"
#include "trail.h"
#include "const_bis.h"
#include "rx_ib.h"

/* =============================================== */
/* global variable declarations */
/* =============================================== */



#ifdef COLLECT_SYNCSYMBOL_INFO

/*****************************************************************************
;  Prototype: void CollectSyncSymbols(void)
;
;  Description:
;
;           The CollectSyncSymbols function is used to monitor a tone in the received
;  tone buffer during sync symbols.
;
;     The gsa_StatesTrail is used to log the data.  Other trail functions
;  also share this buffer.  It is recommended that only one trail function
;  be enabled at a time.
;
;  The CollectSyncSymbols function may be enabled by setting gs_RxSyncSymbolCount to any
;  value >= 0, and setting the variable gs_SyncSymbolCaptureTone to a tone between 0  to 511.

;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void CollectSyncSymbols(void)
{

   /* =============================================== */
   /* Capture one tone during sync symbol */
   /* =============================================== */
   if ((gs_RxSyncSymbolBufferIndex < (2*MAX_STATES - 20)) && ((int32)gs_RxSyncSymbolCount <= gl_rx_sframe_count) )

   {
      /* enter here only in showtime, during sync symbol only, only until statestrail buffer is not full */
      /* and for super frames greater than the number indicated in gs_RxSyncSymbolCount */
      /* We are capturing only one tone from gsa_RxToneBuf. This tone is indicated in the variable */
      /* gs_SyncSymbolCaptureTone */

      gsa_StatesTrail[gs_RxSyncSymbolBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone];
      gsa_StatesTrail[gs_RxSyncSymbolBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone+1];
      gsa_StatesTrail[gs_RxSyncSymbolBufferIndex++] = gusa_CRC_count[FAST_DATA_PATH];  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
      gsa_StatesTrail[gs_RxSyncSymbolBufferIndex++] = gusa_CRC_count[INTERLEAVE_DATA_PATH];  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
   }

}
#endif /* #ifdef COLLECT_SYNCSYMBOL_INFO */

#ifdef COLLECT_SHOWTIME_EVENTS_INFO

/*****************************************************************************
;  Prototype: void CollectBadSyncSymbols(void)
;
;  Description:
;
;           The CollectBadSyncSymbols function is used to monitor a tone in the received
;  tone buffer during sync symbols. If the tone goes +/-0x2000+threshold, the tone is logged
;   into gsa_statestrail buffer.
;
;     The gsa_StatesTrail is used to log the data.  Other trail functions
;  also share this buffer.  It is recommended that only one trail function
;  be enabled at a time.
;
;  The CollectBadSyncSymbols function may be enabled by
;  setting the variable gs_SyncSymbolCaptureTone to a tone between 0  to 511.

;  Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void CollectBadSyncSymbols(void)
{
   int16 s_temp_real, s_temp_imag;

   /* =============================================== */
   /* Capture one tone during sync symbol */
   /* =============================================== */
   if(gs_RxShowtimeEventsInfoBufferIndex < (2*MAX_STATES - 20))

   {
      /* enter here only in showtime, during sync symbol only, only until statestrail buffer is not full */
      /* We are capturing only one tone from gsa_RxToneBuf. This tone is indicated in the variable */
      /* gs_SyncSymbolCaptureTone */

      s_temp_real = abs(gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone]);
      s_temp_imag = abs(gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone+1]);

      if ( (s_temp_real > (0x2000+gs_RxShowtimeEventsInfo_SyncSymbolThreshold)) ||
         (s_temp_real < (0x2000-gs_RxShowtimeEventsInfo_SyncSymbolThreshold)) ||
         (s_temp_imag > (0x2000+gs_RxShowtimeEventsInfo_SyncSymbolThreshold)) ||
         (s_temp_imag < (0x2000-gs_RxShowtimeEventsInfo_SyncSymbolThreshold)) )
      {
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) 0x1234;
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = (int16) gl_RxSymbolCount;
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone];
         gsa_StatesTrail[gs_RxShowtimeEventsInfoBufferIndex++] = gsa_RxToneBuf[2*gs_SyncSymbolCaptureTone+1];
      }
   }
   else
   {
      gs_RxShowtimeEventsInfoBufferIndex = gs_InitRxShowtimeEventsInfoBufferIndex;
   }
   if (gs_febe_cnt > gs_RxShowtimeEventsError_threshold)
      gs_InitRxShowtimeEventsInfoBufferIndex = 2*MAX_STATES;

}
#endif /* #ifdef COLLECT_SHOWTIME_EVENTS_INFO */

