/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   trailphaserr.c
*
*  This file contains global variable declarations.
*
*-------------------------------------------------------------------------
*/
#include "gdata.h"
#include "common.h"
#include "dsp_op2.h"
#include "typedef.h"
#include "trailphaserr.h"
#include "trail.h"
#include "trailfileio_defs.h"
#include <stdlib.h>
#include "pll.h"

#ifdef LEAVE_TRAIL
int16 gs_PrevRxSubState = -1;
int16 gs_RxCurrentSt=-1;
int16 gs_RxMaxPhErr =0;
int16 gs_SubStIdx;
int16 gs_RxStateCnt =0;
PhaseErr gsa_MaxPhErrBuf[MAXPHBUF_SIZE];
int16  gs_StateIdx =-1;
#endif

/****************************************************************************
;  Prototype: void TrailPhaseError(void);
;
;  Description:
;       This function is called in checkforcodeswap().
;     This function trail the maximum phase error for each state
;
;  Arguments:
;     none
;
;  Return Value:
;     none
********************************************************************/
void TrailPhaseError(void)
{
#ifdef LEAVE_TRAIL
if (gs_RxState != gs_RxCurrentSt) {
//If state has changed, change the array index, change the
//state number, and init the number of substate (=0) having
//phase error, init the substate as -1.
   gs_SubStIdx = -1;
   if(gs_StateIdx >= MAXPHBUF_SIZE)
   {
      printf("Too many states, array memory overflow\n");
      return;
   }
   gs_StateIdx ++;
   gs_RxStateCnt ++;
   gs_RxCurrentSt = gs_RxState;
   gsa_MaxPhErrBuf[gs_StateIdx].RxStateNum = gs_RxState;
   gsa_MaxPhErrBuf[gs_StateIdx].NumOfSubSt =0;
   gs_PrevRxSubState = -1;

}
   // check if substate changed

   if (gs_RxSubState != gs_PrevRxSubState){
         if(gs_SubStIdx >= MAX_SUBSTATES)
         {
            printf("Too many substates, array memory overflow\n");
            return;
         }
         gs_SubStIdx++;
         gs_PrevRxSubState = gs_RxSubState;
         gs_RxMaxPhErr = gs_PhaseError; //init max = current error

         //move pointer to next unit
         gsa_MaxPhErrBuf[gs_StateIdx].ErrorInfo[gs_SubStIdx].SubStateNumber   = gs_RxSubState;
         gsa_MaxPhErrBuf[gs_StateIdx].ErrorInfo[gs_SubStIdx].MaxPhaseErr = gs_RxMaxPhErr;
         gsa_MaxPhErrBuf[gs_StateIdx].ErrorInfo[gs_SubStIdx].FrameNumber = (int16) gl_RxSymbolCount;
         gsa_MaxPhErrBuf[gs_StateIdx].NumOfSubSt ++;
      }

   //if same substate, check if error becomes greater

   else {
      if(abs_s(gs_PhaseError ) > abs_s(gs_RxMaxPhErr)){
      //update the max error if the new error is greater
            gs_RxMaxPhErr = gs_PhaseError;
            gsa_MaxPhErrBuf[gs_StateIdx].ErrorInfo[gs_SubStIdx].MaxPhaseErr = gs_PhaseError;
            gsa_MaxPhErrBuf[gs_StateIdx].ErrorInfo[gs_SubStIdx].FrameNumber = (int16) gl_RxSymbolCount;
         }
      }
#endif
}
/****************************************************************************
;  Prototype: void PrintPhaseErrLog(void);
;
;  Description:
;       This function is called in trailend.c
;     This function print the maximum phase error for each state
;
;  Arguments:
;     none
;
;  Return Value:
;     none
********************************************************************/
#ifdef LEAVE_TRAIL
void PrintPhaseErrLog(void)
{
   int16 i, s_count;

   FPRINTF_TO_TRAILFILE(trail_fid, "\nPilot tone = %d", gs_PilotToneIdx);
   if (gs_UpdateTimingRecoveryHWEnable)
      FPRINTF_TO_TRAILFILE(trail_fid, "\nSRC Updates Enabled");
   else
      FPRINTF_TO_TRAILFILE(trail_fid, "\nSRC Updates Disabled");
   FPRINTF_TO_TRAILFILE(trail_fid, "\nPLL Phase Error Information (with 1 radian = 8192):\n\n");

   for (s_count=0; s_count < gs_RxStateCnt; s_count++){
      FPRINTF_TO_TRAILFILE(trail_fid, "RxState: %d, (%s) \n", gsa_MaxPhErrBuf[s_count].RxStateNum, StateName[gsa_MaxPhErrBuf[s_count].RxStateNum]);

      for (i=0; i< gsa_MaxPhErrBuf[s_count].NumOfSubSt; i++){
         FPRINTF_TO_TRAILFILE(trail_fid, "   SubState: %d,\tMaxPhaseError = %d \tat Frame %d\n", gsa_MaxPhErrBuf[s_count].ErrorInfo[i].SubStateNumber, gsa_MaxPhErrBuf[s_count].ErrorInfo[i].MaxPhaseErr, gsa_MaxPhErrBuf[s_count].ErrorInfo[i].FrameNumber);
      }
   }

}

#endif
