/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TRAILPHASERR_H
#define _TRAILPHASERR_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  trailphaserr.h
;
;  Header file for functions in trailphaserr.c
;
*****************************************************************************/
#define MAXPHBUF_SIZE  60   //buffer size for max_phase_error info.
#define MAX_SUBSTATES  300   // max # of substates for each state.

typedef struct{
   int16  SubStateNumber;           //
   int16  MaxPhaseErr;           //
   int16  FrameNumber; //
} ErrInfo;

typedef struct{
   int16  RxStateNum;            //The RX_STATE NUMBER
   int16  NumOfSubSt;            //Number of Substates logged in current state
   ErrInfo  ErrorInfo[MAX_SUBSTATES]; //Max_Phase_Error info. for the substates
} PhaseErr;


extern int16 gs_PrevRxSubState;
extern int16 gs_RxMaxPhErr;
extern int16 gs_SubStIdx;
extern int16 gs_RxStateCnt;
extern int16 gs_MaxBufIdx;
extern int16 gs_RxCurrentSt;
extern PhaseErr gsa_MaxPhErrBuf[MAXPHBUF_SIZE];

void TrailPhaseError(void);
void PrintPhaseErrLog(void);
#endif
