/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: vecpwr.c
;
;  Function for computing total power in complex vector
;
;***************************************************************************/
#include "typedef.h"
#include "dsp_op.h"
#include "acc40.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : VectorPower
 *
 *  Description:  Returns the total power (sum of squares) of a vector of 16-bit signed numbers,
 *             scaled down by the given power of two.
 *             If the 16-bit data in the vector are x[0], x[1], x[2], etc.,
 *             the return value is:
 *
 *             Return value = [Sum {i=0 to ndata-1} (x[i]*x[i])) + ROUND_CNST] >> s_GuardBits)
 *
 *             where the rounding constant ROUND_CNST = 1<<(s_GuardBits-1).
 *                  It is assumed that Sum {i=0 to ndata-1} (x[i]*x[i])
 *                  can be represented as a 40-bit integer.
 *
 *  Prototype:
 *    int32 VectorPower(int16 *psa_databuf, int16 s_ndata, int16 s_GuardBits)
 *
 *  Input Arguments:
 *    int16 *psa_databuf - Pointer to which s_offset is added.
 *    int16 s_offset - Added to psa_databuf to get pointer to start of vector.
 *    int16 s_GuardBits - Number of bits by which the sum of squares is rightshifted (with rounding) before being returned.
 *  Output Arguments:
 *    None.
 *  Return:
 *      int32    - Sum of squares rightshifted and rounded.
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
int32 VectorPower(int16 *psa_databuf, int16 s_offset, int16 s_ndata, int16 s_GuardBits)
{

   int32   l_rx_power;
   int32   l_Prod, l_acc40H, l_acc40L;
   int16   i, s_X;

   l_acc40H = 0;
   l_acc40L = 0;
   psa_databuf += s_offset;

   for (i=0 ; i<s_ndata; i++) {
      s_X = *psa_databuf++;
      l_Prod = (int32)s_X * s_X;
      accum40(&l_acc40H, &l_acc40L, l_Prod);
   }

     l_rx_power = round_acc40(l_acc40H, l_acc40L, s_GuardBits);
   return l_rx_power;
}
