/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***************************************************************************************
;
;  TestBisframing.c

  File used for standalone debugging to see if a framing parameter is possible or not.
  This code is used for bruteforce searching over all possible values of the framing
  parameters and checking if it is possible to generate PMS framing parameters.

   By default it uses extended framing and D upto 511 is used. One can change it to the values one wants.

   User can input the values in debug mode: for INP, latency and required rate.
   It searches over all possible values and stops at first valid configuration it finds.
   Code looks for rate between specified and specified + 2 bits, if fixed rate
   and between min and max for limited rate

      Variables:
      s_minINP : Minimum INP in frames
      s_maxlatency : maximum latency in ms
      s_maxdatarate: maximum rate in bits (actual rate = bits * 4kbps)
      s_minovhdrate : Minimum overhead rate in kbps
      s_OneoverMinS : One over Min S


;
;****************************************************************************************
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

FILE *file_pms;


void main()
{
   int save_myD_Values_New[21]={511,480, 448, 416,384,352, 320, 288, 256, 224, 192, 160, 128,96, 64, 32, 16, 8, 4, 2, 1};
// int save_myD_Values_New[21]={224, 192, 160, 128,96, 64, 32, 16, 8, 4, 2, 1};
// int save_myD_Values_New[21]={ 64, 32, 16, 8, 4, 2, 1};
   int valid_Mp[5]={1, 2, 4, 8 ,16};

   int test_Dp, test_Rp,  test_Mp , test_Tp, found_config=0 , s_NumDValues;
   float Dp, Rp,Mp, Kp ,CW, Lp, MinLp;
   float  MaxLp,  alpha[6],alphaplus, alphaminus, Sp, rate, achieved_INP, ovhd_rate, s_maxovhdrate, alpha_temp;
   float SpDp, SpDpby4;
   float  s_minINP, s_maxlatency, s_maxdatarate, s_minovhdrate, s_minrate, s_OneoverMinS, s_leeway ;
   int s_temp1, s_temp2, s_temp3, s_temp4;
   int i,  s_supportedDvalues[21];
   float s_finalDp, s_finalRp,s_finalMp, s_finalLp, s_finalTp, s_finalSp, s_finalBpn, s_finalCW, s_finalrate, s_finalovhdrate, s_finallatency, s_finalINP;

   #define NUM_DVALUES  21  // Number of D Values

   s_NumDValues=NUM_DVALUES;


   for (i=0; i<s_NumDValues; i++)
   {
      s_supportedDvalues[i] = save_myD_Values_New[i];
   }

   // User defined input values

   s_minINP = 2;
   s_maxlatency=2;
   s_maxdatarate=1648;
   s_minovhdrate=4;
   s_minrate = 1648;  // to test fixed rate
   s_OneoverMinS=16;
   s_maxovhdrate = 64;

   if (s_minrate < s_maxdatarate) s_leeway =0;
   else if (s_minrate == s_maxdatarate) s_leeway=2;

   file_pms = fopen("Output_FramingTest.txt","w");

   fprintf(file_pms,"\n INPUT PARAMETERS \n");

   fprintf(file_pms, "\tMinINP   MaxLatency \t MaxRate \t MinRate \t MinOverheadrate \t OneoverSmin\n");
   fprintf(file_pms, "\t%8.2f \t%8.2f \t%8.2f \t%8.2f \t%8.2f\t %8.2f\t\n", s_minINP, s_maxlatency, s_maxdatarate, s_minrate, s_minovhdrate, s_OneoverMinS);


   for (test_Dp=0; test_Dp<=s_NumDValues; test_Dp++)
   {
      Dp=(float)s_supportedDvalues[test_Dp];

      if (Dp ==0) continue;

      // if least Sp violates latency requirement, skip choice of Dp
      if (Dp /(4*s_OneoverMinS) > s_maxlatency)
         continue;


      for (test_Rp=0; test_Rp<9; test_Rp++)
      {
         Rp=(float)test_Rp*2;
         if((Rp==0) && (Dp !=1)) continue;

         if (s_minINP > 0)
         {
            MaxLp=4*Dp*Rp / s_minINP;
         }
         else
            MaxLp = 8000;

         MinLp=Rp+Dp;

         for(Lp=s_minrate; Lp<MaxLp; Lp++)
         {
            if (s_minINP >0)
            {
               if (4 * Rp *Dp / Lp < s_minINP) continue;
            }


            for (test_Mp=0; test_Mp <5; test_Mp++)
            {
               Mp=(float)valid_Mp[test_Mp];

               if ((Rp==0) && (Mp!=1)) continue;



               for(Kp=0; Kp<255; Kp++)
               {

                  // right sided constraints
                  alpha[0]=4*Mp / s_minovhdrate; // CW/Lp > 4 * Mp / MinOverheadrate
                  alpha[1]=s_maxlatency/(2*Dp); // (Sp * Dp / 4) < maxlatency
                  alpha[2] = 8;  //Sp <=64

                  // left sided constraints
                  alpha[3] =Mp/(8 * s_OneoverMinS); //Sp > MinSp

                  alpha[4]=Mp/(16 *s_maxovhdrate);

                  alpha_temp = min(alpha[0], alpha[1]);
                  alphaplus=min(alpha_temp, alpha[2]);
                  alphaminus=max(alpha[3], alpha[4]);

                  CW=Kp*Mp + Rp;
                  Sp= (float) (8*CW / Lp);

                  // check Mp, Sp relationship
                  if(Mp>(s_OneoverMinS)*Sp) continue;

                  if (32*Mp <Sp) continue;

                  // constraints on Sp
                  if ((Sp < 1/(s_OneoverMinS)) || (Sp >64)) continue;

                  SpDp=Sp*Dp;
                  SpDpby4 = SpDp/4;

                  if (SpDpby4 > s_maxlatency)
                     continue;


                  // max interleaver memory limit
                  if ((CW-1)*(Dp-1) > 16002) continue;

                  // check that CW and D are co-prime
                  s_temp1 = (int)Dp;

                  s_temp2 = (int)CW;

                  if( (CW > 0)  && (Dp >64))
                  {

                     while (s_temp2) // unless remainder = 0
                     {
                        s_temp3 = s_temp1 / s_temp2;
                        s_temp4 = s_temp1 - s_temp2 * s_temp3;
                        s_temp1 = s_temp2;
                        s_temp2 = s_temp4;
                     }

                     if (s_temp1!=1)  continue;
                  }

                  for (test_Tp=1; test_Tp<=64; test_Tp++)
                  {
                     if ((32 * Mp /(test_Tp * Sp)) < s_minovhdrate)
                        continue;
                     if ((32 * Mp /(test_Tp * Sp)) >s_maxovhdrate)
                        continue;


                     rate=(float)((test_Tp*Kp -1)*Mp*Lp/(test_Tp*CW));
                     achieved_INP=(float)(4* Rp * Dp / Lp);

                     ovhd_rate = 32* Mp/(test_Tp* Sp);

                     if ((rate >=s_minrate) && (rate <= s_maxdatarate + s_leeway)){
                        found_config = 1;
                        break;
                     }
                     else
                        continue;


                  }
                  if (found_config)
                     break;


               }
               if (found_config)
                  break;

            }
            if (found_config)
               break;
         } //Lp

         if (found_config)
            break;
      }
      if (found_config)
         break;

   }

   if (found_config==1)
   {
      fprintf(file_pms, "\n FOUND VALID CONFIGURATION\n");
      if (s_leeway==0)
      fprintf(file_pms, "\n LIMITED RATE\n\n");
      else if (s_leeway==2)
      fprintf(file_pms, "\n FIXED RATE\n\n");



      // final possible configuration
      s_finalDp=Dp;
      s_finalRp=Rp;

      s_finalMp=Mp;
      s_finalLp=Lp;
      s_finalTp = (float)test_Tp;
      s_finalBpn = Kp - 1;
      s_finalCW= Kp * s_finalMp + s_finalRp;
      s_finalSp = 8 * s_finalCW / s_finalLp;

      s_finalrate = (float)((s_finalTp*(s_finalBpn+1) -1)*s_finalMp*s_finalLp/(s_finalTp*s_finalCW));
      s_finalovhdrate = 4* s_finalMp * s_finalLp/(s_finalTp* s_finalCW);
      s_finallatency = 2* s_finalCW* s_finalDp /s_finalLp;
      s_finalINP = 4 * s_finalRp * s_finalDp / s_finalLp;
      fprintf(file_pms, "Dp \t Rp \t Mp \t Lp \t Tp \t Bpn \t CW \t Sp \t Rate\t INP\t Latency\t OvhdRate\n");
      fprintf(file_pms,"%8.2f\t %8.2f\t %8.2f\t %8.2f\t %8.2f\t %8.2f\t %8.2f\t %8.5f\t %8.2f\t %8.2f\t %8.2f\t %8.2f\t \n", s_finalDp, s_finalRp, s_finalMp, s_finalLp, s_finalTp, s_finalBpn, s_finalCW, s_finalSp, s_finalrate, s_finalINP, s_finallatency, s_finalovhdrate);


   }
   else
   {
      // NO configuration found
      fprintf(file_pms, "\n NO VALID CONFIGURATION FOUND\n");

   }

   fcloseall();
}
