/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DistributeFineGains.c
*
*   Routine for adding finegain to the specified tones, till RMS gain is not violated
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload_support.h"
#include "bitload_const.h"
#include "minmaxmargin.h"
#include "cmv.h"
#include "bitload.h"
#include "bitload2.h"
#include "states.h"
#include "mul.h"
#include "decimalgain.h"


/*^^^
*-----------------------------------------------------------------------------
*  Prototype : DistributeFineGains(uint8 *puca_RxBat, int16 *psa_RxFineGains,   int16 *psa_SNRBuffer,  RxToneFlags p_ActiveTones_ToConsider, int16 *pus_ncloaded, int32 *pl_SumFGainLinSq, int32 *pl_SumGiSqTssiSq)
*
*
*  Description :
*
*  Add finegains to increase  margin as much as possible, without violatine the RMS
*  fine gain
*  The algorithm works by adding fine gains to thetones which have low margins and
*  keep adding as much as it can
*
*  Input Parameters:
*  psa_RxFineGains : Fine Gain Array (dB)
*  puca_RxBat     : BAT
*  psa_SNRBuffer  : SNR
*  p_ActiveTones_ToConsider: Tones to which fine gains can be added
*  pl_SumFGainLinSq : Linear Sum Square Fine GAins
*
*  Output Parameters:
*  pl_SumFGainLinSq  : Linear Sum Square Fine Gains
*  psa_RxFineGains      : Modified fine gain array
*
*
*-----------------------------------------------------------------------------*/

C_SCOPE void DistributeFineGains(uint8 *puca_RxBat, int16 *psa_RxFineGains,   int16 *psa_SNRBuffer,  RxToneFlags p_ActiveTones_ToConsider, int16 *pus_ncloaded, int32 *pl_SumFGainLinSq, int32 *pl_SumGiSqTssiSq)
{

   int i;
    int16  s_finegainreqd, s_BitAlloc ;
   int32  l_SumFGainLinSq =0,   l_MaxSumFGainLinSq;
   int32 l_SumFGainLinSq_ToConsider;
   int16 threshold, s_flag_rms_increase = 0,  s_Margin, s_MinMargin;
   FlagT ft_AnyToneLefttotakeGain=1;
   int16 s_Dummy2ReturnValue, s_Initial_TCM_Ovhd,s_InitialSumBi;
   int32 l_SumGiSqTssiSq_ToConsider;
   int16 s_path = LP0_DATA_PATH; // may not force it later when we use these functions for LP1 as well

   l_SumFGainLinSq_ToConsider = *pl_SumFGainLinSq;

   l_SumGiSqTssiSq_ToConsider =  *pl_SumGiSqTssiSq;


   GetBatStats(puca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &gus_ncloaded, &s_Dummy2ReturnValue, &s_Initial_TCM_Ovhd, &s_InitialSumBi, s_path);


   s_finegainreqd = DecimalGain((int16)(2*gs_fgain_adjust));
   MULS16(l_MaxSumFGainLinSq , s_finegainreqd ,gus_ncloaded);
   l_MaxSumFGainLinSq = l_MaxSumFGainLinSq<< 5;

// compute min margin
   FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat, gsa_RxFineGains, gsa_RxShowtimeSnrBuf, p_ActiveTones_ToConsider, gs_RxMinBitsPerTone_BIS_TCM , (int16) guc_MaxAllocBitsPerTone, (int16 *)(void *)&i, &s_MinMargin);

   if (s_MinMargin < 0) s_MinMargin =0;
   threshold = 128;

   while ((l_SumFGainLinSq_ToConsider < l_MaxSumFGainLinSq) && (ft_AnyToneLefttotakeGain))
   {
      ft_AnyToneLefttotakeGain = 0;
      for(i = gs_RxBitLoadFirstChannel  ; i <= gs_RxBitLoadLastChannel; i++)
      {
            if (IS_TONEFLAGSET(p_FINEGAINSKIPset, i)) continue;
         if (IS_TONEFLAGSET(p_ActiveTones_ToConsider, i) && (psa_RxFineGains[i] < gs_max_fine_gain) && (guca_RxBat[i] !=0))
         {
            ft_AnyToneLefttotakeGain = 1;

            s_BitAlloc = guca_RxBat[i];

            // Margin = SNR + Coding GAin + FineGain + MarginDelta + Noise Adjust - Constellation SNR

            s_Margin = gsa_RxShowtimeSnrBuf[i] + gsa_RxFineGains[i] + gsa_TotalCodingGain[LP0_DATA_PATH] + OPTNArray[OPTN_MarginDelta]  - gsa_ConstellationSNR[s_BitAlloc]; // assuming Single Latency path


            if (s_Margin  > s_MinMargin + threshold) continue;// skip these tones

            else
            {
               s_finegainreqd =  s_MinMargin + threshold - s_Margin ;

               if    (s_finegainreqd > threshold) s_finegainreqd = threshold;
            }

            s_finegainreqd += psa_RxFineGains[i] ;

            if (s_finegainreqd > gs_max_fine_gain) s_finegainreqd = gs_max_fine_gain;

            // update fine gain linearsum sq
            UpdateFineGainLinSumSq(psa_RxFineGains[i], s_finegainreqd, gusa_DS_Tssi_Value[i], &l_SumFGainLinSq_ToConsider, &l_SumGiSqTssiSq_ToConsider, 0);

            if( ( (gft_EnableNomATP) && (l_SumFGainLinSq_ToConsider < l_MaxSumFGainLinSq) && ( l_SumGiSqTssiSq_ToConsider < gl_MaxSumGiSqTssiSqLin))
               || ((!gft_EnableNomATP) && (l_SumFGainLinSq_ToConsider < l_MaxSumFGainLinSq)) )
            {
               psa_RxFineGains[i] = s_finegainreqd;
               *pl_SumFGainLinSq = l_SumFGainLinSq_ToConsider;
               *pl_SumGiSqTssiSq = l_SumGiSqTssiSq_ToConsider;

            }
            else
            {
               l_SumFGainLinSq_ToConsider = *pl_SumFGainLinSq;
               l_SumGiSqTssiSq_ToConsider = *pl_SumGiSqTssiSq;
               s_flag_rms_increase = 1;
               break;
            }

         }

      }

      threshold += 128;

      if ((s_flag_rms_increase ==1) || (ft_AnyToneLefttotakeGain == 0))
         break;

   }

}
