/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *    Reverb3Snr_b_bis.c
 *
 *   Functions for BG Tasks from RCReverb3RxF_bis.c
 *
 *------------------------------------------------------------------------
 */
//*******************************************************************
// ReverbSnr_b.c
//
// History
//
// 16/04/10 Nihar: VINAX-CO uses tones for the PAR reduction which are a multiple of 16
//                  If the CPE by accident chooses a pilot tone which is used in showtime
//                  for PAR reduction the PLL drifts aways and the CPE looses sync.
//                  To avoid this situation some of the potential pilot tone indexes are
//                  taken out of the supported set
//                  DMT-mode:       tone: 224
//                  BIS-/PLUS-mode: tone: 224, 368
//                  Grep for IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Computed NLNF Metric2 and set NLNF IB bit5=1 to
//            indicate Metric2 training data ready for NLNF decision.
//            Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo
//
// 17/02/2012 Kannan: Aux Pilot SNR threshold is CMV controlled and is reduced from 16dB to
//            10dB to make it work on long 24DSL 16kft and FSAN Class B noise case at 3250m.
//            Grep for Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
//*****************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "tx_ops2.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "gdata.h"
#include "fft_bg.h"
#include "compiler.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "const.h"
#include "gdata_bis.h"
#include "pll.h"
#include "BGChooseRevSegBin.h"
#include "aux_reg_danube.h"
#include "DebugBuffer.h"
#ifdef TARGET_HW
    #include "aux_regs.h"
    //#ifdef DANUBE
    #include "dataswap.h"
    //#endif
#endif

// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
#define NLNF_REVERB_SNR_START_TONE   (64)
#define NLNF_REVERB_SNR_END_TONE     (192)
#define NLNF_REVERB_SNR_NUM_SHIFT    (7) //power(2,7)=128
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to calculate REVERB/REVERB ECHO SNRs in DMT/BIS
 *
 *  Prototype: void BgReverbSnrCalc(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void BgReverbSnrCalc(void)
{
   int16 i, s_Log2AccumLen, *psa_snrBuf;
   int32 *pla_NoisePower;

   // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   int32 ps_sum_snr = 0;
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)

   if (gs_RxState == R_C_PILOT3_RX || gs_RxState == R_C_TREF2_RX_BIS)
   {
      s_Log2AccumLen = LOG2_NUM_SNR_TRAINING_SYMBOLS_ECT;
   }
   else
   {
      if((gl_SelectedMode & MODE_G992_1) || (gl_SelectedMode & MODE_G992_2))
      {
         s_Log2AccumLen = LOG2_NUM_SNR_TRAINING_SYMBOLS_REVERB_DMT;
      }else
      {
         s_Log2AccumLen = LOG2_NUM_SNR_TRAINING_SYMBOLS_REVERB_ADSL2;
      }
   }

   if (gs_RxState == R_C_REVERB2_RX || gs_RxState == R_C_REVERB3_RX_BIS)
      psa_snrBuf = gsa_ReverbSnrBuf;
   else
      psa_snrBuf = gsa_ReverbEchoSnrBuf;

   /* convert 48 bits accumulated value to 32 bits; */
   /* shift is 2 extra to match NoiseAcc() */

   pla_NoisePower = gla_RxAccumBuf; // Overwrite input buffer with 32-bit output.
   RoundNoiseAccum(gla_RxAccumBuf, pla_NoisePower, gs_RxFirstChannel, gs_RxLastChannel, s_Log2AccumLen);

   for(i=0; i< gs_RxFirstChannel; i++)
      psa_snrBuf[i] = 0;

   SnrCalc(pla_NoisePower + gs_RxFirstChannel, psa_snrBuf + gs_RxFirstChannel, gs_RxFirstChannel, gs_RxLastChannel);

   BGChooseRevSegBin(psa_snrBuf);

// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   for (i = NLNF_REVERB_SNR_START_TONE; i < NLNF_REVERB_SNR_END_TONE; i++)
     ps_sum_snr += psa_snrBuf[i];

     if (gs_RxState == R_C_REVERB2_RX || gs_RxState == R_C_REVERB3_RX_BIS)
       gs_NLNF_avg_snr = ps_sum_snr >> NLNF_REVERB_SNR_NUM_SHIFT;
     else
     {
       // Q8.8dB format
       gs_NLNF_avg_snr -= ps_sum_snr >> NLNF_REVERB_SNR_NUM_SHIFT;
       // NLNF Metric2 is in Q8.0 dB format.
       gs_NLNF_avg_snr >>= 8; // Shift Q8.8 ==> Q8.0dB
       // Cap metric2 to minimum -128dB and maximum +127dB.
       if (gs_NLNF_avg_snr < -128)
        gs_NLNF_avg_snr = -128;
       else if (gs_NLNF_avg_snr > 127)
        gs_NLNF_avg_snr = 127;

       gt_nlnf_metrics_ibs.s_NlnfMetric2 = gs_NLNF_avg_snr;
       //Bit5=1 indicates NLNF Metric2 training data ready for NLNF decision.
       gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x20;
     }
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)

   guc_SnrCalcState = TRAINING_DONE;
}
/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to calculate only Reverb SNR
 *
 *  Prototype: void BgSnrCalcOnly(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */


C_SCOPE void BgSnrCalcOnly(void)
{
   int16 i;
   int16 *psa_snrBuf,s_Log2AccumLen;

   if((gl_SelectedMode & MODE_G992_1) || (gl_SelectedMode & MODE_G992_2))
   {
      s_Log2AccumLen = LOG2_NUM_SYMBOLS_NMS_AVG_ADSL1;
   }
   else
   {
      s_Log2AccumLen = LOG2_NUM_SYMBOLS_NMS_AVG_ADSL2;
   }

   RoundNoiseAccum(gla_RxAccumBuf, gla_RxAccumBuf, gs_RxFirstChannel, gs_RxLastChannel, s_Log2AccumLen);
    psa_snrBuf = gt_StateMachCntrl.psa_RXSNRBuf;

   for(i=0; i< gs_RxFirstChannel; i++)
      psa_snrBuf[i] = 0;

   /* compute test reverb snr */
   SnrCalc(gla_RxAccumBuf + gs_RxFirstChannel, psa_snrBuf + gs_RxFirstChannel, gs_RxFirstChannel, gs_RxLastChannel);
   //guc_BkgdTaskState = BKGDTASK_DONE;
   guc_SnrCalcState = TRAINING_DONE;
   guc_BkgdTaskState = BKGDTASK_DONE;

}
C_SCOPE void BgChooseAuxPilot(void)
{
   int16 i;
   int32 l_MaxMetric, l_Metric;
   int16 *psa_snrBuf;

   /* convert 48 bits accumulated value to 32 bits; */
   /* shift is 2 extra to match NoiseAcc() */
   RoundNoiseAccum(gla_RxAccumBuf, gla_RxAccumBuf, gs_RxFirstChannel, gs_RxLastChannel, (int16) (LOG2_NUM_SYMBOLS_NMS_AVG_ADSL1));
  // psa_snrBuf = gsa_ReverbSnrBuf;

   /* compute test reverb snr */
   SnrCalc(gla_RxAccumBuf + gs_RxFirstChannel, gsa_ReverbSnrBuf + gs_RxFirstChannel, gs_RxFirstChannel, gs_RxLastChannel);

   //if ((gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_ADC_REVERB_EN)
   //     &&(guc_NMS_AlgHandler == CALCULATE_SNR_DEFAULT_AGC_GAIN)
   //   )
   {
      psa_snrBuf = gpsa_PGA_Snr;
      memcpy(psa_snrBuf,gsa_ReverbSnrBuf,1024);
      for(i=0; i< gs_RxFirstChannel; i++)
         psa_snrBuf[i] = 0;
   }

#ifdef DEBUG_STREAMING
   DSH_SendStream(DSH_CD_SNR,sizeof(int16)*256,&gsa_ReverbSnrBuf[0]);
#endif

   /* Select aux. pilot tone based on metric 20*log10(k) + SNR(k),
   where k is the tone index.
   Note that gsa_ReverbSnrBuf[gs_CPilotTone+1] is used to estimate the SNR at gs_CPilotTone, in case SNR is not computed
   correctly (it is a special case) at CPilot. */

   /* Starting point is pilot tone metric. */
   l_MaxMetric = (int32)ConvertToDB((int32)gs_CPilotTone) << 1;
   l_MaxMetric += (int32)gsa_ReverbSnrBuf[gs_CPilotTone+1];

    // IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE (START)
    if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)
    {
       int16 s_majorVer;
       s_majorVer = ((gs_CurrentCoVendorID >> 12) & 0xf);

       if ((s_majorVer == 0xB) || (s_majorVer == 0xC))
       {
          gs_MaxAuxPilotToneIdx = 208;
       }
    }
    // IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE (END)

//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START)
#ifndef ISDN // Annex A only
   // Force to select pilot tone #48 if the SNR > 20dB
   // to workaround the pilot tone corruption issue on all other CO Pilot tones.
   // Tracespan log showed that other pilot tones SNR dropped by ~10dB
   // from the second frame in showtime at 9kft/AWGN against ECI PLSE CO at AT&T.
  if ( (gs_CurrentCoChipset == ECI_PLSE_CO_CHIPSET) &&
       (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_ECI_PLSE_IOP_ATT) )
  {
      if(gsa_ReverbSnrBuf[48] > 0x1400)  // If Pilot #48 SNR > 20dB
      {
       gs_MinAuxPilotToneIdx = 48;
       gs_MaxAuxPilotToneIdx = 48;
       gs_AuxPilotToneIdx = 48;
      }
      //Default value = 0x2000000 = (2*(8192^2)/4)
      //is 6dB lower than default received signal power
      //at pilot tone with finegain equal to 0dB
      //Changed to 0x20000 for ECI PLSE
      //since pilot tone power is sometimes lower
      //causing PLL frozen and CO linkdrop.
      gl_PilotTone_PwrThresh = 0x20000;
  }
#endif
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (END)
   /* Search through all aux pilot candidates. */
   for (i = gs_MinAuxPilotToneIdx; i <= gs_MaxAuxPilotToneIdx; i += 16)
   {
      /* Skip pilot tone. */
      if (i == gs_CPilotTone)
         continue;

      //Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold (START)
      //SNR is in Q8.8 format
      if (gsa_ReverbSnrBuf[i] < ((gt_INFX_CMV.us_OperatorSpBits6 & CMV_FOR_AUX_PILOT_MIN_SNR_MASK) << 8))
      continue;
      //Feature_DS_ADSL1_ALL_AuxPilotMinSNR_Threshold (END)

      /* Find and compare metric. */
      l_Metric = (int32)ConvertToDB((int32)i) << 1;
      l_Metric += (int32)gsa_ReverbSnrBuf[i];
      if (l_Metric > l_MaxMetric)
      {
         l_MaxMetric = l_Metric;
         gs_AuxPilotToneIdx = i;
      }
   }

   if (gs_dbgChoosePilot != -1)
   {
      gs_AuxPilotToneIdx = gs_dbgChoosePilot;
   }

   if (gs_AuxPilotToneIdx == gs_CPilotTone)
   {
      gft_AuxPilot = AUX_PILOT_DISABLE;
   }
   else
   {
      /* Calculate the scaling value for Ki and Kp */
      PllScalingCalc(gs_AuxPilotToneIdx, &gs_PllScaling);
      gft_AuxPilot = AUX_PILOT_ACTIVE;
   }
}

//#ifdef DANUBE
#ifdef TARGET_HW
/****************************************************************************
;   Prototype: void RequestSwap_ReverbSnrBuf_ToXmem (void)
;
;   Description: Function makes a request for XDMA by loading the Data Swap
;  Control structure with all necessary parameters required to program the
;  XDMA engine.
;
;  Two global flags will be set:
;     (1) gt_DataSwap.c_State = DATASWAP_REQUESTED
;     (2) gus_DataBuf_InXmem |= REVERB_ECHO_SNR_BUF_IN_XMEM
;
;  The first flag indicates that XDMA transfer is pending and structure
;  gt_DataSwap is occupied.
;
;  The second flag indicates that this particular buffer will be in external
;  memory when DMA is completed.
;
;   Arguments:
;       None
;
;   Return Value:
;       None
;
;****************************************************************************/
C_SCOPE void RequestSwap_ReverbSnrBuf_ToXmem (void)
{
    if (gt_DataSwap.c_State == DATASWAP_READY)
    {
        gt_DataSwap.c_State   = DATASWAP_REQUESTED;
        gt_DataSwap.c_XferDir = XDMA_WRITE_XMEM;

        if (gs_RxState == R_C_REVERB2_RX || gs_RxState == R_C_REVERB3_RX_BIS)
        {
            gt_DataSwap.l_SrcAddr = (int32)&gsa_ReverbSnrBuf[0];
            gt_DataSwap.l_DstAddr = (int32)&gusa_ReverbSnrBuffer_BAR15[0]; // XDSLRTFW-1942 (Start_End)
            gt_DataSwap.s_BufSize = REVERB_SNR_BUF_SIZE;
            gus_DataBuf_InXmem |= REVERB_SNR_BUF_IN_XMEM;
        }
        else
        {
            gt_DataSwap.l_SrcAddr = (int32)&gsa_ReverbEchoSnrBuf[0];
            gt_DataSwap.l_DstAddr = (int32)&gusa_ReverbEchoSnrBuffer_BAR15[0]; // XDSLRTFW-1942 (Start_End)
            gt_DataSwap.s_BufSize = REVERB_ECHO_SNR_BUF_SIZE;
            gus_DataBuf_InXmem |= REVERB_ECHO_SNR_BUF_IN_XMEM;
        }
    }
}
#endif
//#endif
