/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   bitload_support.c
*
*   Subroutines for manipulating Bat and fine gains for g.992.3/g.992.5.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "minmaxmargin.h"
#include "bitload_const.h"
#include "cmv.h"


/* =============================================== */
/* Local function declarations */
/* =============================================== */

C_SCOPE void GetBatStats(uint8 *puca_Bat, int16 s_NumTones, FlagT ft_TcmFlag, uint16 *ps_NumLoadedTones, int16 *ps_Num1BitTones, int16 *ps_TCM_Ovhd, int16 *ps_Sum_bi, int16 s_path);


/*^^^
*-----------------------------------------------------------------------------
*   Prototype: void GetBatStats(uint8 *puca_Bat, int16 s_NumTones, FlagT ft_TcmFlag, int16 *ps_NumLoadedTones, int16 *ps_Num1BitTones, int16 *ps_TCM_Ovhd, int16 *ps_Sum_bi)
*
*   Description:
*     Computes statistics of a given bit allocation table (BAT), including number of loaded tones,
*     number of 1-bit tones, TCM overhead (if enabled), and Sum {bi}.
*
*   Input Parameters:
*     puca_Bat -- pointer to an Rx bit allocation table
*     s_NumTones -- number of tones in BAT
*     ft_TcmFlag -- flag indicating whether TCM is enabled
*
*  Output Parameters:
*     ps_NumLoadedTones - returns number of loaded tones (bi > 0)
*     ps_Num1BitTones -- returns number of 1-bit tones (bi == 1)
*     ps_TCM_Ovhd -- TCM overhead, if ft_TcmFlag set, else 0.
*     ps_Sum_bi -- sum of all bi
*
*   Returns:
*     none
*
*  Global variables:
*
  *-----------------------------------------------------------------------------
^^^*/

C_SCOPE void GetBatStats(uint8 *puca_Bat, int16 s_NumTones, FlagT ft_TcmFlag, uint16 *ps_NumLoadedTones, int16 *ps_Num1BitTones, int16 *ps_TCM_Ovhd, int16 *ps_Sum_bi, int16 s_path)
{

   int i;
   uint8 *p_BatEntry = puca_Bat;

   *ps_NumLoadedTones = 0;
   *ps_Num1BitTones = 0;
   *ps_TCM_Ovhd = 0;
   *ps_Sum_bi = 0;

   for (i=0 ; i< s_NumTones ; i++, p_BatEntry++) {

   /* only if we have dual latency support and we are working for LP0 path,
      assume that LP1 is already set and skip over the LP1 tones */
      if (  ((STATArray[STAT_Mode] & STAT_ConfigMode_ADSL2_ALL) != 0)&&(gt_rx_config.s_Nlp==2)&&(s_path == LP0_DATA_PATH) && (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,i)))
         continue;

      if (*p_BatEntry > 0) {
         *ps_Sum_bi += *p_BatEntry;
         (*ps_NumLoadedTones)++;
         if (*p_BatEntry == 1)
            (*ps_Num1BitTones)++;
      }
   }

   if (ft_TcmFlag)
      *ps_TCM_Ovhd = ((((*ps_NumLoadedTones) - (*ps_Num1BitTones >> 1) + 1) >> 1) + 4);
}
