/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   changebat.c
*
*   Routines for modifying a bit allocation table to change the sum of bi or the
*       sum of Lp.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// changebat.c
//
// History
//
// 17/08/2010 Shakil/Bhadra: Incorporated the correction for Bitswap issue-SMS01320806
//            There is a bug in the current bitswap algorithm for ADSL2/2p, where bitswap requests
//            can be blocked against strong noise which can disturb multiple tones in the similar way
//            resulting few or more affected tones having same or very close SNR.
//            In the current implementation in one of the inner functions (ChangeLpKeepMaxMargin),
//            which is always called if BAT is required to change (SRA, bitswap or L2 request),
//            after the bat table is changed the min margin is calculated from the complete medley spectrum
//            which can block bitswap request as the min margin check from the whole spectrum picks up the
//            second worst tone.
//            Grep for SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap  to find the changes
//
// 17/08/2009 Kannan/Bhadra: IOP fix for Downstream Upshift SRA failure
//                    against  ISAM 7302 NALT-C  & Geminax.
//               Grep for SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA
//
// 15/11/2011 ChihWen/Bhadra: There is a special requirement that CPE should sync up in 2km loop with -90 dBm/Hz AWGN (normally DS rate is 600 Kbps),
//                                              and should be able to reach max capped rate of 6 Mbps by upshift SRA when noise power is decreased to -140 dBm/Hz AWGN.
//            With this special requirement, we need to load more bits not only on already loaded tones, but also on monitored tones,
//                                              in order to reach the max capped rate. A problem behind this requirement is that CNXT CO does not send signal on unloaded tones.
//                                              So the workaround to fulfill the requirement for all CO are as below.
//                                              1. For all CO, changing the threshold for setting monitored tones from 4 dB to 6 dB (SNR_THRESH_LOAD_MIN_BITS).
//                                              2. For all CO, not limiting number of monitored tones to 20 if SRA is enabled on CO site.
//                                              3. For all CO, making OLR (SRA and bitswap) only occurring on loaded/monitored tones.
//                                              4. For CNXT CO, no updating FDQ cofficients on unloaded tones.
//                                              5. For CNXT CO, measuring noise on monitored tones to get an estimation of SNR.
//                                              6. For CNXT CO, SNR on monitored tones are capped to 2-bits required SNR, in order to load two bits and get better SNR measurement.
//
//                                              7. When DS rate capped low, it took bitloading too long time to
//               find gs_deltaLp_max and failed the training. This is the root cause
//               of no-link with 3.5M capped profiles.
//               The solution is to use a larger searching step to find a valid
//               gs_deltaLp_max faster.
//
//                                              8. For CNXT CO, decreasing the Tx buffer size for overhead message by 2 if the tone number in the last segment of SRA message was 14.
//                                                       This was because CRC/link drop was always seen when there was 14 tones in the last segment of SRA message.
//
//            Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones
//
// 14/12/2012 Mahesh: Added L2 entry - Amd 4 changes.
//          Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
// 08/11/2012 Anantha: 1.Disabling marking of bitswap tones as it is used for marking tones which have margin
//                                              between min margin and min margin + delta. Marking of tones with bit swap is moved to
//                                              the end of bitswap scheme
//                                              2. Adding  check for min tone margin threshold while decreasing bits
//                                              3. removed margin fudge while calculating margin
//                                              Grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
// 21/02/2013 Anantha:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//                                              grep for DSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 20/12/2012 Balabath : XDSLRTFW-1086 / ADSLRTFW-1611:Sync loss in FT BS Test
//      1) If RFI tone format (Noise File) didn't have BW information then RFI has effect on neighbor tones also.
//      RFI tone should have 0.0 0.0 in BW columns.Please check the jira entry for more details.
//      2) The reasons for link drop are FT reboot conditions (severe error seconds (30s), error seconds 90s)
//    The reasons for not doing the Bitswap (delayed Bitswap request) on the RFI applied tone (for example Tone 280) is
//    2.1)      Cap of min margin to -3dB, and number of bits to be removed from tones is  set to '1' for CNXT
//    2.2)      Search the tones from first loaded channel.
//    2.3)      Because of strong RFI, observed margin degradation of <-3dB on tones around 80. So, bits are swapped from these tones.
// Solution:
//      3) Remove the cap on minmargin tones, and change deltaLp to 4, otherwise RFI tests will fail.
// Other proposal (to be done):
//      4) If deltaLp is 1, try to do more than one Bitswap request per SNR update.
//      Grep for XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap
//
// 15/01/2018 Chih-Wen: XDSLRTFW-3475
//            BER failed in TR100A 5T1 MV test against Lucent Stinger.
//            After 5dB noise boost, BER failed even with new NMS disabled. Some bits were swapped to lower tones (33~48)
//            because of higher margin, which caused lots of CRC.
//            The workaround was to disable NMS and avoid bits being swapped to tone 33~48.
//
//            To kick in the workaround, the following conditions must be met.
//            1. ADSL2+ AnnexA.
//            2. CNXT CO.
//            3. STAT[STAT_Performance] set "STAT_5T1Noise".
//            4. Loop lengths are between 4K and 6K feet.
//
//            Grep for XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones
//
// ******************************************************************
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload_support.h"
#include "bitload_const.h"
#include "minmaxmargin.h"
#include "cmv.h"
#include "bitload.h"
#include "bitload2.h"
#include "states.h"

#include "decimalgain.h"

//XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (START)
extern FlagT gft_BitswapNotAddingBitsToTones;
extern RxToneFlags gp_BitswapNotAddingBitsToTones;
//XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (END)

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   #define L2_MIN_GI (-3712)
   #define LOWEST_DS_CHANNEL (33)
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

/* =============================================== */
/* Local function prototypes */
/* =============================================== */

uint8 ChangeLpKeepMaxMargin(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumLp,
                                                        int16 *psa_SNRBuffer, int16 s_MinToneMargin,
                                                        RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones,
                                                        int16 *ps_ActualDeltaSumLp, FlagT ft_StopAtMarginThreshold, FlagT ft_NotforceEven1Bit, FlagT ft_AddfineGainplusdeltaLp);

uint8 ChangeBatKeepMaxMargin(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumbi,
                                                         int16 *psa_SNRBuffer, int16 s_MinToneMargin,
                                                         RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones,
                                                         int16 *ps_ActualDeltaSumbi, FlagT ft_StopAtMarginThreshold, int16 *pus_ncloaded);

#define CHGBAT_RETCODE_VIOLATES_MARGIN  1
#define CHGBAT_RETCODE_CANT_CHANGE_LP   2

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
//extern int16 gs_margin_store[480];

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

/*^^^
*-----------------------------------------------------------------------------
*   Prototype:  uint8 ChangeLpKeepMaxMargin(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumLp,
*                                                                        int16 *psa_SNRBuffer, int16 s_MinToneMargin,
*                                                                        RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones, int16 *ps_ActualDeltaSumLp,FlagT ft_StopAtMarginThreshold, FlagT ft_NotforceEven1Bit, FlagT ft_AddfineGainplusdeltaLp)
*
*   Description:
*               Changes the bit allocation table (BAT) to produce the specified change (delta) in Sum{Lp}.  Recall that
*               the Sum{bi} = Sum{Lp} + TCM_Overhead.  This routine figures out the necessary change in Sum{bi} to get the
*               desired change in Lp, and calls ChangeBatKeepMaxMargin() to make the actual changes to the BAT.
*               The delta Lp may be positive or negative.  The specified min tone margin argument specifies the minimum
*               margin that must be maintained on all tones.  For positive deltaLp the margin check is performed before adding
*               each bit to the BAT.  For negative deltaLp the margin is checked after all bits have been subtracted.
*
*               The function sets the value of the Actual delta Lp argument.
*               This will only differ from the desired delta Lp when it is not possible to achieve the desired delta Lp.
*               One ToneFlag array specifies which tones in the BAT are allowed to change.  A second ToneFlag array is written to
*               by the function to indicate which tones in the BAT were actually changed.  The fine gain array input parameter is used
*               to calculate SNR margins, but it is not modified by this routine.
*
*   Input Parameters:
*               puca_RxBat -- pointer to an Rx bit allocation table
*               psa_RxFineGains -- pointer to an Rx fine gain table
*               s_DesiredDeltaSumLp -- desired change in Lp, either positive or negative
*               psa_SNRBuffer -- measured SNR buffer, not adjusted for coding gain or anything else.
*               s_MinToneMargin -- the minimum margin (in 8.8 dB format) that must be met by the BAT table after any modifications
*               p_ActiveTones -- One-bit-per-tone array indicating which tones in the BAT may be changed by this routine.  Only tones
*                               whose bit is set will have their bi changed, and margin checks will only be done on these tones.

  *     Output Parameters:
  *             p_ModifiedTones -- One-bit-per-tone array used to indicate which tones were actually changed by this routine.  In some
  *                             cases a bit may be set for a tone whose final bi value has not changed, because intermediate steps may have
  *                             changed the bit and then changed it back again.
  *             ps_ActualDeltaSumLp -- the actual change in Lp.  This will only differ from the desired delta Lp when it is not possible to achieve the desired
  *             delta Lp.  The two reasons this could happen are: 1) min margin could not be maintained, 2) no room to add bits, or no bits left
  *             to subtract.
  *
  *     Return value:
  *                             0:      success (no error)
  *                             1:      BAT change violates SNR margin.
  *                                             If deltaLp > 0 : Couldn't increase Lp by desired amount without violating margin
  *                                             If deltaLp < 0 : Decreased Lp by desired amount, but still didn't meet margin (used for validating L2 requests).
  *
  *                             2:      impossible to increase/decrease Lp as desired
  *
  *                                             If deltaLp > 0 : Not possible to increase Lp as desired because all tones at maximum bitloading.
  *                                             If deltaLp < 0 : Not possible to decrease Lp as desired because not enough bits left in BAT!
  *
  *     Global variables:
  *             gsa_RxFineGains -- Sets g[i] to zero if b[i] is set to zero.
  *-----------------------------------------------------------------------------
^^^*/
C_SCOPE uint8 ChangeLpKeepMaxMargin(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumLp,
                                    int16 *psa_SNRBuffer, int16 s_MinToneMargin,
                                    RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones,
                                    int16 *ps_ActualDeltaSumLp, FlagT ft_StopAtMarginThreshold,
                                    FlagT ft_NotforceEven1Bit, FlagT ft_AddfineGainplusdeltaLp)
{
   uint8 uc_RetCode;           // Return value
   int16 s_DeltaSumLp = s_DesiredDeltaSumLp;
   int16 s_Dummy1ReturnValue, s_Dummy2ReturnValue, s_ActualDeltaSumbi, s_ch;
   int16 s_Initial_TCM_Ovhd, s_TCM_Ovhd_before, s_TCM_Ovhd_after, s_ActualMinToneMargin, s_InitialSumBi, s_FinalSumBi;
   FlagT ft_Result, ft_TcmFlag;
   RxToneFlags p_ActiveTones_ToConsider;
   int16  s_RxExtraBits;

   uc_RetCode=0;

   if (( gl_SelectedMode & (MODE_ADSL2)))
      ft_TcmFlag =  gft_TcmFlag_bis_DS;
   else
      ft_TcmFlag = gft_TcmFlag;

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
#if 0
   if (gft_Amd4_L2_Entry)
   {
      for (s_ch = 0;s_ch < 480;s_ch++)
      {
         gs_margin_store[s_ch] = 0x7fff;
      }
   }
#endif
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

   GetBatStats(puca_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, &s_Dummy2ReturnValue, &s_Initial_TCM_Ovhd, &s_InitialSumBi, LP0_DATA_PATH);

   s_TCM_Ovhd_before = s_Initial_TCM_Ovhd;

   s_FinalSumBi = s_InitialSumBi;

   s_TCM_Ovhd_after = s_TCM_Ovhd_before;

   // Copy the active tone set to another array, where we clear the tones for which fine gain is set to be
   // negative infinity; as we don't want to change Medley set
   for (s_ch = 0; s_ch < (RX_NUM_TONES>>3); s_ch++)
   {
      p_ActiveTones_ToConsider[s_ch] = p_ActiveTones[s_ch];

      /* only if we have dual latency support and we are working for LP0 path,
      assume that LP1 is already set and skip over the LP1 tones */
      if (((STATArray[STAT_Mode] & STAT_ConfigMode_ADSL2_ALL) != 0) &&
         (gt_rx_config.s_Nlp==2) && (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,s_ch)))

            CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch);
   }


   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
   // Don't consider the Tone set if b=g=0 (linear) for OLR (consider only loaded/monitored tones).
#ifdef ISDN
   if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)
#endif
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (End)
   {
      // For interop with INFN PAR feature. Clear tones from set of tones considered for OLR/PM if their Rx FineGain is
      // negative infinity, i.e. if b=g=0 (linear).
      // These tones might otherwise be loaded during an OLR since their showtime SNR may be high enough.
      //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START_END)
      for (s_ch=gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
      {
         if (gsa_RxFineGains[s_ch] == NEG_INFINITY_DB)
            CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch);
      }
   }

//XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (START)
#ifndef ISDN
   if ((gs_RxState == R_C_SHOWTIME_RX) && (gft_BitswapNotAddingBitsToTones == TRUE) && (s_DeltaSumLp > 0))
   {
      for (s_ch=gs_RxFirstChannel; s_ch <= gs_RxLastChannel; s_ch++)
      {
         if (IS_TONEFLAGSET(gp_BitswapNotAddingBitsToTones, s_ch))
            CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch);
      }
   }
#endif
//XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (END)

   while (s_DeltaSumLp != 0)
   {
      if ((s_DeltaSumLp > 0) && (ft_AddfineGainplusdeltaLp) && (( gl_SelectedMode & (MODE_ADSL2)  )))
      {
         uc_RetCode = 1;
         s_RxExtraBits = ChooseFineGains_BIS(puca_RxBat, psa_RxFineGains,  &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, s_DeltaSumLp,0, LP0_DATA_PATH);
         if (s_RxExtraBits == s_DeltaSumLp)
            uc_RetCode = 0;
      }
      else
      {
         uc_RetCode = ChangeBatKeepMaxMargin(puca_RxBat, psa_RxFineGains, s_DeltaSumLp, psa_SNRBuffer, s_MinToneMargin,
p_ActiveTones_ToConsider, p_ModifiedTones, &s_ActualDeltaSumbi, ft_StopAtMarginThreshold, (int16 *)(void *)&gus_ncloaded);
      }

      GetBatStats(puca_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, &s_Dummy2ReturnValue, &s_TCM_Ovhd_after, &s_FinalSumBi, LP0_DATA_PATH);

      if (uc_RetCode != 0)
      {
      // Can't change Lp as requested
         break;
      }

      // Any change in TCM overhead results in further unwanted change to Lp.  This becomes a new delta Lp that we
      // need to implement.

        {
            s_DeltaSumLp = (s_TCM_Ovhd_after - s_TCM_Ovhd_before);
            s_TCM_Ovhd_before = s_TCM_Ovhd_after;
        }
   } //while(s_DeltaSumLp

   *ps_ActualDeltaSumLp = s_FinalSumBi - s_TCM_Ovhd_after - (s_InitialSumBi - s_Initial_TCM_Ovhd);

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   if(gft_Amd4_L2_Entry)
   {
      gs_L2ActualDeltaSumLp = *ps_ActualDeltaSumLp;
   }
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]


   if (uc_RetCode != 0)
      return(uc_RetCode);

   if((ft_TcmFlag) && (( gl_SelectedMode & (MODE_ADSL2)  )) && (!ft_NotforceEven1Bit))
   {
      // Force an even number of 1-bit tones without changing Lp.

      ft_Result = ForceEvenNum1BitTonesInBAT(puca_RxBat, psa_RxFineGains, psa_SNRBuffer, s_MinToneMargin, p_ActiveTones_ToConsider, p_ModifiedTones);

      if (ft_Result == FAIL)
      {
         // Fail here if couldn't force even # of 1-bit tones while maintaining margin.
         // (Forcing an even # of 1-bit tones while maintaining Lp requires bits to be added to the BAT).

         return(CHGBAT_RETCODE_VIOLATES_MARGIN);
      }
   }

   // Fail here if: Decreased Lp by desired amount, but still didn't meet margin (used for validating L2 requests).
   // (FindToneWithExtremeMargin will return SUCCEED so long as there is one active tone).
   // (If deltaLp was positive and we reach this point, this margin check will always pass, since it was passed earlier).
   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      //SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap (Start)
      if (STATArray[STAT_OLRStatus_DS] == STAT_OLR_BITSWAP)
      {
         //SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap (START_END)
         //For Bitswap request find the smallest margin from the bitswap tones instead of the
         //whole medley spectrum

         FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains,
                                    psa_SNRBuffer, guca_RxBitswapTones, 1,
                                    (int16) guc_MaxAllocBitsPerTone,
                                    &s_Dummy1ReturnValue, &s_ActualMinToneMargin);
      }
      else
      {
         FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains,
                                   psa_SNRBuffer, p_ActiveTones_ToConsider, 1,
                                   (int16) guc_MaxAllocBitsPerTone,
                                   &s_Dummy1ReturnValue, &s_ActualMinToneMargin);

         gs_RxEstimatedMinMargin = s_ActualMinToneMargin;
      }
      //SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap (End)

      //SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (Start)
      // During the UpShift SRA , If the Actual Margin on the tones is less than Target margin then Upshift SRA is rejected.
      // Typical tones observed are 35,36,..  are limited by ISI affect & the actual margin recorded as 5.9dB.
      // Impact :
      //        (i)Upshift SRA is not triggered

      //        Solution: Since RxAvMargin margin is above the Upshift threshold, need to allow for Upshift SRA
      // While changing the BAT, MinMargin on a tone will be verfied.
      // Below code is added to bypass the check between Actual Margin and target/desired SNR Margin
      if (gft_AllowUpshiftSRA != TRUE)
      {
         if (s_ActualMinToneMargin < s_MinToneMargin)
         {
            return (CHGBAT_RETCODE_VIOLATES_MARGIN);
         }
      }
      //SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (End)

      gs_RxEstimatedMinMargin = s_ActualMinToneMargin;
   }


   return(0);              // No error.
}

/*^^^
*-----------------------------------------------------------------------------
*   Prototype:  uint8 ChangeBatKeepMaxMargin(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumbi,
*                                                                        int16 *psa_SNRBuffer, int16 s_MinToneMargin,
*                                                                        RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones, int16 *ps_ActualDeltaSumbi)
*
*
*   Description:
*               Changes the bit allocation table (BAT) to change the Sum{bi} by the specified delta.
*
*               The delta Sum{bi} may be positive or negative.  The specified min tone margin argument specifies the minimum
*               margin that must be maintained on all tones.  The BAT will be modified so
*               as to maximize the min SNR margin of all tones.
*               Note that this function never forces the BAT to have an even number of 1-bit tones.  This is handled by the
*               calling function.  The function sets the value of the Actual Sum{bi} output argument.
*               This will only differ from the desired delta Sum{bi} when it is not possible to achieve the desired
*               delta Sum{bi}.
*               One ToneFlag array specifies which tones in the BAT are allowed to change.  A second ToneFlag array is written to
*               by the function to indicate which tones in the BAT were actually changed.  The fine gain array input parameter is used
*               to calculate SNR margins, but it is not modified by this routine.
*
*   Input Parameters:
*               puca_RxBat -- pointer to an Rx bit allocation table
*               psa_RxFineGains -- pointer to an Rx fine gain table
*               s_DesiredDeltaSumBi -- desired change in Sum{bi}, either positive or negative
*               psa_SNRBuffer -- measured SNR buffer, not adjusted for coding gain or anything else.
*               s_MinToneMargin -- the minimum margin (in 8.8 dB format) that must be met by the BAT table after any modifications
*               p_ActiveTones -- One-bit-per-tone array indicating which tones in the BAT may be changed by this routine.  Only tones
*                               whose bit is set will have their bi changed, and margin checks will only be done on these tones.
*               ft_StopAtMarginThreshold -- Flag indicating that changes to the BAT should stop and the function should return as soon as
*                               the margin requirement is met.  This is intended for use in two different ways:
*
*                                       1) When the current BAT violates margin.  Set this flag and use the largest negative value of
*                                               s_DesiredDeltaSumBi and the return value ps_ActualDeltaSumBi will be the reduction in DeltaSumBi
*                                               needed to meet margin.
*                                       2) When the current BAT has excess margin.  Set this flag and use the largest positive value of
*                                               s_DesiredDeltaSumBi and the return value ps_ActualDeltaSumBi will be the increase in DeltaSumBi
*                                               that is possible while still meeting margin.
*
*       Output Parameters:
*               p_ModifiedTones -- One-bit-per-tone array used to indicate which tones were actually changed by this routine.  In some
*                               cases a bit may be set for a tone whose final bi value has not changed, because intermediate steps may have
*                               changed the bit and then changed it back again.
*               ps_ActualDeltaSumBi -- the actual change in Sum{bi}.  This will only differ from the desired delta Sum{bi} when it is not possible to achieve the desired
*               delta Sum{bi}.  The two reasons this could happen are: 1) min margin could not be maintained, 2) no room to add bits, or no bits left
*               to subtract.
*
*   Returns:
*               uint8 error code
*                               0:      success (no error)
*                               1:      BAT change violates SNR margin
*                               2:      impossible to increase/decrease Lp as desired
*
*       Global variables:
*               guc_MaxAllocBitsPerTone
*-----------------------------------------------------------------------------
^^^*/


C_SCOPE uint8 ChangeBatKeepMaxMargin(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumbi,
                                                                         int16 *psa_SNRBuffer, int16 s_MinToneMargin, RxToneFlags p_ActiveTones_ToConsider, RxToneFlags p_ModifiedTones, int16 *ps_ActualDeltaSumbi,
                                                                         FlagT ft_StopAtMarginThreshold, int16 *pus_ncloaded)

{
   uint8 uc_RetCode;           // Return value
   int16 s_ch;             /*  channel index */
   int16 s_Margin;
   int16 s_DeltaSumbi = s_DesiredDeltaSumbi;
   int16 s_FineGaininit,  s_excessmargin;
   FlagT ft_Result, ft_FlagAnyToneLeft, ft_isSRA;
   int16 s_MinBitsPerTone;
   int16 s_threshold, s_bi, s_CodingGain, s_MinMargin_toComp = 0;
   int32 l_SumFGainLinSq_toconsider;
   uint16 s_ncloaded;

//Amendment 4 L2 modification (Start)
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   int16 s_Fgain_lowest;
   //int16 s_margin_store[479];
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
//Amendment 4 L2 modification (End)

   //XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (start_end)
   int16 s_absDeltaSumBi;
   uc_RetCode = 0;
   l_SumFGainLinSq_toconsider = gl_SumFGainLinSq;
   s_ncloaded = gus_ncloaded;
   s_MinBitsPerTone = (int16) RX_MIN_BITS_PER_TONE;

   if (gft_ModemType == G_DMT_BIS)
      s_MinBitsPerTone = (int16) gs_RxMinBitsPerTone_BIS_TCM;

   ft_isSRA = FALSE;

   if ((( gl_SelectedMode & (MODE_ADSL2)  )) &&
       ((STATArray[STAT_OLRStatus_DS] & STAT_OLR_TYPE) == STAT_OLR_SRA) )
       ft_isSRA = TRUE;

   while (s_DeltaSumbi > 0)
   {
      if (gft_ModemType == G_DMT_BIS) // may need to add more intelligence, to support DMT; and other cases of min bits
        s_MinBitsPerTone = gs_RxMinBitsPerTone_BIS_TCM - 1;

                // Find tone with biggest margin.
      ft_Result = FindToneWithExtremeMargin(LARGEST_MARGIN, puca_RxBat, psa_RxFineGains, psa_SNRBuffer,
p_ActiveTones_ToConsider, s_MinBitsPerTone, (int16)(guc_MaxAllocBitsPerTone-1), &s_ch, &s_Margin);

      if (ft_Result == FAIL)
      {
         uc_RetCode = CHGBAT_RETCODE_CANT_CHANGE_LP;
         break;  // No tones satisfy conditions
      }
      // If adding bits to this tone will violate margin, stop.
      if ((ft_StopAtMarginThreshold) &&(s_Margin < s_MinToneMargin))
      {
         uc_RetCode = CHGBAT_RETCODE_VIOLATES_MARGIN;
         break;
      }

      // if tone was initially unloaded put the fine gain to be zero
      if (puca_RxBat[s_ch] ==0)
      {
         //update linear sum square  fine gain (in case tone is getting loaded for the first time, initial fine gain does not matter)
         // we do this unconditionally, as ncloaded will increase, we should not violate RMS gain constraint
         // in case we work with RMS < 0, it would be better to check RMS constraint here

         if( !IS_TONEFLAGSET(p_FINEGAINSKIPset, s_ch))
         {
            UpdateFineGainLinSumSq(psa_RxFineGains[s_ch], 0, gusa_DS_Tssi_Value[s_ch],  &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 2);
            psa_RxFineGains[s_ch]=0;
         }
         else
         {
            UpdateFineGainLinSumSq(psa_RxFineGains[s_ch], gs_min_fine_gain, gusa_DS_Tssi_Value[s_ch],
&gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 2); psa_RxFineGains[s_ch] = gs_min_fine_gain;
         }
      }

      // add the bit without touching its fine gain
      puca_RxBat[s_ch]++;
      s_DeltaSumbi--;

      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
      //Disabling bitswap tones as it is used for marking tones which have margin
      //between min margin and min margin + delta
      //Marking of tones with bit swap is moved to the end of bitswap scheme

      if(TESTArray[Test_DisableBitSwapImprvmnt] ||
        !((STATArray[STAT_MacroState] == STAT_ShowTimeState)||(STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState)) ||
         ((gs_OlrReq == L2_REQ) || (gs_OlrReq == SRA_REQ)))
            SETTONEFLAG(p_ModifiedTones, s_ch);

   } //while

   // remove the bits by looking for margin below min margin + threshold
   // start with threshold = 0.5 dB
   s_threshold=128;
   ft_FlagAnyToneLeft = TRUE;  /* assume that there is at least one loaded tone
   this flag is important in case we ask for large deltaLp,
   and there is no more loaded tone, we return after removing as much as possible */
   if (s_DeltaSumbi < 0)
   {
      // compute the min margin
      ft_Result =     FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains, psa_SNRBuffer, p_ActiveTones_ToConsider, s_MinBitsPerTone, (int16) guc_MaxAllocBitsPerTone, &s_ch, &s_Margin);

      // if min  margin is below 3dB, start with -3dB for removing bits
      //XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (start)
      s_absDeltaSumBi = abs_s(s_DeltaSumbi);
      if ((s_Margin < -768) &&(s_absDeltaSumBi > 10))  //Assumed if (sumbi >10) it will touch min margin tones also
         s_MinMargin_toComp = -768;
      else
         s_MinMargin_toComp = s_Margin;
      //XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (end)

   }


   // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   if(gft_Amd4_L2_Entry)
   {
      gs_Offset_L2rmsFG_power_prv = gs_Offset_L2rmsFG_power;
      gs_Offset_L2rmsFG_power = (((int16) gt_RxOLRPMVars.uc_max_PCB_val - gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols)<< 8) + gs_RxDesiredMargin - s_Margin;
      if(gs_Offset_L2rmsFG_power <= 0)
      {
         gs_Offset_L2rmsFG_power = 0;
         gft_pwr_limit = 1;
      }
   }


   while ((s_DeltaSumbi < 0) && (ft_FlagAnyToneLeft) && (!gft_pwr_limit) &&
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
         (((s_Margin < s_MinToneMargin) || !((STATArray[STAT_MacroState] == STAT_ShowTimeState) ||
         (STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState))) ||
         (gs_OlrReq == L2_REQ)||(gs_OlrReq == SRA_REQ)|| TESTArray[Test_DisableBitSwapImprvmnt]))
   {
      // Check  for DMT if we have only 1 bit to remove
      if ((s_DeltaSumbi == -1) && (gft_ModemType == G_DMT))
        uc_RetCode = (uint8) Reduce1bitDMT( &s_DeltaSumbi, puca_RxBat, psa_RxFineGains, pus_ncloaded,psa_SNRBuffer,s_MinBitsPerTone, p_ActiveTones_ToConsider,  p_ModifiedTones);
      else
      {
         // reset the flag
         ft_FlagAnyToneLeft = 0;
         for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
         {
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
            if (gft_pwr_limit == 1)
            {
               break;
            }
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

            if (IS_TONEFLAGSET(p_ActiveTones_ToConsider, s_ch) && (s_DeltaSumbi < 0))
            {

               s_bi = puca_RxBat[s_ch];
               if (s_bi < s_MinBitsPerTone)
                  continue;

               // if there is any tone with more than min bits
               ft_FlagAnyToneLeft = 1;
               if (gft_ModemType == G_DMT)
               {
                  if(s_ch <= gs_MaxToneForFast)
                     s_CodingGain = gsa_TotalCodingGain[FAST_DATA_PATH];
                  else
                     s_CodingGain = gsa_TotalCodingGain[INTERLEAVE_DATA_PATH];

                  if (s_DeltaSumbi == -1)
                     break;  // special case since min bits pertone =2 in DMT

               }
               else
               { // for g.992.3/g.992.5
                  // Currently only supports single latency.
                  s_CodingGain = gsa_TotalCodingGain[LP0_DATA_PATH];
               }

               s_Margin = psa_SNRBuffer[s_ch];

               if (s_bi!=0)
               // For bi=0 tones, its fine gain either is negative infinity db or 0db, so ignore its fine gain here
               // avoid the possible overflow problem (for negative inifinity) and also fine for 0db case.
                  s_Margin += psa_RxFineGains[s_ch];


               s_Margin += s_CodingGain;

               // When subtracting bits and looking for the tone with the smallest margin, we use bi_delta = 0.
               s_Margin -= gsa_ConstellationSNR[s_bi];
               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
               //removing margin fudge
               if(TESTArray[Test_DisableBitSwapImprvmnt] ||
                  !((STATArray[STAT_MacroState] == STAT_ShowTimeState)||
                   (STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState)) ||
                   ((gs_OlrReq == L2_REQ) || (gs_OlrReq == SRA_REQ)))
               {
                  s_Margin += OPTNArray[OPTN_MarginDelta] ;
               }

               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
               //Added check to enforce s_MinToneMargin bound
               if ((s_Margin >= s_MinToneMargin) && ((STATArray[STAT_MacroState] == STAT_ShowTimeState)||
                  (STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState)) &&
                  ((gs_OlrReq != L2_REQ)&&(gs_OlrReq != SRA_REQ)) && (!TESTArray[Test_DisableBitSwapImprvmnt]))
               {
                  continue;
               }

               // Check if themargin is better than margin to compare + threshold
               if (s_Margin > s_MinMargin_toComp + s_threshold)
                  continue;
               else if (puca_RxBat[s_ch] == s_MinBitsPerTone)
               {
                  // update fine gain linear sum square
                  UpdateFineGainLinSumSq(psa_RxFineGains[s_ch], 0, gusa_DS_Tssi_Value[s_ch], &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 1 );

                  // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
#if 0
                  if(gft_Amd4_L2_Entry)
                  {
                     if(s_ch >= LOWEST_DS_CHANNEL)
                     {
                        gs_margin_store[s_ch - LOWEST_DS_CHANNEL] = gsa_ConstellationSNR[s_bi] - psa_RxFineGains[s_ch];
                     }
                  }
#endif
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

                  puca_RxBat[s_ch] = 0;
                  if ( !IS_TONEFLAGSET(p_FINEGAINSKIPset, s_ch) )
                     psa_RxFineGains[s_ch] = 0;
                  (*pus_ncloaded)--;
                  s_DeltaSumbi += s_MinBitsPerTone;
               }
               else
               {
                  puca_RxBat[s_ch]--;
                  s_DeltaSumbi++;

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
                  s_Fgain_lowest = gs_min_fine_gain;
                  if(gft_Amd4_L2_Entry)
                  {
                     s_Fgain_lowest = L2_MIN_GI;
                  }
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
                  // remove excess gain (BIS), if not SRA
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
                  if ((!ft_isSRA) &&
                      (((psa_RxFineGains[s_ch] >= s_Fgain_lowest) &&(gft_Amd4_L2_Entry))||
                       ((psa_RxFineGains[s_ch] > s_Fgain_lowest) &&(!gft_Amd4_L2_Entry))) &&
                       ((gl_SelectedMode & (MODE_ADSL2)) && (gft_FineGainOn == TRUE)))
                  {
                      // calculate excess gain
                      s_excessmargin = s_Margin - s_MinToneMargin + (gsa_ConstellationSNR[s_bi] - gsa_ConstellationSNR[s_bi -1]);
                      s_FineGaininit = psa_RxFineGains[s_ch];

                      if(s_excessmargin > 0)  // to ensure that we are taking the gains out, may e in case of bad tones, margin may be negative here
                      {
                        psa_RxFineGains[s_ch] -= s_excessmargin;
                        //ADSLRTFW-1582 FEATURE_DS_BisPlus_ALL_GainScaleInL2Mode_Amd4G9923 (Start)
                        if(!gft_Amd4_L2_Entry)
                        {
                           if (psa_RxFineGains[s_ch] < gs_min_fine_gain)
                           {
                              psa_RxFineGains[s_ch] = gs_min_fine_gain;
                           }
                        }
                        else if (psa_RxFineGains[s_ch] < L2_MIN_GI)
                        {
                           psa_RxFineGains[s_ch] = L2_MIN_GI;
                        }
                        // update fine gain linearsum sq
                        UpdateFineGainLinSumSq(s_FineGaininit, psa_RxFineGains[s_ch], gusa_DS_Tssi_Value[s_ch],
                                                 &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 0);
                      }
                     else if(((s_excessmargin < 0) && (s_excessmargin >= -640)) &&(gft_Amd4_L2_Entry))
                      {
                        psa_RxFineGains[s_ch] -= s_excessmargin;
                        //The following code may not be required
                        if(psa_RxFineGains[s_ch] > 640)
                        {
                           psa_RxFineGains[s_ch] = 640;
                        }
                        //End of the code which may not be required
                        UpdateFineGainLinSumSq(s_FineGaininit, psa_RxFineGains[s_ch], gusa_DS_Tssi_Value[s_ch],
                                                   &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 0);
                      }//else if(0 >= s_excessmargin > -640)
                  }
               }
               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
               //Disabling bitswap tones as it is used for marking tones which have margin
               //between min margin and min margin + delta
               //Marking of tones with bit swap is moved to the end of bitswap scheme
               if(TESTArray[Test_DisableBitSwapImprvmnt] ||
                  !((STATArray[STAT_MacroState] == STAT_ShowTimeState) ||
                   (STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState)) ||
                   (gs_OlrReq == L2_REQ) || (gs_OlrReq == SRA_REQ))
               {
                  SETTONEFLAG(p_ModifiedTones, s_ch);
               }
            }

         }//for

         // Check whether we now meet margin and break if that flag is set.
         ft_Result = FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains, psa_SNRBuffer, p_ActiveTones_ToConsider, s_MinBitsPerTone, (int16) guc_MaxAllocBitsPerTone, &s_ch, &s_Margin);

   //ADSLRTFW-1582 FEATURE_DS_BisPlus_ALL_GainScaleInL2Mode_Amd4G9923 (Start)
         if(gft_Amd4_L2_Entry)
         {
            //gs_Offset_L2rmsFG_power_prv = gs_Offset_L2rmsFG_power;
            gs_Offset_L2rmsFG_power = (((int16) gt_RxOLRPMVars.uc_max_PCB_val - gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols)<< 8) + gs_RxDesiredMargin - s_Margin;
            if(gs_Offset_L2rmsFG_power <= 0)
            {
               gs_Offset_L2rmsFG_power = 0;
               gft_pwr_limit = 1;
            }
         }

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
         if ((s_Margin >= s_MinToneMargin) && ft_StopAtMarginThreshold)
            break;
         /* if margin is still lower implies that we have not been able to touch the
         low margin tone, increase the threshold, instead of resetting the margin to compare*/
         if (s_Margin <=  s_MinMargin_toComp + s_threshold)
            s_threshold += 128;
         else
            s_MinMargin_toComp = s_Margin;
      }
   } // while s_DeltaSumbi < 0

   *ps_ActualDeltaSumbi = s_DesiredDeltaSumbi - s_DeltaSumbi;

   return(uc_RetCode);
}
