/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   forceeven1bit.c
*
*  force even 1 bit tones for BIS
*
*-------------------------------------------------------------------------
*/
//***************************************************************************
// 14/12/2012 Mahesh: Added L2 entry - Amd 4 changes.
//          Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
//***************************************************************************
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "minmaxmargin.h"
#include "bitload_const.h"
#include "bitload_support.h"

/*^^^
*-----------------------------------------------------------------------------
*   Prototype: FlagT ForceEvenNum1BitTonesInBAT(uint8 *puca_Bat, int16 *psa_RxFineGains, int16 *psa_SNRBuffer, int16 s_MinToneMargin,
*                          ToneFlags p_ActiveTones, ToneFlags p_ModifiedTones)
*
*   Description:
*     Makes minimal adjustments to an Rx BAT to force the number of 1-bit tones to be even, without changing
*     the value of Lp = Sum{bi} - TCM_Overhead.  It is assumed that TCM is enabled.
*
*   Input Parameters:
*     puca_Bat -- pointer to an Rx bit allocation table
*     psa_RxFineGains -- pointer to an Rx fine gain table
*     psa_SNRBuffer -- measured SNR buffer, not adjusted for coding gain or anything else.
*     s_MinToneMargin -- the minimum margin (in 8.8 dB format) that must be met by the BAT table after any modifications
*     p_ActiveTones -- One-bit-per-tone array indicating which tones in the BAT may be changed by this routine.  Only tones
*           whose bit is set will have their bi changed, and margin checks will only be done on these tones.

*  Output Parameters:
*     p_ModifiedTones -- One-bit-per-tone array used to indicate which tones were actually changed by this routine.  In some
*           cases a bit may be set for a tone whose final bi value has not changed, because intermediate steps may have
*           changed the bit and then changed it back again.
*
*   Returns:
*     FlagT value indicating SUCCESS or FAIL.  SUCCESS is the normal return value.
*        FAIL is returned if the necessary changes to the BAT are impossible or would violate the specified min margin.
*
*  Global variables:
*
  *-----------------------------------------------------------------------------
^^^*/

C_SCOPE FlagT ForceEvenNum1BitTonesInBAT(uint8 *puca_Bat, int16 *psa_RxFineGains, int16 *psa_SNRBuffer, int16 s_MinToneMargin,
                           RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones)
{
   int16  s_Num1BitTones, s_TCM_Ovhd, s_Dummy;
   uint16 s_NumLoadedTones;
   int16 s_ch, s_Margin, s_ch_leastmargin;
   FlagT ft_Result = FALSE;
   int16 s_CaseType; // Takes on value of 1,2,3 or 4, depending on values of : NumLoadedTones (mod 2)
   // and Num1BitTones (mod 4).
   RxToneFlags p_ActiveTones_ToConsider;
   // Does this function need to check that the minimum number of non-zero bi exist?
   int16 s_path = LP0_DATA_PATH;


   GetBatStats(puca_Bat, gs_RxNumTones, 1, &s_NumLoadedTones, &s_Num1BitTones, &s_TCM_Ovhd, &s_Dummy, s_path);


   // Copy the active tone set to another array

   for (s_ch = 0; s_ch < (RX_NUM_TONES>>3); s_ch++)
      p_ActiveTones_ToConsider[s_ch] = p_ActiveTones[s_ch];


   if(s_Num1BitTones % 2 == 1)
   {
      s_CaseType = (s_NumLoadedTones & 0x1) + (s_Num1BitTones & 0x3); // There are four different case types of interest.

      // First drop a one-bit tone to zero. Choose the tone with the lowest margin.
      FindToneWithExtremeMargin  (SMALLEST_MARGIN, puca_Bat, psa_RxFineGains, psa_SNRBuffer, p_ActiveTones, 1, 1, &s_ch_leastmargin, &s_Margin);

      CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch_leastmargin);


      // Under certain conditions this will have decreased Lp.  Check for these cases.
      if ((s_CaseType == 1) || (s_CaseType == 4))
      {
         // Need to increment Lp.
         if (s_NumLoadedTones > s_Num1BitTones)
         {
         // Since there exists at least one tone with bi > 1, increment Lp by incrementing that bi.
         // This will work unless for all bi > 1, bi = 15, but this is highly unlikely.

            // Find tone that has biggest margin after adding a bit to it.
            ft_Result = FindToneWithExtremeMargin  (LARGEST_MARGIN, puca_Bat, psa_RxFineGains, psa_SNRBuffer,
               p_ActiveTones_ToConsider, 2, (int8) (guc_MaxAllocBitsPerTone-1), &s_ch, &s_Margin);

            if (ft_Result == FAIL)
            {
               gs_forceeven1bit_notonefound = 1 ;
               return(FAIL); // Tones that don't have bi=1 all have bi=15. Highly unlikely!!
            }
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
            if(gft_Amd4_L2_Entry)
            {
               if(psa_RxFineGains[s_ch] >= (s_MinToneMargin - s_Margin))
               {
                  psa_RxFineGains[s_ch] = psa_RxFineGains[s_ch] - (s_MinToneMargin - s_Margin);
               }
            }
            else if (s_Margin < s_MinToneMargin)
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
            {
               gs_forceeven1bit_notonefound = 1 ;
               return(FAIL);
            }

            // Increment the BAT and mark the tone as modified.
            puca_Bat[s_ch] += 1;
            SETTONEFLAG(p_ModifiedTones, s_ch);
         }
         else {


            // All tones have bi=1.
            // In this case increment Lp by performing the following changes on four 1-bit tones:
            // 1->0, 1->0, 1->2, 1->3

            uint8 uca_ChangeToBi[4] = {0,0,2,3};
            int16 s_NumTonesChanged=0;
            int16 s_New_bi;
            int16 s_save_tonenum[4];

            while (s_NumTonesChanged < 4)
            {
               // Get next 1-bit tone with largest margin.
               ft_Result = FindToneWithExtremeMargin  (LARGEST_MARGIN, puca_Bat, psa_RxFineGains, psa_SNRBuffer,
                  p_ActiveTones_ToConsider, 1, 1, &s_ch, &s_Margin);

               if (ft_Result == FAIL)
               {
                  gs_forceeven1bit_notonefound = 1 ;
                  return (FAIL);
               }
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
            if(gft_Amd4_L2_Entry)
            {
               if(psa_RxFineGains[s_ch] >= (s_MinToneMargin - s_Margin))
               {
                  psa_RxFineGains[s_ch] = psa_RxFineGains[s_ch] - (s_MinToneMargin - s_Margin);
               }
            }
               // Check that adding bits to this tone won't violate margin.  If so, fail.
               else if (s_Margin < s_MinToneMargin)
               {
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
               // Check that adding bits to this tone won't violate margin.  If so, fail.

                  gs_forceeven1bit_notonefound = 1 ;
                  return(FAIL);
               }

               s_save_tonenum[s_NumTonesChanged] = s_ch;

               s_NumTonesChanged++;

               CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch);

            }

            if (ft_Result != FAIL)
            {
               // do actual bat changes and set modified tones flag

               for (s_NumTonesChanged =0; s_NumTonesChanged < 4; s_NumTonesChanged ++)
               {
                  s_ch = s_save_tonenum[s_NumTonesChanged];
                  s_New_bi = uca_ChangeToBi[s_NumTonesChanged];
                  puca_Bat[s_ch] = (uint8) s_New_bi;
                  SETTONEFLAG(p_ModifiedTones, s_ch);

               // If bi set to 0, reset fine gain to 0dB.
                  if (s_New_bi == 0)
                  {
                  // update linearsum finegain (done only in showtime for codeswap reasons)
                     if (gs_RxState == R_C_SHOWTIME_RX)
                     UpdateFineGainLinSumSq(psa_RxFineGains[s_ch], 0, gusa_DS_Tssi_Value[s_ch], &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 1 );
                            if( !IS_TONEFLAGSET(p_FINEGAINSKIPset, s_ch))
                     psa_RxFineGains[s_ch] = 0;
                  }

               }

            }

         }

      }


      // Zero the BAT for 1 bit tone saved earlier, reset the fine gain, and mark the tone as modified.
      // update linearsum finegain (done only in showtime for codeswap reasons)

      if (gs_RxState == R_C_SHOWTIME_RX)
      UpdateFineGainLinSumSq(psa_RxFineGains[s_ch_leastmargin], 0, gusa_DS_Tssi_Value[s_ch_leastmargin], &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 1 );

      puca_Bat[s_ch_leastmargin] = 0;
        if( !IS_TONEFLAGSET(p_FINEGAINSKIPset, s_ch_leastmargin))
      psa_RxFineGains[s_ch_leastmargin] = 0; // 0dB
      SETTONEFLAG(p_ModifiedTones, s_ch_leastmargin);

   }
   return(SUCCEED);
}

