/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   updatefinegainlinsq.c
*
*
*
*-------------------------------------------------------------------------
*/
// 14/12/2012 Mahesh: Added L2 entry - Amd 4 changes.
//          Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "minmaxmargin.h"
#include "bitload_const.h"
#include "decimalgain.h"
#include "bitload_support.h"
#include "snr.h"
#include "dsp_op.h"
#include "mul.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*        void UpdateFineGainLinSumSq(int16 finegaindB_init, int16 finegaindB_final, int16 s_tssi, int32 *pl_SumFGainLinSq, int32 *pl_SumGiSqTssiSq, FlagT ft_ToneUnloaded)
*
*  Description:
*        Adjust the FineGainLinear Sum square
*
*  Global Variables:
*
*
*-----------------------------------------------------------------------------
*/

C_SCOPE void UpdateFineGainLinSumSq(int16 finegaindB_init, int16 finegaindB_final, int16 s_tssi, int32 *pl_SumFGainLinSq, int32 *pl_SumGiSqTssiSq, FlagT ft_ToneUnloaded)
{
   int16 s_FGainLin;
   int32 l_SumFGainLinSq_add, l_SumFGainLinSq_sub;
   int32 l_SumGiSqTssiSq_Add, l_SumGiSqTssiSq_Sub;
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   int32 l_SumFGainLinSq_prv = 0;
   int16 s_gain_factor;
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
/* if (gs_RxState == R_C_SHOWTIME_RX)
   s_tssi = 0;
*/
   // preserve the 12 most significant bits as these are sent in R_params
   s_FGainLin = (DecimalGain(finegaindB_final)+(int16)(1<<3)) >>4;


   // compute sumGiSqTssiSq add

   l_SumGiSqTssiSq_Add = ComputeGisqTssiSq(s_FGainLin, s_tssi);

   if (ft_ToneUnloaded ==1) s_FGainLin =0; // tone being unloaded

   MULS16(l_SumFGainLinSq_add, s_FGainLin, s_FGainLin)  ;

   // finegain-init
   s_FGainLin = (DecimalGain(finegaindB_init)+(int16)(1<<3)) >>4;


   //compute sumGisqTssiSq_sub

   l_SumGiSqTssiSq_Sub = ComputeGisqTssiSq(s_FGainLin, s_tssi);

   if (ft_ToneUnloaded == 2) s_FGainLin =0; // tone being loaded for the first time

   MULS16(l_SumFGainLinSq_sub , s_FGainLin , s_FGainLin);


   *pl_SumFGainLinSq = *pl_SumFGainLinSq + l_SumFGainLinSq_add -  l_SumFGainLinSq_sub;
   *pl_SumGiSqTssiSq = *pl_SumGiSqTssiSq + l_SumGiSqTssiSq_Add - l_SumGiSqTssiSq_Sub;
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   if(gft_Amd4_L2_Entry == 1)
   {
      gs_gi_power_change_dB_prv = gs_gi_power_change_dB;
      s_gain_factor = ConvertToDB(gl_save_SumFGainLinSq)  - ConvertToDB((*pl_SumFGainLinSq));
      gs_gi_power_change_dB = s_gain_factor;
      if( s_gain_factor >= gs_Offset_L2rmsFG_power)
      {
         gft_pwr_limit = 1;
         *pl_SumFGainLinSq = l_SumFGainLinSq_prv;
         gs_Offset_L2rmsFG_power = gs_Offset_L2rmsFG_power_prv;
         gs_gi_power_change_dB = gs_gi_power_change_dB_prv;
      }
   }
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
}


C_SCOPE int32 ComputeGisqTssiSq(int16 s_FGainLin, int16 s_tssi)
{
   int16 s_GiTssi;
   int32  l_temp;

   // compute Gi * tssi
   MULS16(l_temp , s_FGainLin , s_tssi);
   l_temp = round(l_temp, 6); //  round the results to 16 bits

   s_GiTssi = (int16) l_temp;

   // compute (gi * tssi ) ^2
   MULS16(l_temp , s_GiTssi , s_GiTssi);
   l_temp = round(l_temp , 9);

   return (l_temp);
}

