/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  datasymbl.c
;
;  Functions for processing synchronization symbols.
;
;***************************************************************************/
// ******************************************************************
// datasymbl.c
//
// History
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 20/03/2015 ChihWen: Switch to FW SNR FDQ update in REIN cases in order to sustain DS margin.
//            Grep for XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "dsp_op.h"
#include "noiseacc.h"
#include "fifo.h"
#include "dd_snrfdq.h"
#include "cmv.h"
#include "memsetbf.h"

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
extern void DDSnrFdqHandler_HW(void);
extern void DisableFDQAdapt(void);
extern void DisableNPRWrite(void);
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START_END)
uint8 guc_ddHwSwSnrFdqState = 0;

/*****************************************************************************
;  Subroutine Name: DataSymbolHandler
;
;  Description:
;     This subroutine processes a data symbol. Currently, does the following:
;        1) Data Directed SNR Calculation
;        2) Data Directed FDQ Adaptation
;
;  Prototype:
;     void DataSymbolHandler(void);
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables (defined in other files):
;     gsa_RxShowtimeSnrBuf[]              - (O) showtime SNR buffer (in Q8.8 format)
;     gla_RxShowtimeSnrAccumBuf[]         - (I/O) accumulated received tone buffer
;     gsa_RxRepBuf[]                   - (O) average received tone buffer
;     gsa_FDQ_coef[]                   - (I/O) current FDQ coefficient buffer
;     gsa_FDQ_exp[]                    - (I/O) current FDQ exponent buffer
;
;  Global Variables (defined in this file):
;     guc_ShowtimeSnrCalcState            - (I/O) showtime SNR calculation substate
;     gus_ShowtimeSNRFrameCnt             - (I/O) showtime SNR calculation count
;     guc_FdqAdaptationState              - (I/O) FDQ adaptation substate
;     gus_ShowtimeFDQFrameCnt          - (I/O) FDQ adaptation count
;
;  Substates:
;       SHOWTIME_SNR_CALC_DISABLE           - disable calculations
;       SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES - accumulate frames for SNR calculation during Showtime
;       SHOWTIME_SNR_CALC_PERFORM_CALC      - perform SNR calculation during Showtime
;       FDQ_ADAPTATION_DISABLE              - disable FDQ calculations
;       FDQ_ADAPTATION_INITIALIZE           - initialization for updating FDQ coefficients during showtime
;       FDQ_ADAPTATION_ACCUMULATE_FRAMES    - accumulate frames of data for updating FDQ coefficients
;       FDQ_ADAPTATION_UPDATE_COEFFICIENTS  - update FDQ coefficients during showtime
;
*******************************************************************************/
void DataSymbolHandler(void)
{
   if (gft_doDDSnrFdqUpdate == DD_ENABLE)
   {
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START)
//ChihWen: bug fix of no sync when shine noise is injected (START)
           if ( (OPTNArray[OPTN_AlgControl3] & CMV_TO_DISABLE_HW_SNR_FDQ) == 0 )
           {
               //ChihWen: VRX518 DMT AnxB bring up (START)
                   if ( ((gl_SelectedMode & MODE_ADSL2) && (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)) ||
                        (gl_SelectedMode & MODE_ADSL1) )
                   {
                     switch (guc_ddHwSwSnrFdqState)
                     {
                        case 0:
                           DDSnrFdqHandler_HW();

                           if (guc_ddProcState == DD_PROC_WAIT_TO_FW_SNR_FDQ)
                           {
                                 guc_ddProcState = DD_PROC_INITIALIZE;
                                 guc_ddHwSwSnrFdqState = 1;
                           }

                           break;

                        case 1:
                           DDSnrFdqHandler();
                           if (guc_ddProcState  == DD_PROC_WAIT)
                              guc_ddHwSwSnrFdqState = 0;
                           break;
                     }//switch (guc_ddHwSwSnrFdqState)
            }//if (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (END)
         else  if ( (gl_SelectedMode & MODE_ADSL2) && (gt_RxOLRPMVars.uc_rxOLRPMState == L2_STEADY_STATE) )
            DDSnrFdqHandler();
         //ChihWen: VRX518 DMT AnxB bring up (END)
      }
      else
      {
      // SNR Calculation and FDQ Adaptation
      if(   guc_ShowtimeSnrCalcState != SHOWTIME_SNR_CALC_DISABLE ||
         guc_FdqAdaptationState != FDQ_ADAPTATION_DISABLE)
      {
         DDSnrFdqHandler();
      }
           }
//ChihWen: bug fix of no sync when shine noise is injected (END)
#else
      // SNR Calculation and FDQ Adaptation
      if(   guc_ShowtimeSnrCalcState != SHOWTIME_SNR_CALC_DISABLE ||
         guc_FdqAdaptationState != FDQ_ADAPTATION_DISABLE)
      {
         DDSnrFdqHandler();
      }
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
   }
}
