/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  dd_snrfdq.c
;
;  Decision-directed SNR, FDQ
;
;***************************************************************************/
// ******************************************************************
// dd_snrfdq.c
//
// History
//
// 10/08/2010 Nihar: Three bug fixes for KTL and BT qual tests:
//            (1) Avoid bitswap on aux pilot in G.dmt/T1.413 mode.
//            (2) No (i.e. 0dB) finegain on aux pilot in G.dmt/T1.413 mode.
//            (3) Skip pilot FDQ magnitude adaptation during sync symbol since CO Tx pilot with average finegain power.
//             Grep for PERF_DS_AB_ALL_ALL_PilotBugfixes
//
// 15/11/2011 ChihWen/Bhadra: There is a special requirement that CPE should sync up in 2km loop with -90 dBm/Hz AWGN (normally DS rate is 600 Kbps),
//                and should be able to reach max capped rate of 6 Mbps by upshift SRA when noise power is decreased to -140 dBm/Hz AWGN.
//            With this special requirement, we need to load more bits not only on already loaded tones, but also on monitored tones,
//                in order to reach the max capped rate. A problem behind this requirement is that CNXT CO does not send signal on unloaded tones.
//                So the workaround to fulfill the requirement for all CO are as below.
//                1. For all CO, changing the threshold for setting monitored tones from 4 dB to 6 dB (SNR_THRESH_LOAD_MIN_BITS).
//                2. For all CO, not limiting number of monitored tones to 20 if SRA is enabled on CO site.
//                3. For all CO, making OLR (SRA and bitswap) only occurring on loaded/monitored tones.
//                4. For CNXT CO, no updating FDQ cofficients on unloaded tones.
//                5. For CNXT CO, measuring noise on monitored tones to get an estimation of SNR.
//                6. For CNXT CO, SNR on monitored tones are capped to 2-bits required SNR, in order to load two bits and get better SNR measurement.
//
//                7. When DS rate capped low, it took bitloading too long time to
//               find gs_deltaLp_max and failed the training. This is the root cause
//               of no-link with 3.5M capped profiles.
//               The solution is to use a larger searching step to find a valid
//               gs_deltaLp_max faster.
//
//                8. For CNXT CO, decreasing the Tx buffer size for overhead message by 2 if the tone number in the last segment of SRA message was 14.
//                   This was because CRC/link drop was always seen when there was 14 tones in the last segment of SRA message.
//
//            Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones
// 18-06-2012 Raghu M. The algorithm used for discard frame is changed.
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 20/03/2015 ChihWen: Switch to FW SNR FDQ update in REIN cases in order to sustain DS margin.
//            Grep for XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "noiseacc.h"
#include "fifo.h"
#include "dd_snrfdq.h"
#include "cmv.h"
#include "memsetbf.h"
#include "snr.h"
#include "plam.h"
#include "accum32.h"
#include "bufmisc.h"
#include <string.h>
#include "showtime_rx_b_bis.h"
#include "bitload_const.h"
#include "vecmult.h"
#include "cmplxvecmult.h"
#include "tx_plam.h"
#include "modem_hw.h"
#include "xception.h"
#include "pll.h"
#include "mul.h"

#if defined(HERCULES_ADSL_CPE) || defined(AMAZON_SE)
#define TOGGLE_FDQ_OUT_BUFFER
#endif

extern int8 guc_Log2NumShowtimeSNRTrainingSymbols;

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ

extern int16 gs_RxToneOffset;
extern void AddVirtualNoise(int16 *psa_snr, int16 s_first_chan, int16 s_last_chan);

FlagT gft_DisableNPRWrite = FALSE;
int16 gs_DDSnrState;
int16 gs_AlgHandlerCount;

void EnableFDQAdapt(void);
void DisableFDQAdapt(void);
void BgCalcSnr(void);
void DisableNPRWrite(void);
void SetUpRTVForSnrFdqHandler(void);

//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START)
extern void ReadFDQ1(void);
extern void ReadFDQ2(void);
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (END)

#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

/************************************************************************
**
** FUNCTION     :   DDSnrFdqHandler
** PROTOTYPE    :   void DDSnrFdqHandler(void)
**
** DESCRIPTION  :   Performs decision directed SNR/FDQ computation
**
**                  1) Noise-accumulation:
**                      a) Scale QAM output by combined-gains to get the fdq output estimate
**
**                      b) Compute decision error which is infact the noise term:
**                         e_re(i) = fdq_output_re(i) - fdq_output_estimate_re(i)
**                         e_im(i) = fdq_output_im(i) - fdq_output_estimate_im(i)
**
**                  2) Noise-accumulation:
**                      a) Compute current noise-power
**                         N(i) = e_re(i)^2 + e_im(i)^2
**
**                      b) Accumulate noise power
**
**                  3) SNR calculation
**                a) Average accumulated noise power
**
**                b) Compute SNR for channel i given averaged noise power N(i)
**
**
***********************************************************************/
void DDSnrFdqHandler(void)
{
    int i ;
    int16 s_rxPmdFrameCnt;
    int16 *psa_qamOutput, *psa_ref;
    int16 *psa_fdqOutput, *psa_recv;
    int16 *psa_noise_err = gpsa_DD_NoiseError;
    int16 s_num_channels, s_num_channels2;
    FlagT ft_DD_discardCurrDataFrame;

    if (gs_DD_NumFramesProcDisable>0)
    {
        gs_DD_NumFramesProcDisable--;
        return;
    }

    /* get number of subchannels */
    s_num_channels = (gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1);
    s_num_channels2 = (s_num_channels << 1);

    // Start the DD SNR processing
    switch(guc_ddProcState)
    {
    case DD_PROC_DISABLE:
        /* DD processing disabled */
        break;

    case DD_PROC_INITIALIZE:
        /* reset accum frame cnt */
        gus_ShowtimeSNRFrameCnt = 0;
        for(i = 0; i < s_num_channels2; i++) {
            gla_RxShowtimeSnrAccumBuf[i] = 0;
        }
        /* Queue the background task to compute 1/rx_combined_gains and save them in a buffer */
        guc_SnrCalcState = TRAINING_IN_PROGRESS;
        AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDDPreProc);
        guc_ddProcState = DD_PROC_PRE;
        break;

    case DD_PROC_PRE:
        /* check for bkgrnd task completion */
        if(guc_SnrCalcState == TRAINING_DONE)
        {
            guc_SnrCalcState = TRAINING_WAITING;

            /*  update fdq state m/c */
            if(guc_FdqAdaptationState != FDQ_ADAPTATION_DISABLE)
            guc_FdqAdaptationState = FDQ_ADAPTATION_ACCUMULATE_FRAMES;
            /*  update snr state m/c */
            if(guc_ShowtimeSnrCalcState != SHOWTIME_SNR_CALC_DISABLE)
            guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES;
            /*  update dd state m/c */
            guc_ddProcState = DD_PROC_ACCUMULATE_FRAMES;
        }
        break;

    case DD_PROC_ACCUMULATE_FRAMES:
        /* assign local pointers to global buffers */
        // We assume that gsa_DD_rxQAMOutput[] contains the captured rx qam outputs
        // It is also assumed that gsa_DD_rxQAMOutput[] is not updated as DD processing is
        // being executed in the foreground.
        psa_qamOutput = &gsa_DD_rxQAMOutput[0];

        // Note: NTC task and hence DD processing always occurs after QAM done interrupt
        // Here, we rely on the fdq outputs to perform DD processing. In this mode, data
        // collection and processing can occur in parallel. Hence, we need to select the
        // appropriate data buffer for DD processing
        if(( gl_SelectedMode & (MODE_ADSL2)  )) s_rxPmdFrameCnt = gs_RxPMDFrameCnt;
        else s_rxPmdFrameCnt = gs_MuxFrameCntRxFastPath;

#ifndef TOGGLE_FDQ_OUT_BUFFER
        // Disable DSL interrupts so that the FDQ_TC will not interfere
        // with the selection of FDQ output buffer.
        DisableADSLInterrupts();

        // We assume that gsa_DD_rxFDQOutput[] ping-pong buffer contains the captured rx fdq outputs
        // NOTE: Shouldnt recieve a fdq done interrupt during the execution of this
        // conditional statement that selects the ping/pong fdq output buffer
        // Refer showtime timing diagram to understand the below check
        if (s_rxPmdFrameCnt == RX_SYMBOLS_PER_SFRAME-1 ||
                gs_RxPMDFrameCnt_FftFdqBufferSymbol == s_rxPmdFrameCnt)
        {
            // It is also assumed that gsa_DD_rxFDQOutput[gs_DD_rxFDQOutput_Buffer_Select]
            // is not updated as DD processing is being executed in the foreground.
            psa_recv = psa_fdqOutput = &gsa_DD_rxFDQOutput[gs_DD_rxFDQOutput_Buffer_Select][0];
            ft_DD_discardCurrDataFrame = gfta_DD_discardCurrDataFrame[gs_DD_rxFDQOutput_Buffer_Select];
        }
        else
        {
            // It is also assumed that gsa_DD_rxFDQOutput[1-gs_DD_rxFDQOutput_Buffer_Select]
            // is not updated as DD processing is being executed in the foreground.
            psa_recv = psa_fdqOutput = &gsa_DD_rxFDQOutput[1-gs_DD_rxFDQOutput_Buffer_Select][0];
            ft_DD_discardCurrDataFrame = gfta_DD_discardCurrDataFrame[1-gs_DD_rxFDQOutput_Buffer_Select];
        }

        // Enable DSL interrupts here again
        EnableADSLInterrupts();
#else
        // no need to toggle for Hercules build
        psa_recv = psa_fdqOutput = &gsa_DD_rxFDQOutput[0][0];
        ft_DD_discardCurrDataFrame = gfta_DD_discardCurrDataFrame[0];
#endif

        if (psa_fdqOutput == &gsa_DD_rxFDQOutput[0][0])
        gl_XYDec_DD_rxFDQOutput_X16 = gl_XYDec_DD_rxFDQOutput0_X16;
        else
        gl_XYDec_DD_rxFDQOutput_X16 = gl_XYDec_DD_rxFDQOutput1_X16;

        /* do basic (non-tcm) constellation decode of 0 and 1 bit tones */
        /* coversion is done in place i.e. qamOutput is overwritten by output of constellation decode */
        do_rx_consdec(psa_qamOutput, psa_fdqOutput, gs_DD_RxFirstChannel, gs_DD_RxLastChannel);

        /* compute reference signal by doing rx gain scaling of qam o/p */
        /* qam_output = quantized(fdq_output * combined_gain)        */
        /* reference_signal = qam_output / combined_gain          */
        /* coversion is done in place i.e. qamOutput is overwritten by reference signal */

        psa_ref = psa_qamOutput;
        VectorMultiplyShowtime(s_num_channels2);

        /* Compute noise error vector e = reference - recieved */
        //for (i= gs_DD_RxFirstChannel; i <= gs_DD_RxLastChannel; i++)
        for (i=s_num_channels; i>0 ; i--)
        {
            *psa_noise_err++ = (*psa_ref++) - (*psa_recv++);
            *psa_noise_err++ = (*psa_ref++) - (*psa_recv++);
        }

#if defined  (DANUBE_WB) || defined (VR9_ERASURE)

      // XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (START)
      // Default use new algorithm to decide on discard frame.
      if ((gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_TOGGLE_NewAndOldDiscardFrameAlgo))
      {
         if (gft_frame_with_lowmetric)
            break;
      }
      else
      {
         //Metric-based frame discarding, this is independent of whether erasure decoding is on/off
         if (gus_lowmetric_detect_cnt++ == gus_lowmetric_detect_period)
         {
            gus_lowmetric_detect_cnt = 0;
            gus_lowmetric_discard_cnt = 0;
         }

         if (gft_frame_with_lowmetric)
         {
           // ft_DD_discardCurrDataFrame = gft_frame_with_lowmetric;
            gft_frame_with_lowmetric = 0;
            if (gus_lowmetric_discard_cnt < gus_lowmetric_discard_max)
            {
               gus_lowmetric_discard_cnt ++;
               gul_num_frame_lowmetric ++ ;
               break;
            }
         }
      }
      // XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (END)
#endif

        /* compute error correlation and adapt fdq */
        if(guc_FdqAdaptationState == FDQ_ADAPTATION_ACCUMULATE_FRAMES)
        {
            /* SEF or LOS or LOF ==> disable fdq adaptation for these set of tones */
            if((ft_DD_discardCurrDataFrame == TRUE) || (gs_NearEndFailure & (PLAM_LOS_FailureBit | PLAM_LOF_FailureBit)))
            {
                guc_FdqAdaptationState = FDQ_ADAPTATION_INITIALIZE;
            }
            else
            {
                CmplxVectorMultiply(gpsa_DD_rxFDQErrCorrBuf, psa_fdqOutput,
                gpsa_DD_NoiseError, TRUE, 13, s_num_channels,
                gpsa_DD_CmplxMultScratchPadX, gpsa_DD_CmplxMultScratchPadY);

                /* Start the background fdq adaptation processing task */
                AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDDFdqAdapt);
                guc_FdqAdaptationState = FDQ_ADAPTATION_UPDATE_COEFFICIENTS;
            }
        }

        /*  accumulate noise power */
        if(guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES)
        {
            NoiseAccShowtime(s_num_channels);

            /* check for end of averaging period -- we use the same period for as that of snr calc for fdq adaptation */
            gus_ShowtimeSNRFrameCnt++;
            if (gus_ShowtimeSNRFrameCnt == (uint16) (1 << guc_Log2NumShowtimeSNRTrainingSymbols))
            {
                /* Start the background showtime snr calc processing task */
                AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDDSnrAdapt);
                guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_PERFORM_CALC;
            }
        }

        /*  both snr and fdq adaptations done or disabled -- update DD state m/c */
        if ((guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_DISABLE || guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_INITIALIZE) &&
                (guc_FdqAdaptationState   == FDQ_ADAPTATION_DISABLE || guc_FdqAdaptationState == FDQ_ADAPTATION_INITIALIZE))
        {
            /*  update DD state m/c */
            guc_ddProcState = DD_PROC_POST;
        }
        /*  only fdq adaptation done -- update fdq state m/c */
        else if(guc_FdqAdaptationState == FDQ_ADAPTATION_INITIALIZE)
        {
            guc_FdqAdaptationState = FDQ_ADAPTATION_ACCUMULATE_FRAMES;
        }

        break;

    case DD_PROC_POST:

        // Disable DSL interrupts so that the FDQ_TC will not interfere
        DisableADSLInterrupts();

        /* update first and last channel to process */
        gs_DD_RxFirstChannel += gs_DD_RxChannelsPerSymbol;
        gs_DD_RxLastChannel += gs_DD_RxChannelsPerSymbol;
        if (gs_DD_RxFirstChannel > gs_RxLastChannel)
        {
            gs_DD_RxFirstChannel = gs_RxFirstChannel; // reset channels
            gs_DD_RxLastChannel = gs_DD_RxFirstChannel + gs_DD_RxChannelsPerSymbol - 1;
            // Increment counters
            if(guc_FdqAdaptationState != FDQ_ADAPTATION_DISABLE)
            {
                gus_ShowtimeFDQUpdateCount++;      // Increment count of FDQ updates.
            }
            if(guc_ShowtimeSnrCalcState != SHOWTIME_SNR_CALC_DISABLE)
            {
                gus_ShowtimeSNRUpdateCount++;         // Increment count of SNR updates.
                // This is the last task we do; this Bkgrnd task may disable
                // DD state m/c or progress it to Initialize state
                AddFunctionToBkgdFifo((PtrToBkgdFunc)SnrUpdate_PostProcess);
                guc_ddProcState = DD_PROC_WAIT;
                // Enable DSL interrupts here again
                EnableADSLInterrupts();
#ifdef AMAZON_SE
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,UpdateRTV);
#endif
                break;
            }
        }
        else if (gs_DD_RxLastChannel > gs_RxLastChannel)
        {
            gs_DD_RxLastChannel = gs_RxLastChannel;   // limit last channel
        }

#ifdef AMAZON_SE
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,UpdateRTV);
#endif
        /* restart accumulation of frames over next set of channels */
        guc_ddProcState = DD_PROC_INITIALIZE;   // The below state also buys a frame of delay as the
        // TC task is using the updated first/last channels
        // Enable DSL interrupts here again
        EnableADSLInterrupts();

        break;

    case DD_PROC_WAIT:
        break;
    }
}

/*
*------------------------------------------------------------------------
*
*  Name:
*     BgDDPreProc
*
*  Prototype:
*     void BgDDPreProc(void);
*
*  Input Arguments:
*     gs_DD_RxFirstChannel
*     gs_DD_RxLastChannel
*
*  Output Arguments:
*     gpsa_DD_1byRxCombinedGains
*
*  Abstract:
*
*  Compute 1/rx_combined_gains for channels (gs_DD_RxFirstChannel,gs_DD_RxLastChannel)
*  and save them in array gpsa_DD_1byRxCombinedGains
*
*  Returns:
*     None
*
*  Global Variables Used:
*      None
*------------------------------------------------------------------------
*/
void BgDDPreProc(void)
{
    int32 i, i2;
    int16 *psa_RxCombinedGain = NULL, s_RxCombinedGain;
    int16 s_lshift_CombGain, s_rshift_1byCombGain, s_exp, s_num_channels;

    uint16 *pusa_RxCombinedGain = NULL,us_RxCombinedGain;
    /* get number of subchannels */
    s_num_channels = (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1);

    /* compute rx gain scale shifts, gpsa_DD_RxGainScaleShifts */
    get_rx_gainscale_shift((int8 *)(void *)&guca_RxBat[gs_DD_RxFirstChannel], s_num_channels, gpsa_DD_RxGainScaleShifts);

    /* compute 1/rx_combined_gain */
   //XDSLRTFW-1727
#if 1 //L2_13dB
   if (STATArray[STAT_PowerMode] == STAT_PM_L2)
     pusa_RxCombinedGain = &gusa_RxL2CombinGains[gs_DD_RxFirstChannel];
   else
#endif
    psa_RxCombinedGain = &gsa_RxCombinedGains[gs_DD_RxFirstChannel];
    for (i=0; i < s_num_channels; i++)
    {
        i2 = (i << 1);
        /* get rx_combined_gain */
      //XDSLRTFW-1727
#if 1//L2_13dB
       if (STATArray[STAT_PowerMode] == STAT_PM_L2)
       {
          //NOTE:@mahesh: note that the limits for combinedgains is now 6142 to 65536 and correspondingly
          // the inverse will have limits of 1024 to 10925, hence we need not maintain a separate buffer for
          // the resulting quotient, thus saving on additional buffer/separate vector multiplication routines

          // min constellation gain -> 8192 for 2 bit constellation
          // max constellation gain -> 14189 for 3 bit constellation
          // min finegain -> -13dB or 1775
          // max finegain -> +2.5dB or 10925
          // combinedgain = Constellation gain * (1/FineGain)
          // min combinedgain = 6142 for +2.5dB & 2bit constellation
          // max combinedgain = 65535 for -13dB & 3bit constellation
          // inverse of combinedgain will have limits of 1024 to 10925

          // @mahesh: however separate division routines are added & the test code is available
          us_RxCombinedGain = *pusa_RxCombinedGain++;
          /* if rx_combined_gain non-zero, compute 1/rx_combined_gain*/
          if (us_RxCombinedGain != 0)
          {
            s_lshift_CombGain = norm_l((int32)us_RxCombinedGain) - 15;
            Divide_32by16U((int32)(0x4000<<16),// Numerator mantissa (1.0 in Q2.30 format)
                           (int16) -(13+1+16),// Numerator exponent
                           (uint16)(us_RxCombinedGain << s_lshift_CombGain), // Denominator mantissa
                           (int16)-(13+s_lshift_CombGain),// Denominator exponent
                           &gpsa_DD_1byRxCombinedGains[i2], &s_exp); // Quotient mantissa,exponent


              // If necessary, adjust 1/RxCombinedGains value to have exponent of -13, i.e.
              // be in Q3.13 format.
              // It is an error here if s_num_exp+13 is > 0.

              s_rshift_1byCombGain = -(s_exp+13);
              if (s_rshift_1byCombGain > 0)
              {
                // Round off before rightshifting.
                 gpsa_DD_1byRxCombinedGains[i2] = (gpsa_DD_1byRxCombinedGains[i2] +
                                                  (1<<(s_rshift_1byCombGain-1)))>> s_rshift_1byCombGain;
              }

          }
          else
          {
              gpsa_DD_1byRxCombinedGains[i2] = us_RxCombinedGain;
          }
          /* Duplicate gain value so as to use assembly vector multiply routines */
          gpsa_DD_1byRxCombinedGains[i2+1] = gpsa_DD_1byRxCombinedGains[i2];
       }
       else
#endif
       {

        s_RxCombinedGain = *psa_RxCombinedGain++;

        /* if rx_combined_gain non-zero, compute 1/rx_combined_gain*/
        if (s_RxCombinedGain != 0)
        {
            // Divide_16bit routine requires a normalized
            // 16-bit mantissa format, so left shift numerator and denominator as needed.
            s_lshift_CombGain = norm_16bit(s_RxCombinedGain);

            Divide_16bit((int16) (0x2000 << 1),                   // Numerator mantissa (1.0 in Q3.13 format)
            (int16) -(13+1),                             // Numerator exponent
            (int16) (s_RxCombinedGain << s_lshift_CombGain),      // Denominator mantissa
            (int16) -(13+s_lshift_CombGain),                // Denominator exponent
            &gpsa_DD_1byRxCombinedGains[i2], &s_exp);          // Quotient mantissa,exponent

            // If necessary, adjust 1/RxCombinedGains value to have exponent of -13, i.e.
            // be in Q3.13 format.
            // It is an error here if s_num_exp+13 is > 0.

            s_rshift_1byCombGain = -(s_exp+13);
            if (s_rshift_1byCombGain > 0)
            // Round off before rightshifting.
            gpsa_DD_1byRxCombinedGains[i2] = (gpsa_DD_1byRxCombinedGains[i2] + (1<<(s_rshift_1byCombGain-1)) ) >> s_rshift_1byCombGain;
        }
        /* else set 1/rx_combined_gain to 0 */
        else
        {
            gpsa_DD_1byRxCombinedGains[i2] = s_RxCombinedGain;
        }
        /* Duplicate gain value so as to use assembly vector multiply routines */
        gpsa_DD_1byRxCombinedGains[i2+1] = gpsa_DD_1byRxCombinedGains[i2];
       }// PM L0
    }

    guc_SnrCalcState = TRAINING_DONE;
}

/*
*------------------------------------------------------------------------
*
*  Name:
*     BgDDSnrAdapt
*
*  Prototype:
*     void BgDDSnrAdapt(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Abstract:
*  SNR Computation
*     This routine computes the SNR for each channel in [s_first_chan, s_last_chan] in the
*     following equation:
*
*     SNR = 10*log10(referece_tone_power/average_noise_power)
*
*     reference_power = ((0x2000)^2 + (0x2000)^2))>>2 = 2^25,
*     where extra 2 bits right shifts are used to match the shift used
*     in average power computation.
*
*     average_noise_power = la_NoisePower[i]
*     where >>2 is applied to la_NoisePower[i]
*
*     SNR[i] = 10*log10(2^25) - 10*log10(la_NoisePower[i])
*
*     The implementation is done in the fixed-point algorithmetic and final SNR
*     is expressed in Q8.8 format
*
*  Returns:
*
*  Global Variables Used:
*      None
*------------------------------------------------------------------------
*/
void BgDDSnrAdapt(void)
{
    /* ======================================================================= */
    /* Calculate SNR                                           */
    /* ======================================================================= */
    if (guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_PERFORM_CALC)
    {
        //SnrCalc
        int32 *pla_NoisePower;
        int16 *psa_snr; /* 8.8 format */

        /* ======================================================================= */
        /* Average Noise Power                                          */
        /* ======================================================================= */

        /* convert 48 bits accumulated value to 32 bits; */
        pla_NoisePower = gla_RxShowtimeSnrAccumBuf; // Overwrite 64-bit input buffer with 32-bit output.
        RoundNoiseAccum(gla_RxShowtimeSnrAccumBuf, pla_NoisePower,
        0, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel), (int16) guc_Log2NumShowtimeSNRTrainingSymbols);

        /* ======================================================================= */
        /* Add Signal Power and compute snr in Q8.8 dB format                 */
        /* ======================================================================= */
        psa_snr = (gsa_RxShowtimeSnrBuf + gs_DD_RxFirstChannel);
        SnrCalc(pla_NoisePower, psa_snr, gs_DD_RxFirstChannel, gs_DD_RxLastChannel);

        guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_INITIALIZE;
    }
}

/*
*------------------------------------------------------------------------
*
*  Name:
*     BgDDFdqAdapt
*
*  Prototype:
*     void BgDDFdqAdapt(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Abstract:
*  FDQ Adaptation
*     Performs the sign-sign LMS (SSLMS) algorithm for updating
*      the FDQ in Showtime according to the following
*      formula:
*
*      C(i,k+1) = C(i,k) - slew * sign{(E(i,k) * conj(Equal_in(i,k)))}
*
*      with:   C(i,k) = complex-valued FDQ tap of tone i at time k
*           slew   = step size
*              E(i,k) = complex-valued decision error
*              Equal_in(i,k) = complex-valued FDQ input signal = FDQ_output*conj(C(i,k))
*
*  Returns:
*
*  Global Variables Used:
*      None
*------------------------------------------------------------------------
*/
void BgDDFdqAdapt(void)
{
    int32 i, i2;

    /* ======================================================================= */
    /* Adapt FDQ Coefs                                            */
    /* ======================================================================= */
    if (guc_FdqAdaptationState == FDQ_ADAPTATION_UPDATE_COEFFICIENTS)
    {
        //Fdq Adapt
        int16 *psa_ErrCorr, s_err_corr_real, s_err_corr_imag;
        int16  s_fdq_exp_real, s_fdq_exp_imag, s_fdq_exp, s_RightShift;
        int32 l_Acc_real, l_Acc_imag;

        /* ======================================================================= */
        /* Rotate error corelation by the Fdq Coef, compute sign and do adaptation */
        /* ======================================================================= */
        psa_ErrCorr = gpsa_DD_rxFDQErrCorrBuf;
        for(i = (int32)gs_DD_RxFirstChannel; i < (int32)(gs_DD_RxLastChannel+1); i++)
        {
            int32 l_temp;
            i2 = i<<1;

            s_err_corr_real = *psa_ErrCorr++;
            s_err_corr_imag = *psa_ErrCorr++;

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Comment out old code and skip FDQ adaptation of pilot tone
// for all symbols (data and sync)
            // PERF_DS_AB_ALL_ALL_PilotBugfixes (START)
            // Skip pilot FDQ magnitude adaptation during sync symbol
            // since CO Tx pilot with average finegain power.
            if (gs_RxPMDFrameCnt_FftFdqBufferSymbol == RX_SYMBOLS_PER_SFRAME)
            continue;
//            // PERF_DS_AB_ALL_ALL_PilotBugfixes (END)
//
//            /* Do not adapt fdq for the DD pilot tone */
//            if (i == gs_AuxPilotToneIdx || i == gs_CPilotTone)
//            continue;

            if (i == gs_PilotToneIdx)
            continue;
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)
            /* Do not adapt fdq for tones with g=0 */
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
            #ifndef ISDN
            if ( ((gs_CurrentCoChipset == GSI_CO_CHIPSET) && (guca_RxBat[i] == 0)) || (gsa_RxFineGains[i] == NEG_INFINITY_DB) )
            #else
            if (gsa_RxFineGains[i] == NEG_INFINITY_DB)
            #endif
               continue;
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)

            // Rotate error corelation by the Fdq Coef, compute e*C
            // cmplx_mult(s_err_corr_real, s_err_corr_imag, *psa_fdqCoef, *(psa_fdqCoef+1), &l_Acc_real, &l_Acc_imag);
            // compute real part [e_re*C_re - e_im*C_im]
            //       l_Acc_real = (int32)s_err_corr_real * (int32)gsa_pre_FDQ_coef[i2];
            //       l_Acc_real -= ((int32)s_err_corr_imag * (int32)gsa_pre_FDQ_coef[i2+1]);
            MULS16(l_Acc_real, s_err_corr_real, gsa_pre_FDQ_coef[i2]);
            MULS16(l_temp, s_err_corr_imag, gsa_pre_FDQ_coef[i2+1]);
            l_Acc_real -= l_temp;

            // compute imag part [e_im*C_re + e_re*C_im]
            //       l_Acc_imag = (int32)s_err_corr_imag * (int32)gsa_pre_FDQ_coef[i2];
            //       l_Acc_imag += ((int32)s_err_corr_real * (int32)gsa_pre_FDQ_coef[i2+1]);
            MULS16(l_Acc_imag, s_err_corr_imag, gsa_pre_FDQ_coef[i2]);
            MULS16(l_temp, s_err_corr_real, gsa_pre_FDQ_coef[i2+1]);
            l_Acc_imag += l_temp;

            //extract sign bit
            l_Acc_real = (l_Acc_real<0)? -gs_DD_FdqAdaptSlew: gs_DD_FdqAdaptSlew;
            l_Acc_imag = (l_Acc_imag<0)? -gs_DD_FdqAdaptSlew: gs_DD_FdqAdaptSlew;

            // add sign bit of gradient to LSB
            l_Acc_real += gsa_pre_FDQ_coef[i2];
            l_Acc_imag += gsa_pre_FDQ_coef[i2+1];

            // Find normalization shift for FDQ coeffs.
            s_fdq_exp_real = norm_l(l_Acc_real);
            s_fdq_exp_imag = norm_l(l_Acc_imag);

            // Re- and Im- part of FDQ share same exponent
            // So normalization-shift of bigger value is applied to both parts
            // If either mantissa is zero, don't do any renormalizing.
            if (l_Acc_real == 0)
            s_fdq_exp_real = s_fdq_exp_imag; // Do this to avoid normalizing either component.

            else if (l_Acc_imag == 0)
            s_fdq_exp_imag = s_fdq_exp_real; // Do this to avoid normalizing either component.

            s_fdq_exp = (s_fdq_exp_real < s_fdq_exp_imag? s_fdq_exp_real: s_fdq_exp_imag); // minimum of both

            /* Normalize coefficient mantissas. */
            l_Acc_real <<= s_fdq_exp;
            l_Acc_imag <<= s_fdq_exp;

            /* Calculate the mantisa shift and the exponent. */
            s_RightShift = 32 - FDQ_MANTISSA_WORDLENGTH;
            s_fdq_exp = (int16)guca_pre_FDQ_exp[i] + s_RightShift - s_fdq_exp;
            if (s_fdq_exp < 0)
            {
                /* If negative, force to zero and update mantissa shift accordingly. */
                s_RightShift -= s_fdq_exp;
                s_fdq_exp = 0;
            }
            else if (s_fdq_exp > FDQ_EXPONENT_MAX)
            {
                /* Saturate if necessary. */
                s_fdq_exp = FDQ_EXPONENT_MAX;
            }

            // update real part of FDQ coef
            gsa_pre_FDQ_coef[i2] = (int16)(l_Acc_real >> s_RightShift);
            // update imag part of FDQ coef
            gsa_pre_FDQ_coef[i2+1] = (int16)(l_Acc_imag >> s_RightShift);
            // update FDQ exp
            guca_pre_FDQ_exp[i] = (uint8)s_fdq_exp;
        }

        gs_DD_1SecFdqUpdateCount++;
        guc_FdqAdaptationState = FDQ_ADAPTATION_LOAD_COEFFICIENTS;
    }
}

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
void EnableFDQAdapt(void)
{
   int8 uc_signLms = 1;
   uint32 ul_data;

   ul_data = ( ( gs_DD_FdqAdaptSlew << 4) | (1<<3) | (uc_signLms<<1) | 1 );
   WriteCoreReg(IRI_QT_REG_RX_FDQADAPT_ADDR, ul_data);
}

void DisableFDQAdapt(void)
{
   ResetCoreReg(IRI_QT_REG_RX_FDQADAPT_ADDR, 1); //clear LSb to disable.
}

void EnableNPRWrite(void)
{
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(1<<22));
}

void DisableNPRWrite(void)
{
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(1<<22));
}

void SetUpRTVForSnrFdqHandler(void)
{
   uint32 ul_data;

   //First disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Enable IR_NPR_ACCUM
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(1<<22));

   //Shift before accumulation
   //SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(3<<24));

   ul_data = (0 << 31)
                  |  MASK_BIT28 // disable tone rotation using PRBS
                  | (ERROR_OUTPUT << 25) // write Error output to RTV buffer 0
                  | 0;

   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_data);


   ul_data = (gs_RxNumTones-1);
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_data);


   //Disable RTV1
   //ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));
}

C_SCOPE FlagT IsLowMetric(void)
{
      // XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2 (START)
      // Default use new algorithm to decide on discard frame.
      if ((gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_TOGGLE_NewAndOldDiscardFrameAlgo))
      {
         if (gft_frame_with_lowmetric)
            return(TRUE);
      }
      else
      {
         //Metric-based frame discarding, this is independent of whether erasure decoding is on/off
         if (gus_lowmetric_detect_cnt++ == gus_lowmetric_detect_period)
         {
            gus_lowmetric_detect_cnt = 0;
            gus_lowmetric_discard_cnt = 0;
         }

         if (gft_frame_with_lowmetric)
         {
                                // ft_DD_discardCurrDataFrame = gft_frame_with_lowmetric;
            gft_frame_with_lowmetric = 0;
            if (gus_lowmetric_discard_cnt < gus_lowmetric_discard_max)
            {
               gus_lowmetric_discard_cnt ++;
               gul_num_frame_lowmetric ++ ;
               return(TRUE);
            }
         }
      }
      // XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2 (END)

      return(FALSE);
}

void BgCalcSnr(void)
{
   int16 i;
   int16 sa_QamDecGainExponent[16] = {
      0,DECGAINEXP1, DECGAINEXP2, DECGAINEXP3,
      DECGAINEXP4, DECGAINEXP5, DECGAINEXP6, DECGAINEXP7,
      DECGAINEXP8, DECGAINEXP9, DECGAINEXP10, DECGAINEXP11,
      DECGAINEXP12, DECGAINEXP13, DECGAINEXP14, DECGAINEXP15
   };

   //int32 l_temp, l_temp1, l_temp2;
   int32 *pla_NoisePower;
   uint32 ul_LSW, ul_MSW;

   pla_NoisePower = gla_RxAccumBuf;

   ul_LSW  = IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR;
   ul_MSW  = IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR;

        //The for loop below takes time about 5 symbols.
   for (i=0 ; i < gs_RxNumTones ; i++ )
   {
      pla_NoisePower = gla_RxAccumBuf;
      ReadCoreReg(ul_LSW , pla_NoisePower);
      pla_NoisePower++;
      ul_LSW+=4;
      ReadCoreReg(ul_MSW , pla_NoisePower);
      //l_temp = *pla_NoisePower;
      pla_NoisePower++;
      ul_MSW+=4;

      //Check max number of right shifting
      //l_temp1 = 0;
      ////l_temp2 = 0;
      //while(l_temp != 0)
      //{
      //   l_temp >>= 1;
      //   l_temp1++;
      //}
      //if (l_temp1 > l_temp2)
      //   l_temp2 = l_temp1;
      //
      //TESTArray[6] = l_temp2 & 0x0000ffff;
      //TESTArray[7] = (l_temp2 & 0xffff0000) >> 16;


      RoundNoiseAccum(gla_RxAccumBuf, gla_RxAccumBuf, 0, (int16)(1), (int16) guc_Log2NumShowtimeSNRTrainingSymbols);

      gla_RxAccumBuf[0] = (int32)( ConvertToDB(gla_RxAccumBuf[0]) + gsa_RxFineGains[i] -
                  ConvertToDB(gsa_QAMDecGainTab[guca_RxBat[i]] << sa_QamDecGainExponent[guca_RxBat[i]]) * 2 +
                  20036 );

      if ((i <= gs_RxLastChannel) && (i >= gs_RxFirstChannel) && (gsa_RxFineGains[i] != NEG_INFINITY_DB))
      {
         gsa_RxShowtimeSnrBuf[i] = 20807 - gla_RxAccumBuf[0];

         if(gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN)
         {

            if(gft_AddNMS == TRUE)
            {

               #if 1
               int16 s_diff,s_NMS_delta;
               s_diff = MAX((gpsa_Medley_Vector[i]- gsa_RxShowtimeSnrBuf[i]),0);
               s_NMS_delta = MAX((gpsa_NMS_Vector[i] - s_diff),0);
               gsa_RxShowtimeSnrBuf[i] += MIN(s_NMS_delta,gt_HercADSL_OPTNMap_MarginControl.s_deltaMarginMax);
               #else
               gsa_RxShowtimeSnrBuf[i] += gpsa_NMS_Vector[i];
               #endif
            }
         }
         else
         {
            gsa_RxShowtimeSnrBuf[i] += gpsa_NoiseSeparationSnrAdj[i];
         }
         if(gft_Enable_DsVnInMedley == 1)
         {
            gsa_RxWithOutVnSnrBuf[i] = gsa_RxShowtimeSnrBuf[i];
         }
         if(gl_SelectedMode & (MODE_ADSL2))
            AddVirtualNoise(gsa_RxShowtimeSnrBuf, i, i);
      }
   }

  guc_SnrCalcState = TRAINING_DONE;
}

void DDSnrFdqHandler_HW(void)
{
   FlagT ft_LowMetric = FALSE;
   int16 s_rxPmdFrameCnt;

        if(( gl_SelectedMode & (MODE_ADSL2)  )) s_rxPmdFrameCnt = gs_RxPMDFrameCnt;
        else s_rxPmdFrameCnt = gs_MuxFrameCntRxFastPath;

#if defined  (DANUBE_WB) || defined (VR9_ERASURE)
   ft_LowMetric = IsLowMetric();
#endif

        //XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START)
        //FDQ adaptation handler
        //ChihWen: bug fix of no sync when shine noise is injected (START)
         //if (guc_FdqAdaptationState == FDQ_ADAPTATION_DISABLE)
         if ((guc_FdqAdaptationState == FDQ_ADAPTATION_DISABLE) || (ft_LowMetric == TRUE))
         //ChihWen: bug fix of no sync when shine noise is injected (END)
            //ChihWen: fix for sync loss issue in AVM PEIN&REIN test (START_END)
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableFDQAdapt);
         else
            //ChihWen: fix for sync loss issue in AVM PEIN&REIN test (START_END)
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableFDQAdapt);
        //XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (END)


   switch (guc_ddProcState)
   {
         case DD_PROC_DISABLE:
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableFDQAdapt);
              AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);
              //XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START_END)
              //ChihWen: bug fix of no sync when shine noise is injected (START_END)
              guc_ddProcState = DD_PROC_WAIT;
              break;

      case DD_PROC_INITIALIZE:

         if(guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_DISABLE)
         {
                 //Disable noise accumulation
                 AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);
            break;
         }

         gs_AlgHandlerCount = 0;
         guc_ddProcState = DD_PROC_PRE;
         break;

      case DD_PROC_PRE:
         if (s_rxPmdFrameCnt == (RX_SYMBOLS_PER_SFRAME-1))
         {
            //Disable noise accumulation
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);

         //Set up RTV for SNR and FDQ handler
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetUpRTVForSnrFdqHandler);

         //Reset the Noise Accumulator Buffer and trigger the SNR in hardware
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetNoisePowerBuffer);

      guc_ddProcState = DD_PROC_ACCUMULATE_FRAMES;
         }
         break;

      case DD_PROC_ACCUMULATE_FRAMES:
         //In the next symbol, this function will be run due to the RX synch symbol reception
         //we should disable the noise accumulation for one symbol
         if (s_rxPmdFrameCnt == (RX_SYMBOLS_PER_SFRAME-2))
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);
         }

         //Enable noise accumulation again
         if (s_rxPmdFrameCnt == (RX_SYMBOLS_PER_SFRAME-1))
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableNPRWrite);
         }

//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START)
         if (ft_LowMetric == TRUE)
         {
            //guc_ddProcState = DD_PROC_DISABLE_HW_SNR_FDQ;
            guc_ddProcState = DD_PROC_SETUP_RTV0_RCD_OUT;
            break;
         }
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (END)

              gs_AlgHandlerCount++;
            if ( gs_AlgHandlerCount == ((uint16) (1 << guc_Log2NumShowtimeSNRTrainingSymbols)-1) )
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);
         if (gs_AlgHandlerCount == (uint16) (1 << guc_Log2NumShowtimeSNRTrainingSymbols))
         {
            guc_ddProcState = DD_PROC_POST;

            // Queue background task to read out the accumulated noise and calculate SNR
            guc_SnrCalcState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCalcSnr);
         }
         break;

      case DD_PROC_POST:
         // wait for background SNR calculation is done
         if (guc_SnrCalcState == TRAINING_DONE)
         {
            guc_ddProcState = DD_PROC_WAIT;
            gus_ShowtimeSNRUpdateCount++;       // Increment count of SNR updates.

            //ChihWen: fix for sync loss issue in AVM PEIN&REIN test (START_END)
            //AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);

            // This is the last task we do; this Bkgrnd task may disable
            // DD state m/c or progress it to Initialize state
         AddFunctionToBkgdFifo((PtrToBkgdFunc)SnrUpdate_PostProcess);
         }
         break;

//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (START)
      case DD_PROC_DISABLE_HW_SNR_FDQ:
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableFDQAdapt);
              AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);
              guc_ddProcState = DD_PROC_READ_FDQ1;
              break;

           case DD_PROC_READ_FDQ1:
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReadFDQ1);
              guc_ddProcState = DD_PROC_READ_FDQ2;
              break;

           case DD_PROC_READ_FDQ2:
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReadFDQ2);
              guc_ddProcState = DD_PROC_SETUP_RTV0_RCD_OUT;
              break;

           case DD_PROC_SETUP_RTV0_RCD_OUT:
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_RCD_OUT);
              guc_ddProcState = DD_PROC_SETUP_RTV1_SFDQ_OUT;
              break;

           case DD_PROC_SETUP_RTV1_SFDQ_OUT:
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf1_SFDQ_OUT);
              guc_ddProcState = DD_PROC_WAIT_TO_FW_SNR_FDQ;
              break;

           case DD_PROC_WAIT_TO_FW_SNR_FDQ:
              break;
//XDSLRTFW-2258 Enhance_DS_ALL_ALL_FW_SNR_FDQ_REIN (END)


      case DD_PROC_WAIT:
         break;
   }//switch (guc_ddProcState)
}
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
