/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  fdq_adap.c
;
;  This file contains routine of FDQ adaptation.
;
;***************************************************************************/

#include "common.h"
#include "fdq_init.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "dsp_op2.h"
#include "fdq_adap.h"
#include "bitload_const.h"
#include "pll.h"

/* =============================================== */
/* constants used only by this file */
/* =============================================== */
/*  define constants for code clarity */
#define psa_rcvbuf         pt_FdqAdapt->psa_rcvbuf
#define  psa_refbuf        pt_FdqAdapt->psa_refbuf
#define psa_FDQ_coef    pt_FdqAdapt->psa_FDQ_coef
#define psa_FDQ_exp        pt_FdqAdapt->psa_FDQ_exp

/*****************************************************************************
;  Prototype:
;     void FdqAdapt(FdqAdaptStruc_t *pt_FdqAdapt);
;
;  Description:
;     This subroutine implements a FDQ adaptation using the following algorithm:
;
;     For each channel i, the following procedure is used:
;
;  1) Call FDQcoefPerTone() to compute the new FDQ coefficient using the
;     same method as that used in FDQ training
;     (i.e., the reference tone signal divided by the received tone signal
;     with the existing FDQ turned on)
;
;  2) Call FdqUpdate() to replace the current FDQ coefficient by the
;      updated FDQ coefficient (the details is given in FdqUpdate() header)
;
;  Input Arguments:
;     (defined in the structure pt_FdqAdapt)
;     psa_rcvbuf -- pointer to the received tone buffer
;     psa_refbuf -- pointer to the reference tone buffer
;     psa_FDQ_coef -- pointer to the current FDQ coefficient buffer
;     psa_FDQ_exp -- pointer to the current FDQ exponent buffer
;
;  Output Arguments:
;     psa_FDQ_coef -- pointer to the FDQ coefficient buffer after updated
;     psa_FDQ_exp -- pointer to the FDQ exponent buffer after updated
;
;  Return:
;     0
;
;  Global Variables:
;     none
;
;****************************************************************************/

int16 FdqAdapt(FdqAdaptStruc_t *pt_FdqAdapt)
{
   int16 i, i2;
   int16 sa_new_FDQ_coef[2];
   uint8 uc_new_FDQ_exp;

   i2 = 2*gs_RxFirstChannel;


   for(i=gs_RxFirstChannel; i<=gs_RxLastChannel; i++, i2+=2) {

      /* Do not adapt fdq for the DD pilot tone */
      if (i == gs_AuxPilotToneIdx || i == gs_CPilotTone)
         continue;
      /* Do not adapt fdq for tones with g=0 */
      if(gsa_RxFineGains[i] == NEG_INFINITY_DB)
         continue;

      /* Compute the second stage of FDQ coefficient of channel i */
      FDQcoefPerTone(&psa_rcvbuf[i2], &psa_refbuf[i2], sa_new_FDQ_coef, &uc_new_FDQ_exp);

      // If the existing coefficient is zero, just replace it with the new one.
      // Otherwise the FDQ coefficient will remain stuck at zero forever, correctly or not.

      if ((psa_rcvbuf[i2] == 0) && (psa_rcvbuf[i2+1] == 0)){
         psa_FDQ_coef[i2] = sa_new_FDQ_coef[0];
         psa_FDQ_coef[i2+1] = sa_new_FDQ_coef[1];
         psa_FDQ_exp[i] = uc_new_FDQ_exp;
      }

   /* Update the FDQ coefficient */
      FdqUpdate(&(psa_FDQ_coef[i2]), &(psa_FDQ_exp[i]), sa_new_FDQ_coef, (int16)uc_new_FDQ_exp);

   }

   return(0);
}

/*  undefine constants for code clarity */
#undef psa_rcvbuf
#undef psa_refbuf
#undef psa_FDQ_coef
#undef psa_FDQ_exp

