/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  pll.c
;
;  This file contains routines to implement the phase lock loop (PLL).
;
;***************************************************************************/
// *********************************************************************************************************
// pll.c
//
// History
//
// 04/01/2015 Anantha Ramu/TV Ram: Uncorrected DTUs observed in some test setups. Two types of fixes done
// 1. Fix for uncorrected DTUs due to Q full condition
// 2. Fix for uncorrected DTUs due PLL disturbance(Noise spread) by SHINE pulse.
// grep for XDSLRTFW-1223.
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
//
// 4/12/2015 Sriram Shastry :  Disabled XDSLRTFW-1223 changes via  compiler . New Pll adaptation is  implemented.
// grep for #ifdef PLL_ADAPTATION_SHOW.
//*********************************************************************************************************

#include <stdlib.h>
#include "common.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rt_state.h"
#include "arctan.h"
#include "dsp_op2.h"
#include "mul.h"
#include "cmv.h"  //XDSLRTFW-3717 (Start_End)

#define LOG_PLL_ERROR (0)
#if LOG_PLL_ERROR
    int16 gsa_pll_err_log[300];                 /* PLL error trace */
   int16 gs_pll_err_index = 0;
#endif

extern int16 TESTArray[];  //XDSLRTFW-3717 (Start_End)


/*****************************************************************************
;  Prototype:
;     void ConvertDataToPllRef(int16 *gsa_DataTone)
;
;  Description:
;     This function decodes the input 4-QAM encoded tone, and
;     replaces the PLL reference tone with the decoded
;     constellation point.
;
;  Input Arguments:
;     gsa_DataTone - array containing the real and imaginary parts
;                 of a 4-QAM encoded tone.
;
;  Output Arguments: none
;
;  Global Variables: none
;
;*************************************************************************************/
void ConvertDataToPllRef(int16 *sa_DataTone)
{
#ifndef ISDN
   int16 s_tmpR, s_tmpI;

   if(TESTArray[Test_DisableShowClkAveraging]) {
      if(sa_DataTone[0] > 0)
         gsa_PllRefTone[0] = (int16)0x7fff;
      else
         gsa_PllRefTone[0] = (int16)0x8001;

      if(sa_DataTone[1] > 0)
         gsa_PllRefTone[1] = (int16)0x7fff;
      else
         gsa_PllRefTone[1] = (int16)0x8001;
   } else {
      s_tmpR = sa_DataTone[0];
      s_tmpI = sa_DataTone[1];
      if((s_tmpR < 0) &&(s_tmpI > 0)) {
         //2nd Quadrant: to rotate it in clockwise direction to 1st quadrant
         //multiply pilot with cos(-pi/2)+i*sin(-pi/2) i.e, -i
         sa_DataTone[0] = s_tmpI;
         sa_DataTone[1] = -s_tmpR;
      } else if((s_tmpR < 0) &&(s_tmpI < 0)){
         //3rd Quadrant: to rotate it in clockwise direction to 1st quadrant
         //multiply pilot with cos(-pi)+i*sin(-pi) i.e, -1
         sa_DataTone[0] = -s_tmpR;
         sa_DataTone[1] = -s_tmpI;
      }else if((s_tmpR > 0) &&(s_tmpI < 0)){
         //4th Quadrant: to rotate it in clockwise direction to 1st quadrant
         //multiply pilot with cos(-3pi/2)+i*sin(-3pi/2) i.e, i
         sa_DataTone[0] = -s_tmpI;
         sa_DataTone[1] = s_tmpR;
      }
      gsa_PllRefTone[0] = (int16)0x7fff;
      gsa_PllRefTone[1] = (int16)0x7fff;
   }

#else

   if(sa_DataTone[0] > 0)
      gsa_PllRefTone[0] = (int16)0x7fff;
   else
      gsa_PllRefTone[0] = (int16)0x8001;

   if(sa_DataTone[1] > 0)
      gsa_PllRefTone[1] = (int16)0x7fff;
   else
      gsa_PllRefTone[1] = (int16)0x8001;

#endif

}

/*****************************************************************************
;  Prototype:
;     void PLL(int16 *psa_InPilotTone)
;
;  Description:
;     This subroutine implements the Phase Lock Loop Operation using three steps:
;
;     1) Computes the phase error between the input pilot tone and reference tone.
;     2) Filter the phase error by the loop filter (having the transfer function of
;     (Kp + Ki/(1-1/z))
;     3) Apply the noise shaping filter to the output of the loop filter to reduce
;     the quantization noise (due to the ADC of the VCXO) in low frequency
;
;  Arguments:
;     psa_InPilotTone -- pointer to the buffer storing the input pilot tone
;
;  Global Variables: none
;
;*************************************************************************************/
void PLL(int16 *psa_InPilotTone)
{
   int32 l_Acc0, l_Acc1, l_temp;
   int16 s_PhaseErrorSaturated ;
   /* ========================================================================== */
   /* Multiply the input tone with the complex conjugate of the reference tone */
   /* and compute the phase error (which is the angle of the multiplied vector) */
   /* ========================================================================== */

   /* Real part of (InPilotTone * complex conjugate of PllRefTone) */
   //l_Acc0  = (int32)gsa_PllRefTone[0]*psa_InPilotTone[0];
   MULS16(l_Acc0, gsa_PllRefTone[0], psa_InPilotTone[0]);

   //l_Acc0 += (int32)gsa_PllRefTone[1]*psa_InPilotTone[1];
   MULS16(l_temp, gsa_PllRefTone[1], psa_InPilotTone[1]);
   l_Acc0 += l_temp;

   /* Imag part of (InPilotTone * complex conjugate of PllRefTone) */
   //l_Acc1  = (int32)psa_InPilotTone[1]*gsa_PllRefTone[0];
   MULS16(l_Acc1, gsa_PllRefTone[0], psa_InPilotTone[1]);

   //l_Acc1 -= (int32)psa_InPilotTone[0]*gsa_PllRefTone[1];
   MULS16(l_temp, gsa_PllRefTone[1], psa_InPilotTone[0]);
   l_Acc1 -= l_temp;

   gs_PhaseError = FastAtan((int16)(l_Acc1 >> 16), (int16)(l_Acc0 >> 16));

   if((gs_RxState ==R_C_MSG_FMT_RX_BIS) || (gs_RxState == R_C_MSG_PCB_RX_BIS))
   {
       if (gs_PhaseError > PLL_HALF_PI_RADIANS) {
         gs_PhaseError -= PLL_PI_RADIANS;
      }
      else if (gs_PhaseError < -PLL_HALF_PI_RADIANS) {
         gs_PhaseError += PLL_PI_RADIANS;
      }

   }

   s_PhaseErrorSaturated = gs_PhaseError;

    // XDSLRTFW-2579 (Start)
   //Phase Criterion to discard bad frame for FDQ update
   if (gs_RxState == R_C_SHOWTIME_RX)
   {
      if ((s_PhaseErrorSaturated >= gs_MaxPhaseErrorThreshold_default) || (s_PhaseErrorSaturated <= -gs_MaxPhaseErrorThreshold_default))
         gft_frame_with_noisypilot = 1;
   }
   //XDSLRTFW-2579 (End)

   if (s_PhaseErrorSaturated >= gs_MaxPhaseErrorThreshold) {
      s_PhaseErrorSaturated = gs_MaxPhaseErrorThreshold;
       //Phase Criterion to discard bad frame for FDQ update
       if (gs_RxState == R_C_SHOWTIME_RX)
            gft_frame_with_noisypilot = 1;
   }
   else if (s_PhaseErrorSaturated <= -gs_MaxPhaseErrorThreshold) {
      s_PhaseErrorSaturated = -gs_MaxPhaseErrorThreshold;

       //Phase Criterion to discard bad frame for FDQ update
       if (gs_RxState == R_C_SHOWTIME_RX)
           gft_frame_with_noisypilot =1;
   }


   //TODO: From Danube declare gft_frame_with_noisypilot atleast 4000 frames after showtime.

   /* ============================================================================= */
   /* Filter the phase error by the loop filter (Kp + Ki/(1-z^(-1))) */
   /* x(n) = x(n-1) + (Kp + Ki)* PhaseError(n) - Kp*PhaseError(n-1) */
   /* ============================================================================= */

#if LOG_PLL_ERROR
   if (gs_pll_err_index < 300)
      gsa_pll_err_log[gs_pll_err_index++] = gs_PhaseError;
#endif

   /* Compute integral portion: */
      MULS16(l_temp, gs_Ki, s_PhaseErrorSaturated);
      l_Acc0 = l_add(gl_pll_freq_offset, l_temp);
      gl_pll_freq_offset = l_Acc0;

   /* Add proportional part: */
   MULS16(l_temp, gs_Kp, s_PhaseErrorSaturated);
   l_Acc0 = l_add(l_Acc0, l_temp);
   gl_pll_loopfilter_out = l_Acc0;
}
// XDSLRTFW-2579 (Start)
/* XDSLRTFW-2464 */
//#ifdef ISDN
/*****************************************************************************
;  Prototype:
;     void UpdatePLLAdaption()
;
;  Description:
;     In Temperature test with FritzBox-7490, showtime PLL setting are modified to  fast settings, In case of gl_pll_freq_offset drift is
;     obsrvd more than +-0.4[fast] or 0.030[slow] ppm/sec
;
;
;  Input Arguments:
;     None
;
;
;  Output Arguments: None
;
;  Global Variables: gs_Kp,gs_Ki,gl_pll_freq_offset and gs_MaxPhaseErrorThreshold
;
;*************************************************************************************/

// Initialization
#define   PHASE_ERROR_SMALLER_THAN_08_deg           (0)
#define   PHASE_ERROR_BETWEEN_08_and_16_deg         (1)
#define   PHASE_ERROR_BETWEEN_16_and_24_deg         (2)
#define   PHASE_ERROR_BETWEEN_24_and_45_deg         (3)
#define   PHASE_ERROR_BETWEEN_m08_and_m16_deg      (-1)
#define   PHASE_ERROR_BETWEEN_m16_and_m24_deg      (-2)
#define   PHASE_ERROR_BETWEEN_m24_and_m45_deg      (-3)

#define   PLL_PI_RADIANS_BY_8_22deg   (3217) // 3217 = pi/8 radians


static FlagT ft_PLL_FirstShowtime = 1;
void  UpdatePLLAdaption(int16 *psa_InputPilotTone)
{
   int16 i= 0;
   uint16 us_idx_curr, us_idx_prev;
   /* int16 s_temp; */
   int32 l_temp, l_temp1;
   int16 us_PhaseErrorReporting_PreviousIdx;

   FlagT ft_ValidPilotTone = 1;


   //-------------------------------------------------------------------------------
   //       Detection algorithm for frequency drift
   //-------------------------------------------------------------------------------
   //
   //
   //-------------------------------------------------------------------------------

   // XDSLRTFW-2492 PLL optimization for crystal frequency drifts (Start)

    if (gus_4096SymbolCnt == 0xFFF)     // check ones in sec at 4095th symbol
    {
      // gs_PLL_Mode:
      // -1: FREQ_DRIFT_TRACKING_OFF
      //  0: FREQ_DRIFT_TRACKING_ON____STABLE_FREQUENCY
      //  1: FREQ_DRIFT_TRACKING_ON____FREQUENCY_DRIFTS

      gs_ExtraDelayBeforeChangingPllLF--;
      if (gs_ExtraDelayBeforeChangingPllLF < 0)
      {
          gs_ExtraDelayBeforeChangingPllLF = 0;
      }

      if (gs_PLL_Mode >=0)
      {
         guc_Pll_idx++;
         us_idx_curr = (guc_Pll_idx   & 0x1F);   // current index
         us_idx_prev = (guc_Pll_idx-1 & 0x1F);   // previous index

         gla_pll_freq_offset[us_idx_curr] = gl_pll_freq_offset_avg;  /*[ppm:2^18] format*/
         gl_Pll_Freq_delta = (gla_pll_freq_offset[us_idx_curr] - gla_pll_freq_offset[us_idx_prev]);

         if (gl_Pll_Freq_delta> SHOWTIME_FAST_PLL)            //  0.4 ppm/sec, switch to fast PLL tracking
         {
            gs_Kp = gs_Kp_Showtime_FallBack;
            gs_Ki = gs_Ki_Showtime_FallBack;
            gs_MaxPhaseErrorThreshold = gs_MaxPhaseErrorThreshold_Fallback;

            gul_PpmDriftCnt++;  // counter only

            gs_PLL_Mode = 1;
            gs_ExtraDelayBeforeChangingPllLF = 1;
         }
         else if (gl_Pll_Freq_delta < (-SHOWTIME_FAST_PLL))    // -0.4 ppm/sec, switch to fast PLL tracking
         {
            gs_Kp = gs_Kp_Showtime_FallBack;
            gs_Ki = gs_Ki_Showtime_FallBack;
            gs_MaxPhaseErrorThreshold = gs_MaxPhaseErrorThreshold_Fallback;

            gul_PpmDriftCnt++; // counter only

            gs_PLL_Mode = 1;
            gs_ExtraDelayBeforeChangingPllLF = 1;

         }
         else if ((gs_PLL_Mode == 1 )&&( gl_Pll_Freq_delta < (SHOWTIME_DEFAULT_PLL)) &&     // +/-0.03125 ppm / sec, prepare to switch for slow PLL tracking
                  (gl_Pll_Freq_delta > (-SHOWTIME_DEFAULT_PLL)))
         {
            gs_PLL_Mode = 0;
            gs_ExtraDelayBeforeChangingPllLF = 15;          // wait 15 more sec before changing slow kp,ki in stable mode
         }

         // Switch back to default kp ki and max phase error threshold
         if((gs_PLL_Mode == 0) && (gs_ExtraDelayBeforeChangingPllLF == 0))
         {
            gs_Kp = gs_Kp_Showtime_default;
            gs_Ki = gs_Ki_Showtime_default;
            gs_MaxPhaseErrorThreshold = gs_MaxPhaseErrorThreshold_default;
         }

      }  // end if (gs_PLL_Mode >=0)
      gl_pll_freq_offset_avg = 0;
    }   // end if (gus_1Sec_RxShowtimeFrameCnt == 3000)
    else
    {
      gl_pll_freq_offset_avg += (gl_pll_freq_offset>>12);
    }   // end if (gus_1Sec_RxShowtimeFrameCnt == 3000)

    /*****************************************************************************/
    /*below section is only for monitoring purpose. Not needed for PLL adapation */
    /*****************************************************************************/

    ft_ValidPilotTone = FALSE;
   MULS16(l_temp,  gsa_RxPilotTone[0], gsa_RxPilotTone[0]);
   MULS16(l_temp1, gsa_RxPilotTone[1], gsa_RxPilotTone[1]);
    gl_PilotTonePower = l_temp + l_temp1;
   if (gl_PilotTonePower >= gl_RxPilotTone_SqErr_Threshold_temp)
      ft_ValidPilotTone = TRUE;

    if (ft_ValidPilotTone)
    {
      gs_Prev_Phase_Error = gs_New_Phase_Error;

      /*    [PhaseError :+-range [8:16:24:45]]
         25736/22.5   = 8degree  = 1169 Radians
         25736/11   = 16degree = 2339 Radians
         25736/5.5  = 32degree = 4679 Radians
         25736/4    = 45degree = 6434 Radians
         25736/ 180)*8 = 8 degree
         Radians = round(25736 / 180 * [8 16 24 32 45])
      */

      if (gs_PhaseError > 3431)              // between    24  and   45 deg
         gs_New_Phase_Error = PHASE_ERROR_BETWEEN_24_and_45_deg;
      else if (gs_PhaseError > 2288)         // between    16  and   24 deg
         gs_New_Phase_Error = PHASE_ERROR_BETWEEN_16_and_24_deg;
      else if (gs_PhaseError > 1144)         // between     8  and   16 deg
         gs_New_Phase_Error = PHASE_ERROR_BETWEEN_08_and_16_deg;
      else if (gs_PhaseError > -1144)        // between    -8  and    8 deg
         gs_New_Phase_Error = PHASE_ERROR_SMALLER_THAN_08_deg;
      else if (gs_PhaseError > -2288)        // between   -16  and   -8 deg
         gs_New_Phase_Error = PHASE_ERROR_BETWEEN_m08_and_m16_deg;
      else if (gs_PhaseError > -3431)        // between   -24  and  -16 deg
         gs_New_Phase_Error = PHASE_ERROR_BETWEEN_m16_and_m24_deg;
      else                                   // between   -45  and  -24 deg
         gs_New_Phase_Error = PHASE_ERROR_BETWEEN_m24_and_m45_deg;

        if (gs_New_Phase_Error == gs_Prev_Phase_Error)
      {
         if (gs_NumOfIdenticalAdjacentPTPhases < gs_MinNumberOfAdjPhaseErrorsToDeclareNewPhase)
                gs_NumOfIdenticalAdjacentPTPhases++;
         else
         {
            if (gs_New_Phase_Error != gs_Last_Reported_Phase_Error)
            {
                    if (gus_PhaseErrorReporting_Idx < 20)
                    {
                        ga_PllRotInfo[gus_PhaseErrorReporting_Idx].ul_SymbolCount = gl_RxSymbolCount;
                        ga_PllRotInfo[gus_PhaseErrorReporting_Idx].s_SectorIdx    = gs_New_Phase_Error;
                        ga_PllRotInfo[gus_PhaseErrorReporting_Idx].s_PhaseError   = gs_Prev_Phase_Error;
                        gs_Last_Reported_Phase_Error = gs_New_Phase_Error;
                        if (gus_PhaseErrorReporting_Idx == 0)
                            us_PhaseErrorReporting_PreviousIdx = 20;
                        else
                            us_PhaseErrorReporting_PreviousIdx = gus_PhaseErrorReporting_Idx-1;

                        // Stop logging if Phase error is not correctable anymore (phase error >45 degree)
                        if ((ga_PllRotInfo[us_PhaseErrorReporting_PreviousIdx].s_SectorIdx == -3)
                                && (ga_PllRotInfo[gus_PhaseErrorReporting_Idx].s_SectorIdx ==  3))
                            gus_PhaseErrorReporting_Idx = 40;
                        else if ( (ga_PllRotInfo[us_PhaseErrorReporting_PreviousIdx].s_SectorIdx ==  3)
                                && (ga_PllRotInfo[gus_PhaseErrorReporting_Idx].s_SectorIdx == -3))
                            gus_PhaseErrorReporting_Idx = 50;
                        else
                        {
                            gus_PhaseErrorReporting_Idx++;
                            if (gus_PhaseErrorReporting_Idx >= 20)
                            {
                                gus_PhaseErrorReporting_Idx = 0;
                            }
                        }

                    }
            }
         }
      }
      else
      gs_NumOfIdenticalAdjacentPTPhases = 0;
   }
   else
   {
   gs_New_Phase_Error = 99;          // Noisy or invalid pilot tone detected (e.g. if CO has dropped the link)
   gs_NumOfIdenticalAdjacentPTPhases = 0;
   }
}
//#endif
/* XDSLRTFW-2464 */
// XDSLRTFW-2492 PLL optimization for crystal frequency drifts (End)
// XDSLRTFW-2579 (End)


