/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             pll_show.c
 * DESCRIPTION:      Functions that implements showtime pilot tone processing
 *
 **********************************************************************/
 // ******************************************************************
// pll_show..c
//
// History
//
// 21/02/2012 Shakil: In ARx platform for ASE we used #ifndef DANUBE_WB to use pilot tone
//                        based metric to freeze SNR and FDQ update on noisy lines. But due to a merging
//                        bug we still use the same compiler switch which was trigerring the pilot tone based
//                        metric for VR9 too in addition to the erasure metric. As a result we may end up
//                        freezing the showtime adaptation even more since the pilot tone based metric is not
//                        always relaible.
//                        Solution: instead of ifndef, ifdef AMAZON_SE was used
//            Grep for XDSLRTFW-418 Bug_VR9_ALL_ALL_SNR_FDQ_Freeze_DUE_TO_PILOT_TONE_METRIC
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//                                        --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                                                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//                                        --> Remove all Rx bypass filters with unity pass
//                                        --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                                                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//                                        --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                                                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//                                        --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                                                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//                                        --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//                                        --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//              Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
//
// 09/05/2013 Palaksha: Fix for the issue "XDSLRTFW-603 TR067B Stresstest fails due too high BER"
//              The flag gft_frame_with_noisypilot is getting set to 1 too often. This was resulting in DEC adaptation getting disabled.
//              So the thresshold for declaring frame as Noise frame now changed to "if instant SNR of pilot is below 12 dB" as in ARx platform
//         Scale the DEC error "gl_energy_error" by 2 for DEC capture length is 128 and no need of scaling required if DEC capture length is 64
//      Grep for XDSLRTFW-603 IOP_DS_Perf_ALL_PllSnrThresholdNoisyFrame
//
// 22-04-2012 Anantha:Added code for show time pilot tone averaging
//                                      grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg
//
// 25/06/2013 Kannan: Added code to debug the DEC adaptation, "gft_frame_with_noisypilot"
//            flag is being set for every sync symbol in DMT mode, since
//            sync symbol pilot tone Freq domain Data available
//            at the gsa_RxPilotTone scaled down(Re: 6152 & Im: 6152)
//            as compared to data symbol pilot tone freq domain data(Re: 8184 & Im: 8184).
//            Need to debug further.
//            Grep for "XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
// ******************************************************************


#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "pll.h"
#include "timercov.h"
#include "mul.h"
#include "trail.h"
#include "dec_adap_Data.h"
#include "gdata_bis.h"

#ifdef DEBUG_DEC_ADAPT
extern uint32 gula_dbg_DecSetting[20];
#endif //#ifdef DEBUG_DEC_ADAPT

extern int16 ConvertToDB(int32 l_xin);
// Cannot use this utility function currently for codeswap reasons
//C_SCOPE int32 sumsq(int16 s_x, int16 s_y)
//{
//      return ((int32)s_x*s_x + (int32)s_y*s_y);
//}

#define NUM_SYMB_CLKRECVRY_WITHOUT_PILOT_AVERAGE (4000)//(480000)

C_SCOPE void do_showtime_pilot_processing(FlagT ft_isSyncFrame)
{
    int32 l_temp, l_temp1;
    FlagT ft_sef_los_pilot=TRUE;
    int16 s_pilot_snir_threshold = 0;
    int32 l_noise_temp, l_noise_temp1;
    uint32 ul_PilotTonePwr;

   /* PLL Related Processing */
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
   CopyPilotTone(gsa_RxPilotTone, gs_PilotToneIdx);
#else
   GetRxData(gsa_RxPilotTone, DD_FFTFDQ_LOGICAL_BUFFER, gs_PilotToneIdx, 1);
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

    if(gft_DDPilot == DD_PILOT_ON)
    {
            ConvertDataToPllRef(gsa_RxPilotTone);


// #ifdef AMAZON_SE
       //This is part of the algorithm of discarding bad frames based on instant snir of pilot tone
       //Currently, the calculation of snir is performed on both erasure and non-erasure based platform
       //to the debugging and evaluation purpose
       //However, the decision is only used on non-erasure based platform

     s_pilot_snir_threshold = gs_pilot_snir_threshold;
    //Taken power management into consideration for snir calculation
    if (gft_ModemType == G_DMT_BIS && gt_RxOLRPMVars.uc_rxOLRPMState == L2_STEADY_STATE)
    {
        s_pilot_snir_threshold -= (gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols-gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols) << 8;
    }
#ifdef ISDN
    else
    {
             s_pilot_snir_threshold = 0x0C00; //XDSLRTFW-603 IOP_DS_Perf_ALL_PllSnrThresholdNoisyFrame (Start_End)
    }
#endif
    //discard frame for data directed snr/fdq update if instant snir is below the threshold
    //10*log( abs(gsa_PllRefTone[0]^2)+gsa_PllRefTone[1]^2)/abs(Noise[0]^2+Noise[1]^2)) < s_pilot_snir_threshold
    MULS16(l_noise_temp, gsa_RxPilotTone[0]-gsa_PllRefTone[0]/4, gsa_RxPilotTone[0]-gsa_PllRefTone[0]/4);
    MULS16(l_noise_temp1, gsa_RxPilotTone[1]-gsa_PllRefTone[1]/4, gsa_RxPilotTone[1]-gsa_PllRefTone[1]/4);
    l_noise_temp += l_noise_temp1;
    // added 1 to l_noise_temp to avoid overflow
    // gs_instant_snir = ConvertToDB(0x8000000)-ConvertToDB(l_noise_temp +1);
    // 0x5147= ConvertToDB(0x8000000)
    gs_instant_snir = 0x5147- ConvertToDB(l_noise_temp +1);
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
    gft_frame_with_noisypilot = 0;
    if (( gs_instant_snir < s_pilot_snir_threshold) && (gul_TotalRxDataFrameCnt > 4000))
        gft_frame_with_noisypilot = 1;
    //TODO: Danube declare gft_frame_with_noisypilot atleast 4000 frames after showtime.
//#endif
    }

    /* The following logic is used to skip bad frames during PLL update when micro interrupt detected */
    MULS16(l_temp, gsa_RxPilotTone[0], gsa_RxPilotTone[0]);
    MULS16(l_temp1, gsa_RxPilotTone[1], gsa_RxPilotTone[1]);

   l_temp += l_temp1;

    // XDSLRTFW-2579 (Start)
    /* Important note : Above code (except gsa_RxPilotTone population) is not needed for PLL adaptation logic. This code mainly populates gft_frame_with_noisypilot
       variable which is used later on some other part of the code. Before removing above code more examination is needed. */

    // calculate pilot tone power ( Ampliture square)
    ul_PilotTonePwr =  (uint32)( ((int32)gsa_RxPilotTone[0]*(int32)gsa_RxPilotTone[0]) + ((int32)gsa_RxPilotTone[1]*(int32)gsa_RxPilotTone[1]) );

    // Statistics of ED metric value (for debugging only)
    // gusa_EDMetricLog[guc_metric_value>>4]++;

    //Simplified algorithm to calculate ED metric threshold.
    //Experiment across different loop and noise showed sufficient reliability of this approach.
    if (guc_metric_value > guc_MaxEDMetric )
    {
        guc_MaxEDMetric =  guc_metric_value;
    }
    guc_EDMetricThreshold = guc_MaxEDMetric>>1;

    // Reference Pilot tone constellation is (+/-)8192 +j(+/-)8192.  Amplitude square = 134217728
    // 33554432 = 0.25*Amplitude square of Ref pilot tone constellation
    // 100663296 = 0.75*Amplitude square of Ref pilot tone constellation

    if(gs_Kp == gs_Kp_Showtime_default) // this logic is disabled when abrupt crystal frequency drift (+/- 0.4 ppm/sec) is observed. Check UpdatePLLAdaption()function
    {
        if ((ul_PilotTonePwr < 33554432) || ((ul_PilotTonePwr < 100663296) && (guc_metric_value < 10)))   // Micro interruption detection logic
        {
            gs_MaxPhaseErrorThreshold = gs_PhaseErrorThresholdDuringMI; // 0.2 degree
            gus_MicroInterruptionDetectionCnt++;
        }
        else if (guc_metric_value < guc_EDMetricThreshold)   // External noise (eg. REIN, PEIN, SHINE etc.) detection logic
        {
            gs_MaxPhaseErrorThreshold = gs_PhaseErrorThresholdDuringExtNoise; // 0.7 degree
            gus_SymbolWithLowEdMetricCnt++;
        }
        else // Normal operating condition
        {
            gs_MaxPhaseErrorThreshold = gs_PhaseErrorThreshold; // 2 degree
        }
    }

   PLL(gsa_RxPilotTone);
   UpdateTimingRecoveryHW(gl_pll_loopfilter_out);

   if (gs_PhaseError < gs_DetectMicroInterrupt_PhaseErrThresh &&
        gs_PhaseError > -gs_DetectMicroInterrupt_PhaseErrThresh)
   {
              ft_sef_los_pilot = FALSE;
   }

 // XDSLRTFW-2579 (End)
   /* No DD processing for sync frames, return */
   if (ft_isSyncFrame)
   {
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
      if(ft_sef_los_pilot)
      {
         gula_dbg_DecSetting[9] = l_temp;
         gula_dbg_DecSetting[10] = gl_PilotTone_PwrThresh;
      }
      if(gft_frame_with_noisypilot)
      {
         gula_dbg_DecSetting[11] += 1;
         gula_dbg_DecSetting[12] = gs_instant_snir;
         gula_dbg_DecSetting[13] = s_pilot_snir_threshold;
         gula_dbg_DecSetting[14] = gsa_RxPilotTone[0];
         gula_dbg_DecSetting[15] = gsa_RxPilotTone[1];
         gula_dbg_DecSetting[16] = gsa_PllRefTone[0];
         gula_dbg_DecSetting[17] = gsa_PllRefTone[1];
         gula_dbg_DecSetting[18] = l_noise_temp;
      }
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
                if (ft_sef_los_pilot || gft_frame_with_noisypilot)
                {
                        gft_CorruptedSynchFrame = TRUE;
                        gl_numCorruptedSynchFrames++;
                }
                return;
        }

        /* The following logic is used to skip bad frames for DD processing when micro interrupt detected */
        if (ft_sef_los_pilot || gft_frame_with_noisypilot)
        {
                gl_DD_numDiscardedDataFrames++;
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
//        if(gft_frame_with_noisypilot == 1) gft_frame_with_noisypilot = 0;

//XDSLRTFW-418 Bug_VR9_ALL_ALL_SNR_FDQ_Freeze_DUE_TO_PILOT_TONE_METRIC (Start)
//#ifndef DANUBE_WB
#ifdef AMAZON_SE
                gfta_DD_discardCurrDataFrame[gs_DD_rxFDQOutput_Buffer_Select] = TRUE;
#endif
//XDSLRTFW-418 Bug_VR9_ALL_ALL_SNR_FDQ_Freeze_DUE_TO_PILOT_TONE_METRIC (End)
                DebugTrail(6, DEBUG_LOG_STSIGNALS, 0xFFFF, (int16)(gl_RxSymbolCount&0xFFFF), (int16)((gl_RxSymbolCount>>16)&0xFFFF), (l_temp&0xFFFF), ((l_temp>>16)&0xFFFF), gs_PhaseError);
        }
        else
        {
                gfta_DD_discardCurrDataFrame[gs_DD_rxFDQOutput_Buffer_Select] = FALSE;
        }

}
