/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;       Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;       Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;       showtime_rx_b.c
;
;       Functions for BG Tasks from synsymbl.c
;
;***************************************************************************/

//***************************************************************************
// showtime_rx_b.c
//
// History
//
// 22/08/2011 Vinjam: Report DS margin as 6 when it is 5.8 or 5.9
//              Grep for XDSLRTFW-275: SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB
//
// 23/8/2011 Vinjam: Renamed "gl_LOS_detect_power" to "gl_AvgPilotPow".
//           renamed "gs_LOS_sframe_cnt" to "gs_LosDefect_state_cnt".
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 23/8/2011 Vinjam: Integrated New LOS detection code which computes "Pilot reference power" threshold
//           on the fly(Dynamic) over 0.1 seconds time interval. Code picked up from VR9 VDSL2 code.
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 09/11/2011 ChihWen/Bhadra: The fix for "ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved":
//                      1. The orginal code will start the searching (for max delta_Lp) from 2880, which will take very long time
//                         to find the max delta_Lp and fail the training. The maximum allowed starting point (for max delta_Lp)
//                         is set to 2000, which will take about 15384 symbols (from 12642 to 28026).
//                      2. Considering the max_Lp (Lp + max_delta_Lp) and min_Lp (Lp - min_delta_Lp) before requesting SRA.
//                      3. The searching for SRA will be enabled when it is BDCM CO or INFO 103 26 bitmask(0x0400) being one (it is zero by default).
//                      Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 15/11/2011 ChihWen/Bhadra: There is a special requirement that CPE should sync up in 2km loop with -90 dBm/Hz AWGN (normally DS rate is 600 Kbps),
//                                              and should be able to reach max capped rate of 6 Mbps by upshift SRA when noise power is decreased to -140 dBm/Hz AWGN.
//                With this special requirement, we need to load more bits not only on already loaded tones, but also on monitored tones,
//                                              in order to reach the max capped rate. A problem behind this requirement is that CNXT CO does not send signal on unloaded tones.
//                                              So the workaround to fulfill the requirement for all CO are as below.
//                                              1. For all CO, changing the threshold for setting monitored tones from 4 dB to 6 dB (SNR_THRESH_LOAD_MIN_BITS).
//                                              2. For all CO, not limiting number of monitored tones to 20 if SRA is enabled on CO site.
//                                              3. For all CO, making OLR (SRA and bitswap) only occurring on loaded/monitored tones.
//                                              4. For CNXT CO, no updating FDQ cofficients on unloaded tones.
//                                              5. For CNXT CO, measuring noise on monitored tones to get an estimation of SNR.
//                                              6. For CNXT CO, SNR on monitored tones are capped to 2-bits required SNR, in order to load two bits and get better SNR measurement.
//
//                                              7. When DS rate capped low, it took bitloading too long time to
//               find gs_deltaLp_max and failed the training. This is the root cause
//               of no-link with 3.5M capped profiles.
//               The solution is to use a larger searching step to find a valid
//               gs_deltaLp_max faster.
//
//                                              8. For CNXT CO, decreasing the Tx buffer size for overhead message by 2 if the tone number in the last segment of SRA message was 14.
//                                                       This was because CRC/link drop was always seen when there was 14 tones in the last segment of SRA message.
//
//            Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones
//
// 21/11/2012 Kannan: Added a function to nofity both Tx & Rx are in showtime state to PPE
//                    Grep for: "XDSLRTFW-541: Platform_VRX318"
//
// 14/12/2012 Mahesh: Added L2 entry - Amd 4 changes.
//          Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
// 27/03/2013 Varun : Updated the margin calculation for monitor tones with Finegains=Finegains(L0)- Finegains(L2),Earlier calculation used only
//                    L2 fain gains while using L0 bit loading which resulted in wrong margin triggering wrong L2 RFI auto exit.
//                    grep for XDSLRTFW-1660
//
// 31/03/2014 ChihWen: DS rate improvement against Adtran Geminax in DMT mode.
//                To improve the DS rate against Adtran Geminax in DMT mode, the solutions are below.
//                1. When preparing the parameters in R-MsgsRA, search the best R (>= 4) which will achieve highest K (best net rate),
//                   then set K in R-MsgsRA accordingly, but set R = 0, coding gain = 5.5 dB, and loaded tone number by the equation below.
//                   (loaded tone number) = 159 * (codeword size) - 232. This one-order equation is from (codeword size, loaded tone number)
//                   = (245,152) and (104,64). After receiving R-MsgsRA, Adtran Geminax will send C-RatesRA with proper options of R and K,
//                   in which AR9 will select the second or third option.
//                2. Report DS LOS when pilot power < gl_PilotTone_PwrThresh/256 instead of gl_PilotTone_PwrThresh due to link drop by CO.
//            This is controlled by CMV info 103 27 bit5 0x0020 and is disabled by default.
//            1: Enabled
//            0: Disabled (Default)
//                Grep for XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate
//
//***************************************************************************


#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "bitload.h"
#include "rx_eoc.h"
#include "gdata_bis.h"
#include "bitload2.h"
#include "cmv.h"
#include "gdata_dmt.h"
#include "vecpwr.h"
#include "tx_plam.h"
#include <string.h>
#include "noiseacc.h"
#include "ss_snrfdq.h"
#include "dd_snrfdq.h"
#include "rx_ovrhd_bis.h"
#include "detect.h"
#include "showtime_rx_b_bis.h"
#include "pll.h"
#include "trail.h"
#include "tx_ops_bis.h"
#include "mul.h"
#include "states.h"

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//XDSLRTFW-541: Platform_VRX318 (START)
#include "LL_IOf.h"
#include "memrymap.h"
#include "ppe_memmap.h"
//XDSLRTFW-541: Platform_VRX318 (END)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
#define L2_EXIT_MARGIN_THRESHOLD                0x0100  // margin threshold
#define L2_EXIT_TONE_NUM_THRESHOLD      1                               // tone number threshold
//XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)
extern void SetUpSWRSDetectBins();
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
#ifndef ISDN
void CapSnrOnMonitoredTones(int16 capped_snr,int16 s_RxDesiredMargin);
#endif
//SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
//bit allocation saved before Bitswap
extern uint8 guca_RxBat_Before_BS[RX_NUM_TONES];
//SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)


//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//XDSLRTFW-541: Platform_VRX318 (START)
/*
*-------------------------------------------------------------------------------
*
*       Prototype: void DFE_PPE_LinkStatus_TxRxShow()
*
*       This function notifies PPE that both TX and RX directions are
*   in showtime. (BIT0)
*
*       Input Arguments:
*
*
*       Output Arguments:
*
*       Returns:
*
*       Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void DFE_PPE_LinkStatus_TxRxShow(void)
{
        uint32 ul_addr, ul_data;
        // Bit defintion of DREG registers:
        // 0x7DC0 (DREG_MISCRAM0_ADDR)
        //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
        //  Bit 1      --> Set by DSL FW on first Rx showtime
        //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF

        ul_addr = DREG_MISCRAM0_ADDR ;
        ReadPpeReg(ul_addr, &ul_data);
        ul_data |=MASK_BIT0;
        WritePpeReg(ul_addr, ul_data);

}


//XDSLRTFW-541: Platform_VRX318 (END)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//SMS01353004 Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (START)
//This fuction is to identify the tones whose margin are ever below -6 dB.
//SMS01478732 Fix_DS_BisPlus_ALL_FallBackToSlowBitswap (START)
//SMS01544209 Fix_DS_BisPlus_ALL_FixForReinTest (START)
void IdentifyTonesWithStrongNoise(void)
{
        int16 s_Margin;
        uint16 i, s_RxChannelsAllocated;
        uint16 s_tone_num_evaculate = 0;
        uint16 s_bit_num = 0;
        uint16 s_bit_sum_1db_margin = 0;

        int16 s_bitswap_evacuation_thrd_local;

        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
        int16 s_tone_num_low_margin_L2 = 0;
        TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoRequest;
        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)

        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
        //Backup the RxBat in L0 state, which will be used to calculate the margin of monitored tones in L2 state.
        if (OPTNArray[OPTN_Power_Management] & OPTN_L2_Exit_Based_on_RFI)
        {
                if (STATArray[STAT_PowerMode] == STAT_PM_L0)
                {
                        memcpy(guca_RxBat_Before_BS, guca_RxBat, sizeof(uint8) * gs_RxNumTones);

                }
        }
        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)

        s_bitswap_evacuation_thrd_local = -(gs_bitswap_evacuation_thrd << 8);//-gs_bitswap_evacuation_thrd*256

        for (i = gs_RxFirstChannel; i <= gs_RxLastChannel; i++)
        {
            if (IS_TONEFLAGSET(p_MEDLEYset_DS, i))
            {
               if (OPTNArray[OPTN_Power_Management] & OPTN_L2_Exit_Based_on_RFI)
               {
                  //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
                  //Reset the margin.
                  s_Margin = L2_EXIT_MARGIN_THRESHOLD+1;
                  //Calculate the margin for all tones in MEDLEY set in L0 state, or for loaded tones in L2 state.
                  if ( (STATArray[STAT_PowerMode] == STAT_PM_L0) ||
                       ((STATArray[STAT_PowerMode] == STAT_PM_L2) && (guca_RxBat[i] > 0)) )
                  {
                     s_Margin =
                        ComputeMarginPerTone(gsa_RxShowtimeSnrBuf[i]+gsa_TotalCodingGain[INTERLEAVE_DATA_PATH],
                                             guca_RxBat[i],
                                             gsa_RxFineGains[i],
                                             (int16 *)(void *)&s_RxChannelsAllocated);

                     //Calculate the margin for monitored tones in L2 state when it is non-CNXT CO, since we found CNXT CO may not
                     //transmit signal on monitored tones. The margin of loaded tones are calculated by referring to the loaded bit number in L0 state,
                     //and the L2 PCB value relative to L0 state.
                     // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
                   }
                   else if ( (gs_CurrentCoChipset != GSI_CO_CHIPSET) &&
                             (STATArray[STAT_PowerMode] == STAT_PM_L2) &&
                             (guca_RxBat_Before_BS[i] > 0) &&
                             (guca_RxBat[i] == 0) &&
                             (gsa_RxFineGains[i] != NEG_INFINITY_DB) )
                     // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
                   { //XDSLRTFW-1660(START_END)
                     s_Margin = ComputeMarginPerTone(gsa_RxShowtimeSnrBuf[i]+gsa_TotalCodingGain[INTERLEAVE_DATA_PATH]+((gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols-gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols)<<8),
                                                      guca_RxBat_Before_BS[i],
                                                      (gsa_TempRxFineGains[i]-gsa_RxFineGains[i]),
                                                      (int16 *)(void *)&s_RxChannelsAllocated);

                    }
                                //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)
               }
               else
               {
                  s_Margin =
                       ComputeMarginPerTone(gsa_RxShowtimeSnrBuf[i]+gsa_TotalCodingGain[INTERLEAVE_DATA_PATH],
                                            guca_RxBat[i],
                                            gsa_RxFineGains[i],
                                            (int16 *)(void *)&s_RxChannelsAllocated);
               }

               s_bit_num += guca_RxBat[i];
               if (s_Margin < 256) // 1dB margin in 8.8 format = 1*256
                  s_bit_sum_1db_margin += guca_RxBat[i];

               //if (s_Margin < -gs_bitswap_evacuation_thrd*256)
               //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
               //if (s_Margin < s_bitswap_evacuation_thrd_local)
               if ((s_Margin < s_bitswap_evacuation_thrd_local) && (STATArray[STAT_PowerMode] == STAT_PM_L0))
               //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)
               {
                  gft_TonesWithStrongNoise = TRUE;
                  STATArray[STAT_Performance] |= STAT_STRONG_TIMEVARY_NOISE;
                  if ( (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_BITSWAP_EVACUATION) &&
                       (!IS_TONEFLAGSET(guca_TimeVaryNoise_Ind_sav,i)) )
                  {
                     SETTONEFLAG(guca_TimeVaryNoise_Ind_sav,i);
                     STATArray[STAT_BITSWAP_EVACUATION] |= STAT_BS_EVACUATION_ON;
                  }
               }
               //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
               //Count the number of loaded/monitored tones whose margin are below 1 dB.
               else if (( (STATArray[STAT_PowerMode] == STAT_PM_L2) && (s_Margin < L2_EXIT_MARGIN_THRESHOLD) )
                         && (OPTNArray[OPTN_Power_Management] & OPTN_L2_Exit_Based_on_RFI))
               {
                  s_tone_num_low_margin_L2++;
               }
                        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)
            }
        }

        //Evacuation feature is relaxed (buffer reset) when the sum of loaded bits of the tones' margin below 1 dB is too high.
        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
        //if (s_bit_num < (s_bit_sum_1db_margin << 3)) //(s_bit_num < s_bit_sum_1db_margin*8
        if ((s_bit_num < (s_bit_sum_1db_margin << 3)) && (STATArray[STAT_PowerMode] == STAT_PM_L0)) //(s_bit_num < s_bit_sum_1db_margin*8
        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)
        {
                STATArray[STAT_BITSWAP_EVACUATION] &= ~STAT_BS_EVACUATION_ON;
                MemSetBuffer((int16 *)(void *)guca_TimeVaryNoise_Ind_sav, 0, 0, 64);
        }
        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (START)
        //Send the L2 exit command.
        else if (((s_tone_num_low_margin_L2 >= L2_EXIT_TONE_NUM_THRESHOLD) && (STATArray[STAT_PowerMode] == STAT_PM_L2))
                && (OPTNArray[OPTN_Power_Management] & OPTN_L2_Exit_Based_on_RFI))
        {
                //Sending out power management request to L0 state.

                //Resetting
                memset(&t_TxOvhdMsgInfoRequest, 0, sizeof(TxOvhdMsgInfoRequest_t ));

                // Fill up the structure members of "TxOvhdMsgInfoRequest_t"
                t_TxOvhdMsgInfoRequest.uc_message_type = STATE_TRANS_REQ;
                t_TxOvhdMsgInfoRequest.uc_message_designator = POWER_MGMT_CMD_DESIG;
                t_TxOvhdMsgInfoRequest.uc_Source = AUTO_CMD_SOURCE;
                t_TxOvhdMsgInfoRequest.uc_Segmented = FALSE;
                t_TxOvhdMsgInfoRequest.uc_TestParameterId = L0_STATE;

                if (TxHdlcSendRequest(OVHD_NORMAL_PRIORITY, t_TxOvhdMsgInfoRequest) ==
                        HDLC_QUEUE_ADDED)
                {
                }

        }
        //XDSLRTFW-444 ADSLRTFW-1455 Feature_B_DS_BisPlus_ALL_L2Exit (END)

}



/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *              CapSnrOnMonitoredTones
 *
 *      Prototype:
 *              void CapSnrOnMonitoredTones(int16 capped_snr,int16 s_RxDesiredMargin)
 *
 *      Input Arguments: capped_snr
 *
 *      Output Arguments: None
 *
 *  Abstract:   CNXT DSLAM's won't send any signal on monitor tones
 *             For CNXT DSLAM's SNR on monitor tones is just noise measurements. So just limit this
 *             to start with 2 bits SNR required.
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      guca_RxBat,gsa_RxFineGains,gsa_RxShowtimeSnrBuf
 *------------------------------------------------------------------------
 */

#ifndef ISDN
void CapSnrOnMonitoredTones(int16 capped_snr,int16 s_RxDesiredMargin)
{
        uint16 i;

        for (i = gs_RxFirstChannel; i <= gs_RxLastChannel; i++)
        {
                if ( (guca_RxBat[i] == 0) &&
                                 (gsa_RxFineGains[i] == 0))
      {
         if(gsa_RxShowtimeSnrBuf[i] >= (capped_snr + 0x0600))
            gsa_RxShowtimeSnrBuf[i] = capped_snr;
         /* don't consider the below cases for bitload */
         else if (gsa_RxShowtimeSnrBuf[i] >=
                  (gsa_ConstellationSNR[1]+s_RxDesiredMargin - gsa_TotalCodingGain[LP0_DATA_PATH])
                  )
         {
            gsa_RxShowtimeSnrBuf[i] = (gsa_ConstellationSNR[1]+s_RxDesiredMargin - gsa_TotalCodingGain[LP0_DATA_PATH])
                                       - 0x0100;
         }

      }
   }
}
#endif
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)


/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *              SnrUpdate_PostProcess
 *
 *      Prototype:
 *              void SnrUpdate_PostProcess(void)
 *
 *      Input Arguments:
 *
 *      Output Arguments:
 *
 *  Abstract:   Post processing involved after an snr update
 *                              For ex: Updates Avearge and Min Margin, AttnDr, SnrUpdate Count etc
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */
void SnrUpdate_PostProcess(void)
{
/* ======================================================================= */
/* calculate snr margin to report during EOC                               */
/* ======================================================================= */

/* Add coding gain, margin adjustment and Fine Gains to SNR margin reporting*/
        gs_RxAvMargin = CalcAvgMargin();

        /* Calculate margin correction due to CO TX nonlinearity only once, if activated. */
        if (gs_NonLinMgnCorr == (int16)0x8000)
        {
                gs_NonLinMgnCorr = gs_RxDesiredMargin - gs_RxAvMargin;
                /* Limit to [0,0.4] dB range. */
                if (gs_NonLinMgnCorr < 0)
                        gs_NonLinMgnCorr = 0;
                if (gs_NonLinMgnCorr > 0x0067)
                        gs_NonLinMgnCorr = 0x0067;
        }
        /* Add margin correction due to CO TX nonlinearity after every margin calculation. */
        gs_RxAvMargin += gs_NonLinMgnCorr;


   // XDSLRTFW-275: SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (Start)
   // Report DS margin as 6 when it is 5.8 or 5.9
   if ((gs_RxAvMargin > 0x05CC) && (gs_RxAvMargin < 0x0600))   // 0x05CC is 5.79dB in 6.6 format
      gs_RxAvMargin = 0x0600; // 0x0600 is 6dB in 8.8. format
   // XDSLRTFW-275: SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (End)

        /* Represent margin in Q7.1 format (-64dB to +63.5dB with 0.5dB steps) */
        //gs_Margin and gs_Margin_Point1dB are the actual value of margin. They are internal variables, meaning not accessible
        //by ME. The gt_NearEndParam.s_SnrMargin and gs_SnrMargin_OneOverTen_dB_Resolution are the ones accessible by ME, whose
        //values by default are gs_Margin and gs_Margin_Point1dB, but could be overwriten or postpone set to the actual margin in
        //different conditions.
        gs_Margin = gs_RxAvMargin;

        gs_Margin_Point1dB = FormSNRM(gs_Margin);

        gs_Margin += (1<<6);            // Add 0.25 dB for rounding.
        gs_Margin >>= 7;

        if(gs_Margin >= 127)                            // Max representable is +63.5dB.
                gs_Margin = 127;
        else if(gs_Margin < (-128))             // Min representable is -64dB.
                gs_Margin = -128;

        if (gs_Margin < 0) {
                logShowtimeEventA(0,gs_Margin);

                if((TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressSNRMarginToME) != 0)
                {
                        // Do not report negative snr margin to ME if the cmv is set
                        gt_NearEndParam.s_SnrMargin = 0;
                        gs_SnrMargin_OneOverTen_dB_Resolution = 0;
                }
                //else, the gt_NearEndParam.s_SnrMargin and gs_SnrMargin_OneOverTen_dB_Resolution
                //values will be set in CheckShowtimeUpdate on a 10sec timer
        }
        else {
        gt_NearEndParam.s_SnrMargin = gs_Margin;
        gs_SnrMargin_OneOverTen_dB_Resolution = gs_Margin_Point1dB; //-1dB (0.1dB unit)
        }
   //XDSLRTFW-2443 / XDSLRTFW-2462 (start_end)
   UpdateRxSnrBufGet();


   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
#ifndef ISDN
      int16 s_capped_snr;
      int16 s_RxDesiredMargin;
      if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
      {
         s_RxDesiredMargin = gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta];
         // Cap the SNR to "SNR required to load 2 bits".
         s_capped_snr = gsa_ConstellationSNR[2]+s_RxDesiredMargin - gsa_TotalCodingGain[LP0_DATA_PATH];
         CapSnrOnMonitoredTones(s_capped_snr,s_RxDesiredMargin);
      }
#endif
      //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)
      if (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_BITSWAP_EVACUATION)
         IdentifyTonesWithStrongNoise();
      // Do Autonmous Bitswap
      Rx_OLR_Decision();

      // Update Attainable Net Data Rate estimate.
      UpdateATTNDR();

        // If we got UpdateTestPar msg, we should update the "external"
        // copy of Test parameters during 10s period
                if (gus_10sec_Timer > 0)
                {
                        gs_RxSNRM_ovhd = gs_RxAvMargin;
                        gt_NearEndParam.ul_AttainableDataRate = gl_ATTNDRds_Estimate_Updated;
                }
        }
        else
        {

                /* Save margin EOC buffer */
                gpt_EocRxReadBuf->c_snr_margin[0] = (int8) gs_Margin;

        }

   gft_ShowtimeSnrUpdateFlag = TRUE;    // Set flag to indicate the SNR has been updated.
   if (guc_ddProcState != DD_PROC_DISABLE)
   {
       /* restart accumulation of frames over next set of channels */
       guc_ddProcState = DD_PROC_INITIALIZE;    // The below state also buys a frame of delay as the
       // TC task is using the updated first/last channels
   }
}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *              detect_LOS
 *
 *      Prototype:
 *              void detect_LOS(void)
 *
 *      Input Arguments:
 *
 *      Output Arguments:
 *
 *  Abstract:   Detects Loss of Signal
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */

#if 1
//New LOS detection code which computes "Pilot reference power" threshold on the fly
//(Dynamic). Code picked up from VR9 VDSL2 code.

#define LOS_INIT         (0)
#define LOS_SETUP        (1)
#define LOS_DETECT       (2)

//As per ADSL2 spec., power should be averaged over 0.1 sec
//(which is 400 synbols for 4Khz frame rate)
//To simplify the computation, we choose to use 512 symbols for average
#define NUM_SYMS_FOR_THRESH                     (512)   //was (128) in VR9 VDSL2 code
#define LOG2_NUM_SYMS_FOR_THRESH        (9)     //was (7) in VR9 VDSL2 code

//As per ADSL2 spec., power should be averaged over 0.1 sec
//(which is 400 synbols for 4Khz frame rate)
//To simplify the computation, we choose to use 512 symbols for average
#define NUM_SYMS_FOR_DETECT             (512)
#define LOG2_NUM_SYMS_FOR_DETECT (9)

//uint16 us_dbg_los_init_cnt = 0; //for debug new los logic

void detect_LOS(void)
{
      int32 l_temp;
        int32 l_Pow;
   //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START_END)
      // int32 l_temp;
        uint8 uc_los_def;

        //Compute the pilot tone power
        l_Pow = gsa_RxPilotTone[0]*gsa_RxPilotTone[0] + gsa_RxPilotTone[1]*gsa_RxPilotTone[1];

        switch(guc_LosDefect_state) {

        case LOS_INIT:
        //us_dbg_los_init_cnt++; //for debug new los logic
                gl_AvgPilotPow_Thresh = 0;
                gs_LosDefect_state_cnt = 0;
                guc_LosDefect_state = LOS_SETUP;
                break;

        case LOS_SETUP:
                //Compute the average pilot tone power
                gl_AvgPilotPow_Thresh += (l_Pow>>LOG2_NUM_SYMS_FOR_THRESH);
                gs_LosDefect_state_cnt++;
                if(gs_LosDefect_state_cnt == NUM_SYMS_FOR_THRESH)
                {
                        //Set the threshold to be 6 dB below the average pilot tone
                        gl_AvgPilotPow_Thresh >>= 2;
            gl_PilotTone_PwrThresh = gl_AvgPilotPow_Thresh;
                        gl_AvgPilotPow = 0;
                        gs_LosDefect_state_cnt = 0;
                        guc_LosDefect_state = LOS_DETECT;
                }
                break;

        case LOS_DETECT:
                //Compute the average pilot tone power
                gl_AvgPilotPow += (l_Pow>>LOG2_NUM_SYMS_FOR_DETECT);
                gs_LosDefect_state_cnt++;
                if(gs_LosDefect_state_cnt == NUM_SYMS_FOR_DETECT)
                {
//XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (START)
//Avoid CO to drop the link due to pilot power is occasionally lower than threshold.
#ifndef ISDN
               if (gft_Adtran_GMX_DMT == TRUE)
                     l_temp = gl_AvgPilotPow_Thresh >> 8;
               else
#endif
                     l_temp = gl_AvgPilotPow_Thresh;

               if (gl_AvgPilotPow < l_temp)
      //XDSLRTFW-1586 IOP_DS_A_GMX_DMT_LowRate (END)
               {
                  gs_los_cnt++;     /* Count of LOS defects per second */
                  uc_los_def = PRESENT;
               }
               else
               {
                  uc_los_def = TERMINATED;
               }

               //Reset for the next period of NUM_SYMS_FOR_AVG
               gl_AvgPilotPow = 0;
               gs_LosDefect_state_cnt = 0;

               if (( gl_SelectedMode & (MODE_ADSL2)  ))
               gt_tx_Anomaly.uc_los_def =uc_los_def;
               else
                     gt_TxIbData.uc_flos_def = uc_los_def;

                } //if(gs_LosDefect_state_cnt == NUM_SYMS_FOR_AVG)
                break;
        }

} //uint8 detect_LOS(void)


#else
//Old LOS detection code which uses hardcoded value for "Pilot reference power"
//Threshold, which is used in decision logic to triger the LOS.

void detect_LOS(void)
{
        FlagT ft_generate_error = FALSE;
        uint8 uc_temp;
        int32 l_temp, l_temp2;


    if (guc_LOSDetectState == LOS_DETECT_ENABLED)
    {
        /* ================================== */
        /* accumulate power                                       */
        /* ================================== */

        if (gs_LosDefect_state_cnt == 0) //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
            gl_AvgPilotPow = 0; //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)

                // Get pilot tone power and add to accumulator.
                MULS16(l_temp,gsa_RxPilotTone[0],gsa_RxPilotTone[0]);
                MULS16(l_temp2,gsa_RxPilotTone[1],gsa_RxPilotTone[1]);
                gl_AvgPilotPow += ((l_temp+l_temp2)/LOS_ACCUM_SFRAMES);  //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)

        gs_LosDefect_state_cnt++;  //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)

                /* Accumulate over a period of 0.1 seconds = 6 Superframes */
        if (gs_LosDefect_state_cnt == LOS_ACCUM_SFRAMES)  //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
        {
            gs_LosDefect_state_cnt = 0;  //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)

                        /* =================================================================== */
                        /* Compare measured power to LOS threshold */
                        /* =================================================================== */

            //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
                        if ((gl_AvgPilotPow < gl_PilotTone_PwrThresh)

                                )
                        {
                                gs_los_cnt++;           /* Count of LOS defects per second */
                        logShowtimeEventA(2, gs_los_cnt);
                                uc_temp = PRESENT;
                        }
                        else
                        {
                                uc_temp = TERMINATED;
                        }

                        if (( gl_SelectedMode & (MODE_ADSL2)  ))
                        gt_tx_Anomaly.uc_los_def =uc_temp;
                        else
                                gt_TxIbData.uc_flos_def = uc_temp;

                }
        }
}
#endif


/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *              detect_SEF
 *
 *      Prototype:
 *              void detect_SEF(void)
 *
 *      Input Arguments:
 *
 *      Output Arguments:
 *
 *  Abstract:   Performs Severely-errored frame detection
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */

void detect_SEF(void)
{
        FlagT ft_generate_error = FALSE, ft_sef_frame = FALSE;
        int16 sa_numMatches[2];
        uint8 *puc_temp;
        int16 RevSeg;

        if (( gl_SelectedMode & (MODE_ADSL2)  ))
                puc_temp = &(gt_tx_Anomaly.uc_sef_def);
        else
                puc_temp = &(gt_TxIbData.uc_fsef_def);


        if (guc_SEFDetectState == SEF_DETECT_ENABLED)
    {
                /* Quadrant detection of sync frame */
                RevSeg = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, &sa_numMatches[C_REVERB], &sa_numMatches[C_SEGUE]);
                /* Matches over less than 3/4 of all tones tested */
                if(sa_numMatches[gs_RxSyncToneType] < ((3*gs_RSDetect_NumBins+3)>>2))
                {
                        ft_sef_frame = TRUE;    /* then trigger sef */
                        logShowtimeEventA(1,gus_SEF_totalcount);
                }
                // DMT: a margin-based criterion leads into race condition, bc (in a dropped link) margin stops getting updated till LOF is declared

                if (ft_sef_frame)


        /* Increase gs_SEF_sframe_count by 1 current frame is severly errored */
                {

            gft_SEF_currentframe = TRUE;
                gus_SEF_totalcount++;

                        /*  sync symbol does not correlate, update count */
                        /*  of consecutive frames that did not correlate and */
                        /*  test for SEF */
                        gs_SEF_sframe_cnt++;

                        if (gs_SEF_sframe_cnt >= NUM_FRAMES_SEF_PRESENT)
                        {
                                gs_SEF_sframe_cnt = NUM_FRAMES_SEF_PRESENT;

                                gs_sef_cnt++;           /* SEF defect per second */

                                if (*puc_temp == TERMINATED)
                                        // When SEF condition changes from Off to On, increase counter.
                                        gs_sef_event_cnt++;
                                *puc_temp = PRESENT;
                        }
                }
                else
                {

            gft_SEF_currentframe = FALSE;
                        /*  sync symbol does correlate, update count */
                        /*  of consecutive frames that did correlate and */
                        /*  test for termination of SEF */
                        gs_SEF_sframe_cnt--;

                        if (gs_SEF_sframe_cnt <= 0)
                        {
                                gs_SEF_sframe_cnt = 0;

                                *puc_temp = TERMINATED;
                        }

                }
        }
}


