/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  ss_snrfdq.c
;
;  Functions for BG Tasks from synsymbl.c
;
;***************************************************************************/

#include "common.h"
#include "rt_state.h"
#include "snr.h"
#include "gdata.h"
#include "fdq_adap.h"
#include "ib.h"
#include "tx_ib.h"
#include "dsp_op.h"
#include "rx_ops.h"
#include "bitload.h"
#include "noiseacc.h"
#include "fifo.h"
#include "pwr_ctbk.h"
#include "rx_eoc.h"
#include "accum32.h"
#include "rt_tones.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "gdata_bis.h"
#include "tx_plam.h"
#include "bitload2.h"
#include <string.h>
#include "cmv.h"
#include "gdata_dmt.h"
#include "tx_ops2.h"
#include "ApplyFineGains.h"
#include "dec_gain.h"
#include "bitload_const.h"
#include "showtime_rx_b_bis.h"
#include "tx_ovrhd_bis.h"



/*****************************************************************************
;  Subroutine Name: GenShowtimeCReverbRef(int32 l_rmsFineGain_dmt, int16 *psa_RxFineGains_bis)
;
;  Description:
;
;
;  Prototype:
;     void GenShowtimeCReverbRef(void);
;
;  Input Arguments:
;     l_rmsFineGain_dmt -  rms fine gain, used in dmt mode
;     psa_RxFineGains_bis  -  array of linear fine gaines, used in bis mode
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables:
;
*******************************************************************************/
void GenShowtimeCReverbRef(int32 l_rmsFineGain_dmt, int16 *psa_RxFineGains_bis)
{
   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
      {
         if ((gt_RCMsgFmt_bis.uc_MedleyPRBSds == 1) && (gt_RMsgFmt_bis.uc_MedleyPRBSus == 1))
         {
            /* The reverb reference signal was overwritten by the first medley frame for */
            /* 14th order medley sequence in g992_5 mode in RCMedleyRxF_TDQTest_Bis() function */
            /* Hence, we need to regenerate the reverb reference signal for showtime processing */

            Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
               gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));
         }
      }

      /* This is a convenient time to apply the linear fine gains to the sync symbol reference */
      ApplyFineGains(gsa_CReverbRefTones, (int16)gs_RxFirstChannel, (int16)gs_RxLastChannel, (uint16 *)(void *)gsa_TempRxFineGains);
   }
   else
   {
      gs_RxSyncFrameGain = DECGAIN2;
      if( (!(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) && (gs_CurrentCoChipset==ALA_CO_CHIPSET)) ||
         (gs_CurrentCoChipset==IFTN_CO_CHIPSET) ||
         (gs_CurrentCoChipset==BDCM_CO_CHIPSET) ||
         (gs_CurrentCoChipset==TI_CO_CHIPSET))
      {
         /* Compliant synch symbol power, scale reference with RMS value of fine gains without excess margin reduction. */

         // TI CO sends compliant sync symbol power only when RMSGi<0(dB)
         if ((gs_CurrentCoChipset!=TI_CO_CHIPSET) || (gt_TxPMDControl.us_RMSGI_DS <0))
         {
            l_rmsFineGain_dmt *= (int32) DECGAIN2;
            gs_RxSyncFrameGain = (int16) (l_rmsFineGain_dmt >> 13);
         }
      }
      else
      {
         /* Non-compliant synch symbol power, scale reference with excess margin reduction value. */
         if (!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable))
         {
            gs_RxSyncFrameGain = (int16)(((int32)DECGAIN2 * gs_ExcessMarFDQBoost) >> 13);
         }
      }
      Gen_Reverb_Ref_fd(gsa_CReverbRefTones, GEN_REVERB_TYPE_CO, gs_RxNumTones,
         gs_RxFirstChannel, gs_RxLastChannel, gs_RxSyncFrameGain);
   }
}

/*****************************************************************************
;  Subroutine Name: SyncSymbolSnrFdqHandler
;
;  Description:
;     This background task does the following:
;
;        1) SNR calculation
;        2) FDQ adaptation
;
;  Prototype:
;     void SyncSymbolSnrFdqHandler(void);
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables (defined in other files):
;     gsa_RxShowtimeSnrBuf[]              - (O) showtime SNR buffer (in Q8.8 format)
;     gsa_CReverbRefTones[]               - (I) reference sync frame
;     gsa_RxToneBuf[]                  - (I) recieved sync frame
;     gsa_FDQ_coef[]                   - (I/O) current FDQ coefficient buffer
;     gsa_FDQ_exp[]                    - (I/O) current FDQ exponent buffer
;
;  Global Variables (defined in this file):
;     guc_ShowtimeSnrCalcState            - (I/O) showtime SNR calculation substate
;     gus_ShowtimeSNRFrameCnt             - (I/O) showtime SNR calculation count
;     guc_FdqAdaptationState              - (I/O) FDQ adaptation substate
;     gus_ShowtimeFDQFrameCnt          - (I/O) FDQ adaptation count
;
;  Substates:
;       SHOWTIME_SNR_CALC_DISABLE           - disable calculations
;       SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES - accumulate frames for SNR calculation during Showtime
;       SHOWTIME_SNR_CALC_PERFORM_CALC      - perform SNR calculation during Showtime
;       FDQ_ADAPTATION_DISABLE              - disable FDQ calculations
;       FDQ_ADAPTATION_INITIALIZE           - initialization for updating FDQ coefficients during showtime
;       FDQ_ADAPTATION_ACCUMULATE_FRAMES    - accumulate frames of data for updating FDQ coefficients
;       FDQ_ADAPTATION_UPDATE_COEFFICIENTS  - update FDQ coefficients during showtime
;
*******************************************************************************/
void SyncSymbolSnrFdqHandler(void)
{
   // We assume that gsa_RxTonesBuf[] contains the captured sync frame after FFT and FDQ.
   // We also assume that gsa_RxTonesBuf[] is only updated on sync frames.
    int16 i;
   int16 s_MinMargin = 0;


    /* ======================================================================= */
   //  SNR Update.
   // Note that the checks of guc_ShowtimeSnrCalcState are not mutually exclusive,
   // and that more than one condition may be met since the state may change within
   // this function.
   /* ======================================================================= */




   /* =================================================================== */
   /*  accumulate frames */
   /* Only update SNR is current sync frame is a good one, or we have LOS or LOF for 2.5 seconds */
   /* =================================================================== */
   if (gft_SnrOrFdqUpdate == 1)
   {  /* do SNR this turn */

      if(guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_DISABLE) {
         gft_SnrOrFdqUpdate = 0; /* go to FDQ update Directly */
      }

      if((gft_SEF_currentframe == FALSE) || (gs_NearEndFailure & PLAM_LOS_FailureBit) || (gs_NearEndFailure &PLAM_LOF_FailureBit))
   {
      if(guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_INITIALIZE) {
         gus_ShowtimeSNRFrameCnt = 0;

      /*  initialize noise power accumulators */
         MemSetBuffer((int16 *)(void *)gla_RxShowtimeSnrAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));

         guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES;
      }

      if(guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES) {

         gus_ShowtimeSNRFrameCnt++;

      /*  accumulate noise power */
         NoiseAcc(gla_RxShowtimeSnrAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0/* Indicates Not Medley*/, -1, -1,/* -1 => Unused input parameters */
            gsa_CReverbRefTones, gs_RxFirstChannel, gs_RxLastChannel);

      /*  move to next state after accumulating (1 << OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols]) frames */
         if(gus_ShowtimeSNRFrameCnt == (uint16) (1 << OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols])) {
            guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_PERFORM_CALC;
         }
      }

   /* =================================================================== */
   //  perform SNR calculation
   /* =================================================================== */
      if(guc_ShowtimeSnrCalcState == SHOWTIME_SNR_CALC_PERFORM_CALC) {

         int32 *pla_NoisePower;

         /* convert 48 bits accumulated value to 32 bits; */
         pla_NoisePower = gla_RxShowtimeSnrAccumBuf; // Overwrite 64-bit input buffer with 32-bit output.
         RoundNoiseAccum
            (gla_RxShowtimeSnrAccumBuf, pla_NoisePower, gs_RxFirstChannel, gs_RxLastChannel, (int16) OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols]);

         SnrCalc(pla_NoisePower + gs_RxFirstChannel, gsa_RxShowtimeSnrBuf + gs_RxFirstChannel,
               gs_RxFirstChannel, gs_RxLastChannel);

        /* ======================================================================= */
        /* calculate snr margin to report during EOC                               */
         /* ======================================================================= */

         SnrUpdate_PostProcess();

         gus_ShowtimeSNRUpdateCount++;    // Increment count of SNR updates.
         guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_INITIALIZE;
         gft_SnrOrFdqUpdate = 0;

      }
      } // end of if((gft_SEF_currentframe == FALSE) || (gs_NearEndFailure & PLAM_LOS_FailureBit) || (gs_NearEndFailure &PLAM_LOF_FailureBit))
   }  /* gft_SnrOrFdqUpdate is 1 */


   /* ======================================================================= */
   // FDQ Adaptation
   // Note that the checks of guc_ShowtimeFDQAdaptationState are not mutually exclusive,
   // and that more than one condition may be met since the state may change within
   // this function. The second condition is used to avoid bad sync frames for FDQ adaption.
   /* ======================================================================= */

   if (gft_SnrOrFdqUpdate == 0)
   {

      if (guc_FdqAdaptationState == FDQ_ADAPTATION_DISABLE) {
         gft_SnrOrFdqUpdate = 1;  /* skip doing FDQ and go to SNR */
      }

      /* If current frame is non-sef frame, update FDQ */
   /* The second condition is added to pass the showtime only test which has incorrect */
   /* initial FDQ coefficients, which results in bad SEF showtime snr and SEF detection */
      if((gft_SEF_currentframe == FALSE) || ((TESTArray[TEST_InitState] & TEST_ShowtimeInitState)!=0))
   {
      if (guc_FdqAdaptationState == FDQ_ADAPTATION_INITIALIZE) {

         gus_ShowtimeFDQFrameCnt = 0;
         MemSetBuffer(gsa_RxShowtimeFDQAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));

      /* Move to next state */
         guc_FdqAdaptationState = FDQ_ADAPTATION_ACCUMULATE_FRAMES;
      }

      if (guc_FdqAdaptationState == FDQ_ADAPTATION_ACCUMULATE_FRAMES) {

      /* =================================================================== */
      /*  accumulate frames */
      /* =================================================================== */

         Accum16to32((int32 *)(void *)gsa_RxShowtimeFDQAccumBuf, (int16) (2*gs_RxFirstChannel),
                  gsa_RxToneBuf, (int16) (2*gs_RxFirstChannel), (int16)(2*(gs_RxLastChannel-gs_RxFirstChannel+1)));

         gus_ShowtimeFDQFrameCnt++;

         if(gus_ShowtimeFDQFrameCnt == (uint16) (1 << OPTNArray[OPTN_Log2NumShowtimeFDQTrainingSymbols])) {

         /*  compute average received tones */
            for(i=2*gs_RxFirstChannel; i<(2*gs_RxLastChannel+2); i++) {
               gsa_RxShowtimeFDQRepBuf[i] = (int16)(((int32 *)(void *)gsa_RxShowtimeFDQAccumBuf)[i]>>OPTNArray[OPTN_Log2NumShowtimeFDQTrainingSymbols]);
            }

         /*  move to next state */
            guc_FdqAdaptationState = FDQ_ADAPTATION_UPDATE_COEFFICIENTS;
         }
      }

      if (guc_FdqAdaptationState == FDQ_ADAPTATION_UPDATE_COEFFICIENTS) {

      /*  compute the new FDQ coefficients */
         if(FdqAdapt(&gt_FdqAdaptInput) == 0) {

         // Done adapting all FDQ coefficients. Change to state that loads/activates
         // the new coefficients.  Note that for the FDQ_ADAPTATION_LOAD_COEFFICIENTS
         // state this function does nothing but wait for the state to change to
         // FDQ_ADAPTATION_COEFFICIENTS_LOADED.

            guc_FdqAdaptationState = FDQ_ADAPTATION_LOAD_COEFFICIENTS;
            gus_ShowtimeFDQFrameCnt = 0;
         }
      }

      if (guc_FdqAdaptationState == FDQ_ADAPTATION_COEFFICIENTS_LOADED) {

      // This state is entered after the time-critical showtime task finishes loading the
      // new FDQ coefficients and changes the value of guc_FdqAdaptationState.  Since at
      // this point the contents of the RxToneBuf were calculated using the old coefficients,
      // we should wait until the next sync frame before we begin accumulating the values in
      // RxToneBuf again.  Therefore this state is one frame long.

         gus_ShowtimeFDQUpdateCount++;    // Increment count of FDQ updates.

         guc_FdqAdaptationState = FDQ_ADAPTATION_INITIALIZE;
         gft_SnrOrFdqUpdate = 1; /* Do SNR next time */
      }
   } /* end of if((gft_SEF_currentframe == FALSE)|| ((TESTArray[TEST_InitState] & TEST_ShowtimeInitState)!=0))  */
   else if(gs_NearEndFailure & (PLAM_LOS_FailureBit | PLAM_LOF_FailureBit))
   {
         guc_FdqAdaptationState = FDQ_ADAPTATION_INITIALIZE;
      gft_SnrOrFdqUpdate = 1;
   }
   }
}

