/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  synsymbl.c
;
;  Functions for processing synchronization symbols.
;
;***************************************************************************/

#include "common.h"
#include "rt_state.h"
#include "snr.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "fdq_adap.h"
#include "ib.h"
#include "tx_ib.h"
#include "dsp_op.h"
#include "rx_ops.h"
#include "bitload.h"
#include "noiseacc.h"
#include "fifo.h"
#include "pwr_ctbk.h"
#include "rx_eoc.h"
#include "accum32.h"
#include "synsymbl.h"
#include "rt_tones.h"
#include "tx_ops2.h"
#include "ApplyFineGains.h"
#include "dec_gain.h"
#include <string.h>
#include "cmv.h"
#include "memsetbf.h"

/*****************************************************************************
;  Subroutine Name: SynchSymbolHandler
;
;  Description:
;     This subroutine processes a synchronization symbol (a set of DMT tones)
;     by conducting the SNR calculationa and the FDQ adaptation if desired.
;
;  Prototype:
;     void SynchSymbolHandler(int16 *ps_inbuf);
;
;  Input Arguments:
;     ps_inbuf -- pointer to the input buffer containing received DMT tones
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables (defined in other files):
;     gsa_RxShowtimeSnrBuf[]              - (O) showtime SNR buffer (in Q8.8 format)
;     gsa_CReverbRefTones[]               - (I) reverb reference tone
;     gla_RxShowtimeSnrAccumBuf[]                  - (I/O) accumulated received tone buffer
;     gsa_RxRepBuf[]                   - (O) average received tone buffer
;     gsa_FDQ_coef[]                   - (I/O) current FDQ coefficient buffer
;     gsa_FDQ_exp[]                    - (I/O) current FDQ exponent buffer
;
;  Global Variables (defined in this file):
;     guc_ShowtimeSnrCalcState            - (I/O) showtime SNR calculation substate
;     gus_ShowtimeSNRFrameCnt             - (I/O) showtime SNR calculation count
;     guc_FdqAdaptationState              - (I/O) FDQ adaptation substate
;     gus_ShowtimeFDQFrameCnt          - (I/O) FDQ adaptation count
;
;  Substates:
;       SHOWTIME_SNR_CALC_DISABLE           - disable calculations
;       SHOWTIME_SNR_CALC_ACCUMULATE_FRAMES - accumulate frames for SNR calculation during Showtime
;       SHOWTIME_SNR_CALC_PERFORM_CALC      - perform SNR calculation during Showtime
;       FDQ_ADAPTATION_DISABLE              - disable FDQ calculations
;       FDQ_ADAPTATION_INITIALIZE           - initialization for updating FDQ coefficients during showtime
;       FDQ_ADAPTATION_ACCUMULATE_FRAMES    - accumulate frames of data for updating FDQ coefficients
;       FDQ_ADAPTATION_UPDATE_COEFFICIENTS  - update FDQ coefficients during showtime
;
*******************************************************************************/
void SynchSymbolHandler(int16 *psa_RxToneBuf)
{

   // We assume that gsa_RxTonesBuf[] contains the captured sync frame after FFT and FDQ.
   // We also assume that gsa_RxTonesBuf[] is only updated on sync frames, so it will not be
   // updated while sync frame processing is executing in the background.

   if ((guc_RxSyncFrameProcessingState == TRAINING_DONE) ||
      (guc_RxSyncFrameProcessingState == TRAINING_WAITING))
   {
      // Start the background processing task
         guc_RxSyncFrameProcessingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRxSyncFrameProcessing);
         //BgRxSyncFrameProcessing();
   }

}
