/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  synsymbl_b.c
;
;  Functions for BG Tasks from synsymbl.c
;
;***************************************************************************/

//***************************************************************************
// synsymbl_b.c
//
// History
//
// 23/08/2011 Vinjam: detect_LOS( ) routine is called for every symbol.
//                    call to detect_LOS( ) routine is taken out from sync symbol handler
//                    It is placed in show tme NTC task function.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//***************************************************************************

#include "common.h"
#include "rt_state.h"
#include "snr.h"
#include "gdata.h"
#include "fdq_adap.h"
#include "ib.h"
#include "tx_ib.h"
#include "dsp_op.h"
#include "rx_ops.h"
#include "bitload.h"
#include "noiseacc.h"
#include "fifo.h"
#include "pwr_ctbk.h"
#include "rx_eoc.h"
#include "accum32.h"
#include "rt_tones.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "gdata_bis.h"
#include "tx_plam.h"
#include "bitload2.h"
#include <string.h>
#include "cmv.h"
#include "gdata_dmt.h"
#include "tx_ops2.h"
#include "ApplyFineGains.h"
#include "dec_gain.h"
#include "ss_snrfdq.h"



/*****************************************************************************
;  Subroutine Name: BgRxSyncFrameProcessing
;
;  Description:
;     This background task processes a synchronization symbol (a set of DMT tones)
;     which may include any of the following:
;
;        1) Loss-of-signal detection
;        2) Severely-errored frame detection
;        3) SNR Calculation and FDQ adaptation (for sync symbol based adaptation)
;
;     Ideally this task would complete within one superframe time, i.e. before the
;     next sync frame arrives, but no error will occur if it takes longer.  The next
;     sync frame will be skipped over.
;
;  Prototype:
;     void BgRxSyncFrameProcessing(void);
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables (defined in other files):
;     gsa_CReverbRefTones[]               - (I) reference sync frame
;     gsa_RxToneBuf[]                  - (I) recieved sync frame
;
*******************************************************************************/
void BgRxSyncFrameProcessing(void)
{

   /* ======================================================================= */
   /* Detect SEF */
   /* ======================================================================= */
   if(guc_SEFDetectState  != SEF_DETECT_DISABLED)
   {
      detect_SEF();
   }

   /* ======================================================================= */
   /* Update IB statistics for current superframe */
   /* ======================================================================= */
   if(gft_ModemType != G_DMT_BIS)
      Update_TxIb();
   else
      Update_Anamoly_bis(0); //0: stands for far end


   /* Update FDQ and SNR after LOS and SEF detections */
   if (!gft_doDDSnrFdqUpdate)
   {
#ifndef TARGET_HW
      if(   guc_ShowtimeSnrCalcState != SHOWTIME_SNR_CALC_DISABLE ||
         guc_FdqAdaptationState != FDQ_ADAPTATION_DISABLE)
      {
         SyncSymbolSnrFdqHandler();
      }
#endif // #ifndef TARGET_HW
   }

   guc_RxSyncFrameProcessingState = TRAINING_DONE;

}
