/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  dec_adap.c
;
;  This file contains functions for showtime DEC adaptation.
;
;***************************************************************************/

// ******************************************************************
//  dec_adapt.c
//
// History
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 22/03/2013 Ram: Added fixes towards solving PM-L2 issues. Major changes are
//                 a. DEC adaptation in showtime is done only in L0 state. We are seeing burst
//                    CRCs when DEC adaptation is done in L2 state. Hence swithching it OFF (for now).
//                    Switch it ON again once the issue is fixed.
//                 b. Once back to L0 state, DEC adaptation starts afresh with new Avg Rx data.
//                 c. Downloading of New DEC Co-effs is avoided during L0 to L2 transition (to avoid Mips Peaking)
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 24/04/2013 Kannan: DEC adaptation state machine is common for both DMT & BIS modes.
//                    During PM L2 state, DEC adaptation was paused for sometime and is applicable
//                    for only Bis & Plus mode. Pausing is not required for G.DMT & T1413 mode.
//                    Pausing is not taken care for G.DMT & T1413 mode. Hence Dec adaptation got halted
//                    in G.DMT & T1413 mode.
//                    Grep for  XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation
//
// 25/06/2013 Kannan: If DEC HW is struck in WAIT state instead of IDLE state while downloading the
//                   DEC coefficients, restart the DEC HW state machine by changing the
//                   sending sync flag. This is done automatically when dec adaptation state
//                   is changed to AVERAGE_RX_DATA
//                   Grep for "XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
// 17/11/2015 Kannan: Timing violation in TC-tasks in case of following situation
//                   If
//                   - US sync symbol (including Tx-signal mirroring) and
//                   - writing of  DEC coefs
//                   is happening in the same symbol the last commands of the TC-task are not written anymore in the same timeslot
//                   This results in a false configuraiton of the Tx-QT-programming and linkdrops after 10 sec of showtime
//                   Grep for: XDSLRTFW-2458: BugFix_LinkDropAfter10secInSTwith_ADTRAN_DSLAM
//
// 24/11/2017 Sriram Shastry:VRX518 US CRCs and FECs in Tests of 1TR112 ADSL2+ Anx J.
//       Disable OOB handling if US Bitswap is ongoing .DEC update logic gets into conflict with OLR as both algorithms
//       copy gsa_TxCombinedGains to the inactive gain table / active table.
//       Grep for XDSLRTFW-3479
// ******************************************************************


#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "string.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "ec_data.h"
#include "dec_adap_Data.h"
#include "dec_adap_b.h"
#include "cmv.h"
#include "trail.h"

#define DEC_TX_CAPTURE_DURATION 6

//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
#define DEC_HW_WAIT_STATE_THRESHOLD  (512)

extern int16 gsa_deccapturedata[];
/***************************************************************************************
;  Subroutine Name: ControlDECAdaptation
;
;  Description:
;     This function implements the state machine that controls
;     the   DEC adaptation during showtime.
;
;  Prototype:
;     void ControlDECAdaptation(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;**********************************************************************************************/

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
extern FlagT gft_SkipDECDownload;
extern uint32 gul_NumDECSkip;
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
extern uint32 gul_DecHW_WaitCount;
extern uint16 gus_dbg_DecHW_StruckCount;

#ifdef DEBUG_DEC_ADAPT
extern uint32 gula_dbg_DecSetting[20];
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

void ControlDECAdaptation(void)
{
   int32 i;
   int16 s_txPmdFrameCnt;

   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      s_txPmdFrameCnt = gs_TxPMDFrameCnt;
   }
   else
   {
      s_txPmdFrameCnt = gs_MuxFrameCntTxFastPath;
   }

   if (guc_DECAdaptationState == DEC_ADAPTATION_INITIALIZE)
   {
      /* Set up to determine RX/TX frame alignment and superframe count. */
      guc_DECAdaptationState = MEASURE_ALIGNMENT;

      guc_DECRxCaptureFlag = START;
      /* Select TX frame offset as late as possible to make sure that the TX */
      /* TC task sets capture done flag in the frame following the one where */
      /* capture occurs. */
      gs_DECAdaptationTxOffset = 3 * (gs_TxFrameLength >> 2);
      //In the probing phase, set Isample capture length to 1 and Isample capture offset the same as Esample offset to avoid error bit set in V_DEC_CAPTURE register.
      //Even though we are not interested in the ISAMPLE capture here.
      gs_DECTxDataCaptureLength =1;
      gs_DECAdaptationInputCaptureOffset = gs_DECAdaptationTxOffset;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, LoadDECAdaptationTxOffset);
#ifdef ADSL_62
      // these two buffers are common to BIS/DMT
      gpsa_DECAdaptationTxData = (int16 *) &gsa_deccapturedata[2*DEC_RX_DATA_CAPTURE_LEN];

      /* Make sure that DEC data accumulation array starts at the 32 bit word boundary. */
      gpla_DECAdaptationRxDataAccum = (int32 *)(void *)gsa_deccapturedata;
      // XDSLRTFW-576: IOP_DS_BisPlus_ALL_LinkDropADMAError (start_end)
      gft_Dec_Init = TRUE;
#endif
   }
   else if (guc_DECAdaptationState == MEASURE_ALIGNMENT)
   {
      /* Wait for Rx data capture to be completed. */
      if (guc_DECRxCaptureFlag == DONE)
      {

         /* Find the frame count of the first TX frame that needs to be captured. */
         /* We capture 3 TX frames, the TX frame during which the RX data is      */
         /* captured and 2 preceeding ones. The offset of 6 frames from the       */
         /* current frame count is due to the following:                          */
         /* 1. guc_DECRxCaptureFlag is set to DONE one frame after the last TX    */
         /* frame we need to capture (i.e., 3 frames after the first one).        */
         /* 2. IFFT output buffer that we read at IFFT_DONE interrupt contains    */
         /* data that will be sent the following frame (adds 1 frame latency).    */
         /* 3. AddFunctionToFifo loads function in the next time critical task    */
         /* (1 frame latency).                                                    */
         /* 4. The IFFT_DONE interrupt is enabled on the frame boundary following */
         /* the EnableIFFTDoneInt() write to CRI register (1 frame latency).      */

         gs_DECTxDataCaptureStartCnt = s_txPmdFrameCnt - 7;
         //set ISAMPLE capture length
            gs_DECTxDataCaptureLength = gs_DECLengthPerPhase - 1 + (DEC_RX_DATA_CAPTURE_LEN >> gs_Log2DECUpsamplingFactor);

            //put capture offset calcultation in background
            guc_CalcDECCaptureOffsetFlag = START;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)CalcDECCaptureOffset);

         /* Limit the TX data capture frame count to [0, 68] range. */
         if (gs_DECTxDataCaptureStartCnt < 0)
            gs_DECTxDataCaptureStartCnt += TX_SYMBOLS_PER_SFRAME+1;

#ifdef ADSL_62
         /* Initialize buffer for Rx data accumulation. */
         memset(gpla_DECAdaptationRxDataAccum, 0, DEC_RX_DATA_CAPTURE_LEN*sizeof(int32));
#endif
         guc_DECAdaptationState = CALC_CAPTUREOFFSET;
      }
   }

   else if (guc_DECAdaptationState == CALC_CAPTUREOFFSET)
   {
      if (guc_CalcDECCaptureOffsetFlag == DONE)
      {
         /* Set up to start averaging Rx data. */
         guc_DECAdaptationState = AVERAGE_RX_DATA;
         guc_DECRxCaptureFlag = START;

         gs_DECAdaptationCnt = 0;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, LoadDECAdaptationTxOffset);
      }
   }
   else if (guc_DECAdaptationState == AVERAGE_RX_DATA)
   {
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation (Start)
      if ((gft_ModemType == G_DMT_BIS && gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE) ||
          (gft_ModemType == G_DMT))
      {
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation (End)
         /* Wait for Rx data capture to be completed and for RX synch frame to be */
         /* processed to make sure it is not corrupted. Flag indicating corrupt synch */
         /* frame is updated in the same RX TC task as the flag indicating synch symbol */
         /* change so below comments regarding flag validity holds here too. */
         if ((guc_DECRxCaptureFlag == DONE) && (gs_RxPMDFrameCnt_FftFdqBufferSymbol == 0))
         {
            if (gft_CorruptedSynchFrame == FALSE)
            {
               /* Accumulate Rx data if not corrupted. */
               for (i = 0; i < DEC_RX_DATA_CAPTURE_LEN; i++)
               {
                  gpla_DECAdaptationRxDataAccum[i] += (int32)gsa_DECAdaptationRxData[i];
               }
               gs_DECAdaptationCnt++;
            }
            else
            {
               /* Reset the flag for next superframe. */
               gft_CorruptedSynchFrame = FALSE;
               //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
               gula_dbg_DecSetting[8] += 1;
#endif //#ifdef DEBUG_DEC_ADAPT
               //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
            }

            if (gs_DECAdaptationCnt == (1 << OPTNArray[OPTN_Log2NumShowtimeDECTrainingSymbols]))
            {
               /* If accumulation is done, compute the average. */
               for (i = 0; i < DEC_RX_DATA_CAPTURE_LEN; i++)
               {
                  gsa_DECAdaptationAvgRxData[i] = (int16)(gpla_DECAdaptationRxDataAccum[i] >> OPTNArray[OPTN_Log2NumShowtimeDECTrainingSymbols]);
               }

               /* Set up for DEC adaptation. */
               guc_DECAdaptationState = CAPTURE_TRAINING_DATA;
               //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
               gs_DECTxDataCaptureFrameCnt = DEC_TX_CAPTURE_DURATION + 1;
               guc_DECRxCaptureFlag = WAIT;
               guc_DECTxCaptureFlag = WAIT;
            }
            else
            {
               guc_DECRxCaptureFlag = START;
            }
         }
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation(Start)
      } //if
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation (End)
   }
   else if (guc_DECAdaptationState == CAPTURE_TRAINING_DATA)
   {
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation (Start)
      if ((gft_ModemType == G_DMT_BIS && gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE) ||
          (gft_ModemType == G_DMT))
      {
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation (End)

         if (s_txPmdFrameCnt == gs_DECTxDataCaptureStartCnt)
         {

            /* Disable DD Processing for the duration of this instantaneous MIPs peak */
            if (gs_DD_NumFramesProcDisable < DEC_TX_CAPTURE_DURATION ) gs_DD_NumFramesProcDisable = DEC_TX_CAPTURE_DURATION ;

            gs_DECAdaptationCnt = 0;
            guc_DECRxCaptureFlag = START;
            guc_DECTxCaptureFlag = START;
            /* Trigger the count. */
            gs_DECTxDataCaptureFrameCnt = 0;
         }
         else if (gs_DECTxDataCaptureFrameCnt < DEC_TX_CAPTURE_DURATION + 1)
         {
            /* Count if triggered. */
            gs_DECTxDataCaptureFrameCnt++;
         // XDSLRTFW-3479(Start)
            if (((gft_TxOutBandSignalEnable == TRUE) /* anxB decadapt */ ) && (gft_BlockOOBSignal_BecauseOf_OngoingUSOLR ==  FALSE))   /* Don't start.Stop for TxOOBSignal if US OLR-msg is ongoing */
         // XDSLRTFW-3479(End)
            {
               if (gs_DECTxDataCaptureFrameCnt == 2)
               {
                  /* Start sending outband signal (next frame). */
                  //for adsl_62, account for one symbol delay between TXQT and Strymon
                  AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableOutBandSignalInsertion);
               }

               else if (gs_DECTxDataCaptureFrameCnt == 5)
               {
                  /* Stop sending the outband signal (next frame). */
                     AddFunctionToFifo(gp_TxLoadingFunctionFifo, DisableOutBandSignalInsertion);
               }
            }

            if (gs_DECTxDataCaptureFrameCnt >= DEC_TX_CAPTURE_DURATION)
            {
               /* Three frames were captured. Mark the end of TX data capture. */
               if (guc_DECTxCaptureFlag == ACTIVE)
                  guc_DECTxCaptureFlag = DONE;
            }
         }

         /* Wait for TX and RX data capture to be completed and for RX synch frame to be */
         /* processed. RX synch frame is processed at RX frame count 68 so if the flag */
         /* indicating synch symbol change is not set by RX frame count 0 we can use */
         /* current data for DEC updates. Note that this also holds if we are in L2 power */
         /* management state since the standard (Section 8.7.6.) specifies that current */
         /* synch frame has gain scaling and power cutback values as applicable in the L2 */
         /* power management state (i.e., can be used for DEC updates) iff L2 exit */
         /* sequence is not completed by frame 67. Note that the used RX frame count gets */
         /* updated in the same RX TC task which is used for inverted synch symbol and */
         /* L2 exit sequence detections. */
         if ((guc_DECTxCaptureFlag == DONE) && (guc_DECRxCaptureFlag == DONE) && (gs_RxPMDFrameCnt_FftFdqBufferSymbol == 0))
         {
            if (gft_SynchSymbolChange == FALSE)
            {

            //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
               if (((gft_CorruptedSynchFrame == FALSE) &&
                    (gft_frame_with_noisypilot == 0)
#ifndef ISDN
               && (gs_RxAvMargin >= 0x0300)
#endif
               )
                   ||(gft_enable_new_adaptation == TRUE)
                  )
               {
                  /* If synch symbol did not change or get corrupted, calculate DEC */
                  /* coefficient update in background. */
                  guc_DECAdaptationState = DEC_COEF_UPDATE;
                  guc_DECCoefUpdateFlag = START;
                  AddFunctionToBkgdFifo((PtrToBkgdFunc) UpdateDECCoef);
               }
               else
               {
                  //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
                  if (gft_CorruptedSynchFrame)
                     gula_dbg_DecSetting[5] += 1;
                  if (gft_frame_with_noisypilot)
                     gula_dbg_DecSetting[6] += 1;
                  if (gs_RxAvMargin < 0x0300)
                     gula_dbg_DecSetting[7] += 1;
#endif //#ifdef DEBUG_DEC_ADAPT

                  /* Synch symbol got corrupted so capture another one. */
                  gs_DECTxDataCaptureFrameCnt = DEC_TX_CAPTURE_DURATION + 1;
                  //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
                  guc_DECRxCaptureFlag = WAIT;
                  guc_DECTxCaptureFlag = WAIT;
                  gft_CorruptedSynchFrame = FALSE;
               }
            }
            else
            {
               /* Synch symbol has changed so restart the DEC update process. */
               guc_DECAdaptationState = AVERAGE_RX_DATA;
               memset(gpla_DECAdaptationRxDataAccum, 0, DEC_RX_DATA_CAPTURE_LEN*sizeof(int32));
               guc_DECRxCaptureFlag = START;
               gs_DECAdaptationCnt = 0;
               gft_SynchSymbolChange = FALSE;
            }
         }
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation (Start)
      } // if
      // XDSLRTFW-913: Bug_ALL_DmtAndT1413_EnaDecAdaptation (End)
   }
   else if (guc_DECAdaptationState == DEC_COEF_UPDATE)
   {
      if (guc_DECCoefUpdateFlag == DONE)
      {
         guc_DECAdaptationState = DEC_COEF_DOWNLOAD;
         guc_DECCoefDnloadFlag = START;
      }
   }
   else if (guc_DECAdaptationState == DEC_COEF_DOWNLOAD)
   {
      if (guc_DECCoefDnloadFlag == DONE)
      {
         // Set up for DEC adaptation.
         guc_DECAdaptationState = CAPTURE_TRAINING_DATA;
         //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
         gs_DECTxDataCaptureFrameCnt = DEC_TX_CAPTURE_DURATION + 1;
         guc_DECRxCaptureFlag = WAIT;
         guc_DECTxCaptureFlag = WAIT;
         guc_DECCoefDnloadFlag = WAIT;
         gus_ShowtimeDECUpdateCount++;

         //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
         gul_DecHW_WaitCount = 0;

         // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
         if (gft_SkipDECDownload == TRUE) {
            gft_SkipDECDownload = FALSE;

            guc_DECAdaptationState = AVERAGE_RX_DATA;
            guc_DECRxCaptureFlag = START;
            gs_DECAdaptationCnt = 0;
            gft_SynchSymbolChange = FALSE;
         }
         // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
      }
      else
      {
         //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
         if (gul_DecHW_WaitCount > DEC_HW_WAIT_STATE_THRESHOLD)
         {
            gft_SkipDECDownload = TRUE;
            gul_DecHW_WaitCount = 0;
            gus_dbg_DecHW_StruckCount++;
         }
         //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
         // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
         //To prevent Mips peaking
         if (gft_SkipDECDownload != TRUE)
         {
            // XDSLRTFW-2458: BugFix_LinkDropAfter10secInSTwith_ADTRAN_DSLAM
            //Do the DEC coefficient downloading in NTC task to avoid TS violation in plus mode
            DownloadDECCoef();
         }
         else
         {
            gul_NumDECSkip++;
            guc_DECCoefDnloadFlag = DONE;
            guc_DECCoefDnloadState = LOAD_TDQ;
         }
         // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
      }
   }
}

#ifndef ADSL_62
/***************************************************************************************
;  Subroutine Name: GetDECAdaptationTxData
;
;  Description:
;     This function saves a Tx frame to be used for showtime
;     DEC adaptation.
;
;  Prototype:
;     void GetDECAdaptationTxData(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;**********************************************************************************************/
void GetDECAdaptationTxData(void)
{
#ifdef PROFILE_TASKS
   LogMips(ST_TX_TC_IFFT, TC_NTC_START_FLAG);
#endif

   guc_DECTxCaptureFlag = ACTIVE;

   /* Disable bit reversed addressing of the IFFT output buffer. */
   Disable_IFFT_Reordering();

   /* Get the TX data. */
   GetTxOutBuffer(&(gpsa_DECAdaptationTxData[gs_DECAdaptationCnt]), gs_TxFftLength);
   gs_DECAdaptationCnt += gs_TxFftLength;

   /* Re-enable bit reversed addressing of the IFFT output buffer. */
   Enable_IFFT_Reordering();

#ifdef PROFILE_TASKS
   LogMips(ST_TX_TC_IFFT, TC_NTC_END_FLAG);
#endif
}
#endif  //#ifndef ADSL_62
