/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  dec_adap_b.c
;
;  Background function for showtime DEC coefficient update
;
;***************************************************************************/
//***************************************************************************
// dec_adap_b.c
//
// History
// 16/08/2011 ChihWen/Bhadra:
//          1. Finding a max delta Lp which fulfills the framing limitation during framing calculation.
//          2. Cap the delta Lp with the max delta Lp before requesting SRA.
//          3. Enabling chamber IOP bit (OPTN 25 bitmask(0x8000)) for FDQ/SNR adaptation.
//          4. Enabling dynamic threshold for DEC adaptation.
//          5. Masking the code of freezing PLL/SNR/FDQ adaptation since
//              the noise boosting will be up to 27 dB
//          Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//***************************************************************************
#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "ec_data.h"
#include "dec_adap_Data.h"
#include "mul.h"

// MAX_MISMATCH sets the max noise threshold for DEC coefficient update.
///#define MAX_MISMATCH    (20000)
int32 gl_MAX_MISMATCH = (20000)*10 ;
int32 gl_energy_error;
#ifdef DEBUG_SHOW_DECADAPT
int16 jgTrig = 1;
int32 *jgPtr = (int32 *)0x170c00;
#endif
//SMS00855577 SMS00927039 FEATURE_DS_ALL_ALL_IdentifyTimeVariantNoise (Begin)
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (Start)

DATA_BULKO1_BEGIN
#ifndef  ISDN  // Only for Annex - A
static int32 gl_max_energy_error = 0;
static int32 gl_min_energy_error = 0x7fffffff;
static int32 gl_avg_energy_error = 0;
static int32 gl_new_MAX_MISMATCH = (40000);
static int32 l_max_energy_error = 0;
static int32 l_min_energy_error = 0x7fffffff;
static int32 l_avg_energy_error = 0;
static int16 gs_dec_cnt = 0;
#endif
DATA_MAP_END//DATA_BULKO1_BEGIN
//SMS00855577 SMS00927039 FEATURE_DS_ALL_ALL_IdentifyTimeVariantNoise (End)
//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
/***************************************************************************************
;  Subroutine Name: UpdateDECCoef
;
;  Description:
;     This function updates the DEC coefficients via LMS.
;
;  Prototype:
;     void UpdateDECCoef(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;**********************************************************************************************/
void UpdateDECCoef(void)
{
   int32 i, j, k;
   int16 *psa_error;
   int32 l_Phase;
   int32 l_CoefIdx;
   int32 l_error, l_tmp, l_tmp2, l_error_sq;
   int16 s_CoefMSW;
   uint16 us_CoefLSW;

   guc_DECCoefUpdateFlag = ACTIVE;

#ifndef ADSL_62
   /* Insert the cyclic prefix into the captured data and extract needed samples. */
   /* Variable l_TxDataStart holds the start index of the TX data with cyclic */
   /* prefix that affects the captured error samples. */
   l_TxDataStart = 2 * gs_TxFrameLength + gs_DECAdaptationTxOffset - gs_pre_dec_h_delay - gs_DECLengthPerPhase + 1;
   for (i = 0; i < gs_DECTxDataCaptureLength; i++)
   {
      /* Find frame index (k) and sample index (j) within a frame with cyclic prefix. */
      k = 0;
      j = l_TxDataStart + i;
      while (j >= gs_TxFrameLength)
      {
         j -= gs_TxFrameLength;
         k++;
      }

      /* Find sample index in the captured IFFT output buffer. */
      j -= gs_TxCPLength;
      if (j < 0)
      {
         j += gs_TxFftLength;
      }
      MULS16(l_tmp2, k, gs_TxFftLength);
      j += l_tmp2;

      /* Copy needed samples to the beginning of the buffer. */
      gpsa_DECAdaptationTxData[i] = gpsa_DECAdaptationTxData[j];
   }
#endif
   gl_energy_error = 0;

   /* Form error signal. */
   psa_error = (int16*)gsa_DECAdaptationRxData;
   for (i = 0; i < DEC_RX_DATA_CAPTURE_LEN; i++)
   {
      /* Compute error and saturate to 16 bits. */
      l_error = (int32) gsa_DECAdaptationRxData[i] - gsa_DECAdaptationAvgRxData[i];
      psa_error[i] = sature16(l_error);
#ifdef DEBUG_SHOW_DECADAPT
      if (jgTrig & 1) {
         jgPtr[i] = gsa_DECAdaptationRxData[i];
      }
#endif

      MULS16(l_error_sq, psa_error[i], psa_error[i]);

      // Max magnitude of l_error_sq is 0x40000000.
      // Max magnitude of gl_energy_error is 0x3FFFFFFF.
      // Hence sum will not overflow during this accumulation.
      gl_energy_error += l_error_sq;

      // Limit sum to avoid overflow on the next iteration.
      if(gl_energy_error > 0x3FFFFFFFL) gl_energy_error = 0x3FFFFFFFL;

      /* Update the running average. */
      if (psa_error[i] > 0)
      {
         gsa_DECAdaptationAvgRxData[i] += 1;
      }
      else if (psa_error[i] < 0)
      {
         gsa_DECAdaptationAvgRxData[i] -= 1;
      }
   }
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
   //SMS00855577 SMS00927039 FEATURE_DS_ALL_ALL_IdentifyTimeVariantNoise (Begin)
   //To avoid the impact of on/off time-variant noise to DEC adaptation, here dynamic measure
   //the max/min residual echo noise power for every 64 DEC adaptation time, and update the threshold
   //as four times of min residual echo noise power.
#ifndef  ISDN  // Only for Annex - A
   gs_dec_cnt++;
   if (gl_energy_error > l_max_energy_error)
      l_max_energy_error = gl_energy_error;
   if (gl_energy_error < l_min_energy_error)
      l_min_energy_error = gl_energy_error;
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
   l_avg_energy_error += (gl_energy_error >> 7);
   if (gs_dec_cnt == 128)
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
   {
      gl_max_energy_error = l_max_energy_error;
      gl_min_energy_error = l_min_energy_error;
      gl_avg_energy_error = l_avg_energy_error;

      l_max_energy_error = 0;
      l_min_energy_error = 0x7fffffff;
      l_avg_energy_error = 0;

      gl_new_MAX_MISMATCH = gl_min_energy_error << 2;
      if (gl_new_MAX_MISMATCH > gl_max_energy_error)
         gl_new_MAX_MISMATCH = gl_max_energy_error;
      if (gl_new_MAX_MISMATCH > 10000000)
         gl_new_MAX_MISMATCH = 10000000;
      gs_dec_cnt = 0;
   }
   #if 0 //TODO: enable this while adding "FEATURE_DS_ALL_ALL_IdentifyTimeVariantNoise"
   if (gft_TimeVariantNoise == TRUE)
      gl_MAX_MISMATCH = gl_new_MAX_MISMATCH;

   if (gft_TW_HomeMadeLoop_12K == TRUE)     //SMS00928078 PERF_A_DS_CNXT_Plus_Stability (Start_End)
      gl_MAX_MISMATCH = gl_new_MAX_MISMATCH;
   #endif
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
   if (gft_enable_new_adaptation == TRUE)
      gl_MAX_MISMATCH = gl_new_MAX_MISMATCH;
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)

#endif
    //SMS00855577 SMS00927039 FEATURE_DS_ALL_ALL_IdentifyTimeVariantNoise (End)
    //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)

#ifdef DEBUG_SHOW_DECADAPT
   jgTrig &= 0xFFFE ;
#endif
   //If gl_energy_error >= MAX_MISMATCH, then we bypass DEC coefficient update

   if(gl_energy_error < gl_MAX_MISMATCH )
   {
      /* Update DEC coefficients. */
      for (l_Phase = 0; l_Phase < gs_DECUpsamplingFactor; l_Phase++)
      {
         for (k = 0, l_CoefIdx = l_Phase; k < gs_DECLengthPerPhase; k++, l_CoefIdx+=gs_DECUpsamplingFactor)
         {
            l_tmp = 0;
            for (i = 0, j = l_Phase; i < (DEC_RX_DATA_CAPTURE_LEN >> gs_Log2DECUpsamplingFactor); i++, j+=gs_DECUpsamplingFactor)
            {
               /* Compute DEC coefficient correction (gradient) in 2.30 format. */
               MULS16(l_tmp2, psa_error[j], gpsa_DECAdaptationTxData[gs_DECLengthPerPhase-1+i-k]);
               l_tmp += l_tmp2;
               /* Saturate DEC coefficient correction. */
               if (l_tmp > 0x3FFFFFFFL)
                  l_tmp = 0x3FFFFFFFL;
               else if (l_tmp < -0x40000000L)
                  l_tmp = -0x40000000L;
            }
            /* Round and shift DEC coefficient correction. */
            l_tmp = (l_tmp + (1 << (gs_DECAdaptExp - 1))) >> gs_DECAdaptExp;

            /* Calculate new DEC coefficient (2.30 format to avoid overflow). */
            us_CoefLSW = gpusa_pre_dec_h_lsw[l_CoefIdx];
            s_CoefMSW = gsa_pre_dec_h[l_CoefIdx];
            if (us_CoefLSW > 0x7FFF)
            {
               s_CoefMSW--;
            }
            l_tmp = ((((int32)s_CoefMSW << 16) | (int32)us_CoefLSW) >> 1) - l_tmp;

            /* Saturate new DEC coefficient. */
            if (l_tmp > 0x3FFFBFFFL)
               l_tmp = 0x3FFFBFFFL;
            else if (l_tmp < -0x40000000L)
               l_tmp = -0x40000000L;

            /* Convert from 2.30 to 1.31 format. */
            l_tmp <<= 1;

            /* Store new DEC coefficient. */
            gsa_pre_dec_h[l_CoefIdx] = (int16) ((l_tmp + 0x8000) >> 16);
            gpusa_pre_dec_h_lsw[l_CoefIdx] = (uint16)l_tmp;
         }
      }
   }
   guc_DECCoefUpdateFlag = DONE;
   guc_EcTrainingState = TRAINING_DONE;
}


/***************************************************************************************
;  Subroutine Name: CalcDECCaptureOffset
;
;  Description:
;     This function Calculate the DEC ISAMPLE and ESAMPLE capture offsets in background.
;
;  Prototype:
;     void CalcDECCaptureOffset(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;**********************************************************************************************/
void CalcDECCaptureOffset(void)
{
   /* Get RX/TX frame alignment (as a number of TX samples). With the initial */
         /* TX offset of 3/4 of the frame, the RX/TX frame alignment (calculated */
         /* from the beginning of the TX frame where the capture starts) resides in */
         /* the range (-3/4, 1/4] of the frame. */
         /* gs_RxTxFrameAlign is measured in Txsample rate */
         gs_RxTxFrameAlign = (gs_DECAdaptationRxOffset >> gs_Log2DECUpsamplingFactor) - gs_DECAdaptationTxOffset;

         //We need a long input data (231 samples for 4.4 mhz and 464 for 2.2 mhz) to get the FW LMS algorithm to work.
         //The error capture length is only 64 sample. To ensure input sample capture to be completed before the error sample is completed,
         //ITOFS_ER is programmed such that the error capture happens in the middle of a sync symbol and
         //ITOFS_IN is programmed such that the input capturing and error capturing finishes at the same sample.

         //calculate capture strobe (ITOFS_ER) for the error sample, (gs_TxFrameLength >> 1) =>midde of the RX frame
         gs_DECAdaptationTxOffset =  (gs_TxFrameLength >> 1) - gs_RxTxFrameAlign;

         if (gs_DECAdaptationTxOffset >= gs_TxFrameLength )
            gs_DECAdaptationTxOffset = gs_DECAdaptationTxOffset - gs_TxFrameLength;

            //calculate capture strobe (ITOFS_IN) for dec input sample
         gs_DECAdaptationInputCaptureOffset = gs_DECAdaptationTxOffset + (DEC_RX_DATA_CAPTURE_LEN >> gs_Log2DECUpsamplingFactor) - gs_DECTxDataCaptureLength;
         if(gs_DECAdaptationInputCaptureOffset<0)
            gs_DECAdaptationInputCaptureOffset += gs_TxFrameLength;


         //The code below forces ISAMPLE capure to cover two DMT symbols. It is supposed to assist the LMS to converge if ISMAPLES contains
         //the transition from a symbol to another
         //The Esample capture offset is shifted correspondingly. But we also don't want Esample capture is too close to the start of a frame
         //Therefore the shifts are not symmetrical.
         if (0)
         {
            if (gs_DECAdaptationInputCaptureOffset < 2*DEC_RX_DATA_CAPTURE_LEN)
            {
               gs_DECAdaptationInputCaptureOffset += 2*DEC_RX_DATA_CAPTURE_LEN;
               gs_DECAdaptationTxOffset  += 2*DEC_RX_DATA_CAPTURE_LEN;

               if (gs_DECAdaptationTxOffset >= gs_TxFrameLength )
                  gs_DECAdaptationTxOffset = gs_DECAdaptationTxOffset - gs_TxFrameLength;
            }
            else if (gs_TxFrameLength-gs_DECAdaptationInputCaptureOffset <DEC_RX_DATA_CAPTURE_LEN )
            {
               gs_DECAdaptationInputCaptureOffset -= DEC_RX_DATA_CAPTURE_LEN;
               gs_DECAdaptationTxOffset  -= DEC_RX_DATA_CAPTURE_LEN;

               if(gs_DECAdaptationTxOffset<0)
                  gs_DECAdaptationTxOffset += gs_TxFrameLength;
            }
         }

   guc_CalcDECCaptureOffsetFlag = DONE;
}
