/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  enc_gain.c
;
;  This file contains routine of computing encoder gain.
;
;***************************************************************************/
// *************************************************************************
// enc_gain.c
//
// History
//
// 11/08/2010 Nihar/Bhadra: Its found that against Conexant E67 & D79 firmware versions in T1.413 mode
//            needs US pilot tone, but the CPE firmware by default only sends this on the
//            Sync frames. This leads to link drop immediately after reaching Showtime.
//            The fix is 'not' to send zero gain on the US pilot tone (16) in T1.413 mode
//            against Conexant CO. This fix is CMV controlled, and can be disabled by
//          cw INFO 103 0 0x1000
//            Grep for IOP_T1413_CNXT_SendValidGainOnUSPilot
//
// 11/08/2010 Ram/Bhadra: Added CNXT D57 Vendor ID to the above fix which sends valid gain on US Pilot
//            against D57 in addition to E67 and D79 versions in T1.413 mode.
//            Grep for IOP_US_T1413_CNXT_AddD57ToUSPilotFix

// *************************************************************************
#include "common.h"
#include "dsp_op.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "bitload_const.h"
#include "mul.h"

/*^^^
*-------------------------------------------------------------------
*
*   Prototype:
*     void CalcEncodGain(int16 *psa_BAT, int16 *psa_FineGain, int16 *psa_TxCombinedGains);
*
*  Description:
*     Compute the combined encoder gain for each channel,
*     where each gain is computed as the multiplication of constellation gain
*     and the upstream (US) fine gain for that channel.
*
*  Input Arguments:
*     psa_BAT -- pointer to the bit allocation table for US channel
*     psa_FineGain -- pointer to the fine gain table for US channel
*
*  Return:
*     psa_TxCombinedGains[]   -- (O) Combined decoder gains
*
*  Global Variables:
*     gsa_QAMEncGainTab[]     -- (I) QAM decoder constellation gain table
*     gsa_TxCombinedGains[]   -- (O) Combined decoder gains
*
*-------------------------------------------------------------------
*^^^
*/
C_SCOPE void CalcEncodGain(uint8 *psa_BAT, int16 *psa_FineGains, int16 *psa_TxCombinedGains)
{
   int i, s_ch, s_qc;
   int16 s_gain;
   int32 l_Acc;

   if (( gl_SelectedMode & (MODE_ADSL2)  )) /* Adsl2 mode */
   {
      /* Note: Gain scaling and constellation mapping for blackout tones is vendor descritionary */
      /* Zero out the fine gains and hence the combined gains for blackout tones */
      for (i=0 ; i<gs_TxNumTones ; i++)
      {
         if (!IS_TONEFLAGSET(gp_MEDLEYset_US, i))
            psa_FineGains[i] = 0;
      }
   }

   for(s_ch=gs_TxFirstChannel; s_ch<=gs_TxLastChannel; s_ch++) {

      /* Get the contellation size (bit loading) for this channel */
      s_qc = psa_BAT[s_ch];

      if(   s_qc == 0 &&                                 /* Unloaded Tone */
         !(( gl_SelectedMode & (MODE_ADSL2)  )))   /* Not Adsl2 Mode */
      {
         psa_TxCombinedGains[s_ch] = 0;
      }
      else
      {

         /* Get the QAM decoder constellation gain for this channel */
         s_gain = gsa_QAMEncGainTab[s_qc];

         /* ========================================================= */
         /* Compute the combined gain = s_gain*TxFineGain */
         /* ========================================================= */
         MULS16(l_Acc,s_gain , psa_FineGains[s_ch]);
         l_Acc = round(l_Acc, 13);
         psa_TxCombinedGains[s_ch] = sature16(l_Acc);
      }
      // R3_P1: AR8_TF: IOP_T1413_CNXT_SendValidGainOnUSPilot (Start)
#ifndef ISDN   // Only for Anx-A
      // Its found that against Conexant E67 & D79 firmware versions in T1.413 mode
      // needs US pilot tone, but the CPE firmware by default only sends this on the
      // Sync frames. This leads to link drop immediately after reaching Showtime.
      // The fix is 'not' to send zero gain on the US pilot tone (16) in T1.413 mode
      // against Conexant CO.
      // R3_P1: AR8_TF: IOP_US_T1413_CNXT_AddD57ToUSPilotFix
      if ((s_qc == 0) &&
          ((!(gt_INFX_CMV.us_OperatorSpBits & CMV_TO_DISABLE_USPILOT_CNXT)) &&
           (STATArray[STAT_Mode] & STAT_ConfigMode_T1413) &&
           ((gs_fe_T1413_VendorID == T1413_GSI_ID) ||
            (gs_fe_T1413_VendorID == T1413_GSI_ID2)) && (s_ch == 16)))
      {
         /* Get the QAM decoder constellation gain for this channel */
         s_gain = gsa_QAMEncGainTab[s_qc];

         /* ========================================================= */
         /* Compute the combined gain = s_gain*TxFineGain */
         /* ========================================================= */
         MULS16(l_Acc, s_gain, psa_FineGains[s_ch]);
         l_Acc = round(l_Acc, 13);
         psa_TxCombinedGains[s_ch] = sature16(l_Acc);
      }
#endif // ifndef ISDN
      // R3_P1: AR8_TF: IOP_T1413_CNXT_SendValidGainOnUSPilot (End)
   }
}

