/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  tx_sb.c
;
;  This file contains functions for producing the synchronization byte for
;   the transmitter.
;
;***************************************************************************/

#include "common.h"
#include "gdata.h"
#include "tx_aoc.h"
#include "rt_state.h"
#include "ib.h"
#include "rx_ib.h"
#include "tx_ib.h"
#include "eoc.h"
#include "rx_eoc.h"
#include "tx_eoc.h"



/*****************************************************************************
;  Subroutine Name: Tx_Mode3OH_Handler(...)
;
;  This subroutine calls different handlers to produce the framing mode 3
;   overhead byte  (containing SI, AOC or EOC message) based on input frame number.
;  It also updates the TX super frame count.
;
;  Prototype:
;     uint8 Tx_Mode3OH_Handler(int16 s_frame_number);
;
;  Input Arguments:
;     s_frame_number -- TX frame number
;
;  Output Arguments:
;     none
;
;  Return:
;     framing mode 3 overhead byte transmitted in this frame.
;
;  Global Variables:
;     gs_bitswap_tx_sframe_count    -- (I/O) super frame count.
*******************************************************************************/
uint8 Tx_Mode3OH_Handler(int16 s_frame_number)
{
   int16 i;
   uint8 uc_byte;

   /* Decide the content of the synch byte based on the frame number */
   if(s_frame_number == 0) {

      /* place 0 for CRC byte */
      uc_byte = 0;
   }

   /* Generate Indicator Bits (IB) byte */
   else if((s_frame_number == 1) || (s_frame_number == 34) || (s_frame_number == 35)) {

      uc_byte = TxIbHandler(s_frame_number);
   }
   /* Generate either AOC or EOC byte */
   else {

      i = s_frame_number&0x3;
      if(i<2) {

         /* return AOC byte */
         uc_byte = TxAocHandler(s_frame_number);
      }
      else {

         /* return EOC byte */
         uc_byte = TxEocHandler(s_frame_number);
        }
   }
   return(uc_byte);
}

