/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcAvgMargin.c
*
*   Average SNR margin calculation
*
*-------------------------------------------------------------------------
*/


// ****************************************************************************
// CalcAvgMargin.c
//
// History
// 19/12/2011 Balabath: Noise margin test (NMCPE A224) is fail on Lucent linecard models AP72 and AP72-HBI.
//                      Reported margin of 9dB in Annex L mode after reaching showtime. In Annex L modes OPTNArray[OPTN_MarginDelta]
//                      is kikcing in and value is set to 0x0300. (ie.,3dB). And this value is considered twice while
//                      calculating the average margin.once @ ComputeMarginPerTone and also after the function call of
//                      "ComputeMarginPerTone" (In file CalcAvgMargin.c@fn CalcAvgMrgInnerLoop). Hence we report the wrong margin.
//                      Reason for failing the margin test is, during the bitloading we do bit allocation with 3dB desired margin.
//                      (ie., targetmargin (6dB) - OPTNArray[OPTN_MarginDelta](3dB)). So we really don't have margin of 6dB.)
//                      It seems we pass Noise margin verfication test with OPTNArray[OPTN_MarginDelta] value of 2dB.
//                      Hence change 2dB for CNXT to reduce the imapct on performance.
//                      Grep for XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification.
//
// 21/12/2011 Raghu:Stress test (FT stress test) has a marginal fail (1.07 e-07 instead of 1.0 e-07) on the
//                      Lucent Stinger linecard A2P72-HBI.
//                      1) Increase number of frames used for SNR averaging from 512 to 2048 When the margin
//                      goes below 2dB.
//                      2) Block size used for updating SNR and FDQ are inreased from 32 to 48 to reduces the
//                      response time which got increased due to increase in the frames used for averaging.
//                      Currently this is enabled only for CNXT DSLAMS.
//                      For code changes grep for XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest
//
// 26/03/2014 Balabath:XDSLRTFW-1564 /XDSLRTFW-1665 - Avoid declaring LOM from CPE side, in particular when no
//                NearEnd CRCs are observed by removing the ceiling on the 15 bit loaded tones. This is required to avoid
//                second retrain in FT evoultive test cases as well unnecessary LOM reboot.
//                for code changes grep for " XDSLRTFW-1564 / XDSLRTFW-1665"
//
// ****************************************************************************


#include "typedef.h"

#include "common.h"
#include "gdata.h"
#include "gdata_dmt.h"
#include "gdata_bis.h"
#include "bitload2.h"
#include "pll.h"

#include "trail.h"
#include "cmv.h"
#include "bitload_const.h"
#ifdef DANUBE
#ifdef TARGET_HW
#include "dataswap.h"
#endif
#endif
#include "memory.h"

/*^^^
*-----------------------------------------------------------------------------
*   Prototype:
*     int16 CalcAvgMargin(int16 *psa_RxToneOrder, int16 *psa_SnrBuf, int16 *psa_RxBat, int16 *psa_RxFineGains,  FlagT ft_OneTone, int16 s_toneidx)
*
*   Description:
*       Computes Average margin
*
*   Input Parameters:
*
*  Output Parameters:
*
*   Returns:
*     Average SNR Margin adjustment in 8.8 format
*
*  Global variables:
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE int16 CalcAvgMrgInnerLoop(int i_phase)
{
   int i;
   int16 s_CodingGain, s_AvMargin, s_LoadedToneIdx=-1;
   int16 s_ch, s_Margin = 0;
   int16 s_RxMinMargin, s_RxMinMarginTone = 0;
   int16 s_RxChannelsAllocated = 0;
   int32 l_TotalMargin = 0;
   int32 l_TotalMarginNoCap = 0;
   int16 s_tempsnr;
   int16 *psa_RxToneOrder;
   int i_bi;
   int16 s_RxMaxMargin, s_RxMaxMarginTone = -1;
#ifdef DANUBE
#ifdef TARGET_HW
   int16 sa_RxMgnMiniBuf[2];
   int32 l_RxMgnSdramAddr;
#endif
#endif

   if (i_phase == 2)    // Logging is only done for second phase
   {
   if (gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_RXMARGINPERTONE)
   {
#ifdef DANUBE
#ifdef TARGET_HW
      /* Init reg with direct access external SDRAM address */
      l_RxMgnSdramAddr = ADSL_IMAGE_BASE_ADDR + XMEM_RX_MARGIN_BUF_ADDR;
      gus_DataBuf_InXmem |= RX_MARGIN_BUF_IN_XMEM;

#endif
#else   //#ifdef DANUBE
         gt_debugTrailCollectControl.s_debugTrailLen=0;
         // clear entries of statestrail
         memset(&gsa_StatesTrail, 0, sizeof(int16) * gt_debugTrailCollectControl.s_debugTrailSize);
#endif
      }
   }

   /* Initialize to largest number */
   s_RxMinMargin = (int16)0x7fff;
   s_RxMaxMargin = (int16)0x8000;
   /* We need to go through all possibly bitloaded tones because in G992.2 the tones are not reordered */
   psa_RxToneOrder = (int16*)(gsa_RxToneOrder + gs_RxLastChannel);

   //for(i=gs_RxLastChannel ; i>=gs_RxFirstChannel; i--)
   for( i=gs_RxLastChannel-gs_RxFirstChannel ; i>=0; i--)
   {
      /* Get physical tone index */
      s_ch = *psa_RxToneOrder--;

      /* Skip for the DD pilot tone */
      if (s_ch == gs_AuxPilotToneIdx || s_ch == gs_CPilotTone)
         continue;
      i_bi = guca_RxBat[s_ch];

      if(i_bi > 0)
      {
         // In phase 1, skip over b=15 tones.
         if ((i_phase == 2) || (i_bi < RX_MAX_BITS_PER_TONE))
         {
         s_LoadedToneIdx++;

         if ((gl_SelectedMode & MODE_ADSL2) == 0) // DMT
            {
               /* Compute coding gain for this tone*/
               if(s_LoadedToneIdx <= gs_MaxToneForFast)
               {
                  s_CodingGain = gsa_TotalCodingGain[FAST_DATA_PATH];
               }
               else
               {
                  s_CodingGain = gsa_TotalCodingGain[INTERLEAVE_DATA_PATH];
               }
            }

            else if ((gt_rx_config.s_Nlp==2)&& (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,s_ch)))

               s_CodingGain = gsa_TotalCodingGain[FAST_DATA_PATH ];
            else

               s_CodingGain = gsa_TotalCodingGain[INTERLEAVE_DATA_PATH];

            s_tempsnr = gsa_RxShowtimeSnrBuf[s_ch];

            /* Compute the average margin (SNR[ch] - gsa_ConstellationSNR[ch] + s_FineGain) */
            s_Margin = ComputeMarginPerTone(s_tempsnr, (int16) i_bi, gsa_RxFineGains[s_ch], &s_RxChannelsAllocated);

            /* Add coding gain and noise separation SNR adjustment. */
            s_Margin += s_CodingGain ;


            // else ft_MarginforOneTone == FALSE

            if (i_phase == 2)    // Logging is only done for second phase
            {
#ifdef DANUBE
#ifdef TARGET_HW
            /* Record the margin per tone during showtime only if flag set */
            if ((gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_RXMARGINPERTONE) && (s_ch < RX_NUM_TONES))
            {
               // Read a 32-bit longword from Rx Margin Buffer in SDRAM into local buffer
               // Modified one 16-bit word with rx margin data
               // Write back the 32-bit longword to SDRAM
               // NOTE: external SDRAM only supports 32-bit longword write
               *(int32*)sa_RxMgnMiniBuf = *(int32*)(l_RxMgnSdramAddr + (s_ch & ~1)*2);
               sa_RxMgnMiniBuf[s_ch&1] = s_Margin;
               *(int32*)(l_RxMgnSdramAddr + (s_ch & ~1)*2) = *(int32*)sa_RxMgnMiniBuf;
            }
#endif
#else //#ifdef DANUBE
            /* Record the margin per tone during showtime only if flag set */
               if ((gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_RXMARGINPERTONE) && (s_ch <= gt_debugTrailCollectControl.s_debugTrailSize) )

               *(INFOMap[INFO_DebugTrail] + s_ch) = s_Margin;
#endif
            }
            /* Always record the min margin value and corresponding tone */
            if (s_Margin < s_RxMinMargin)
            {
               s_RxMinMargin = s_Margin; /* Least margin for a loaded tone */
               s_RxMinMarginTone = s_ch;  /* Loaded tone with the least margin */
            }
            if (s_Margin > s_RxMaxMargin)
            {
               s_RxMaxMargin = s_Margin; /* max margin for a loaded tone */
               s_RxMaxMarginTone = s_ch;  /* Loaded tone with the max margin */
            }

            l_TotalMarginNoCap += (int32)(s_Margin);  // XDSLRTFW-1564 / XDSLRTFW-1665(Start_End)

            // For second phase, limit the margin of b=15 tones.
            if ((i_phase == 2) && (i_bi == RX_MAX_BITS_PER_TONE))
            {
               if (s_Margin > gs_MarginLimit)
                  s_Margin = gs_MarginLimit;
            }
            l_TotalMargin += (int32)(s_Margin);
         }
      } // if psa_RxBat[...
   } //for(...

   if (i_phase == 2)
   {
      // Disable the margin collection, once it is collected
      gt_debugTrailTriggerControl.s_logType &= ~(DEBUG_LOG_RXMARGINPERTONE);

      // Update global variables.
      gs_RxMinMargin = s_RxMinMargin;
      gs_RxMinMarginTone = s_RxMinMarginTone;
      gs_RxMaxMargin = s_RxMaxMargin;
      gs_RxMaxMarginTone = s_RxMaxMarginTone;
   }
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (Start)
   if (i_phase == 1)
      gus_ToneNumNon15Bits = (uint16)s_RxChannelsAllocated;
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (End)
   //XDSLRTFW-1564 / XDSLRTFW-1665(start)
   if (s_RxChannelsAllocated == 0)
   {
      // This can only happen for phase1 call if all bits have b=15.  In that
      // case we want gs_MarginLimit to be set to a large number.
      s_AvMargin = 0x7FFF;
      gs_RxAvMarginNoCap = 0x7FFF;
   }
   else
   {
      /*gs_RxAvMargin = TotalMargin/RxChannelsAllocated in Q8.8 */
      s_AvMargin = QuickAverage(l_TotalMargin, s_RxChannelsAllocated);
      if((i_phase == 2)&&(gft_FTMarginTune == TRUE))
         gs_RxAvMarginNoCap = QuickAverage(l_TotalMarginNoCap, s_RxChannelsAllocated);

   }
   //XDSLRTFW-1564 / XDSLRTFW-1665(end)
   return(s_AvMargin);

}



/*^^^
*-----------------------------------------------------------------------------
*   Prototype:
*     int16 CalcAvgMargin(int16 *psa_RxToneOrder, int16 *psa_SnrBuf, int8 *puca_RxBat, int16 *psa_RxFineGains)
*
*   Description:
*       Computes Average margin
*
*   Input Parameters:
*
*  Output Parameters:
*
*   Returns:
*     Average SNR Margin adjustment in 8.8 format
*
*  Global variables:
*
*-----------------------------------------------------------------------------
^^^*/
int8 guc_Log2NumShowtimeSNRTrainingSymbols = 9;


C_SCOPE int16 CalcAvgMargin(void)
{
   //XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest (start_end)
   // initialised to a high value
   int16 s_AvMargin = 100*256;
   int16 s_MinMargin;
   int16 s_Margin;
   int32 l_margin;
   int16 s_interp1;
   int16 s_interp2;

   //XDSLRTFW-1564 / XDSLRTFW-1665(start)
   if((gt_INFX_CMV.us_SRA_IOP_Bits & CMV_FOR_MARGIN_ON_15BITS_TONES)
      &&((gft_AutoSRA_ErrorCondition == TRUE)&&(gl_SelectedMode & MODE_ADSL2))
      )
      gft_FTMarginTune = TRUE;

   gs_MarginLimit = CalcAvgMrgInnerLoop(1);
   gs_RxAvMarginOnNon15bits = gs_MarginLimit; //XDSLRTFW-2066
#if 0
   //XDSLRTFW-1564 (start)
   if((gt_INFX_CMV.us_SRA_IOP_Bits & CMV_FOR_MARGIN_ON_15BITS_TONES)
      &&(gft_AutoSRA_ErrorCondition == TRUE)
      &&(gs_RxAvMargin < (gs_RxDesiredMargin >>1))
      )
      {
         gs_MarginLimit = 0x7fff; // Don't cap margin on 15 bit loaded tones
      }
   //XDSLRTFW-1564 (end)
#endif
   s_AvMargin = CalcAvgMrgInnerLoop(2);
   gs_RxAvMarginWithCap = s_AvMargin;
   if(gft_FTMarginTune)
   {
      // derive weightage factors
      // Max cap to TargetMargin
      s_Margin = MIN(gs_RxDesiredMargin,gs_RxAvMarginWithCap);
      // Min cap to MinMargin
      // "gs_RxMinRequestedSTMargin " is in 1dB steps.
      s_MinMargin = gs_RxMinRequestedSTMargin*256;
      s_Margin = MAX(s_Margin,s_MinMargin);//256 for 8.8 format
      s_Margin -= s_MinMargin;
      //s_interp1 = (uint16)((s_Margin*32)/gs_RxDesiredMargin); // 32 is weightage factor (TODO: think replacement for division).
      s_interp1 =  QuickAverage((s_Margin*32), ((gs_RxDesiredMargin-s_MinMargin) >> 7)); //retruns in 9.7 format
      // take only integer portion.
      s_interp1 = s_interp1 >> 7;
      s_interp2 = 32 - s_interp1;
      l_margin = ((gs_RxAvMarginWithCap*s_interp1)+(gs_RxAvMarginNoCap*s_interp2));
      s_Margin = (int16)(l_margin >> 5);
      // MIN and MAX checks on the reported margin.
      s_Margin = MAX(gs_RxAvMarginWithCap,s_Margin);
      s_Margin = MIN(gs_RxAvMarginNoCap,s_Margin);
      gs_ReportMargin = s_Margin;
      s_AvMargin = s_Margin;
   }
   //XDSLRTFW-1564 / XDSLRTFW-1665(end)


    // XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest (start)
    // Increase number of frames used for SNR averaging from 512 to 2048
    // When the margin goes below 2dB
    // Currently this is enabled for CNXT DSLAMS. This changes is needed for all CO's in the future.
    // Basic assumption is once margin goes to 0dB the probablity of decision erros increses.
    // So increasing the number of frames for SNR estimate can reduce the variance in SNR estimate.

   guc_Log2NumShowtimeSNRTrainingSymbols = OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols];
   if ((gs_CurrentCoChipset == GSI_CO_CHIPSET)&&
        (gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_EXTRA_Log2NumShowtimeSNRTrainingSymbols)
       )
    {
        int8 tmp = 0;
      if (s_AvMargin <= 2*256)
      {
         tmp = 2;
         guc_Log2NumShowtimeSNRTrainingSymbols = OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols]+tmp;
      }
   }
   // XDSLRTFW-358 Enh_DS_BisPlus_CNXT_StressTest (end)



   return(s_AvMargin);
}



