/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodeCInfo1.c
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// DecodCInfo1.c
//
// History
//
// 08/07/10  Nihar: Added code to resolve the interop issues with ADI/Anaconda in DMT/RA/Fast mode
//              Disable CO rate generation and CO calculation of DS framing parameters
//             by setting Ncloaded (Number of DS tones loaded) to "0"
//             If Target margin in C-MSG-1 is not correct estimate DS min-margin and do retrain
//             with correct min-margin if estimation was wrong
//             grep for "IOP_DS_DMT_ADI_SendNcloadedEqualToZero"
//
// 27/07/09 Nihar/Bhadra: Bug fix for initializing the gs_CurrentCoChipset
//                 in T1.413 mode.
//                 Grep for IOP_ALL_T1413_ALL_AddVendID
//
// 26/07/2010 Ram/Bhadra:   Added vendor ID for CNXT D57 T1.413 Vendor ID
//                 Grep for IOP_CNXT_T1413_ALL_AddD57VendID
// 12/08/2010 Nihar: Switch the vender ID in T1413 mode to TI VID
//                   if the CO is Siemens. This improves US rates in long loops.
//                   Grep for IOP_A_US_T1413_OldIFX_SwitchToTIVID
//
// 12/08/2010 Nihar: Bug fix for initializing the gs_CurrentCoChipset
//                 in T1.413 mode.
//                 Grep for IOP_ALL_T1413_ALL_AddVendID
//
//
// 10/01/2012 Kannan: 17/04/08 Hanyu: Parsed CO vendor ID for CNXT O.69 and TI 4000C in T1.413.
//                 Added a flag to emulate 64pt IFFT for CNXT and TI 4000C
//                 in T1.413 to get the same performance as G.dmt.
//                 Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//          1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//          After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//          Then CPE will select the first option from the C-RatesRA.
//          2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//       incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//       Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//       frame sync and TDQ calculation incorrect.
//       The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//       zero response for the reference tones.
//          3. Change near-end vendor ID to "AWARE" to improve US rate.
//          4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//       so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//          Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement.
//
// 08/02/2012:US rates are very low (~400kbps) upto 2km with Ikanos ISAM NVLT-C in T1413 mode.
//            This appears to be Ikanos TEQ problems. Problems were seen even after merging
//            XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement. Options
//            analogcutback,64 tone FFT etc., didn't help. VendorID change to TI resolves this.
//            And also clear the variable "gft_NVLTC_T1413_fix" in persistent memory.
//       For code changes Grep for XDSLRTFW-414 Enh_US_T1413_TIVID_Switch
//03/09/2012: Anantha:  Changed variable name prefix to reflect change in data type
//Grep pattern XDSLRTFW-496: Feature_T1413_Info
//
// 24/03/14 Hanyu: Ported ADSLRTFW-745 (SMS00778928): Retrain for CTLM VID so that we can send the TI VID
//                 Grep for: XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID
// 10/04/2014 Sriram Shastry: Parse T1.413 CO vendor ID for ECI Pulsecom DSLAM at AT&T lab.
//                        Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// ******************************************************************

#include "common.h"
#include "tx_ops.h"
#include "gdata.h"
#include "showinit.h"
#include "synsymbl.h"
#include "ib.h"
#include "DecodCInfo1.h"
#include "mp.h"
#include "cmv.h"

#include "bitload.h"
#include "ghs.h"
#include "tone_ord.h"
#include "DSLEngin.h"
#include "dec_adap.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "T1413.h"
#include "states.h"
#include "trail.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 DecodCInfo1(void);
*
*   Abstract:
*       Decode C_MSGS1 and C_RATES1 message received from ATU-C
*
*   Input Parameters:
*     none
*
*  Return:
*     Error Code:
*        NO_DECODE_ERROR            -- no error
*        FRAME_MODE_ERROR           -- Frame Mode != 3
*
*  Global Variables:
*     guca_R_C_Msgs1 -- (I) packed C_MSGS1 received from ATU-C
*     gt_RCMsgs1     -- (O) structure containing decoded C_MSGS1 messages
*
*-----------------------------------------------------------------------------
^^^*/

int16 DecodCInfo1(void)
{
   int16 i, j, s_OptionIdx;
   int16 s_error_code = NO_DECODE_ERROR;
   uint16 *pus_DS_ReqBytes = NULL, *pus_US_ReqBytes = NULL;
   uint8 *puc_DS_CheckBytes, *puc_US_CheckBytes;

    #ifdef DANUBE
    uint32   ul_fe_VendorID_Standard;
    #endif

    /* ================================================================= */
   /* Decode C_RATES1 information */
   /* ================================================================= */
    s_OptionIdx = 0;

   for(i=0; i<4; i++) {

      /* Bf and Bi field */
      for(j=0; j<2; j++) {
         if(j == 0) {
            pus_DS_ReqBytes = &gta_DS_options[i].pus_ReqBytes[FAST_DATA_PATH*NUM_DS_BEARER_CHANNELS];
            pus_US_ReqBytes = &gta_US_options[i].pus_ReqBytes[FAST_DATA_PATH*NUM_US_BEARER_CHANNELS];
         } else if (j == 1) {
            pus_DS_ReqBytes = &gta_DS_options[i].pus_ReqBytes[INTERLEAVE_DATA_PATH];
            pus_US_ReqBytes = &gta_US_options[i].pus_ReqBytes[INTERLEAVE_DATA_PATH];
         }

         *pus_DS_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* AS0 */
         *pus_DS_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* AS1 */
         *pus_DS_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* AS2 */
         *pus_DS_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* AS3 */
         *pus_DS_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* LS0 */
         *pus_DS_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* LS1 */
         *pus_DS_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* LS2 */

         *pus_US_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* LS0 */
         *pus_US_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* LS1 */
         *pus_US_ReqBytes++ = (int16) guca_R_C_Rates1[s_OptionIdx++];    /* LS2 */
      }

      /* RRSI: */
        puc_DS_CheckBytes = &gta_DS_options[i].puc_CheckBytes[FAST_DATA_PATH];
      *puc_DS_CheckBytes    = guca_R_C_Rates1[s_OptionIdx++] & 0x3F;       /* RSf */

        /* A check that we had for 0<= RSf, RSi <=63 is not critical (options in C_RATES1 are not used)
         Since some Centillium CO's send 128 (ala format of C_RatesRA) the checks are removed so as not to fail on them */

        puc_DS_CheckBytes = &gta_DS_options[i].puc_CheckBytes[INTERLEAVE_DATA_PATH];
        *puc_DS_CheckBytes    = guca_R_C_Rates1[s_OptionIdx++] & 0x3F;       /* RSi */

        gta_DS_options[i].uc_S  = guca_R_C_Rates1[s_OptionIdx++];       /* S  */
        gta_DS_options[i].us_D  = (uint16)guca_R_C_Rates1[s_OptionIdx++];       /* I */

        s_OptionIdx++;  /* for FS(LS2) */

        puc_US_CheckBytes = &gta_US_options[i].puc_CheckBytes[FAST_DATA_PATH];
      *puc_US_CheckBytes    = guca_R_C_Rates1[s_OptionIdx++] & 0x3F;       /* RSf */

        puc_US_CheckBytes = &gta_US_options[i].puc_CheckBytes[INTERLEAVE_DATA_PATH];
        *puc_US_CheckBytes    = guca_R_C_Rates1[s_OptionIdx++] & 0x3F;       /* RSi */

        gta_US_options[i].uc_S  = guca_R_C_Rates1[s_OptionIdx++];       /* S  */
        gta_US_options[i].us_D  = (uint16) guca_R_C_Rates1[s_OptionIdx++];       /* I */

        s_OptionIdx++;  /* for FS(LS2) */
   }

   /* Decode C_MSGS1 */
    /* m0 to m3, Maximum numbers of bits per sub-carrier supported */
   gt_RCMsgs1.us_MaxBitsPerTone = (uint16)(guca_R_C_Msgs1[0] & 0xF);

   /* Set the maximum number of bits per tone allocated to DS channel */
    if(gt_RCMsgs1.us_MaxBitsPerTone < (uint16)guc_Log2MaxConstSize)
      guc_MaxAllocBitsPerTone = (uint8)gt_RCMsgs1.us_MaxBitsPerTone;
   else
      guc_MaxAllocBitsPerTone = guc_Log2MaxConstSize;

    /* m6 to m8, Transmit PSD during initialization */
   gt_RCMsgs1.us_PSDLevel = (uint16)((guca_R_C_Msgs1[1] & 0x1) << 2) | ((guca_R_C_Msgs1[0] >> 6) & 0x3) ;

    /* m9 to m10, Framing Mode */
    gt_RCMsgs1.us_FrameMode = (uint16)(guca_R_C_Msgs1[1] >> 1) & 0x3;

    /* m11 NTR */
   gt_RCMsgs1.us_NTR_Option = (uint16)(guca_R_C_Msgs1[1] >> 3) & 0x1 ;

   // m15 Ees
   if(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)
      gt_RCMsgs1.uc_T1413_Ees = (guca_R_C_Msgs1[1] >> 7) & 0x1;

    /* m16, Echo cancelling option */
   gt_RCMsgs1.us_EC_Option = (uint16)(guca_R_C_Msgs1[2] & 0x1);

    /* m17, Trellis Coding Option */
    gt_RCMsgs1.us_TrellisCoding_Option = (uint16)((guca_R_C_Msgs1[2] >> 1) & 0x1);

 #ifdef DANUBE
      if (gft_ModemType ==G_DMT)
      {

            ul_fe_VendorID_Standard  = (uint32)guca_fe_G9941_VendorID[2] << 24 ;
            ul_fe_VendorID_Standard |= (uint32)guca_fe_G9941_VendorID[3] << 16 ;
            ul_fe_VendorID_Standard |= (uint32)guca_fe_G9941_VendorID[4] << 8 ;
            ul_fe_VendorID_Standard |= (uint32)guca_fe_G9941_VendorID[5] ;

            if( ul_fe_VendorID_Standard == (uint32) GHS_ADI_ID)
            {
                // use the reserved field to tell the differnce between ADI930 and Anaconda
            gt_RCMsgs1.us_T1413_Vendor_Id = ((guca_R_C_Msgs1[3] >> 4) & 0xF) + (guca_R_C_Msgs1[4] << 4) + ((guca_R_C_Msgs1[5] & 0xF) << 12); //m28-43
            if (gt_RCMsgs1.us_T1413_Vendor_Id == 0) //ANCDA_CO
               guca_fe_G9941_VendorID[6] =0x40;
            else if (gt_RCMsgs1.us_T1413_Vendor_Id == T1413_ADI_ID) //ADI 9xx CO
                  guca_fe_G9941_VendorID[6] =0x30;
            }
      }

#endif
    // R3_P1: AR8_TF: PERF_US_T1413_T1&CNXT_64ptIFFT (Start)
#ifndef ISDN   // Only for Anx-A
    gft_Enable_IFFT64_T1413 = 0;
#endif // ifndef ISDN
    // R3_P1: AR8_TF: PERF_US_T1413_T1&CNXT_64ptIFFT (End)

   if( STATArray[STAT_Misc] &  STAT_T1413_Signal_Detected)
   {
         //XDSLRTFW-496: Feature_T1413_Info (start)
      gt_RCMsgs1.us_T1413_Vendor_RevNo = (guca_R_C_Msgs1[2] >> 2) & 0x1F;     //m18-22
      gt_RCMsgs1.us_T1413_RevNo = ((guca_R_C_Msgs1[2] >> 7) & 0x1) + ((guca_R_C_Msgs1[3] & 0x6) << 1);   //m23-25
      //XDSLRTFW-496: Feature_T1413_Info (end)
        gt_RCMsgs1.us_T1413_Vendor_Id = ((guca_R_C_Msgs1[3] >> 4) & 0xF) + (guca_R_C_Msgs1[4] << 4) + ((guca_R_C_Msgs1[5] & 0xF) << 12); //m28-43

      // We may want to populate for other vendors. Currently BDCOM identification is necessary for sync frame pwr issue
        if (gt_RCMsgs1.us_T1413_Vendor_Id == 0x4D54)
        {
            gs_CurrentCoChipset = BDCM_CO_CHIPSET;
        }
        // IOP_ALL_T1413_ALL_AddVendID (Start)
        switch (gt_RCMsgs1.us_T1413_Vendor_Id)
        {
#ifndef ISDN   // Only for Anx-A
        case T1413_BRCM_ID:
            gs_CurrentCoChipset = BDCM_CO_CHIPSET;
            break;

        case T1413_BRCM_ERICY_ID:
            gs_CurrentCoChipset = BDCM_CO_CHIPSET;
            break;

        case T1413_IFTN_ID:
            gs_CurrentCoChipset = IFTN_CO_CHIPSET;
            // IOP_A_US_T1413_OldIFX_SwitchToTIVID (START_END)
            gft_IFTN_T1413LongLoop_TIVID = 1;
            break;

        case T1413_GSI_ID:
        case T1413_GSI_ID1:
        case T1413_GSI_ID2:  // IOP_CNXT_T1413_ALL_AddD57VendID
            gs_CurrentCoChipset = GSI_CO_CHIPSET;
             gft_Enable_IFFT64_T1413 = 1; // R3_P1: AR8_TF: PERF_US_T1413_T1&CNXT_64ptIFFT
            break;

        case T1413_CTLM_COPPER_ID:
             //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
             // If we see this specific CTLM VID, reset the modem
             // and send the TSTC VID next time
             if (gft_USCRC_CTLM == 0)
             {
                gft_USCRC_CTLM = 1;
                //Drop the link using exception handler.
                gus_ExceptionCode = E_CODE_IOP_CHANGE_VID_TSTC;
                gs_RxNextState = FAIL_RX;
                gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
             }
             //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)
             /* no break */
        case T1413_CTLM_ID:
            gs_CurrentCoChipset = CTLM_CO_CHIPSET;
            break;

        case T1413_ALA_ID:
            gs_CurrentCoChipset = ALA_CO_CHIPSET;
            break;

        case T1413_TI_ID:
            gs_CurrentCoChipset = TI_CO_CHIPSET;
             // R3_P1: AR8_TF: PERF_US_T1413_T1&CNXT_64ptIFFT
             if (gt_RCMsgs1.us_EC_Option)
                gft_Enable_IFFT64_T1413 = 1;
            break;

        case T1413_ADI_ID:
            gs_CurrentCoChipset = ADI_CO_CHIPSET;
            break;

        case T1413_AWRE_ID:
            gs_CurrentCoChipset = AWRE_CO_CHIPSET;
            break;
            // in T1.413-mode a 0x00 vendor-ID indicates:
            //      - a new Geminax version:      IFTN DSLAM  (older version send out SIEMENS vendor ID)
            // (open: Does CTLM always send out a valid vendor ID in T1.413 mode?)
        case T1413_VENDOR_ID:
            if(gt_RCMsgs1.uc_T1413_Ees == 1)
            gs_CurrentCoChipset = IFTN_CO_CHIPSET;
            else // LU FS/CNXT-O.69 DSLAM sends VID=0 and EES = 0 in T1.413 C-MSGS1
            {
                gs_CurrentCoChipset = GSI_CO_CHIPSET;
                gft_Enable_IFFT64_T1413 = 1;
            }
            break;
         //XDSLRTFW-414 Enh_US_T1413_TIVID_Switch (start)
         case T1413_IKANOS_ID:
            gs_CurrentCoChipset = IKNS_CO_CHIPSET;
            break;
         //XDSLRTFW-414 Enh_US_T1413_TIVID_Switch (end)
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START)
          case T1413_ECI_ID:
             gs_CurrentCoChipset = ECI_PLSE_CO_CHIPSET;
             break;
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (END)
#endif
        default:
            gs_CurrentCoChipset = GENERIC_CO_CHIPSET;
            break;
        }
        // IOP_ALL_T1413_ALL_AddVendID (End)

      //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
#ifndef ISDN   // Only for Anx-A
      // If we switched from the CTLM_COPPER to a different CO, set our VID
      // back to normal
      // SMS00820159 BugFix_All_T1413_All_CorrectVarDec (Start_End)
      if ((gt_RCMsgs1.us_T1413_Vendor_Id != T1413_CTLM_COPPER_ID) &&
          (gft_USCRC_CTLM))
      {
         gft_USCRC_CTLM = 0;
         //Drop the link using exception handler.
         gus_ExceptionCode = E_CODE_IOP_RESET_CHANGE_VID_FLAG;
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
      }
#endif
      //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)

//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
//Reboot to enable the fix for improving performance against NVLT-C in T1413 mode.
#ifndef ISDN   // only for Anx-A
      //if (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)//already checked out side if cond line221
      //{
         if ((gt_RCMsgs1.us_T1413_Vendor_Id != 0x53) && (gft_NVLTC_T1413_fix == TRUE))
         {
            gft_NVLTC_T1413_fix = FALSE;
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
         }

         if ((gt_RCMsgs1.us_T1413_Vendor_Id == 0x53) && (gft_NVLTC_T1413_fix == FALSE))
         {
            gft_NVLTC_T1413_fix = TRUE;
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
         }
      //}
#endif
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
      // Geminax Co sends 0x0 as T1413 vendor id and their older fw used to send 0x4c.
      // turn off dec adaptation for geminax
      /* Certain older Gmx FW versions use PAR reduction on the sync frames.  This interferes
      with our DEC adaptation so we disable adaptation for those versions.*/

        if ((gt_RCMsgs1.us_T1413_Vendor_Id == 0x0) || (gt_RCMsgs1.us_T1413_Vendor_Id == 0x4c)){
         OPTNArray[OPTN_AlgControl] |= OPTN_DECAdaptDisable;
      }

      //save it into gs_fe_T1413_VendorID
        gs_fe_T1413_VendorID = gt_RCMsgs1.us_T1413_Vendor_Id;



#ifdef  T1413_SUPPORT_EES_OFF
      if((gt_RCMsgs1.uc_T1413_Ees == 1) && (gt_RMsgs1.uc_T1413_Ees == 1))
         gft_T1413_EesFlag = TRUE;
      else
         gft_T1413_EesFlag = FALSE;
#endif
   }

    /* m44 to m47, Minimum required SNR margin */
    gt_RCMsgs1.us_MinRequiredSnrMargin = (uint16)(guca_R_C_Msgs1[5] >> 4) & 0xF;
   gs_RxDesiredMargin = (gt_RCMsgs1.us_MinRequiredSnrMargin)<<8;/* desired SNR margin in Q8.8 format */

#ifdef ISDN
   // IOP_DS_DMT_ADI_SendNcloadedEqualToZero (Start)
   //    For ADI and ANCD CO in Fast-path / Rate-Adaptive we:
   //       - use the final target margin for R-MSG-RA rate calculation
   //       - set ncloaded to "0" to disable framing parameter generation on CO-side
    if ((gs_CurrentCoChipset == ADI_CO_CHIPSET) ||
         (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET))
    {
       if ((gs_RxDesiredMargin <= 0) &&
          ((guca_R_C_Rates1[0] != 0) &&
          (guca_R_C_Rates1[0] != guca_R_C_Rates1[90])))
       {
          gs_RxDesiredMargin = gs_Persis_TargetSNRMrg;
          gft_ADI_ANCDA_minSNR_flag = TRUE;
       }
    }
   // IOP_DS_DMT_ADI_SendNcloadedEqualToZero (End)
#endif

   /* The framing mode is set in OPTNArray     */
   gt_RMsgs1.us_FrameMode = (OPTNArray[OPTN_DMTLinkControl] & OPTN_FMMask);

   /* Choose common framing mode */
   if(gt_RCMsgs1.us_FrameMode > gt_RMsgs1.us_FrameMode)
      gft_FrameMode = gt_RMsgs1.us_FrameMode;
   else
      gft_FrameMode = gt_RCMsgs1.us_FrameMode;

   /* Set TCM flag */
   gft_TcmFlag = (uint8)gt_RCMsgs1.us_TrellisCoding_Option;
    /* If C_Rates1 indicate use of interleave path, then adjust suitably
       the assumptions for TCM coding gain, and Max coding gain.
       Defaults are 6, 7.5 dB respectively.
      But, If the CO assumes a big RS gain on top of the TCM gain,
      we might not be able to pick up the 1st/2nd DS options,
      because with the defaults we only may gain 1.5 dB RS gain
      on top of TCM.  */
    if (gft_TcmFlag == TRUE) {
       if (guca_R_C_Rates1[0] == 0) {     /* AS0[FAST]=0 -> CO uses interleave path (so far, all CO modems have consistent path in C_Rates1) */
           gs_tcm_coding_gain = gs_intlv_tcm_coding_gain ;
           gs_max_coding_gain = gs_intlv_max_coding_gain ;
       }
    }

   return (s_error_code);
}



