/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodeCInfoRA.c
*
*-------------------------------------------------------------------------
*/
//***********************************************************************
//History
//DecodCInfoRA.c
//19-02-2013 Anantha: Ikanos DSLAM sends min_avg_margin as 4dB in DMT mode hence during stress
//             test when margin drops below 4dB CPE drops with LOM failure. To avoid the
//             link restart making min_avg_margin as 0dB
//             grep for XDSLRTFW-446: IOP_DS_DMT_IKNS_LOMFailure
//***********************************************************************

#include "common.h"
#include "tx_ops.h"
#include "gdata.h"
#include "showinit.h"
#include "synsymbl.h"
#include "ib.h"
#include "mp.h"
#include "cmv.h"

#include "bitload.h"
#include "ghs.h"
#include "tone_ord.h"
#include "DSLEngin.h"
#include "dec_adap.h"
#include "exchdata.h"
#include "rinfotbl.h"









/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void DecodCInfoRA(void);
*
*   Abstract:
*       Decode C_MSG_RA and C_RATES_RA received from ATU-C
*
*   Input Parameters:
*     none
*
*  Global Variables:
*     gsa_RCMsgRA[]     - (I) packed R_C_MSG_RA information
*     guc_RCRatesRA     - (I) packed 8-bit C_RATES_RA
*     gt_RCMsgRA        - (O) structure of decoded C_MSG_RA
*     gs_US_RateOption     - (O) selected upstream rate option
*
*-----------------------------------------------------------------------------
^^^*/

void DecodCInfoRA(void)
{
   int16 i, j, s_OptionIdx;
    uint16 *pus_DS_ReqBytes = NULL, *pus_US_ReqBytes = NULL;
    uint8 *puc_DS_CheckBytes, *puc_US_CheckBytes;

   /* ================================================================= */
   /* Decode C_MSG_RA information */
   /* ================================================================= */
   gs_RxMinRequestedSTMargin = 0 ;     // In case of T1.413 link
   if ( !(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected) )
   {
      //DebugBuffer_ADSL(4,NOT_END_OF_MSG,(uint16)C_MSG_RA_DMT_MSG,R_C_MSG_RA_RX_LEN, (uint8 *)(gsa_RCMsgRA), DEBUG_BUFFER_DELIMITER_ADSL);

      /* m32 to m37: Max. allowed downstream SNR margin at initialization and in steady state (in (-32,31) range) */
      gt_RCMsgRA.us_MaxDSSnrMargin = (uint16)(gsa_RCMsgRA[4] & 0x3F);

      /* Set the variable for excess margin reduction (Q8.8 format). Note: Double shift takes care of the sign. */
      gs_RequestedRxMaxMargin = (int16)(gt_RCMsgRA.us_MaxDSSnrMargin << 10) >> 2;

      /* m38 to m43: min. required DS SNR margin in steady state */
      gt_RCMsgRA.us_MinRequiredSSDSSnrMargin = (uint16)(gsa_RCMsgRA[4]>>6);
      gt_RCMsgRA.us_MinRequiredSSDSSnrMargin |= (uint16)((gsa_RCMsgRA[5] & 0xF)<<2);

      gs_RxMinRequestedSTMargin  = gt_RCMsgRA.us_MinRequiredSSDSSnrMargin;
      if (gs_RxMinRequestedSTMargin & 0x20) {      // It's a signed number -> negative
         gs_RxMinRequestedSTMargin |= 0xFFC0 ;     // Sign extend
      }
   }
    //XDSLRTFW-446: IOP_DS_DMT_IKNS_LOMFailure (start_end)
   if((gs_CurrentCoChipset == IKNS_CO_CHIPSET) && (gft_ModemType == G_DMT)){
      gs_RxMinRequestedSTMargin = 0;
   }

   /* m44 to m47: New minimum required DS SNR margin at initialization */
   gt_RCMsgRA.us_MinRequiredInitDSSnrMargin = (uint16)(gsa_RCMsgRA[5]>>4);

   /* set variable for bitloading */
   gs_RxDesiredMargin = (gt_RCMsgRA.us_MinRequiredInitDSSnrMargin)<<8;

   /* Max margin information is optional in G.dmt, disable excess margin reduction if information is invalid. */
   if (gs_RequestedRxMaxMargin < gs_RxDesiredMargin)
      gs_RequestedRxMaxMargin = (64*256);

   /* ================================================================= */
   /* Decode C_RATES_RA information */
   /* ================================================================= */
    s_OptionIdx = 0;

   for(i=0; i<4; i++) {

      /* Bf and Bi field */
      for(j=0; j<2; j++) {
         if(j == 0) {
            pus_DS_ReqBytes = &gta_DS_options[i].pus_ReqBytes[FAST_DATA_PATH*NUM_DS_BEARER_CHANNELS];
            pus_US_ReqBytes = &gta_US_options[i].pus_ReqBytes[FAST_DATA_PATH*NUM_US_BEARER_CHANNELS];
         } else if (j == 1) {
            pus_DS_ReqBytes = &gta_DS_options[i].pus_ReqBytes[INTERLEAVE_DATA_PATH*NUM_DS_BEARER_CHANNELS];
            pus_US_ReqBytes = &gta_US_options[i].pus_ReqBytes[INTERLEAVE_DATA_PATH*NUM_US_BEARER_CHANNELS];
         }

         *pus_DS_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* AS0 */
         *pus_DS_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* AS1 */
         *pus_DS_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* AS2 */
         *pus_DS_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* AS3 */
         *pus_DS_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* LS0 */
         *pus_DS_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* LS1 */
         *pus_DS_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* LS2 */

         *pus_US_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* LS0 */
         *pus_US_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* LS1 */
         *pus_US_ReqBytes++ =  gsa_RCRatesRA[s_OptionIdx++];    /* LS2 */
      }

      /* RRSI: in downstream direction */
        puc_DS_CheckBytes = &gta_DS_options[i].puc_CheckBytes[FAST_DATA_PATH];
        *puc_DS_CheckBytes++   = (uint8)(gsa_RCRatesRA[s_OptionIdx++] & 0x3F);  /* RSf */
        puc_DS_CheckBytes = &gta_DS_options[i].puc_CheckBytes[INTERLEAVE_DATA_PATH];
        *puc_DS_CheckBytes++   = (uint8)(gsa_RCRatesRA[s_OptionIdx] & 0x3F);    /* RSi */

        /*  bit b7 of RSi goes into Bit B8 of Bi (AS0) */
        gta_DS_options[i].pus_ReqBytes[NUM_DS_BEARER_CHANNELS*INTERLEAVE_DATA_PATH] |= (((int16)(gsa_RCRatesRA[s_OptionIdx++] & 0x80)) << 1);

        if((gsa_RCRatesRA[s_OptionIdx] & 0x3F) == 0)
            gta_DS_options[i].uc_S = S_HALF;   /*  S = 1/2 */
        else
            gta_DS_options[i].uc_S = (uint8)(gsa_RCRatesRA[s_OptionIdx] & 0x3F);  /* S */

        /*  Bits B7 and B6 of S field go into Bits I9 and I8 of DS interleave Depth */
        gta_DS_options[i].us_D = ((gsa_RCRatesRA[s_OptionIdx++] & 0xC0) << 2);

        gta_DS_options[i].us_D |= gsa_RCRatesRA[s_OptionIdx++];    /* I */

        /* FS(LS2) */
        s_OptionIdx++;

        /* RRSI: in upstream direction */
        puc_US_CheckBytes = &gta_US_options[i].puc_CheckBytes[FAST_DATA_PATH];
        *puc_US_CheckBytes++   = (gsa_RCRatesRA[s_OptionIdx++] & 0x3F);  /* RSf */
        puc_US_CheckBytes = &gta_US_options[i].puc_CheckBytes[INTERLEAVE_DATA_PATH];
        *puc_US_CheckBytes++   = (gsa_RCRatesRA[s_OptionIdx] & 0x3F);    /* RSi */

        /*  bit b7 of RSi goes into Bit B8 of Bi (LS0) */
        gta_US_options[i].pus_ReqBytes[NUM_US_BEARER_CHANNELS*INTERLEAVE_DATA_PATH] |= (((int16)(gsa_RCRatesRA[s_OptionIdx++] & 0x80)) << 1);

        if((gsa_RCRatesRA[s_OptionIdx] & 0x3F) == 0)
            gta_US_options[i].uc_S = S_HALF;   /*  S = 1/2 */
        else
            gta_US_options[i].uc_S = (gsa_RCRatesRA[s_OptionIdx] & 0x3F);  /* S */

        /*  Bits B7 and B6 of S field go into Bits I9 and I8 of DS interleave Depth */
        gta_US_options[i].us_D = (((int16)(gsa_RCRatesRA[s_OptionIdx++] & 0xC0)) << 2);

        gta_US_options[i].us_D |= (int16) gsa_RCRatesRA[s_OptionIdx++];    /* I */

        /* FS(LS2) */
        s_OptionIdx++;

   }
}

