/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRMsgs1.c
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// FormRMsgs1.c
//
// History
//
// 12/08/2010 Nihar: Switch the vender ID in T1413 mode to TI VID
//                   if the CO is Siemens. This improves US rates in long loops.
//                   Grep for IOP_A_US_T1413_OldIFX_SwitchToTIVID
//
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//          1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//          After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//          Then CPE will select the first option from the C-RatesRA.
//          2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//       incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//       Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//       frame sync and TDQ calculation incorrect.
//       The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//       zero response for the reference tones.
//          3. Change near-end vendor ID to "AWARE" to improve US rate.
//          4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//       so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//          Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement.
//
// 08/02/2012:US rates are very low (~400kbps) upto 2km with Ikanos ISAM NVLT-C in T1413 mode.
//            This appears to be Ikanos TEQ problems. Problems were seen even after merging
//            XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement. Options
//            analogcutback,64 tone FFT etc., didn't help. VendorID change to TI resolves this.
//            And also clear the variable "gft_NVLTC_T1413_fix" in persistent memory.
//          For code changes Grep for XDSLRTFW-414 Enh_US_T1413_TIVID_Switch
//03/09/2012:Anantha:  Changed variable name prefix to reflect change in data type
//Grep pattern XDSLRTFW-496: Feature_T1413_Info
//
// 24/03/14 Hanyu: Ported ADSLRTFW-745 (SMS00778928): Retrain for CTLM VID so that we can send the TI VID
//                 Grep for: XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID
// 10/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// ******************************************************************
#include "common.h"
#include "tx_ops.h"
#include "gdata.h"
#include "showinit.h"
#include "synsymbl.h"
#include "ib.h"
#include "mp.h"
#include "cmv.h"

#include "bitload.h"
#include "ghs.h"
#include "tone_ord.h"
#include "DSLEngin.h"
#include "dec_adap.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "T1413.h"
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRMsgs1(void)
*
*   Abstract:
*       Pack R_MSGS1 to the format for transmit
*
*   Input Parameters: none
*
*  Output Parameter: none
*
*  Global Variables:
*     gt_RMsgs1      -- (I) R_MSGS1 information
*     guca_RMsgs1Tab    -- (O) packed R_MSGS1 data
*
*-----------------------------------------------------------------------------
^^^*/
void FormRMsgs1(void)
{
    int16 i;

    /* ============================================================= */
    /* Set R_MSGS1 */
    /* ============================================================= */
    for(i=0; i<R_MSG1_NUM_BYTES; i++)
    guca_RMsgs1Tab[i] = 0;

//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START)
#ifndef ISDN //Annex A only
  if ( (gs_CurrentCoChipset == ECI_PLSE_CO_CHIPSET) &&
       (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_ECI_PLSE_IOP_ATT) )
       gt_RMsgs1.us_MaxBitsPerTone = 8;
#endif
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (END)
    /* m0-m3, Max. number of bits per sub-carrier supported */
    guca_RMsgs1Tab[0] = (uint8)(gt_RMsgs1.us_MaxBitsPerTone & 0xF);

    /*  m4-m8 are reserved */
    /* The framing mode is set in OPTNArray     */
    gt_RMsgs1.us_FrameMode = (OPTNArray[OPTN_DMTLinkControl] & OPTN_FMMask);

    /* m9-m10, Framing mode */
    guca_RMsgs1Tab[1] |= (uint8)((gt_RMsgs1.us_FrameMode & 0x3) << 1);

    /* m11, Network Timing Reference */
    guca_RMsgs1Tab[1] |= (uint8)((gt_RMsgs1.us_NTR_Option & 0x1) << 3);

    if (OPTNArray[OPTN_DMTLinkControl] & OPTN_DualLatency_Disable){
        gt_RMsgs1.us_US_DualLatency = 0;
        gt_RMsgs1.us_DS_DualLatency = 0;
    }

    /* m12, support of dual latency upstream */
    guca_RMsgs1Tab[1] |= (uint8)((gt_RMsgs1.us_US_DualLatency & 0x1) << 4);

    /* m13, support of dual latency downstream */
    guca_RMsgs1Tab[1] |= (uint8)((gt_RMsgs1.us_DS_DualLatency & 0x1) << 5);

    /* m14, support of higher bit rates (S=1/2) */
    if (OPTNArray[OPTN_DMTLinkControl] & OPTN_SHALF_Disable)
    gt_RMsgs1.us_Higher_BitRates = 0;

    guca_RMsgs1Tab[1] |= (uint8)((gt_RMsgs1.us_Higher_BitRates & 0x1) << 6);

    //m15, unused and set to 1 in G992_1 and G992_2, set to EES in T1.413 Issue 2
    if(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)
    guca_RMsgs1Tab[1] |= (( gt_RMsgs1.uc_T1413_Ees & 0x1 ) << 7);
    else
    guca_RMsgs1Tab[1] |= 0x80;

    /* m16, Overlapped Spectrum Option */
    guca_RMsgs1Tab[2] = (uint8)(gt_RMsgs1.us_EC_Option & 0x1);

    /* m17, Trellis Coding Option */
    if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB)|| (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C) ||
            (OPTNArray[OPTN_AlgControl] & OPTN_TCM_Disable))
    gt_RMsgs1.us_TrellisCoding_Option = 0;

    if((gft_TcmFlag == 1) && (gt_RMsgs1.us_TrellisCoding_Option == 1)){
        gft_TcmFlag = TRUE;
        STATArray[STAT_Misc] |= STAT_TCM_DS;
        STATArray[STAT_Misc] |= STAT_TCM_US;
    }
    else
    gft_TcmFlag = FALSE;


    guca_RMsgs1Tab[2] |= (uint8)((gt_RMsgs1.us_TrellisCoding_Option & 0x1) << 1);
#ifndef ISDN    // Only for Anx-A
    // IOP_A_US_T1413_OldIFX_SwitchToTIVID (START)
   //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (START)
   if ((gft_USCRC_CTLM) ||
       (gft_IFTN_T1413LongLoop_TIVID == 1))
   //XDSLRTFW-1662 IOP_US_T1413DMT_CTLM_SendTSTCVendID (END)
    {
        gt_RMsgs1.us_T1413_Vendor_Id = 0x0004;
    }
    // IOP_A_US_T1413_OldIFX_SwitchToTIVID (END)
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
//Change near-end ID to AWARE in order to improve US rate.
   //XDSLRTFW-414 Enh_US_T1413_TIVID_Switch (start)
   if ((gt_RCMsgs1.us_T1413_Vendor_Id == 0x53) && (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected))
      gt_RMsgs1.us_T1413_Vendor_Id = T1413_TI_ID;//T1413_AWRE_ID;
   //XDSLRTFW-414 Enh_US_T1413_TIVID_Switch (end)
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
#endif  // ifndef ISDN
    if(STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)   {
      //XDSLRTFW-496: Feature_T1413_Info (start)
        guca_RMsgs1Tab[2] |= ((gt_RMsgs1.us_T1413_Vendor_RevNo & 0x1F) << 2);    //m18-m22
        guca_RMsgs1Tab[2] |= ((gt_RMsgs1.us_T1413_RevNo & 0x1) << 7);      //m23
        // Pack m24 to 31
        guca_RMsgs1Tab[3] |= (gt_RMsgs1.us_T1413_RevNo & 0x6) >> 1;        //m24-m25
      //XDSLRTFW-496: Feature_T1413_Info (end)
        guca_RMsgs1Tab[3] |= ((gt_RMsgs1.us_T1413_Vendor_Id & 0xF) << 4);        //m28-m31
        //Pack m32 to m39
        guca_RMsgs1Tab[4] |= ((gt_RMsgs1.us_T1413_Vendor_Id & 0xFF0) >> 4);      //m32-m39
        //Pack m40 to m43
        guca_RMsgs1Tab[5] |= ((gt_RMsgs1.us_T1413_Vendor_Id & 0xF000) >> 12);    //m40-m43
    }
}




