/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRRates.c
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "tx_ops.h"
#include "gdata.h"
#include "showinit.h"
#include "synsymbl.h"
#include "ib.h"
#include "mp.h"
#include "cmv.h"

#include "bitload.h"
#include "ghs.h"
#include "tone_ord.h"
#include "DSLEngin.h"
#include "dec_adap.h"
#include "exchdata.h"
#include "rinfotbl.h"







/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRRates(uint8 *puca_RRatesTab);
*
*   Abstract:
*       Pack R_RATES1 or R_RATES_RA to the byte array for transmit
*
*   Input Parameters: none
*
*  Output Parameter:
*     puca_RRatesTab -- pointer to an array of bytes containing packed rates message
*
*  Global Variables:
*     gta_US_options[]  -- (O) US rate option table
*     gta_DS_options[]  -- (O) DS rate option table
*
*-----------------------------------------------------------------------------
^^^*/
void FormRRates(uint8 *puca_RRatesTab)
{
   int16 i, s_OptionIdx;
    uint16 *pus_US_ReqBytes;
    uint8  *puc_US_CheckBytes;


   /* ============================================================= */
   /* Set R_RATES1 */
   /* ============================================================= */
   for(i=0; i<R_RATES1_NUM_BYTES; i++)
      puca_RRatesTab[i] = 0;

   s_OptionIdx = 0;

   for(i=0; i<4; i++) {

        pus_US_ReqBytes     = &gta_US_options[i].pus_ReqBytes[FAST_DATA_PATH*NUM_US_BEARER_CHANNELS];
      /* Assign Bf field: LS0, LS1, LS2 */
      puca_RRatesTab[s_OptionIdx++] = (uint8) (*pus_US_ReqBytes++);
        puca_RRatesTab[s_OptionIdx++] = (uint8) (*pus_US_ReqBytes++);
        puca_RRatesTab[s_OptionIdx++] = (uint8) (*pus_US_ReqBytes++);

        pus_US_ReqBytes     = &gta_US_options[i].pus_ReqBytes[INTERLEAVE_DATA_PATH*NUM_US_BEARER_CHANNELS];
      /* Assign Bi field: LS0, LS1, LS2 */
      puca_RRatesTab[s_OptionIdx++] = (uint8) (*pus_US_ReqBytes++);
        puca_RRatesTab[s_OptionIdx++] = (uint8) (*pus_US_ReqBytes++);
        puca_RRatesTab[s_OptionIdx++] = (uint8) (*pus_US_ReqBytes++);

      /* Set RRSI: */
        puc_US_CheckBytes   = &gta_US_options[i].puc_CheckBytes[FAST_DATA_PATH];
      puca_RRatesTab[s_OptionIdx++] = (*puc_US_CheckBytes++);   /*  RSf */
        puc_US_CheckBytes   = &gta_US_options[i].puc_CheckBytes[INTERLEAVE_DATA_PATH];
      puca_RRatesTab[s_OptionIdx++] = (*puc_US_CheckBytes++);   /*  RSi */
      puca_RRatesTab[s_OptionIdx++] = (gta_US_options[i].uc_S); /*  S */
      puca_RRatesTab[s_OptionIdx++] = (uint8) gta_US_options[i].us_D;   /*  I */

        /* FS(LS2) field is 0 */
        s_OptionIdx++;

   }
}


