/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCCrc1RxF.c
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCCrc1RxF.c
//
// History
//
// 12/01/2012 Kannan: 17/04/08   Hanyu Liu: Added code to enable HW 64pt IFFT for CNXT and TI 4000C
//            in T1.413 to get the same performance as G.dmt.
//            Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//
// 17/05/2013 Ram: Changes to improve DS data rates with CNXT chipset (Lucent Stinger)
//                 a) T1413: Switch of Tx images in loops > 16.8 Kft
//                 b) GDMT in VRX318: Reduce US Tx gain by 2dB in loops > 16.8 Kft
//                 Grep for: XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops
//                           XDSLRTFW-819: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(C-MSG1 and C-RATES1)-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "ifft_fix.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "fifo.h"
#include "RCCrc1RxF.h"
#include "cmv.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "DecodCInfo1.h"
#include "states.h"
#include "RCRates1RxF.h"
#include "RCMedleyRxF.h"
#include "trail.h"
#include "DebugBuffer.h"
#ifndef ISDN   // Only for Anx-A
// R3_P1: AR8_TF: PERF_US_T1413_T1&CNXT_64ptIFFT
#include "act_t1413.h"
#include "T1413.h"   // R3_P1: AR8_TF: IOP_ALL_ALL_ALL_T1413_Ghs_Activation_Fix
#endif // ifndef ISDN




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCCrc1RxF
 *
 *  Description: Decodes the R_C_CRC information and compares to the
 *  CRC computed on the received message.  If the CRC's
 *  match then initialization continues with next state, otherwise
 *  initialization failure is declared.
 * This function is reused by several states:
 *
 *  Prototype: void RCCrc1RxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed   - (I) R_C_CRC1 computed over received R_C_RATES1
 *      gus_RC_CRC_received   - (I/O) received R_C_CRC1
 *      gusa_PN512Tab[]     - (I) packed PRD sequence
 *      gsa_RxToneBuf[]     - (O) output of FDQ
 *      gl_RxSymbolCount    - (I) number of symbol periods in current state
 *      gs_RxNextState      - (O) RX state beginning next symbol period
 *    gs_RxState        - (I) current RX state
 *
 *  Notes: implements states R_C_CRC1_RX, R_C_CRC2_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCCrc1RxF(void) {

    uint16  us_infobit;
   int16 s_err;

#ifndef ISDN
    int32 l_fe_VendorID_Check;
#ifdef VRX318
    int32 l_temp;
#endif
#endif

    /*  clear received RC_CRC1 */
    if (gl_RxSymbolCount == 0)
   {
        gus_RC_CRC_received =  0x0000;
      gs_RxSubStateCnt = 0;
   }



    /*  get infobit */
    us_infobit = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

    /*  build received RC_CRC1 */
   gus_RC_CRC_received |=  (us_infobit << gs_RxSubStateCnt);

    /*  compare CRC's when all bits received */
   gs_RxSubStateCnt++;
   if (gs_RxSubStateCnt == R_C_CRC1_RX_LEN) {
#ifdef DEBUG_TRACES // XDSLRTFW-597
        //to differentiate between 2 messages
        if(gt_StateMachCntrl.puc_RXmessage == guca_R_C_Rates1)
        {
            LogMessages(4,NOT_END_OF_MSG,(uint16)C_RATES1_DMT_MSG,4, (uint8 *)(void *)&gul_Preamble_CMSG1, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(NOT_END_OF_MSG,R_C_RATES1_NUM_BYTES,(uint8 *)guca_R_C_Rates1, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,2,(uint8 *)(void *)(&gus_RC_CRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
        }
        else
        {
            LogMessages(4,NOT_END_OF_MSG,(uint16)C_MSG1_DMT_MSG,R_C_MSGS1_NUM_BYTES, (uint8 *)guca_R_C_Msgs1, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,2,(uint8 *)(void *)&gus_RC_CRC_received, DEBUG_BUFFER_DELIMITER_ADSL);
        }
#endif // #ifdef DEBUG_TRACES
#ifdef DEBUG_STREAMING
        //to differentiate between 2 messages
        if(gt_StateMachCntrl.puc_RXmessage == guca_R_C_Rates1)
        {
           DSH_SendStream(DSH_C_RATES1,R_C_RATES1_NUM_BYTES,&guca_R_C_Rates1[0]);
        }
        else
        {
           DSH_SendStream(DSH_C_MSG1,R_C_MSGS1_NUM_BYTES,&guca_R_C_Msgs1[0]);
        }
#endif

      /* ============================================================ */
      /* If received CRC equals to the computed CRC */
      /* ============================================================ */
        if ( gus_RC_CRC_received == gus_RC_CRC_computed ) {

         switch (gs_RxState) {

                case R_C_CRC1_RX:

                    gs_RxNextState = R_C_MSGS1_RX;
               gpF_RxStateFunc = (PtrToFunc)RCRates1RxF;
                    break;

                case R_C_CRC2_RX:

               /* Decode C_RATES1 and C_MSG1 msg. */
                    s_err = DecodCInfo1();

               if(s_err == NO_DECODE_ERROR)
               {
#ifndef ISDN   // Only for Annex-A
                  // PERF_US_T1413_T1&CNXT_64ptIFFT (START)
                  // Switch to 64IFFT after retrain when CO VID is identified in C-MSGS1:
                  //1) When CO VID is TI4000C or GlobeSpan/CNXT set gft_Enable_IFFT64_T1413
                  //2) Retrain with T1.413 as preference
                  //3) Do the emulation of 64pt IFFT by sending mirrored complex conjugate
                  //   with images in the FW during training and in the showtime by Iridia QT(data symbol)
                  //   and in the FW for sync symbol.
                  //4) Start sending 64pt IFFT Emualtion from RCEctRxF.c, This is state after RREVERB1 Tx,
                  //   Selected this state to keep the state as it was done in Danube.
                  //5) This is CMV controlled and it is enabled by default, if required it can be disabled
                  //   by MASKING(0) the bit B15 & B14 of INFO 103 27, i.e 0xC000 ==> 0x0000
                  if ( (((gft_Enable_IFFT64_T1413) && (gft_IFFT64_T1413_TxImages == 0)) ||
                        ((gft_Enable_IFFT64_T1413 == 0x0) && (gft_IFFT64_T1413_TxImages != 0))) &&
                        (STATArray[STAT_Mode] & STAT_ConfigMode_T1413) &&
                        (((gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_USE_IFFT64)>>14) == IFFT64_T1413_CNXT_TI_ENABLED) )
                  {
                     /* Restart T1.413 to reconfigure the IFFT size */
                     gs_RxNextState = FAIL_RX;
                     gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;

                     /* Set exception handler variables */
                     gus_ExceptionState = gs_RxState;
                     gus_ExceptionCode = E_CODE_RESTART_T1413;
                     guc_Ghs_fails_count = MAX_ALLOWED_GHS_FAILS; //Force to start with T.1413 first in retrain
                  }
                  // PERF_US_T1413_T1&CNXT_64ptIFFT (END)
                  else
                  {
                     //XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (Start)
                     // Extract the provider  code (Vendor ID, 4 octets), Workaround for TI  AC7/CNXT vendor ID
                     l_fe_VendorID_Check = (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) |
                                           (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);

                     if (((gs_fe_T1413_VendorID == T1413_GSI_ID)  ||
                          ((gl_SelectedMode & MODE_ADSL1) && (l_fe_VendorID_Check  == GHS_GSI_ID))) &&
                         (gs_EstimatedLoopLength > 16800)) // Looplength > 16.8Kft
                     {
                        /* Seeing some US CRC errs and US rates are more than standard requirement. Hence, Add some
                           more noise to R-Medley signal to avoid aggressive US bit loading*/
                        gt_INFX_CMV.s_med_offset += 25; //Value arrived experimentally.

                        /* Switching off tx-images in T1413 mode to improve DS data rates in loops >= 16.8Kft*/
                        if (gft_IFFT64_T1413_TxImages == 1) {
                           gft_IFFT64_T1413_TxImages = 0;
                        }
                        //XDSLRTFW-819: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (Start)
#ifdef VRX318
                        //Decrease US Tx gain by 2dB to reduce echo effect in DS, thus improving DS data rates.
                        l_temp = (int32)gus_TxSineGain*13014; //13014 => -2 dB in 2.14 format -> (-2 = 20*log10(13014/2^14))
                        gus_TxSineGain = (int16)(l_temp >> 14);
                        AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
#endif
                       //XDSLRTFW-819: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (End)
                     }
                     //XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (End)
#endif // ifndef ISDN
                     /*  Set the flag to indicate C_Info1 has been correctly received */
                     gft_RCExch1RcvFlag = RECEIVE_OK1;
                     gs_RxNextState     = R_C_MEDLEY_RX;
                     gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF;
#ifndef ISDN   // Only for Annex-A
                  }
#endif // ifndef ISDN
               }
               else {
                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

                  /* Set exception handler variables */
                  gus_ExceptionState   = gs_RxState;
                  gus_ExceptionCode = E_CODE_RCCRC2Rx_C_RATES1_DECOD_ERR;
               }
                    break;

            } /* switch (gs_RxState)  */
        }
        else {
            /* ============================================================ */
            /*  CRC's don't match:  go to FAIL state */
            /* ============================================================ */
            gft_RCExch1RcvFlag = NOT_RECEIVE;
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCCRC1Rx_C_RATES1_DECOD_ERR;
        }
    }
}



