/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RCMedleyRxF.c
*
*   Functions implementing states in the Channel Analysis phase of
*   Initialization for both TX and RX.
*
*   RX: R_C_MEDLEY/R_C_MEDLEY_FR,
*
*------------------------------------------------------------------------
*/
//*******************************************************************
// RCMedleyRxF.c
//
// History
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
//*****************************************************************************

#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "bitload.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pn_tab.h"
#include "pwr_ctbk.h"
#include "fifo.h"
#include "accum32.h"
#include "noiseacc.h"
#include "cmv.h"
#include "med2rev.h"
#include "DSLEngin.h"
#include "detect.h"
#include <string.h>
#include "vecpwr.h"
#include "memcopy.h"
#include "memsetbf.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "rcmedley_Data.h"
#include "rcmedly2.h"
#include "RCMedleyRxF_Bitload.h"
#include "states.h"
#include "RCRatesRARxF.h"
#include "codeswap.h"
#include "fft_bg.h"
#include "find_sintbl.h"
#include "RCMedleyRxF.h"
#include "fdq_init.h"
#include "fdq_adj.h"
#include "tdq_init.h"
#include "diagparam_bis.h"
#include "T1413.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/
/* ================================================================= */
/* constants used by CRMedleyRxF() */
/* ================================================================= */

/*^^^
*------------------------------------------------------------------------
*
*  Name: RCMedleyRxF
*
*  Description: Processes the C_Medley signal and detects C_Segue2.
*  C_Medley is used by the ATU-R to calculate the downstream SNR per tone, which
*  is then used to determine the number of bits per tone.
*
*  NOTE:
*  Medley NTC function is split into two functions for codeswap purposes
*  Namely RCMedleyRxF() and RCMedleyRxF_Bitload()
*
*  Prototype: RCMedleyRxF(void)
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      gl_RxSymbolCount            - (I) number of symbol periods in current state
*      gs_RxNextState              - (O) RX state beginning next symbol period
*     gusa_PN512Tab[]            - (I) PN512 sequence table
*     gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
*     gsa_MedleySnrBuf[]          - (O) computed SNR per tone
*     guc_BitloadOK           - (O) indicator if bit loading succeeds
*
* Substates:
* ----------
* Below States are implemented in function RCMedleyRxF()
* R_C_MEDLEY_RX_INITIALIZE          - Initialization
* R_C_MEDLEY_RX_LOAD_CURRENT_TDQ    - Loads current TDQ or turns it off if required
* R_C_MEDLEY_RX_FDQ_INIT            - Initialize parameters for FDQ training
* R_C_MEDLEY_RX_AVERAGE_FRAME       - Gather average frame for FDQ training
* R_C_MEDLEY_RX_FDQ_TRAIN           - Compute FDQ coefficients
* R_C_MEDLEY_RX_ADJUST_SYNCH        - Adjust buffer alignments and FDQ coefficients
* R_C_MEDLEY_RX_PRE_TEST_SNR_INIT      - Rotate the reference tone corresponding to post-sync
* R_C_MEDLEY_RX_TEST_SNR_INIT       - Initialize for SNR calculation
* R_C_MEDLEY_RX_CALCULATE_TEST_SNR     - Gather average frame and calculate SNR
* R_C_MEDLEY_RX_KEEP_BEST           - Keep the best TDQ and throw out others
* R_C_MEDLEY_RX_LOAD_BEST           - Load the best TDQ (or turned it off it achieves best capacity)
* R_C_MEDLEY_RX_FINAL_SNR_INIT         - Initialize for final SNR computation
* R_C_MEDLEY_RX_CALCULATE_FINAL_SNR - Gather average frame and calculate final SNR
*
* Below States are implemented in function RCMedleyRxF_Bitload_BIS()
* R_C_MEDLEY_RX_BITLOAD          - Perform bitloading or selecting profile
* R_C_MEDLEY_RX_DS_ATTEN            - Calculate downstream loop attenuation
* R_C_MEDLEY_RX_WAIT             - Wait for the end of the R_C_MEDLEY state.
* R_C_MEDLEY_RX_CAPTURE_FRAMES         - Capture time-domain frames.
* R_C_MEDLEY_RX_DETECT_SEGUE        - Detect C_SEGUE2 and check for time out.
*
*------------------------------------------------------------------------
*^^^
*/

/* =============================================== */
/* substates */
/* =============================================== */
/* Below States are implemented in function RCMedleyRxF_BIS() */
#define  R_C_MEDLEY_RX_INITIALIZE         (0)
#define R_C_MEDLEY_RX_SWAP_BTLDDMT        (1001)
#define R_C_MEDLEY_RX_COMPUTE_HCHAN         (1002)

/* Below States are implemented in function RCMedleyMultiTdq() */
#define  R_C_MEDLEY_RX_LOAD_TDQ           (1)
#define R_C_MEDLEY_RX_FINAL_SNR_INIT      (12)
#define  R_C_MEDLEY_RX_COMPUTE_NMS_INIT    (25)


void RCMedleyRxF(void)
{
    int16 i, j, s_PN512_LEN;
    int16 s_DS_AbsoluteFRCutback_DB;   // DS Init Politeness power cutback in dB.

    s_PN512_LEN = PN512_LEN;

    switch (gs_RxSubState) {

    case R_C_MEDLEY_RX_INITIALIZE:

        /* ============================================================================= */
        /* Perform necessary initialization at symbol 0 */
        /* ============================================================================= */
        if(gl_RxSymbolCount == 0)
        {
            gs_RxSubStateCnt = 0;
            gt_StateMachCntrl.l_RXCurrentStateLen  = R_C_MEDLEY_RX_LEN-1;
            gt_StateMachCntrl.s_RXFollowingState   = R_C_RATES_RA_RX;
            gt_StateMachCntrl.psa_RXSNRBuf         = gsa_MedleySnrBuf;
            gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCRatesRARxF;

            gs_RxFirstPNbit = 0;
            gs_MedleyModulo = s_PN512_LEN;
            gsa_ref_tones = gsa_unpk_PN512;
#ifdef ADSL_62_XYMEM
            gsa_FDQ_coef_best = (int16 *) ( gsa_YBlock_Extended+ 2*(RX_NUM_TONES));
#endif
            /* Switch to Aux Pilot Tone */
            if(gft_AuxPilot == AUX_PILOT_ACTIVE)
            {
                gs_PilotToneIdx = gs_AuxPilotToneIdx;
                ScalePLL(gs_PllScaling);
            }

            gs_UnpackPNState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc) BgUnpackPN);

            /* initialize Accumulation pointers for NoiseAcc() and BgMedleyToReverbAccum()*/
            gla_NoisePower = gla_RxAccumBuf+2*gs_RxFirstChannel;
            gsa_recv_tones = &gsa_RxToneBuf[0];
            gs_TrainCnt = 0;

            // zero out SNR which may have been overwritten in other states
            MemSetBuffer(gt_StateMachCntrl.psa_RXSNRBuf, 0, 0, (int16)(sizeof(int16)*gs_RxNumTones));

            // For G992.1, downstream power cutback is specified by gt_RCMsgs1.us_PSDLevel
            gt_TxPMDControl.us_pwr_cutback_DS = (7-gt_RCMsgs1.us_PSDLevel)*2;

            // For G992.2, downstream (DS) power cutback is the maximum of
            //    1) Absolute DS Fast Retrain Power cutback = sum of FR DS Politeness and Relative cutbacks.
            //    AND
            //    2) Initialization Politeness Power cutback (specified by gt_RCMsgs1.us_PSDLevel).
            if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C))
            {
                s_DS_AbsoluteFRCutback_DB = gs_DPF + gs_RDC;
                if (s_DS_AbsoluteFRCutback_DB > gt_TxPMDControl.us_pwr_cutback_DS)
                gt_TxPMDControl.us_pwr_cutback_DS = s_DS_AbsoluteFRCutback_DB;
            }

            //Obsolete
            // Calculate downstream loop attenuation.
            //       s_Atten = LoopAttenuation(gl_Atten_Rx_Total_Power, (int16)(gs_RxLastChannel-gs_RxFirstChannel+1), (int16)(gt_TxPMDControl.us_pwr_cutback_DS<<8), (uint16)204);



            /* Medley Tdq Enabled */
            if ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) != 0)
            {
                /* Initialize alignment counters */
                gs_AlignmentOffset = 0;
                gs_CumulativeAlignmentOffset = 0;

                /* Initialize Unity TDQ FDQ coefficient */
                gsa_FDQ_coef_pilot_UnityTdq[0] = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)];
                gsa_FDQ_coef_pilot_UnityTdq[1] = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1];
                guc_FDQ_exp_pilot_UnityTdq = guca_pre_FDQ_exp[gs_PilotToneIdx];

                gs_TdqIdx = 0;
                gs_TdqOffIdx = -1;
                gs_last_tdq_idx = gs_NumMultiTdq-1;
                /* Determine whether or not to test TDQ-off case */
                if ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqOffEnable) != 0)
                {
                    gs_last_tdq_idx++;
                    /* last case is TDQ off */
                    gs_TdqOffIdx = gs_last_tdq_idx;
                }

                if (gft_OfflinePreSyncs == FALSE) {
                    j = -(gs_NumMultiTdq>>1);
                    for (i=0; i<gs_NumMultiTdq; i++){
                        gsa_MultiTdqPreSyncs[i] = j++;         /* set Multiple TDQ Pre Sync points    */
                    }
                }
                gs_MultiTdqTrainingState = TRAINING_IN_PROGRESS;
                AddFunctionToBkgdFifo((PtrToBkgdFunc) BGMultiTdqCalc);

                gft_CopyRxBuffer = FALSE;
            }
            gft_MedleyCntUpdate = TRUE;
            gul_TotMedpRev4SymbCount = 0;
            gul_MedleySymbCount = 0;
            gul_MedleyToRCRatesSymbCount = 0;
        }   // if RxSymbolcnt==0

        gs_RxSubState = R_C_MEDLEY_RX_COMPUTE_HCHAN;
        break;

        /* ======================================================================================== */
        /* Compute Hchannel(f) test paramter for loop diagnostics */
        /* ======================================================================================== */
    case R_C_MEDLEY_RX_COMPUTE_HCHAN:
        if (gl_RxSymbolCount >= PGA_SETTLING_TIME)
        {
            // Compute Hlin function in background from accumulated frame
            guc_BkgdTaskState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)ComputeHlin);

            gs_RxSubState = R_C_MEDLEY_RX_SWAP_BTLDDMT;
        }
        break;

    case R_C_MEDLEY_RX_SWAP_BTLDDMT:
#ifdef USE_ENGINE_FOR_BG_FFTS
        if (gft_StartEngineFFT)
        EngineFFT_StateMachine();
#endif

#ifdef BIS_CODESWAP
        // Wait for pending codeswap to be finished
        if (gs_CodeSwapStatus != CODESWAP_IDLE)
        break;
#endif
        /* If Medley Multi Tdq Done or Disabled */
        if ((guc_BkgdTaskState  == TRAINING_DONE) && (gs_MultiTdqTrainingState == TRAINING_DONE ||
                    (OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) == 0))
        {
#ifdef BIS_CODESWAP
            // Start overwrite of multitdq codeswap page with bitload page
            gs_CodeSwapStatus = CODESWAP_START;
#endif
            gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF_TDQTest;
           if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & (OPTN_NoiseMarginChange_NM_Ctrl_ADC_MEDLEY_EN))
           {
               gs_RxSubState = R_C_MEDLEY_RX_COMPUTE_NMS_INIT;
           }
           else

           {
            if (((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) == 0) && (gft_TrainFdqIfMultiTdqDisabled == FALSE))
               gs_RxSubState = R_C_MEDLEY_RX_FINAL_SNR_INIT;
            else
               gs_RxSubState = R_C_MEDLEY_RX_LOAD_TDQ;
           }
        }
        break;
    }

    /* ============================================================================== */
    /* increment RxFirstPNbit following its use in the NoiseAccum function       */
    /* ============================================================================== */
    gs_RxFirstPNbit += (1 + gft_SkipOneFrame);
    if(gs_RxFirstPNbit >= s_PN512_LEN)
    {
        gs_RxFirstPNbit=0;
    }
}

/* undefine substates */
#undef R_C_MEDLEY_RX_INITIALIZE
#undef R_C_MEDLEY_RX_SWAP_BTLDDMT
#undef R_C_MEDLEY_RX_LOAD_TDQ
#undef R_C_MEDLEY_RX_FINAL_SNR_INIT
#undef R_C_MEDLEY_RX_COMPUTE_HCHAN
#undef R_C_MEDLEY_RX_COMPUTE_NMS_INIT

