/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RCMedleyRxF_Bitload.c
*
*   Functions implementing the bitloading phase of RCMedley processing.
*
*
*   RX: R_C_MEDLEY/R_C_MEDLEY_FR,
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// RCMedleyRxF_Bitload.c
//
// History
//
// 25/08/2010 Nihar: Enhance DS Data rate in 5T1 Noise loops for Alcatel CO's in DMT mode
//                    using Noise Margin Separation Calculation. By default, its enabled.
//                    To disable it, set bit 10 of INFO 103 0
//                    grep for PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate.
//
// 02/09/2010 Nihar: Boost fine gain by 0.2dB on the mid-range
//                   loops against TI COs in DMT mode
//                   Grep for PERF_DS_DMT_TI_FGainBoost
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "bitload_dmt.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pn_tab.h"
#include "pwr_ctbk.h"
#include "fifo.h"
#include "accum32.h"
#include "noiseacc.h"
#include "cmv.h"
#include "med2rev.h"
#include "DSLEngin.h"
#include "detect.h"
#include <string.h>
#include "vecpwr.h"
#include "memcopy.h"
#include "memsetbf.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "rcmedley_Data.h"
#include "rcmedly2.h"
#include "RCMedleyRxF.h"
#include "states.h"
//#ifdef DANUBE
#ifdef TARGET_HW
#include "dataswap.h"
#endif
//#endif
// PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start_End)
#include "T1413.h"

#ifndef ISDN    // Only for Anx-A
// PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start)
// Increase the Fine Gain by 0.2dB for 5T1 Noise Long loops Eg: 9kft, 12kft, and 15kft
// 5T1 Noise Loops.
// This is done for Fast and Interleaved modes. It is applicable for ALCATEL CO's.
// This change is for Alcatel STM FG10 ADLT-J DSLAM to compare AR7 Data rate.

// 0.2dB *256 = 51.2 (Approx 51 => 0x0033)
#define FINE_GAIN_DELTA_ALCATEL_DMT_5T1NOISE_LOOPS (0x0033)
// PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (End)

// PERF_DS_DMT_TI_FGainBoost (Start)
// Increase the Fine Gain by 0.2dB for all loops.
// This is done for Fast and Interleaved modes. It is applicable for TI CO's.
// It is done to meet the Data Rate Requirement for British Telecom to compare the
// TI's AR7/UR8 CPE's Data Rate.

// 0.2dB *256 = 51.2 (Approx 51 => 0x0033)
#define FINE_GAIN_DELTA_TI_DMT_ALL_LOOPS   (0x0033)
// PERF_DS_DMT_TI_FGainBoost (End)
#endif
/*^^^
*------------------------------------------------------------------------
*
*  Name: RCMedleyRxF_Bitload
*
*  Description: Processes the bitloading phase of RCMedley
*  processing and then detects C_Segue2.
*
*  NOTE:
*  Medley NTC function is split into two functions for codeswap purposes
*  Namely RCMedleyRxF() and RCMedleyRxF_Bitload()
*
*  Prototype: RCMedleyRxF_Bitload(void)
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      gl_RxSymbolCount            - (I) number of symbol periods in current state
*      gs_RxNextState              - (O) RX state beginning next symbol period
*     gusa_PN512Tab[]            - (I) PN512 sequence table
*     gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
*     gsa_MedleySnrBuf[]          - (O) computed SNR per tone
*     guc_BitloadOK           - (O) indicator if bit loading succeeds
*
* Substates:
* ----------
* Below States are implemented in function RCMedleyRxF()
* R_C_MEDLEY_RX_INITIALIZE          - Initialization
* R_C_MEDLEY_RX_LOAD_CURRENT_TDQ    - Loads current TDQ or turns it off if required
* R_C_MEDLEY_RX_FDQ_INIT            - Initialize parameters for FDQ training
* R_C_MEDLEY_RX_AVERAGE_FRAME       - Gather average frame for FDQ training
* R_C_MEDLEY_RX_FDQ_TRAIN           - Compute FDQ coefficients
* R_C_MEDLEY_RX_ADJUST_SYNCH        - Adjust buffer alignments and FDQ coefficients
* R_C_MEDLEY_RX_PRE_TEST_SNR_INIT      - Rotate the reference tone corresponding to post-sync
* R_C_MEDLEY_RX_TEST_SNR_INIT       - Initialize for SNR calculation
* R_C_MEDLEY_RX_CALCULATE_TEST_SNR     - Gather average frame and calculate SNR
* R_C_MEDLEY_RX_KEEP_BEST           - Keep the best TDQ and throw out others
* R_C_MEDLEY_RX_LOAD_BEST           - Load the best TDQ (or turned it off it achieves best capacity)
* R_C_MEDLEY_RX_FINAL_SNR_INIT         - Initialize for final SNR computation
* R_C_MEDLEY_RX_CALCULATE_FINAL_SNR - Gather average frame and calculate final SNR
*
* Below States are implemented in function RCMedleyRxF_Bitload()
* R_C_MEDLEY_RX_BITLOAD          - Perform bitloading or selecting profile
* R_C_MEDLEY_RX_DS_ATTEN            - Calculate downstream loop attenuation
* R_C_MEDLEY_RX_WAIT             - Wait for the end of the R_C_MEDLEY state.
* R_C_MEDLEY_RX_CAPTURE_FRAMES         - Capture time-domain frames.
* R_C_MEDLEY_RX_DETECT_SEGUE        - Detect C_SEGUE2 and check for time out.
*
*------------------------------------------------------------------------
*^^^
*/

/* =============================================== */
/* substates */
/* =============================================== */
/* Below States are implemented in function RCMedleyRxF_Bitload() */
#define  R_C_MEDLEY_RX_BITLOAD            (14)
#define  R_C_MEDLEY_RX_DS_ATTEN           (15)
#define R_C_MEDLEY_RX_WAIT             (16)
#define R_C_MEDLEY_RX_CAPTURE_FRAMES      (17)
#define R_C_MEDLEY_RX_DETECT_SEGUE        (18)
#define R_C_SWITCH_MEDLEY_TO_REV4_WAIT    (19)

//uint16 gus_Wait_period;
void RCMedleyRxF_Bitload(void)
{


    int16 s_ToneType;


    int16 s_PN512_LEN, s_SequenceLengthMultiplier;

    if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
    {
        s_SequenceLengthMultiplier = 2;
    }
    else
        s_SequenceLengthMultiplier = 1;

    s_PN512_LEN = s_SequenceLengthMultiplier * PN512_LEN;

    switch (gs_RxSubState)
    {

        /* ============================================================================== */
        /* Perform Bitloading  */
        /* ============================================================================== */
    case R_C_MEDLEY_RX_BITLOAD:

//#ifdef DANUBE
#ifdef TARGET_HW
        /* Swap Medley SNR buffer to XMEM */
        RequestSwap_MedleySnrBuf_ToXmem();
#endif
//#endif
        /* Fine gain adjustment calibrations -- unless user has initialized for debug purposes */
        if (!gs_fgain_adjust)
        {
            if (gus_ncloaded <= OPTNArray[OPTN_FgainAjust_Threshold])
            {
                // PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (Start)
#ifndef  ISDN  // Only for Annex - A
                if (((gs_CurrentCoChipset == ALA_CO_CHIPSET) ||
                        (gs_fe_T1413_VendorID == T1413_ALA_ID)) &&
                        (gft_5T1Noise != FALSE) &&
                        ((gt_INFX_CMV.us_OperatorSpBits & CMV_TO_DISABLE_5T1NOISE_ALC_DMT) == 0))
                {
                    // Increase the Fine Gain by 0.2dB for 5T1 Noise Long loops Eg: 9kft, 12kft, and
                    // 15kft
                    // 5T1 Noise Loops.
                    // This is done for Fast and Interleaved modes in g.dmt, T1413 and G.lite Modes.
                    // It is applicable for ALCATEL CO's.
                    // This change is for Alcatel STM FG10 ADLT-J DSLAM to compare AR7 Data rate.

                    // 0.2dB *256 = 51.2 (Approx 51 => 0x0033)
                    OPTNArray[OPTN_FgainAdjust_LongLoop] +=
                        FINE_GAIN_DELTA_ALCATEL_DMT_5T1NOISE_LOOPS;
                }
#endif // ifndef ISDN
                // PERF_DS_DMT_ALCATEL_Enhance5T1NoiseLoopDataRate (End)
                gs_fgain_adjust = OPTNArray[OPTN_FgainAdjust_LongLoop];
            }
            else if (gus_ncloaded <= OPTNArray[OPTN_FgainAjust_Threshold2])
            {
                // AR8_TF: PERF_DS_DMT_TI_FGainBoost (Start)
#ifndef  ISDN  // Only for Annex - A
                // if (gs_CurrentCoChipset==TI_CO_CHIPSET) {
                // Increase the Fine Gain by 0.2dB for Mid Range loops.
                // This is done for Fast and Interleaved modes. It is applicable for TI CO's.
                // It is done to meet the Data Rate Requirement for British Telecom to compare the
                // TI's AR7/UR8 CPE's Data Rate.

                // 0.2dB *256 = 51.2 (Approx 51 => 0x0033)
                OPTNArray[OPTN_FgainAdjust_MedLoop] += FINE_GAIN_DELTA_TI_DMT_ALL_LOOPS;
                // }
#endif // ifndef ISDN
                // AR8_TF: PERF_DS_DMT_TI_FGainBoost (End)
                gs_fgain_adjust = OPTNArray[OPTN_FgainAdjust_MedLoop];
            }
            else if ( (gus_ncloaded > OPTNArray[OPTN_FgainAjust_Threshold2])
                      && ((OPTNArray[OPTN_AlgControl2]&OPTN_ShortFGAdjust_allCOs)||(gs_CurrentCoChipset==ALA_CO_CHIPSET)||(gs_CurrentCoChipset==BDCM_CO_CHIPSET)) )
            {
                gs_fgain_adjust = OPTNArray[OPTN_FgainAdjust_ShortLoop];
            }
            // else gs_fgain_adjust remains at 0 (as it was upon entrring the if() loop)
            // Add delta fine gain adjustment for long loops
            //XDSLRTFW-3674 Options_For_debug(start)
            if(gt_HercADSL_OPTNMap_MarginControl.s_FineGainAdjust != 0)
            {
               gs_fgain_adjust = gs_fgain_adjust+gt_HercADSL_OPTNMap_MarginControl.s_FineGainAdjust;
            }
            //XDSLRTFW-3674 Options_For_debug(end)
            if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) ||
                    ((gl_SelectedMode & (MODE_G992_2)) && (gl_SelectedMode & (ANNEX_C))))
            {
                gs_fgain_adjust = 0 ;       /* Cannot apply fine gain adjustment, when there are not a lot of idle tones */
            }
        }

        /* Perform bitloading or loading profile */
        gft_BitloadState = TRAINING_IN_PROGRESS;
        AddFunctionToBkgdFifo((PtrToBkgdFunc) BgMedleyBitload);

        //gs_RxSubState =  R_C_MEDLEY_RX_WAIT;
        //gus_Wait_period = 0;
        gs_RxSubState = R_C_SWITCH_MEDLEY_TO_REV4_WAIT;

        break;
#if 0
    //The below substate modified to know the pending Medley symbols.
    case R_C_MEDLEY_RX_WAIT:
       gus_Wait_period++;
       if ((gft_BitloadState == TRAINING_DONE)
            &&(gft_MedleyCntUpdate == TRUE)
          )
       {
            gul_TotMedpRev4SymbCount = gl_RxSymbolCount;
            gft_MedleyCntUpdate = FALSE;
       }
       if( (gus_Wait_period >= 4096) &&(gft_BitloadState == TRAINING_DONE))
       {
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_SWITCH_MEDLEY_TO_REV4_WAIT;
       }
       break;
#endif
case R_C_SWITCH_MEDLEY_TO_REV4_WAIT:

        /* Waiting for the end of R_C_MEDLEY state */

        if(gl_RxSymbolCount >= gt_StateMachCntrl.l_RXCurrentStateLen-R_C_MEDLEY_WT_LEN)

        {
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_MEDLEY_RX_DETECT_SEGUE;
        }

        break;


    case R_C_MEDLEY_RX_DETECT_SEGUE:

        /* ================================================================ */
        /* Detect C_SEGUE2 and check for time out */
        /* ================================================================ */
        /*  decode incoming symbol */


        s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

        /*  if incoming symbol is C_Segue, then incr. counter */
        /*  else reset counter */
        if (s_ToneType == C_SEGUE)    /*  C_Segue detected */
        {
            gs_RxSubStateCnt++;
        }
        else
        {
            gs_RxSubStateCnt = 0;

        }


        /*  C_SEGUE2 detected, go to next state */
        if (gs_RxSubStateCnt == R_C_SEGUE2_LEN)
        {
            gft_EnablePLL = FALSE;
            gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
            gpF_RxStateFunc = (PtrToFunc)gt_StateMachCntrl.pF_RxFollowingState;

            // Save the Rx overflow counters for the current state
            memcpy(gusa_RCMedley_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
            gul_MedleyToRCRatesSymbCount = gl_RxSymbolCount;
        }

        /*  if C_SEGUE not detected yet, then the ATU-C has timed out */
        /*  goto FAIL_RX state  */
        if (gl_RxSymbolCount >= R_C_MEDLEY_TIMEOUT )
        {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCMedleyRx_C_SEGUE2_Failure;

            // Save the Rx overflow counters for the current state
            memcpy(gusa_RCMedley_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
        }

        break;
    }

    /* ============================================================================== */
    /* increment RxFirstPNbit following its use in the NoiseAccum function       */
    /* ============================================================================== */
    if (gs_RxSubState<R_C_MEDLEY_RX_WAIT)
    {
        if(++gs_RxFirstPNbit == s_PN512_LEN)
        {
            gs_RxFirstPNbit=0;
        }
    }
}

/* undefine substates */
#undef R_C_MEDLEY_RX_BITLOAD
#undef R_C_MEDLEY_RX_DS_ATTEN
#undef R_C_MEDLEY_RX_WAIT
#undef R_C_MEDLEY_RX_CAPTURE_FRAMES
#undef R_C_MEDLEY_RX_DETECT_SEGUE
#undef R_C_SWITCH_MEDLEY_TO_REV4_WAIT

