/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMedleyRxF_TDQTest_bis.c
 *
 *   Functions implementing states in the Channel Analysis phase of
 *   Initialization for RX.
 *
 *   RX: R_C_MEDLEY_BIS
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "snr.h"
#include "pll.h"
#include "medley.h"
#include "fifo.h"
#include "cmv.h"
#include "med2rev.h"
#include <string.h>
#include "memcopy.h"
#include "memsetbf.h"
#include "rcmedley_Data.h"
#include "gdata_bis.h"
#include "RCMedleyRxF_Bitload_bis.h"
#include "states.h"
#include "RMedleyTxF_bis.h"
#include "fdq_init.h"
#include "fdq_adj.h"
#include "find_sintbl.h"
#ifdef USE_ENGINE_FOR_BG_FFTS
#include "fft_bg.h"
#endif

#include "states.h"
#include "tx_ops_bis.h"
#include "Gen_PNMedley_14thorder.h"

//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMedleyRxF_BIS
 *
 *  Description: Processes the C_Medley signal.
 *  C_Medley is used by the ATU-R to calculate the downstream SNR per tone, which
 *  is then used to determine the number of bits per tone.
 *
 * NOTE:
 * Medley NTC function is split into two functions for codeswap purposes
 * Namely RCMedleyRxF_BIS() and RCMedleyRxF_Bitload_BIS()
 *
 *  Prototype: RCMedleyRxF_TDQTest_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount            - (I) number of symbol periods in current state
 *      gs_RxNextState              - (O) RX state beginning next symbol period
 *    gusa_PN512Tab[]            - (I) PN512 sequence table
 *    gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
 *    gsa_MedleySnrBuf[]          - (O) computed SNR per tone
 *    guc_BitloadOK           - (O) indicator if bit loading succeeds
 *
 * Substates:
 * ----------
 * Below States are implemented in function RCMedleyRxF_BIS()
 * R_C_MEDLEY_RX_INITIALIZE            - Initialization
 * R_C_MEDLEY_RX_LOAD_CURRENT_TDQ      - Loads current TDQ or turns it off if required
 * R_C_MEDLEY_RX_FDQ_INIT           - Initialize parameters for FDQ training
 * R_C_MEDLEY_RX_AVERAGE_FRAME         - Gather average frame for FDQ training
 * R_C_MEDLEY_RX_FDQ_TRAIN          - Compute FDQ coefficients
 * R_C_MEDLEY_RX_ADJUST_SYNCH       - Adjust buffer alignments and FDQ coefficients
 * R_C_MEDLEY_RX_PRE_TEST_SNR_INIT     - Rotate the reference tone corresponding to post-sync
 * R_C_MEDLEY_RX_TEST_SNR_INIT         - Initialize for SNR calculation
 * R_C_MEDLEY_RX_CALCULATE_TEST_SNR    - Gather average frame and calculate SNR
 * R_C_MEDLEY_RX_KEEP_BEST          - Keep the best TDQ and throw out others
 * R_C_MEDLEY_RX_LOAD_BEST          - Load the best TDQ (or turned it off it achieves best capacity)
 * R_C_MEDLEY_RX_FINAL_SNR_INIT        - Initialize for final SNR computation
 * R_C_MEDLEY_RX_CALCULATE_FINAL_SNR   - Gather average frame and calculate final SNR
 *
 * Below States are implemented in function RCMedleyRxF_Bitload_BIS()
 * R_C_MEDLEY_RX_BITLOAD            - Perform bitloading or selecting profile
 * R_C_MEDLEY_RX_DS_ATTEN           - Calculate downstream loop attenuation
 * R_C_MEDLEY_RX_WAIT               - Wait for the end of the R_C_MEDLEY state.
 * R_C_MEDLEY_RX_CAPTURE_FRAMES        - Capture time-domain frames.
 * R_C_MEDLEY_RX_DETECT_SEGUE       - Detect C_SEGUE2 and check for time out.
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
void RCMedleyRxF_TDQTest(void) {

   int16 s_PN512_LEN;

   s_PN512_LEN = PN512_LEN;

   RCMedleyMultiTdq();

   /* ============================================================================== */
   /* increment RxFirstPNbit following its use in the NoiseAccum function        */
   /* ============================================================================== */
   gs_RxFirstPNbit += (1 + gft_SkipOneFrame);
   if(gs_RxFirstPNbit >= s_PN512_LEN)
   {
      gs_RxFirstPNbit=0;
   }
}
