/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCrc1TxF.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "ifft_fix.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "fifo.h"
#include "RCrc1TxF.h"
#include "cmv.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "RMsgs1TxF.h"
#include "RMedleyTxF.h"
#include "states.h"






/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCrc1TxF
 *
 *  Description: Transmits a CRC16 by sending one bit of the CRC each symbol
 *  period.  A zero bit is encoded as one symbol of R_Reverb and a one
 *  bit is encoded as one symbol of R_Segue.  This function is used for all states
 *  that send CRC's in this fashion
 *
 *  Prototype: void RCrc1TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_R_CRC          - (I) CRC16 computed over the message to be sent
 *      gl_TxSymbolCount      - (I) # symbol periods in current TX state
 *      gs_TxNextState         - (O) TX state that will begin next symbol period
 *       gs_TxState           - (I) current TX state
 *    gs_TxSubState        - (I/O) current TX substate
 *      gt_StateMachCntrl      - (O) Maintains state machine control variables
 *
 *  Notes: implements states R_CRC1_TX, R_CRC2_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCrc1TxF(void) {

    uint16  us_infobit;

   if (gl_TxSymbolCount == 0) {
      gs_TxSubStateCnt = 0;

      switch (gs_TxState) {

      case R_CRC1_TX:
         gt_StateMachCntrl.s_TXFollowingState  = R_MSGS1_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RMsgs1TxF;
         break;
      case R_CRC2_TX:
         gt_StateMachCntrl.s_TXFollowingState  = R_MEDLEY_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RMedleyTxF;
         break;
      }
    }



      /* ==================================================================== */
      /*  Send CRC  */
      /* ==================================================================== */

      /* extract bit */
      us_infobit = (gus_R_CRC >> gs_TxSubStateCnt);

      us_infobit &= 0x0001;

      /* encode and transmit bit  */
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, us_infobit);

      gs_TxSubStateCnt++;
      if(gs_TxSubStateCnt == R_CRC1_TX_LEN) {
         gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
         gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
      }



}

