/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RMedleyTxF.c
*
*   State function for states R_MEDLEY and R_MEDLEY_FR.
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// RMedleyTxF.c
//
// History
//
// 08/07/2010 Nihar: Send noise during Tx Medley so that US BAT is lower than the CO could get
//                   Helps in getting rid of US CRC/FEC during field trials.
//                By default it is disabled. To enable it set bit 0 of OPTN 25 0
//                   Grep for IOP_US_ALL_ADI930_AddNoiseToTxMedley
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "gdata.h"
#include "tx_ops.h"
#include "rmedley_Data.h"
#include "fifo.h"
#include <string.h>
#include "TxTneSt.h"
#include "GenMedly.h"
#include "memsetbf.h"
#include "RReverb4TxF.h"
#include "RReverbFrTx3F.h"
#include "states.h"
#include "cmv.h"
#include "const.h"


/*^^^
*------------------------------------------------------------------------
*
*  Name: RMedleyTxF
*
*  Description: Transmits R_Medley, a wide band, pseudo random signal,
*  which is used by the ATU-C to estimate upstream SNR.  The R_Medley
*  signal is derived from the UPRD sequence, using a 64-bit cyclic subset
*
*      d[1 + (n % N)] ... d[1 + ((n+63) % N)]; n = 0 ... L
*
*  where N is the length of the PRD, n is the index to the R_Medley symbol
*  period, and L is the duration of R_MEDLEY, in symbol periods.  This data
*  sequence is then modulated in the same manner as that of R_Reverb.
*
*  The implementation consists of unpacking the PRD data sequence into an
*  array, computing the index to the beginning of the data subset,
*  retrieving the data subset, removing the untransmitted tones
*  and generating the time domain sequence.
*
*  Prototype: void RMedleyTxF(void)
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      gsa_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegueSetUp())
*      gl_TxSymbolCount    - (I) # symbol periods in current TX state
*      gs_TxNextState      - (O) TX state that will begin next symbol period
*               gs_TxState                      - (I) current TX state
*
*  Notes: implements states R_MEDLEY_TX (and R_MEDLEY_FR_TX for G992_2)
*
*------------------------------------------------------------------------
*^^^
*/
C_SCOPE void RMedleyTxF(void)
{
    uint16 us_TxNoiseStartToneIdx = 0, i;
   //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise (Start)
#ifndef ISDN
        FlagT ft_fixedRate_detected;
        uint8 us_LS0_offset;
#endif
        //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise (End)
    /* unpack PRD from table */
    if (gl_TxSymbolCount == 0)
    {
        gft_IFFT_On = TRUE;
#ifdef ISDN
        // IOP_US_ALL_ADI930_AddNoiseToTxMedley (Start_End)
        gt_INFX_CMV.s_med_offset += gs_Persis_CurrTxNoiseLevel;
#else
   //Co Vendor id (ADI930,IOP Bit,G.dmtMode+fastpath)
   //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise (Start)

      if ((gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_INCREASE_TX_MEDLEY_NOISE_ADI) && (gs_CurrentCoChipset == ADI_CO_CHIPSET))
      {
          // uc_R_C_Rates1_LSx[0] = guca_R_C_Rates1[7];      // Update LSO ( US rate option) with 5 idx  )
          // uc_R_C_Rates1_LSx[1] = guca_R_C_Rates1[37];     // Update LS1 ( US rate option) with 6 idx  )
          // uc_R_C_Rates1_LSx[2] = guca_R_C_Rates1[67];     // Update LS2 ( US rate option) with 6 idx  )
          // uc_R_C_Rates1_LSx[3] = guca_R_C_Rates1[97];     // Update LS3 ( US rate option) with 7 idx  )

         // ft_us_fixedRate_detected = 1;        // all 4 options are equal
         // for(i = 1;i < 4;i++)
           // {
               // if (uc_R_C_Rates1_LSx[0] != uc_R_C_Rates1_LSx[i])
               // {
                   // ft_us_fixedRate_detected = 0;        // at least 1 of the 3 options is not equal to the first one
               // }
           // }

           ft_fixedRate_detected = 1;          // initialize to "Fixed-Rate"

           if (guca_R_C_Rates1[7] == 0)        // if (US: ILV path)
               us_LS0_offset = 17;             // ILV-path:  LS0(US) starts at offset 17
           else
               us_LS0_offset =  7;             // Fast-path: LS0(US) starts at offset  7

           for(i = 1;i < 4;i++)
           {
               if (guca_R_C_Rates1[us_LS0_offset] != guca_R_C_Rates1[us_LS0_offset+i*30])
                   ft_fixedRate_detected = 0;      // Rate-adaptive if at least 1 of the 3 options is not equal to the first one
           }

           // Applicable for RA case only
           if (ft_fixedRate_detected == 0) // not for the Fixed rate cases
           {
               // NMV Test 2850M FB noise
               // only for FB-noise, loops>2650m, Fast+ILV
               if (((STATArray[STAT_Performance] & STAT_FBNoiseLowThreshold) == STAT_FBNoiseLowThreshold)
                       && (gt_NearEndParam.us_LoopAttenuation > DS_LPR_2650_M_Line_ATTEN_40_9_dB) )
               {
                 gt_INFX_CMV.s_med_offset = USSNR_Medley_27_7_maxBitPerTone_5_8_maxNetRate_457kbps;    // Tx Noise to Medley signal
               }

               // Stress Test 3600M white noise
               // only for -130WN, loops>3350m, Fastpath
               if (((STATArray[STAT_Performance] & STAT_M130WhiteNoise) == STAT_M130WhiteNoise)
                       && (guca_R_C_Rates1[7] != 0)
                       && (gt_NearEndParam.us_LoopAttenuation > DS_LPR_3350_M_Line_ATTEN_50_5_dB))
               {
                   gt_INFX_CMV.s_med_offset = USSNR_Medley_27_7_maxBitPerTone_5_8_maxNetRate_457kbps; // Tx Noise to Medley signal
               }
           }
       }

    //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise (End)
#endif
#ifndef BIS_CODESWAP
        switch (gs_TxState)
        {

        case R_MEDLEY_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_MEDLEY_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_REVERB4_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb4TxF;
            break;

        case R_MEDLEY_FR_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_MEDLEY_FR_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_REVERB_FR6_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverbFrTx3F;
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,InsertTxCP);
            break;
        }
#else
        gt_StateMachCntrl.l_TXCurrentStateLen = R_MEDLEY_TX_LEN-1;
        gt_StateMachCntrl.s_TXFollowingState  = R_REVERB4_TX;
        gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb4TxF;
#endif

        // If h/w generates the medley sequence
        if((TESTArray[TEST_HWSequenceGeneration] & TEST_HwDMTMedleySequenceGeneration) != 0)
        {
            guc_sequenceToGenerate = (uint8)GENERATE_DMT_MEDLEY;
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,TxHwSequenceGenerationSetup);
        }
        // else s/w generates medley sequence
        else
        {
            gs_TxFirstPNbit = 0;
        }
    }
    // if s/w generates medley sequence
    if((TESTArray[TEST_HWSequenceGeneration] & TEST_HwDMTMedleySequenceGeneration) == 0)
    {
        /*  get unpacked medley sequence */
        /*  if gft_MedleyFlag is not TRUE, then transmit silence during Medley. */
        /*  This feature allows the echo effect to be measured.                                 */
        if (gft_MedleyFlag == TRUE)     {
            for (i = us_TxNoiseStartToneIdx*2; i < 2 * gs_TxNumTones; i++)
            {
                gsa_unpk_PN_US[i] += gt_INFX_CMV.s_med_offset;
            }

            GenerateMedley(gsa_unpk_PN_US, gsa_TxToneBuf, gs_TxFirstPNbit, gs_PN_US_LEN, (int16)(2*gs_TxNumTones));

            for (i = us_TxNoiseStartToneIdx*2; i < 2 * gs_TxNumTones; i++)
            {
                gsa_unpk_PN_US[i] -= gt_INFX_CMV.s_med_offset;
            }
        }
        else {
            TxToneSetUp(0,0,0);
        }
        /*  clear unused frequencies */
        MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*2*gs_TxMedleyFirstCh));
        if (gs_TxMedleyLastCh < gs_TxNumTones)
        MemSetBuffer(gsa_TxToneBuf, (int16)(2*gs_TxMedleyLastCh+2), 0, (int16)(sizeof(int16)*2*(gs_TxNumTones-gs_TxMedleyLastCh-1)));

        /* Update offset to first unpacked bit. */
        gs_TxFirstPNbit += gs_PN_US_Step;
        if (gs_TxFirstPNbit >= gs_PN_US_LEN)
        gs_TxFirstPNbit -= gs_PN_US_LEN;
    }


    /* go to next state */
    if (gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen) {
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
        gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;

        // Save the Tx overflow counters for the current state
        memcpy(gusa_RMedley_TxOverflowCnts, gusa_TxOverflowCnts, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));
    }
}
