/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RMsgs1TxF.c
 *
 *------------------------------------------------------------------------
 */

 // ****************************************************************************************************
// RMsgs1TxF.c
// History :
//  27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-MSG1 in particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//****************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "ifft_fix.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "fifo.h"
#include "RMsgs1TxF.h"
#include "cmv.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "FormRMsgs1.h"
#include "RCrc1TxF.h"
#include "states.h"
#include "DebugBuffer.h"




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RMsgs1TxF
 *
 *  Description: Sends the R_MSG1 message to
 *  the ATU-C.  One bit of information is transmitted in each symbol.
 *  A zero bit is encoded as one symbol of R_Reverb and a one
 *  bit is encoded as one symbol of R_Segue.  A CRC16 checksum is computed
 *  on the R_MSGS1 which will be sent during next state
 *
 *  Prototype: void RMsgs1TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      guca_RMsgs1Tab[]    - (O) R_Msgs1 message data to be transmitted
 *    guca_RMsgFR2Tab[] - (I) R_Msg_FR2 message data to be transmitted
 *    guca_RMsgFR1Tab[]   - (I) R_Msg_FR1 message data to be transmitted
 *    gus_R_CRC           - (I/O) CRC16 computed over gus_RMsgs1Tab[]
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) Current TX state
 *      gt_StateMachCntrl   - (O) Maintains state machine control variables
 *
 *  Notes: implements states R_MSGS1_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RMsgs1TxF(void) {

    uint16  us_infobit;

    if (gl_TxSymbolCount == 0) {

      /* Pack R_MSGS1 for transmission */
      FormRMsgs1();

      gt_StateMachCntrl.l_TXCurrentStateLen = R_MSGS1_TX_LEN;
        gt_StateMachCntrl.s_TXFollowingState  = R_CRC2_TX;
      gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RCrc1TxF;
      gt_StateMachCntrl.puca_TX_message     = guca_RMsgs1Tab;

        gus_R_CRC = 0x0000;
      gs_TxSubStateCnt = 0;
    }



      us_infobit = TxInfoBit( gt_StateMachCntrl.puca_TX_message, gs_TxSubStateCnt);


      /*  computed CRC2 */
      CalcCRC16(&gus_R_CRC, us_infobit);

      gs_TxSubStateCnt++;
      if (gs_TxSubStateCnt == (gt_StateMachCntrl.l_TXCurrentStateLen)) {
         gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
         gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
#ifdef DEBUG_TRACES // XDSLRTFW-597
       LogMessages(4,NOT_END_OF_MSG,R_MSG1_DMT_MSG,R_MSG1_NUM_BYTES, (uint8 *)guca_RMsgs1Tab, DEBUG_BUFFER_DELIMITER_ADSL);
       LogMessageSegments(END_OF_THE_MSG,2,(uint8 *)(void *)(&gus_R_CRC), DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
       DSH_SendStream(DSH_R_MSG1_ADSL,R_MSG1_NUM_BYTES,&guca_RMsgs1Tab[0]);
#endif
      }



}

