/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RRates1TxF.c
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// RRates1TxF.c
//
// History
//
// 25/08/2010 Nihar: Added Noise for Tx Medley to Alcatel ADLT-J STM FG10 CO
//                    to avoid aggressive US Bit loading and to Improve the
//                    US Margin. By default, its enabled. To disable it,
//                    set bit 3 of INFO 103 0.
//                    Grep for IOP_US_DMT_ALCATEL_AddNoiseToTxMedleyToImproveUsMargin
//
// 17/05/2013 Ram: Added some noise to US Tx Medley signal to avoid aggressive US
//                 bit loading. This improves US margin and reduces US CRCs.
//                 This scheme was enabled for ALCATEL chipset and now have extended
//                 this to CNXT (Lucent Stinger) chipset.
//                 Grep for: XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-RATES1 in particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// ****************************************************************************************
#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "ifft_fix.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "fifo.h"
#include "RRates1TxF.h"
#include "cmv.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "FormRRates.h"
#include "RCrc1TxF.h"
#include "states.h"
#include "DebugBuffer.h"
#include "const.h"

// IOP_US_DMT_ALCATEL_AddNoiseToTxMedleyToImproveUsMargin (Start)
#include "T1413.h"
#define ADD_TX_MEDLEY_NOISE_ALCATEL_DMT  (35)
// IOP_US_DMT_ALCATEL_AddNoiseToTxMedleyToImproveUsMargin (End)
/*^^^
*------------------------------------------------------------------------
*
*  Name: RRates1TxF
*
*  Description: R_RATES1_TX is used to send four rate configuration
*  options to the ATU-C.  One bit of information is transmitted in each
*  symbol of R_RATES1_TX.  A zero bit is encoded as one symbol of
*  R_Reverb and a one bit is encoded as one symbol of R_Segue.  A CRC16
*  checksum is computed on the rates information which will be sent
*  during R_CRC1_TX.
*
*  Prototype: void RRates1TxF(void);
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      guca_PreAmbleField[]      - (I) 4 byte prefix sent before R_Rates1
*      guca_RRates1Tab[]         - (I) Rate configuration options to be sent
*      gus_R_CRC                 - (I/O) CRC16 computed over guca_RRates1Tab[]
*      gs_TxSubState             - (I/O) substate within current state
*      gl_TxSymbolCount          - (I) # symbol periods in current TX state
*      gs_TxNextState            - (O) TX state that will begin next symbol period
*
*  Substates:
*      R_RATES1_TX_TRANSMIT      - Send R_RATES1_TX with cyclic prefix
*                                  for R_RATES1_PRFX_LEN symbols.
*      R_RATES1_TX_CALCULATE_CRC - Send R_RATES1_TX configuration
*                                  options & compute CRC.
*  Notes: implements state R_RATES1_TX
*
*------------------------------------------------------------------------
*^^^
*/

/* =============================================== */
/* substates */
/* =============================================== */
#define R_RATES1_TX_TRANSMIT        (0)
#define R_RATES1_TX_CALCULATE_CRC   (1)

void RRates1TxF(void) {

    uint16  us_infobit;

#ifndef ISDN
    int32 l_fe_VendorID_Check;  // Added the 32 bit local var. for TI/CNXT Vendor id//
#endif

    gft_IFFT_On = TRUE;
    switch (gs_TxSubState) {

        /* ==================================================================== */
        /*  Send R_RATES1_TX with cyclic Prefix */
        /* ==================================================================== */
    case R_RATES1_TX_TRANSMIT:

        if(gl_TxSymbolCount == 0) {

            /* Pack R_RATES1 for transmission */
            FormRRates(guca_RRates1Tab);

            gs_TxSubStateCnt = 0;
        }

        /* Start sending symbols with cyclic prefix */
        //TxInfoBit(guca_PreAmbleField, (int16)(gl_TxSymbolCount));
        TxInfoBit(guca_PreAmbleField, gs_TxSubStateCnt);

        //if (gl_TxSymbolCount == (R_RATES1_PRFX_LEN - 1)) {
        gs_TxSubStateCnt++;
        if (gs_TxSubStateCnt == R_RATES1_PRFX_LEN) {
            gs_TxSubState = R_RATES1_TX_CALCULATE_CRC;
            gus_R_CRC = 0x0000;
            gs_TxSubStateCnt = 0;
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessages(4,NOT_END_OF_MSG,(uint16)R_RATES1_DMT_MSG,4, (uint8 *)guca_PreAmbleField, DEBUG_BUFFER_DELIMITER_ADSL);
#endif
        }
        break;

        /* ==================================================================== */
        /*  Send R_RATES1_TX Configuration Options & Compute CRC  */
        /* ==================================================================== */
    case R_RATES1_TX_CALCULATE_CRC:

        us_infobit = TxInfoBit(guca_RRates1Tab, gs_TxSubStateCnt);

        /* compute CRC1 */
        CalcCRC16(&gus_R_CRC, us_infobit);

        gs_TxSubStateCnt++;
        if (gs_TxSubStateCnt == R_RATES1_TX_LEN-R_RATES1_PRFX_LEN) {
            gs_TxNextState = R_CRC1_TX;
            gpF_TxStateFunc = (PtrToFunc)RCrc1TxF;
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessageSegments(NOT_END_OF_MSG,R_RATES1_NUM_BYTES,(uint8 *)guca_RRates1Tab, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,2,(uint8 *)(void *)&gus_R_CRC, DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
            DSH_SendStream(DSH_R_RATES1,R_RATES1_NUM_BYTES,&guca_RRates1Tab[0]);
#endif
            // IOP_US_DMT_ALCATEL_AddNoiseToTxMedleyToImproveUsMargin (Start)
#ifndef ISDN   // Only for Anx-A
            /* Low US Margin( < 5dB) was observed for Alcatel STM ADLT-J FG10(Feature Group 10) CO
            in DMT mode(short loops). It was observed only when configured Max US Data rate is
            more than 960Kbps. If the configured Max US Data rate is more than 960Kbps, then CO
            does the aggressive US bit loading by reducing the US margin ( < 5dB).. In order to
            avoid aggressive US Bit loading we need to add some noise in the Tx Medley.

            Experimentally Tx Medley noise offset as "35" was obtained to improve the US margin
            and at the same time not much degradation in the US data rate. 32Kbps US data rate
            degradation was observed ONLY in the short loops which is beyond the TR067
            requirement and is comparable to the AR7 data rate. This fix does not have any impact
            on the long loops; hence it is applied for all the Loops.

            It is limited to the Alcatel DSLAMs for g.dmt, t1.413 and g.lite mode; it is applied
            based on the CO Vendor ID as Alcatel (i.e ALCB) and t1413 VID. This fix doesn't get
            applied for Alcatel DSLAM who's chipset is Broadcom, since it sends CO VID as (BDCM).
            By default the fix is enabled, it may be disabled by an API bit if required
            */

            //XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (Start)
            // Extract the provider  code (Vendor ID, 4 octets), Workaround for TI  AC7/CNXT vendor ID
            l_fe_VendorID_Check = (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) |
                                  (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);

            if (((gt_INFX_CMV.
                            us_OperatorSpBits & CMV_TO_DISABLE_TXMED_NOISE_ALC_DMT) == 0)
                    && ((gs_CurrentCoChipset == ALA_CO_CHIPSET) ||
                        (gs_fe_T1413_VendorID == T1413_ALA_ID)  ||
                        (gs_fe_T1413_VendorID == T1413_GSI_ID)  ||
                        ((gl_SelectedMode & MODE_ADSL1) && (l_fe_VendorID_Check  == GHS_GSI_ID)) ))
            {
               // ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise  (Start_End)
               gt_INFX_CMV.s_med_offset += USSNR_Medley_51_0_maxBitPerTone_13_6_maxNetRate_1172kbps;
            }
            //XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (End)

#endif // ifndef ISDN
            // IOP_US_DMT_ALCATEL_AddNoiseToTxMedleyToImproveUsMargin (End)
        }



        break;
    }
}

#undef R_RATES1_TX_TRANSMIT
#undef R_RATES1_TX_CALCULATE_CRC
