/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb3TxF.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "ifft_fix.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "fifo.h"
#include "RReverb3TxF.h"
#include "cmv.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "RSegue2TxF.h"
#include "states.h"





/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb3TxF
 *
 *  Description: R_REVERB3_TX transmits the R_Reverb signal.
 *
 *  Prototype: void RReverb3TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB3_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RReverb3TxF(void) {

    if (gl_TxSymbolCount == 0) {

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);


      gft_IFFT_On = TRUE;

         switch(gs_TxState) {

      case R_REVERB3_TX:
         gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB3_TX_TIMEOUT-1;
         gt_StateMachCntrl.s_TXFollowingState = R_SEGUE2_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RSegue2TxF;
         gt_StateMachCntrl.s_TxSubStateLen = MIN_R_REVERB3_TX_CONT_LEN;
#if 1
//       AddFunctionToFifo(gp_TxLoadingFunctionFifo,InsertTxCP);
#endif
         gpft_RCExchRcvFlag = &gft_RCExch1RcvFlag;
         break;


        }
      *gpft_RCExchRcvFlag = NOT_RECEIVE;
    }

#if 1
   if ((gl_TxSymbolCount == 2) && (gs_TxState==R_REVERB3_TX))
      InsertTxCP();
#endif

   /* If RX has completed detection of R_C_CRC_RA2 or R_C_CRC2 or R_C_CRC5 or R_C_SEGUE3  */
   /* (indicated by setting gft_RCExchRARcvFlag or gft_RCExch1RcvFlag or gft_RCExch2RcvFlag or  */
    /*  gft_RCSegue3RcvFlag = RECEIVE_OK1) */
   /* continue to transmit R_Reverb for another 64 or 20 or 64 or 0 symbols respectively */
   /* and then enter next state */
   if(*gpft_RCExchRcvFlag == RECEIVE_OK1) {
      gs_TxSubStateCnt = 0;
      *gpft_RCExchRcvFlag = RECEIVE_OK2;
   }
   else if(*gpft_RCExchRcvFlag == RECEIVE_OK2) {
      gs_TxSubStateCnt++;
      if((gs_TxSubStateCnt >= gt_StateMachCntrl.s_TxSubStateLen))
      {

         gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
         gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;



      }
   }

   /* Check if time out happens */
   if (gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen) {
        gs_TxNextState = FAIL_TX;
      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RReverb3Tx_C_SEGUE1_Failure;
    }
}

