/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverbRATxF.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "tx_ops.h"
#include "fifo.h"
#include "showinit.h"
#include "cmv.h"
#include "states.h"
#include "RSegueRATxF.h"



#include "RReverbRATxF.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverbRATxF
 *
 *  Description: R_REVERB3_TX transmits the R_Reverb signal.
 *
 *  Prototype: void RReverb3TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB_RA_TX, R_REVERB5_TX, and R_REVERB6_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */


   #define REVERB_RA_SUBSTATE_LENGTH_AFTER_CRC_RA2   (1400)


void RReverbRATxF(void) {

    if (gl_TxSymbolCount == 0) {

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);

      gft_IFFT_On = TRUE;
      gpft2_RCExchRcvFlag = &gft_RCExchRARcvFlag;
      *gpft2_RCExchRcvFlag = NOT_RECEIVE;
    }

    /* If RX has completed detection of R_C_CRC_RA2 */
    /* (indicated by setting gft_RCExchRARcvFlag or gft_RCExch1RcvFlag or gft_RCExch2RcvFlag or  */
    /*  gft_RCSegue3RcvFlag = RECEIVE_OK1) */
   /* continue to transmit R_Reverb for another 64 or 20 or 64 or 0 symbols respectively */
   /* and then enter next state */
    if(*gpft2_RCExchRcvFlag == RECEIVE_OK1) {
      gs_TxSubStateCnt = 0;
      *gpft2_RCExchRcvFlag = RECEIVE_OK2;
    }
    else if(*gpft2_RCExchRcvFlag == RECEIVE_OK2) {
      gs_TxSubStateCnt++;
      /* extend the state to the maximum allowed duration */
      if (gs_TxSubStateCnt >= REVERB_RA_SUBSTATE_LENGTH_AFTER_CRC_RA2 )
      {

         {
         gs_TxNextState = R_SEGUE_RA_TX;
         gpF_TxStateFunc = (PtrToFunc)RSegueRATxF;
         }

      }
    }
   /* Check if time out happens */
    if (gl_TxSymbolCount == (R_REVERB_RA_TX_TIMEOUT-1)) {
      gs_TxNextState = FAIL_TX;

      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RReverbRATx_C_SEGUE2_Failure;
    }
}




