/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSegue3TxF.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "tx_ops.h"
#include "fifo.h"
#include "showinit.h"
#include "cmv.h"
#include "RRatesRATxF.h"
#include "states.h"




/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSegue3TxF
 *
 *  Description: Transmits the R_Segue signal to the ATU-C.
 *  This function is reused by several states.
 *
 *  Prototype: void RSegue3TxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
  *  Notes: implements states R_SEGUE3_TX
 *------------------------------------------------------------------------
 *^^^
 */
void RSegue3TxF(void) {

    if (gl_TxSymbolCount == 0) {

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);



      gft_IFFT_On = TRUE;

        /*  state machine control */

#ifdef  T1413_SUPPORT_EES_OFF
      if ( (STATArray[STAT_Misc] & STAT_T1413_Signal_Detected)
         && (!gft_T1413_EesFlag) )
         gt_StateMachCntrl.s_TXFollowingState  = R_MSGS2_TX;
      else
#endif
         gt_StateMachCntrl.s_TXFollowingState  = R_MSG_RA_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RRatesRATxF;

    }

    if (gl_TxSymbolCount == (R_SEGUE1_TX_LEN-1)) {
      /* set the next TX state */
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
    }


}

